/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

class Exec {
    private final ArrayList<String> cmdArray = new ArrayList();
    private final boolean waitProc;
    private final ProcessBuilder processBuilder;
    private final String shellForm;

    Exec(String progpath, String[] arguments, boolean wait, String directory, String in, String out, String err) {
        this.cmdArray.add(progpath);
        this.cmdArray.addAll(Arrays.asList(arguments));
        this.processBuilder = new ProcessBuilder(this.cmdArray);
        this.processBuilder.directory(directory.isEmpty() ? null : new File(directory));
        if (in != null && !in.isEmpty()) {
            this.processBuilder.redirectInput(new File(in));
        }
        this.processBuilder.redirectOutput(out != null && !out.isEmpty() ? ProcessBuilder.Redirect.to(new File(out)) : ProcessBuilder.Redirect.INHERIT);
        this.processBuilder.redirectError(err != null && !err.isEmpty() ? ProcessBuilder.Redirect.to(new File(err)) : ProcessBuilder.Redirect.INHERIT);
        this.waitProc = wait;
        StringBuilder str = new StringBuilder();
        if (!directory.isEmpty()) {
            str.append("( cd ").append(directory).append(" ; ");
        }
        for (String s : this.cmdArray) {
            str.append(s).append(" ");
        }
        if (in != null && !in.isEmpty()) {
            str.append("< ").append(in);
        }
        if (out != null && !out.isEmpty()) {
            str.append("> ").append(out);
        }
        if (err != null && !err.isEmpty()) {
            str.append("2> ").append(err);
        }
        if (!directory.isEmpty()) {
            str.append(")");
        }
        if (!wait) {
            str.append("& ");
        }
        this.shellForm = str.toString();
    }

    boolean action() throws IOException {
        Process process = this.processBuilder.start();
        int errorCode = 0;
        if (this.waitProc) {
            try {
                errorCode = process.waitFor();
            }
            catch (InterruptedException ex) {
                System.err.println(ex.getMessage());
            }
        }
        return errorCode == 0;
    }

    public String toString() {
        return "exec " + this.shellForm;
    }
}

