/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.util.ArrayList;
import org.harctoolbox.harchardware.IStringCommand;
import org.harctoolbox.harchardware.StringCommander;
import org.harctoolbox.harchardware.Utils;
import org.harctoolbox.harchardware.comm.LocalSerialPortBuffered;
import org.harctoolbox.harchardware.comm.TcpSocketPort;
import org.harctoolbox.harchardware.comm.UdpSocketPort;
import org.harctoolbox.harchardware.comm.UrlPort;
import org.harctoolbox.harchardware.ir.GlobalCache;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;

public class MainString {
    private static final int defaultPortNumber = 1;
    private static JCommander argumentParser;
    private static CommandLineArgs commandLineArgs;

    private MainString() {
    }

    private static String join(ArrayList<String> arr, String separator) {
        StringBuilder result = new StringBuilder();
        for (String s : arr) {
            result.append(result.length() == 0 ? "" : separator).append(s);
        }
        return result.toString();
    }

    private static int noTrue(boolean ... bool) {
        int sum = 0;
        for (boolean b : bool) {
            if (!b) continue;
            ++sum;
        }
        return sum;
    }

    private static void usage(int exitcode) {
        StringBuilder str = new StringBuilder();
        argumentParser.usage(str);
        str.append("\nparameters: <protocol> <deviceno> [<subdevice_no>] commandno [<toggle>]\n   or       <Pronto code>");
        (exitcode == 0 ? System.out : System.err).println(str);
        MainString.doExit(exitcode);
    }

    private static void doExit(int exitcode) {
        System.exit(exitcode);
    }

    public static void main(String[] args) {
        argumentParser = new JCommander((Object)commandLineArgs);
        argumentParser.setProgramName("HarcHardware");
        try {
            argumentParser.parse(args);
        }
        catch (ParameterException ex) {
            System.err.println(ex.getMessage());
            MainString.usage(1);
        }
        if (commandLineArgs.helpRequested) {
            MainString.usage(0);
        }
        if (commandLineArgs.versionRequested) {
            System.out.println("HarcHardware version 0.9.1a");
            System.out.println("JVM: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + " " + System.getProperty("os.name") + "-" + System.getProperty("os.arch"));
            System.out.println();
            System.out.println("Copyright (C) 2011, 2012, 2013, 2014 Bengt Martensson.\n\nThis program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License along with this program. If not, see http://www.gnu.org/licenses/.");
            System.exit(0);
        }
        if (MainString.noTrue(commandLineArgs.url, commandLineArgs.serial, commandLineArgs.globalcache, commandLineArgs.tcp, commandLineArgs.udp) != 1) {
            System.err.println("Exactly one of --serial, --globalcache, --udp, --url, and --tcp must be given.");
            System.exit(1);
        }
        boolean didSomethingUseful = false;
        GlobalCache globalCache = null;
        LocalSerialPortBuffered localSerialPortBuffered = null;
        TcpSocketPort tcpPort = null;
        UdpSocketPort udpPort = null;
        UrlPort urlPort = null;
        IStringCommand harcHardware = null;
        String localIpAddress = commandLineArgs.myIp;
        try {
            if (commandLineArgs.globalcache) {
                globalCache = new GlobalCache(commandLineArgs.ip, commandLineArgs.verbose, commandLineArgs.timeout, false);
                harcHardware = globalCache.getSerialPort(commandLineArgs.portNumber);
            } else if (commandLineArgs.url) {
                if (commandLineArgs.ip == null) {
                    System.err.println("Must give a sensible hostname for URL.");
                    System.exit(1);
                }
                urlPort = new UrlPort("http", commandLineArgs.ip, commandLineArgs.portNumber, null, null, commandLineArgs.timeout, commandLineArgs.verbose);
                harcHardware = urlPort;
            } else if (commandLineArgs.tcp) {
                if (commandLineArgs.portNumber == 1) {
                    System.err.println("Must give a sensible port number for TCP.");
                    System.exit(1);
                }
                if (commandLineArgs.ip == null) {
                    System.err.println("Must give a sensible hostname for TCP.");
                    System.exit(1);
                }
                tcpPort = new TcpSocketPort(commandLineArgs.ip, commandLineArgs.portNumber, commandLineArgs.timeout, commandLineArgs.verbose, TcpSocketPort.ConnectionMode.keepAlive);
                harcHardware = tcpPort;
            } else if (commandLineArgs.udp) {
                if (commandLineArgs.portNumber == 1) {
                    System.err.println("Must give a sensible port number for UDP.");
                    System.exit(1);
                }
                if (commandLineArgs.ip == null) {
                    System.err.println("Must give a sensible hostname for UDP.");
                    System.exit(1);
                }
                if (commandLineArgs.myIp == null) {
                    System.err.print("No own IP address given, let's try the environment...");
                    localIpAddress = Utils.getHostname();
                    System.err.println("using \"" + localIpAddress + "\"");
                }
                udpPort = new UdpSocketPort(commandLineArgs.ip, commandLineArgs.portNumber, commandLineArgs.timeout, commandLineArgs.verbose);
                harcHardware = udpPort;
            } else if (commandLineArgs.serial) {
                localSerialPortBuffered = new LocalSerialPortBuffered(commandLineArgs.portNumber);
                harcHardware = localSerialPortBuffered;
            }
            StringCommander.Framer framer = new StringCommander.Framer(commandLineArgs.prefix + "{0}" + commandLineArgs.suffix + (commandLineArgs.appendReturn ? "\r" : ""), commandLineArgs.toUpper);
            if (commandLineArgs.parameters.isEmpty() && didSomethingUseful) {
                System.exit(0);
            }
            if (commandLineArgs.parameters.isEmpty() || commandLineArgs.telnet) {
                if (!commandLineArgs.telnet) {
                    System.err.println("No arguments given, going into interactive telnet mode.");
                }
                System.err.println("Type quit to quit.");
                StringCommander.telnet(harcHardware, framer);
            } else {
                String[] result;
                String command = framer.frame(MainString.join(commandLineArgs.parameters, " "));
                int returnLines = commandLineArgs.oneLine ? 1 : (commandLineArgs.twoLines ? 2 : 0);
                StringCommander stringCommander = new StringCommander(harcHardware);
                for (String s : result = stringCommander.sendStringCommand(new String[]{command}, commandLineArgs.count, returnLines, commandLineArgs.delay)) {
                    System.out.println(s);
                }
                if (harcHardware != null) {
                    harcHardware.close();
                }
            }
        }
        catch (NoSuchTransmitterException ex) {
            System.err.println(ex.getMessage());
            System.exit(3);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            System.exit(3);
        }
        catch (NoSuchPortException ex) {
            System.err.println("No such port: " + ex.getMessage());
            System.exit(3);
        }
        catch (PortInUseException ex) {
            System.err.println(ex.getMessage());
            System.exit(3);
        }
        catch (UnsupportedCommOperationException ex) {
            System.err.println(ex.getMessage());
            System.exit(3);
        }
    }

    static {
        commandLineArgs = new CommandLineArgs();
    }

    private static final class CommandLineArgs {
        @Parameter(names={"-1"}, description="Expect one line of response")
        private boolean oneLine;
        @Parameter(names={"-2"}, description="Expect two line of response")
        private boolean twoLines;
        @Parameter(names={"-#", "--count"}, description="Number of times to send sequence")
        private int count = 1;
        @Parameter(names={"--delay"}, description="Delay between commands in milliseconds")
        private int delay = 0;
        @Parameter(names={"-g", "--globalcache"}, description="Use GlobalCache")
        private boolean globalcache = false;
        @Parameter(names={"-h", "--help", "-?"}, description="Display help message")
        private boolean helpRequested = false;
        @Parameter(names={"--http", "--url"}, description="Use URLs (http)")
        private boolean url = false;
        @Parameter(names={"-i", "--ip"}, description="IP address or name")
        private String ip = null;
        @Parameter(names={"-m", "--myip"}, description="For UPD only: IP number to listen to")
        private String myIp = null;
        @Parameter(names={"-p", "--port"}, description="Port number, either TCP port number, or serial port number (counting the first as 1).")
        private int portNumber = 1;
        @Parameter(names={"--prefix"}, description="Prefix to be prepended to all sent commands.")
        private String prefix = null;
        @Parameter(names={"-r", "--return"}, description="Append a carrage return at the end of the command.")
        private boolean appendReturn;
        @Parameter(names={"-s", "--serial"}, description="Use local serial port.")
        private boolean serial;
        @Parameter(names={"--suffix"}, description="Sufffix to be appended to all sent commands.")
        private String suffix = null;
        @Parameter(names={"-t", "--tcp"}, description="Use tcp sockets")
        private boolean tcp;
        @Parameter(names={"-T", "--timeout"}, description="Timeout in milliseconds")
        private int timeout = 2000;
        @Parameter(names={"--telnet"}, description="Go in interactive telnet mode")
        private boolean telnet;
        @Parameter(names={"-u", "--upper"}, description="Translate commands to upper case.")
        private boolean toUpper;
        @Parameter(names={"--udp"}, description="Use Udp sockets.")
        private boolean udp;
        @Parameter(names={"-v", "--version"}, description="Display version information")
        private boolean versionRequested;
        @Parameter(names={"-V", "--verbose"}, description="Turn on verbose reporting")
        private boolean verbose;
        @Parameter(description="[parameters]")
        private ArrayList<String> parameters = new ArrayList();

        private CommandLineArgs() {
        }
    }
}

