/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.FieldPosition;
import java.text.MessageFormat;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.harchardware.IStringCommand;
import org.harctoolbox.harchardware.comm.TcpSocketPort;
import org.harctoolbox.harchardware.ir.GlobalCache;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;

public class StringCommander {
    IStringCommand hardware;

    public StringCommander(IStringCommand hardware) {
        this.hardware = hardware;
    }

    public String[] sendStringCommand(String[] cmds, int count, int returnLines, int delay) throws IOException {
        if (count < 1) {
            throw new IllegalArgumentException("Count = " + count + " < 1; this is meaningless.");
        }
        String[] result = new String[returnLines];
        try {
            for (String cmd : cmds) {
                String command = cmd;
                if (command == null) continue;
                for (int c = 0; c < count; ++c) {
                    if (delay > 0 && c > 0) {
                        Thread.sleep(delay);
                    }
                    this.hardware.sendString(command);
                }
            }
            for (int i = 0; i < returnLines; ++i) {
                result[i] = this.hardware.readString();
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return result;
    }

    public String sendStringCommand(String cmd, int returnLines) throws IOException {
        return this.sendStringCommand(new String[]{cmd}, 1, returnLines, 0)[0];
    }

    public String sendStringCommand(String cmd) throws IOException {
        return this.sendStringCommand(cmd, 0);
    }

    private void listenForever(PrintStream printStream) throws IOException {
        while (true) {
            String result;
            if ((result = this.hardware.readString()).trim().length() <= 0) {
                continue;
            }
            printStream.println(result);
        }
    }

    private static void doExit(int exitcode) {
        System.exit(exitcode);
    }

    public static void telnet(IStringCommand hardware, Framer commandFramer) {
        StringReaderThread readerThread = new StringReaderThread(hardware, System.out);
        readerThread.start();
        StringWriterThread writerThread = new StringWriterThread(hardware, new BufferedReader(new InputStreamReader(System.in, IrpUtils.dumbCharset)), commandFramer);
        writerThread.start();
    }

    public static void telnet(IStringCommand hardware) {
        StringCommander.telnet(hardware, new Framer());
    }

    public static void main(String[] args) {
        try {
            TcpSocketPort denon = new TcpSocketPort("denon", 23, 2000, true, TcpSocketPort.ConnectionMode.keepAlive);
            StringCommander stringCommander = new StringCommander(denon);
            String result = stringCommander.sendStringCommand("MVDOWN\r", 1);
            System.out.println(result);
            denon.close();
            System.exit(0);
            GlobalCache gc = new GlobalCache("gc", true);
            GlobalCache.SerialPort port = gc.getSerialPort(1);
            port.sendString("CR0\r");
            System.out.println(port.readString());
            port.close();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch (NoSuchTransmitterException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public static class Framer {
        MessageFormat format;
        private final boolean toUpper;

        public Framer(String format, boolean toUpper) {
            this.format = new MessageFormat(format);
            this.toUpper = toUpper;
        }

        public Framer() {
            this("{0}", false);
        }

        public String frame(String arg) {
            return this.format.format(this.toUpper ? arg.toUpperCase(IrpUtils.dumbLocale) : arg);
        }

        public String frame(Object[] args) {
            return this.format.format(args, new StringBuffer(), (FieldPosition)null).toString();
        }
    }

    public static class StringWriterThread
    extends Thread {
        private final StringCommander stringCommander;
        private final BufferedReader inStream;
        private final Framer commandFramer;

        public StringWriterThread(IStringCommand hardware, BufferedReader inStream, Framer commandFramer) {
            this.inStream = inStream;
            this.stringCommander = new StringCommander(hardware);
            this.commandFramer = commandFramer;
        }

        @Override
        public void run() {
            String line = null;
            boolean done = false;
            while (!done) {
                try {
                    line = this.inStream.readLine();
                    if (line.startsWith("quit")) {
                        System.err.println("Goodbye");
                        StringCommander.doExit(0);
                        break;
                    }
                }
                catch (IOException ex) {
                    System.err.println(ex.getMessage());
                }
                if (line != null && line.equals("quit")) {
                    done = true;
                    continue;
                }
                try {
                    this.stringCommander.hardware.sendString(this.commandFramer.frame(line));
                }
                catch (IOException ex) {
                    System.err.println(ex.getMessage());
                }
            }
        }
    }

    public static class StringReaderThread
    extends Thread {
        private final PrintStream printStream;
        private final StringCommander stringCommander;

        public StringReaderThread(IStringCommand hardware, PrintStream printStream) {
            this.printStream = printStream;
            this.stringCommander = new StringCommander(hardware);
        }

        @Override
        public void run() {
            try {
                this.stringCommander.listenForever(this.printStream);
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
        }
    }
}

