/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.beacon;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.harctoolbox.IrpMaster.IrpUtils;

public class AmxBeaconListener {
    private static final int reapInterval = 60000;
    private static final int reapAge = 120000;
    private ListenThread listenThread;
    private GrimReaperThread grimReaperThread;
    private Date startTime = null;
    private Callback callback = null;
    private String key = null;
    private String value = null;
    private boolean debug = false;
    private HashMap<InetAddress, Node> nodes = new HashMap();

    public void setDebug(boolean dbg) {
        this.debug = dbg;
    }

    public AmxBeaconListener(Callback callback, String key, String value, boolean debug) {
        this.callback = callback;
        this.key = key;
        this.value = value;
        this.callback = callback;
        this.debug = debug;
        this.nodes = new HashMap();
        this.listenThread = new ListenThread(this);
        this.grimReaperThread = new GrimReaperThread(this);
    }

    public AmxBeaconListener(Callback callback, String key, String value) {
        this(callback, key, value, false);
    }

    public AmxBeaconListener() {
        this(null, null, null, false);
    }

    public AmxBeaconListener(Callback callback) {
        this(callback, null, null, false);
    }

    public void start() {
        if (!this.listenThread.isAlive()) {
            this.listenThread.start();
        }
        if (!this.grimReaperThread.isAlive()) {
            this.grimReaperThread.start();
        }
        this.startTime = new Date();
    }

    public void stop() {
        if (this.debug) {
            System.err.println("Stopping...");
        }
        this.grimReaperThread.interrupt();
        this.listenThread.interrupt();
    }

    private synchronized void printNodes() {
        System.out.println(this.nodes.size());
        for (InetAddress addr : this.nodes.keySet()) {
            System.out.println(this.debug ? this.nodes.get(addr) : addr.getHostName() + " " + this.nodes.get(addr).lastAliveDate);
        }
    }

    public synchronized Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public synchronized void reset() {
        this.nodes.clear();
    }

    public long getAge() {
        return new Date().getTime() - this.startTime.getTime();
    }

    private synchronized void reap() {
        boolean reaped = false;
        for (Map.Entry kvp : ((HashMap)this.nodes.clone()).entrySet()) {
            Node node = (Node)kvp.getValue();
            if (node.lastAliveDate.getTime() + 120000L < new Date().getTime()) {
                if (this.debug) {
                    System.err.println("Reaped " + node.addr.getHostName());
                }
                this.nodes.remove(kvp.getKey());
                reaped = true;
                continue;
            }
            if (!this.debug) continue;
            System.err.println("Not reaped " + node.addr.getHostName());
        }
        if (reaped && this.callback != null) {
            this.callback.func(this.nodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean listenWait(int timeout) {
        block23: {
            if (timeout < 0) {
                return false;
            }
            if (this.debug) {
                System.err.println("listening to beacon...");
            }
            byte[] buf = new byte[1000];
            DatagramSocket sock = null;
            try {
                InetAddress group = InetAddress.getByName("239.255.250.250");
                sock = new MulticastSocket(9131);
                ((MulticastSocket)sock).joinGroup(group);
                sock.setSoTimeout(timeout);
                DatagramPacket pack = new DatagramPacket(buf, buf.length);
                if (this.debug) {
                    System.err.println("listening...");
                }
                sock.receive(pack);
                String payload = new String(pack.getData(), 0, pack.getLength(), IrpUtils.dumbCharset).trim();
                InetAddress a = pack.getAddress();
                int port = pack.getPort();
                if (this.debug) {
                    System.err.print("Got |" + payload + "| from " + a.getHostName() + ":" + port + "...");
                }
                if (payload.startsWith("AMXB")) {
                    payload = payload.substring(5, payload.length() - 1);
                }
                if (this.debug) {
                    System.err.println(payload);
                }
                String[] pairs = payload.split("><");
                HashMap<String, String> table = new HashMap<String, String>(pairs.length);
                for (String pair : pairs) {
                    String[] x = pair.split("=");
                    table.put(x[0], x[1]);
                }
                Node r = new Node(a, port, table);
                if (this.key != null && !r.get(this.key).equals(this.value)) {
                    if (this.debug) {
                        System.err.println("Wrong value of `" + this.key + "', discarded.");
                    }
                    break block23;
                }
                if (this.nodes.containsKey(a)) {
                    if (this.debug) {
                        System.err.println("already in table, just refreshing.");
                    }
                    this.nodes.get(a).refresh();
                    break block23;
                }
                if (this.debug) {
                    System.err.println("not in table, entered, invoking callback.");
                }
                AmxBeaconListener amxBeaconListener = this;
                synchronized (amxBeaconListener) {
                    this.nodes.put(a, r);
                }
                if (this.callback != null) {
                    this.callback.func(this.nodes);
                }
            }
            catch (IOException ex) {
                if (!SocketTimeoutException.class.isInstance(ex)) {
                    System.err.println(ex.getMessage());
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (sock != null) {
                    sock.close();
                }
            }
        }
        return !Thread.currentThread().isInterrupted();
    }

    private synchronized Node getFirstKey(String key, String value) {
        for (Node r : this.nodes.values()) {
            if (!r.table.containsKey(key) || !((String)r.table.get(key)).equals(value)) continue;
            return r;
        }
        return null;
    }

    private Node listenForKey(int timeout) {
        Date startTime = new Date();
        Node r = null;
        while (r == null) {
            boolean gotResponse;
            r = this.getFirstKey(this.key, this.value);
            int millisecondsLeft = (int)(startTime.getTime() + (long)timeout - new Date().getTime());
            if (r != null || (gotResponse = this.listenWait(millisecondsLeft))) continue;
            return null;
        }
        return r;
    }

    public static Node listenFor(String key, String value, int timeout) {
        AmxBeaconListener ab = new AmxBeaconListener(null, key, value, false);
        ab.listenForKey(timeout);
        return ab.getFirstKey(key, value);
    }

    public static Collection<Node> listen(int time, boolean debug) {
        AmxBeaconListener abl = new AmxBeaconListener(null, null, null, debug);
        long endTime = new Date().getTime() + (long)time;
        while (new Date().getTime() < endTime) {
            abl.listenWait((int)(endTime - new Date().getTime()));
        }
        return abl.getNodes();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            new AmxBeaconListener(new PrintCallback()).start();
        } else {
            if (args.length == 3) {
                AmxBeaconListener ab = new AmxBeaconListener();
                ab.setDebug(true);
                ab.start();
                boolean n = false;
                while (true) {
                    System.out.println(new Date());
                    ab.printNodes();
                    try {
                        Thread.sleep(Integer.parseInt(args[0]));
                    }
                    catch (InterruptedException ex) {
                        System.err.println(ex.getMessage());
                    }
                }
            }
            if (args.length == 1) {
                Collection<Node> result = AmxBeaconListener.listen(Integer.parseInt(args[0]), true);
                for (Node r : result) {
                    System.out.println(r);
                }
            } else if (args.length == 2) {
                Node r = AmxBeaconListener.listenFor("-Make", args[0], Integer.parseInt(args[1]));
                System.err.println(r);
            }
        }
    }

    private static class PrintCallback
    implements Callback {
        private PrintCallback() {
        }

        @Override
        public void func(HashMap<InetAddress, Node> nodes) {
            for (Node node : nodes.values()) {
                System.out.println(node);
            }
        }
    }

    private static class GrimReaperThread
    extends Thread {
        AmxBeaconListener beacon;

        GrimReaperThread(AmxBeaconListener beacon) {
            this.beacon = beacon;
        }

        @Override
        public void run() {
            boolean status = true;
            while (status) {
                this.beacon.reap();
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException ex) {
                    status = false;
                }
            }
            if (this.beacon.debug) {
                System.err.println("GrimReaperThread reaped.");
            }
        }
    }

    private static class ListenThread
    extends Thread {
        final AmxBeaconListener beaconListener;

        ListenThread(AmxBeaconListener beaconListener) {
            this.beaconListener = beaconListener;
        }

        @Override
        public void run() {
            while (this.beaconListener.listenWait(0)) {
            }
            if (this.beaconListener.debug) {
                System.err.println("ListenThread exited.");
            }
        }
    }

    public static class Node {
        private final InetAddress addr;
        private final int port;
        private final HashMap<String, String> table;
        private Date lastAliveDate;

        private Node(InetAddress addr, int port, HashMap<String, String> table) {
            this.addr = addr;
            this.port = port;
            this.table = table;
            this.lastAliveDate = new Date();
        }

        public String toString() {
            StringBuilder res = new StringBuilder();
            for (String s : this.table.keySet()) {
                res.append("\n").append("table[").append(s).append("] = ").append(this.table.get(s));
            }
            return "IP = " + this.addr.getHostName() + "\n" + "port = " + this.port + res.toString() + "\nLast alive: " + this.lastAliveDate;
        }

        public void refresh() {
            this.lastAliveDate = new Date();
        }

        public String get(String key) {
            return this.table.get(key);
        }

        public InetAddress getInetAddress() {
            return this.addr;
        }

        public HashMap<String, String> getTable() {
            return this.table;
        }
    }

    public static interface Callback {
        public void func(HashMap<InetAddress, Node> var1);
    }
}

