/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.beacon;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownServiceException;
import org.harctoolbox.IrpMaster.IrpUtils;

public class OpenremoteClient {
    public static final String multicastIp = "224.0.1.100";
    public static final int multicastPort = 3333;
    public static final int listenPort = 2346;
    public static final String token = "openremote";
    private final String baseUrl;

    public OpenremoteClient(String baseUrl) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
    }

    public OpenremoteClient() {
        this(OpenremoteClient.discover());
    }

    public OpenremoteClient(String host, int portnumber) {
        this("http://" + host + ":" + portnumber + "/controller");
    }

    public String getBaseurl() {
        return this.baseUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String discover() {
        DatagramSocket sock = null;
        try {
            sock = new DatagramSocket();
            InetAddress addr = InetAddress.getByName(multicastIp);
            byte[] buf = token.getBytes("US-ASCII");
            DatagramPacket dp = new DatagramPacket(buf, buf.length, addr, 3333);
            sock.send(dp);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
        String result = null;
        ServerSocket srvSock = null;
        Socket s = null;
        try {
            srvSock = new ServerSocket(2346);
            s = srvSock.accept();
            BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream(), IrpUtils.dumbCharset));
            result = in.readLine();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
                if (srvSock != null) {
                    srvSock.close();
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
        }
        return result;
    }

    private int httpRequest(String shortUrl, String method) {
        int result = 0;
        try {
            String urlStr = this.baseUrl + shortUrl;
            System.err.println(urlStr);
            URL url = new URL(urlStr);
            HttpURLConnection hu = (HttpURLConnection)url.openConnection();
            hu.setRequestMethod(method);
            hu.getContent();
        }
        catch (UnknownServiceException ex) {
            System.err.println(ex.getMessage());
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        return result;
    }

    public boolean controlCommand(int controlNo, String param) {
        return this.httpRequest("/rest/control/" + Integer.toString(controlNo) + "/" + param, "POST") == 200;
    }

    public boolean getPanels() {
        return this.httpRequest("rest/panels", "GET") == 200;
    }

    public static void main(String[] args) {
        OpenremoteClient client = new OpenremoteClient();
        System.out.println("Discovered " + client.getBaseurl());
    }
}

