/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class ArduinoFlasher {
    private static String avrdude = "/usr/bin/avrdude";
    private static String confFile = "/etc/avrdude/avrdude.conf";
    private BufferedReader out = null;
    private BufferedReader err = null;
    private Process process = null;
    private final ArrayList<String> cmdArray = new ArrayList();
    private final ProcessBuilder processBuilder;

    public static String getAvrdude() {
        return avrdude;
    }

    public static void setAvrdude(String aAvrdude) {
        avrdude = aAvrdude;
    }

    public static String getConfFile() {
        return confFile;
    }

    public static void setConfFile(String aConfFile) {
        confFile = aConfFile;
    }

    public BufferedReader getOut() {
        return this.out;
    }

    public BufferedReader getErr() {
        return this.err;
    }

    public ArduinoFlasher(ArduinoBoard arduinoBoard, String port, String hexPath, int verbosity) {
        this(arduinoBoard.partno(), arduinoBoard.programmer(), port, arduinoBoard.programmingBaud(), hexPath, verbosity);
    }

    public ArduinoFlasher(String partno, String programmer, String port, int baud, String hexPath, int verbosity) {
        this.cmdArray.add(avrdude);
        for (int i = 0; i < verbosity; ++i) {
            this.cmdArray.add("-v");
        }
        this.cmdArray.add("-C");
        this.cmdArray.add(confFile);
        this.cmdArray.add("-p");
        this.cmdArray.add(partno);
        this.cmdArray.add("-c");
        this.cmdArray.add(programmer);
        this.cmdArray.add("-P");
        this.cmdArray.add(port);
        this.cmdArray.add("-b");
        this.cmdArray.add(Integer.toString(baud));
        this.cmdArray.add("-D");
        this.cmdArray.add("-U");
        this.cmdArray.add("flash:w:" + hexPath + ":i");
        this.processBuilder = new ProcessBuilder(this.cmdArray);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (String s : this.cmdArray) {
            str.append(s).append(" ");
        }
        return str.toString();
    }

    public void start() throws IOException {
        this.process = this.processBuilder.start();
        this.out = new BufferedReader(new InputStreamReader(this.process.getInputStream(), Charset.forName("US-ASCII")));
        this.err = new BufferedReader(new InputStreamReader(this.process.getErrorStream(), Charset.forName("US-ASCII")));
    }

    public int waitFor() {
        int errorCode = -1;
        try {
            errorCode = this.process.waitFor();
        }
        catch (InterruptedException ex) {
            System.err.println(ex.getMessage());
        }
        return errorCode;
    }

    public static void main(String[] args) {
        ArduinoFlasher flasher = new ArduinoFlasher(ArduinoBoard.nano, "/dev/ttyUSB0", "../IrScrutinizer/arduino/hex/nano/arduinoirscrutinizer.hex", 1);
        System.out.println(flasher);
        try {
            String line;
            String line2;
            flasher.start();
            StringBuilder o = new StringBuilder();
            int status = flasher.waitFor();
            if (status != 0) {
                System.err.println("Exit status = " + status);
            }
            while ((line2 = flasher.out.readLine()) != null) {
                o.append(line2).append("\n");
            }
            System.out.println(o);
            StringBuilder e = new StringBuilder();
            while ((line = flasher.err.readLine()) != null) {
                e.append(line).append("\n");
            }
            System.err.println(e);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public static enum ArduinoBoard {
        uno,
        nano,
        leonardo,
        due,
        yun,
        tre,
        mini,
        micro,
        mega_2560,
        ethernet;


        public boolean isAtMega328() {
            return this == uno || this == nano || this == mini || this == ethernet;
        }

        public boolean isAtMega32u4() {
            return this == leonardo || this == micro;
        }

        public boolean isAtMega2560() {
            return this == mega_2560;
        }

        public String partno() {
            return this.isAtMega328() ? "AtMega328p" : (this.isAtMega32u4() ? "AtMega32u4" : (this.isAtMega2560() ? "AtMega2560" : null));
        }

        public String programmer() {
            return this.isAtMega328() ? "arduino" : (this.isAtMega32u4() ? "arduino" : (this.isAtMega2560() ? "wiring" : null));
        }

        public int programmingBaud() {
            return this == nano ? 57600 : 115200;
        }
    }
}

