/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IHarcHardware;

public abstract class LocalSerialPort
implements IHarcHardware {
    public static final String defaultPort = "/dev/ttyS0";
    private static final int msToWaitForPort = 100;
    protected InputStream inStream;
    protected OutputStream outStream;
    private CommPort commPort;
    private final String portName;
    private String actualPortName;
    private final int baud;
    private final int length;
    private final int stopBits;
    private final Parity parity;
    private final FlowControl flowControl;
    private int timeout;
    private static ArrayList<String> cachedPortNames = null;
    private static final int maxtries = 3;

    public LocalSerialPort(String portName, int baud, int length, int stopBits, Parity parity, FlowControl flowControl, int timeout) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this.portName = portName;
        this.actualPortName = null;
        this.baud = baud;
        this.length = length;
        this.stopBits = stopBits;
        this.parity = parity;
        this.flowControl = flowControl;
        this.timeout = timeout;
    }

    private void lowLevelOpen() throws NoSuchPortException, PortInUseException {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)this.actualPortName);
        this.commPort = portIdentifier.open(this.getClass().getName(), 100);
    }

    private static String nextPortName(String portName) {
        String pattern = "(.*)(\\D+)(\\d+)(:?)";
        String dig = portName.replaceFirst("(.*)(\\D+)(\\d+)(:?)", "$3");
        int n = Integer.parseInt(dig);
        return portName.replaceFirst("(.*)(\\D+)(\\d+)(:?)", "$1$2" + Integer.toString(n + 1) + "$4");
    }

    @Override
    public void open() throws HarcHardwareException, IOException {
        this.open(false);
    }

    public void open(boolean iterate) throws HarcHardwareException, IOException {
        boolean success = false;
        this.actualPortName = this.portName;
        int tries = 0;
        do {
            try {
                this.lowLevelOpen();
                success = true;
            }
            catch (NoSuchPortException ex) {
                if (!iterate) {
                    throw new HarcHardwareException(ex);
                }
                this.actualPortName = LocalSerialPort.nextPortName(this.actualPortName);
            }
            catch (PortInUseException ex) {
                if (!iterate) {
                    throw new HarcHardwareException(ex);
                }
                this.actualPortName = LocalSerialPort.nextPortName(this.actualPortName);
            }
        } while (!success && ++tries < 3);
        if (!success) {
            throw new HarcHardwareException("Could not open LocalSerialPort " + this.portName + (iterate ? " -- " + this.actualPortName : ""));
        }
        if (this.commPort instanceof SerialPort) {
            SerialPort serialPort = (SerialPort)this.commPort;
            try {
                serialPort.setSerialPortParams(this.baud, this.length, this.stopBits, this.parity.ordinal());
            }
            catch (UnsupportedCommOperationException ex) {
                throw new HarcHardwareException(ex);
            }
            this.inStream = serialPort.getInputStream();
            this.outStream = serialPort.getOutputStream();
        }
        if (this.commPort instanceof RXTXPort) {
            ((RXTXPort)this.commPort).setFlowControlMode(this.flowControl.ordinal());
        }
        this.setTimeout();
    }

    public LocalSerialPort(String portName, int baud) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, baud, 8, 1, Parity.NONE, FlowControl.NONE, 0);
    }

    public LocalSerialPort(String portName) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, 9600, 8, 1, Parity.NONE, FlowControl.NONE, 0);
    }

    public LocalSerialPort(int portNumber) throws IOException, NoSuchPortException, PortInUseException, UnsupportedCommOperationException {
        this(LocalSerialPort.getSerialPortName(portNumber), 9600, 8, 1, Parity.NONE, FlowControl.NONE, 0);
    }

    public static String getSerialPortName(int portNumber) throws IOException, NoSuchPortException {
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        int nr = 0;
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            if (portIdentifier.getPortType() == 1) {
                ++nr;
            }
            if (nr != portNumber) continue;
            return portIdentifier.getName();
        }
        throw new NoSuchPortException();
    }

    public static ArrayList<String> getSerialPortNames(boolean useCached) throws IOException {
        if (useCached && cachedPortNames != null) {
            return cachedPortNames;
        }
        Enumeration portEnum = null;
        try {
            portEnum = CommPortIdentifier.getPortIdentifiers();
        }
        catch (UnsatisfiedLinkError ex) {
            throw new IOException(ex.getMessage());
        }
        ArrayList<String> names = new ArrayList<String>();
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            if (portIdentifier.getPortType() != 1) continue;
            names.add(portIdentifier.getName());
        }
        cachedPortNames = names;
        return names;
    }

    public void flushInput() throws IOException {
        while (this.inStream.available() > 0) {
            this.inStream.read();
        }
    }

    @Override
    public boolean isValid() {
        return this.commPort != null;
    }

    @Override
    public void setTimeout(int timeout) throws IOException {
        this.timeout = timeout;
        this.setTimeout();
    }

    private void setTimeout() throws IOException {
        if (this.timeout > 0) {
            try {
                this.commPort.enableReceiveTimeout(this.timeout);
            }
            catch (UnsupportedCommOperationException ex) {
                throw new IOException("timeout not supported");
            }
        } else {
            this.commPort.disableReceiveTimeout();
        }
    }

    @Override
    public String getVersion() {
        return "n/a";
    }

    public String getActualPortName() {
        return this.actualPortName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.isValid()) {
            return;
        }
        try {
            this.inStream.close();
            this.outStream.close();
            this.commPort.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.commPort = null;
        }
    }

    public void flush() throws IOException {
        this.outStream.flush();
    }

    public void setDTR(boolean state) {
        if (this.commPort instanceof RXTXPort) {
            ((RXTXPort)this.commPort).setDTR(state);
        }
    }

    public void dropDTR(int duration) {
        this.setDTR(false);
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setDTR(true);
    }

    public static enum FlowControl {
        NONE,
        RTSCTS_IN,
        RTSCTS_OUT,
        RTSCTS,
        XONXOFF_IN,
        dummy2,
        dummy3,
        dummy4,
        XONXOFF_OUT,
        dummy5,
        dummy6,
        dummy7,
        XONXOFF;

    }

    public static enum Parity {
        NONE,
        ODD,
        EVEN,
        MARK,
        SPACE;

    }
}

