/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IStringCommand;
import org.harctoolbox.harchardware.comm.LocalSerialPort;

public final class LocalSerialPortBuffered
extends LocalSerialPort
implements IStringCommand {
    private BufferedReader bufferedInStream;
    private boolean verbose;

    public LocalSerialPortBuffered(String portName, int baud, int length, int stopBits, LocalSerialPort.Parity parity, LocalSerialPort.FlowControl flowControl, int timeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        super(portName, baud, length, stopBits, parity, flowControl, timeout);
        this.verbose = verbose;
    }

    public LocalSerialPortBuffered(String portName, int baud, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, baud, 8, 1, LocalSerialPort.Parity.NONE, LocalSerialPort.FlowControl.NONE, 0, verbose);
    }

    public LocalSerialPortBuffered(String portName) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, 9600, 8, 1, LocalSerialPort.Parity.NONE, LocalSerialPort.FlowControl.NONE, 0, false);
    }

    public LocalSerialPortBuffered(int portNumber) throws IOException, NoSuchPortException, PortInUseException, UnsupportedCommOperationException {
        this(LocalSerialPortBuffered.getSerialPortName(portNumber), 9600, 8, 1, LocalSerialPort.Parity.NONE, LocalSerialPort.FlowControl.NONE, 0, false);
    }

    @Override
    public void open() throws HarcHardwareException, IOException {
        this.open(false);
    }

    @Override
    public void open(boolean iterate) throws HarcHardwareException, IOException {
        super.open(iterate);
        this.bufferedInStream = new BufferedReader(new InputStreamReader(this.inStream, IrpUtils.dumbCharset));
    }

    @Override
    public void sendString(String cmd) throws IOException {
        if (this.verbose) {
            System.err.println("LocalSerialPortBuffered.sendString: Sent '" + cmd + "'.");
        }
        this.sendBytes(cmd.getBytes(IrpUtils.dumbCharset));
    }

    public void sendBytes(byte[] data) throws IOException {
        this.outStream.write(data);
    }

    public void sendBytes(byte[] data, int offset, int length) throws IOException {
        this.outStream.write(data, offset, length);
    }

    public void sendByte(byte b) throws IOException {
        this.outStream.write(b);
    }

    @Override
    public String readString() throws IOException {
        return this.readString(false);
    }

    public String readString(boolean wait) throws IOException {
        if (!wait && !this.bufferedInStream.ready()) {
            return null;
        }
        String result = this.bufferedInStream.readLine();
        if (this.verbose) {
            System.err.println("LocalSerialPortBuffered.readString: received " + (result != null ? "\"" + result + "\"" : "<null>"));
        }
        return result;
    }

    @Override
    public void setVerbosity(boolean verbosity) {
        this.verbose = verbosity;
    }

    public void waitFor(String goal, String areUThere, int delay, int tries) throws IOException, HarcHardwareException {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.flushIn();
        for (int i = 0; i < tries; ++i) {
            this.sendString(areUThere);
            String answer = this.readString(true);
            if (answer == null) continue;
            if ((answer = answer.trim()).startsWith(goal)) {
                this.flushIn();
                return;
            }
            if (delay <= 0) continue;
            try {
                Thread.sleep(delay);
                continue;
            }
            catch (InterruptedException ex) {
                break;
            }
        }
        throw new HarcHardwareException("Hardware not responding");
    }

    private void flushIn() {
        block3: {
            try {
                String junk;
                while ((junk = this.readString()) != null) {
                    if (!this.verbose) continue;
                    System.err.println("LocalSerialPortBuffered.flushIn: junked '" + junk + "'.");
                }
            }
            catch (IOException ex) {
                if (!this.verbose) break block3;
                System.err.println("IOException in LocalSerialPortBuffered.flushIn ignored: " + ex.getMessage());
            }
        }
    }

    @Override
    public boolean ready() throws IOException {
        return this.bufferedInStream.ready();
    }

    public static void main(String[] args) {
        try {
            ArrayList<String> names = LocalSerialPortBuffered.getSerialPortNames(false);
            for (String name : names) {
                System.out.println(name);
            }
            LocalSerialPortBuffered port = null;
            port = new LocalSerialPortBuffered("/dev/ttyS0", 38400, 8, 1, LocalSerialPort.Parity.EVEN, LocalSerialPort.FlowControl.NONE, 10000, true);
            String cmd = "#QVR\r";
            port.sendString(cmd);
            System.out.println(port.readString());
            port.close();
        }
        catch (NoSuchPortException ex) {
            System.err.println(ex.getMessage());
        }
        catch (PortInUseException ex) {
            System.err.println(ex.getMessage());
        }
        catch (UnsupportedCommOperationException ex) {
            System.err.println(ex.getMessage());
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }
}

