/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.util.ArrayList;
import org.harctoolbox.harchardware.Utils;
import org.harctoolbox.harchardware.comm.IBytesCommand;
import org.harctoolbox.harchardware.comm.LocalSerialPort;
import org.harctoolbox.harchardware.misc.SonySerialCommand;

public final class LocalSerialPortRaw
extends LocalSerialPort
implements IBytesCommand {
    private static final long serialVersionUID = 1L;

    public LocalSerialPortRaw(String portName, int baud, int length, int stopBits, LocalSerialPort.Parity parity, LocalSerialPort.FlowControl flowControl, int timeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        super(portName, baud, length, stopBits, parity, flowControl, timeout);
    }

    @Override
    public byte[] readBytes(int size) throws IOException {
        return Utils.readBytes(this.inStream, size);
    }

    public int readBytes(byte[] buf) throws IOException {
        return this.inStream.read(buf);
    }

    public int readByte() throws IOException {
        return this.inStream.read();
    }

    @Override
    public void sendBytes(byte[] data) throws IOException {
        this.outStream.write(data);
    }

    public void sendBytes(byte[] data, int offset, int length) throws IOException {
        this.outStream.write(data, offset, length);
    }

    public void sendByte(byte b) throws IOException {
        this.outStream.write(b);
    }

    @Override
    public void setVerbosity(boolean verbosity) {
    }

    public static void main(String[] args) {
        try {
            ArrayList<String> names = LocalSerialPortRaw.getSerialPortNames(false);
            for (String name : names) {
                System.out.println(name);
            }
            LocalSerialPortRaw port = null;
            port = new LocalSerialPortRaw("/dev/ttyS0", 38400, 8, 1, LocalSerialPort.Parity.EVEN, LocalSerialPort.FlowControl.NONE, 10000, true);
            if (args.length == 0) {
                int upper = 1;
                int lower = 19;
                SonySerialCommand.Type type = SonySerialCommand.Type.get;
                byte[] cmd = SonySerialCommand.bytes(upper, lower, type);
                port.sendBytes(cmd);
                if (upper <= 1) {
                    byte[] answer = port.readBytes(8);
                    for (int i = 0; i < 8; ++i) {
                        System.out.println(i + "\t" + answer[i]);
                    }
                    SonySerialCommand.Command response = SonySerialCommand.interpret(answer);
                    System.out.println(response);
                }
                port.close();
            }
        }
        catch (NoSuchPortException ex) {
            System.err.println(ex.getMessage());
        }
        catch (PortInUseException ex) {
            System.err.println(ex.getMessage());
        }
        catch (UnsupportedCommOperationException ex) {
            System.err.println(ex.getMessage());
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }
}

