/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.IStringCommand;
import org.harctoolbox.harchardware.Utils;
import org.harctoolbox.harchardware.comm.IBytesCommand;
import org.harctoolbox.harchardware.comm.TcpSocketChannel;

public class TcpSocketPort
implements IStringCommand,
IBytesCommand,
IHarcHardware {
    public static final int defaultTimeout = 2000;
    TcpSocketChannel tcpSocketChannel;

    @Override
    public void open() throws IOException {
        this.tcpSocketChannel.connect();
    }

    @Override
    public boolean ready() throws IOException {
        return this.tcpSocketChannel.ready();
    }

    @Override
    public void sendBytes(byte[] cmd) throws IOException {
        this.tcpSocketChannel.connect();
        this.tcpSocketChannel.getOut().write(cmd);
        this.tcpSocketChannel.close(false);
    }

    @Override
    public byte[] readBytes(int length) throws IOException {
        this.tcpSocketChannel.connect();
        byte[] result = Utils.readBytes(this.tcpSocketChannel.getIn(), length);
        this.tcpSocketChannel.close(false);
        return result;
    }

    public TcpSocketPort(String hostIp, int portNumber, int timeout, boolean verbose, ConnectionMode connectionMode) throws UnknownHostException {
        this.tcpSocketChannel = new TcpSocketChannel(hostIp, portNumber, timeout, verbose, connectionMode);
    }

    public TcpSocketPort(String hostIp, int portNumber, boolean verbose, ConnectionMode connectionMode) throws UnknownHostException {
        this.tcpSocketChannel = new TcpSocketChannel(hostIp, portNumber, 2000, verbose, connectionMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.tcpSocketChannel.close(true);
        }
        catch (IOException iOException) {
        }
        finally {
            this.tcpSocketChannel = null;
        }
    }

    @Override
    public void sendString(String str) throws IOException {
        this.sendBytes(str.getBytes(IrpUtils.dumbCharset));
    }

    @Override
    public String readString() throws IOException {
        this.tcpSocketChannel.connect();
        String result = this.tcpSocketChannel.getBufferedIn().readLine();
        this.tcpSocketChannel.close(false);
        return result;
    }

    @Override
    public boolean isValid() {
        return this.tcpSocketChannel != null && this.tcpSocketChannel.isValid();
    }

    @Override
    public String getVersion() {
        return "";
    }

    @Override
    public void setTimeout(int timeout) {
        try {
            this.tcpSocketChannel.setTimeout(timeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public void setVerbosity(boolean verbose) {
        this.tcpSocketChannel.setVerbosity(verbose);
    }

    public static void main(String[] args) {
        try {
            TcpSocketPort port = new TcpSocketPort("denon", 23, 2000, true, ConnectionMode.keepAlive);
            port.sendString("MVDOWN\r");
            String result = port.readString();
            System.out.println(result);
            port.close();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public static enum ConnectionMode {
        keepAlive,
        justInTime;

    }
}

