/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.harctoolbox.IrpMaster.IrpUtils;

public class UdpSocketChannel {
    private final String hostIp;
    private final InetAddress inetAddress;
    private final int portNumber;
    private boolean verbose;
    private int timeout;
    private DatagramSocket socket = null;
    private PrintStream outStream = null;
    private static final int BUFFERSIZE = 65000;
    private final byte[] byteBuffer = new byte[65000];

    public UdpSocketChannel(String hostIp, int portNumber, int timeout, boolean verbose) throws UnknownHostException {
        this.hostIp = hostIp;
        this.inetAddress = InetAddress.getByName(hostIp);
        this.portNumber = portNumber;
        this.timeout = timeout;
        this.verbose = verbose;
    }

    public void connect() throws IOException {
        if (this.socket == null) {
            this.socket = new DatagramSocket();
            this.socket.setSoTimeout(this.timeout);
            this.outStream = new PrintStream((OutputStream)new FilteredStream(new ByteArrayOutputStream()), false, "US-ASCII");
        }
    }

    private void send(byte[] buf) throws IOException {
        if (this.verbose) {
            System.err.println("Sending command `" + new String(buf, IrpUtils.dumbCharset) + "' over UDP to " + this.hostIp + ":" + this.portNumber);
        }
        DatagramPacket dp = new DatagramPacket(buf, buf.length, this.inetAddress, this.portNumber);
        this.socket.send(dp);
    }

    public void sendString(String string) throws IOException {
        this.send(string.getBytes("US-ASCII"));
    }

    public void close() throws IOException {
        if (this.outStream != null) {
            this.outStream.close();
            this.outStream = null;
        }
        if (this.socket != null) {
            this.socket.disconnect();
            this.socket.close();
            this.socket = null;
        }
    }

    public PrintStream getOut() {
        return this.outStream;
    }

    public String readString() throws SocketException, IOException {
        DatagramSocket inSocket = new DatagramSocket(this.portNumber, this.inetAddress);
        inSocket.setSoTimeout(this.timeout);
        DatagramPacket pack = new DatagramPacket(this.byteBuffer, this.byteBuffer.length);
        if (this.verbose) {
            System.err.println("listening at:" + this.portNumber + "...");
        }
        inSocket.receive(pack);
        String payload = new String(pack.getData(), 0, pack.getLength(), IrpUtils.dumbCharset);
        InetAddress a = pack.getAddress();
        int port = pack.getPort();
        if (this.verbose) {
            System.err.println("Got package for " + a + ":" + port + ": " + payload);
        }
        inSocket.disconnect();
        inSocket.close();
        return payload;
    }

    public boolean isValid() {
        return this.socket != null;
    }

    public void setTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
        this.socket.setSoTimeout(timeout);
    }

    public void setVerbosity(boolean verbose) {
        this.verbose = verbose;
    }

    public static void main(String[] args) {
        try {
            UdpSocketChannel ch = new UdpSocketChannel("irtrans", 21000, 2000, true);
            ch.connect();
            ch.sendString("snd philips_37pfl9603,power_toggle");
            String response = ch.readString();
            System.out.println(response);
            ch.close();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    private class FilteredStream
    extends FilterOutputStream {
        FilteredStream(OutputStream stream) {
            super(stream);
        }

        @Override
        public void write(byte[] b) throws IOException {
            UdpSocketChannel.this.send(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            byte[] buf = new byte[len];
            System.arraycopy(b, off, buf, 0, len);
            UdpSocketChannel.this.send(buf);
        }
    }
}

