/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.IStringCommand;
import org.harctoolbox.harchardware.comm.UdpSocketChannel;

public class UdpSocketPort
implements IStringCommand,
IHarcHardware {
    UdpSocketChannel udpSocketChannel;

    public UdpSocketPort(String hostIp, int portNumber, int timeout, boolean verbose) throws UnknownHostException {
        this.udpSocketChannel = new UdpSocketChannel(hostIp, portNumber, timeout, verbose);
    }

    @Override
    public void close() throws IOException {
        this.udpSocketChannel.close();
        this.udpSocketChannel = null;
    }

    @Override
    public void sendString(String str) throws IOException {
        this.udpSocketChannel.connect();
        this.udpSocketChannel.sendString(str);
        this.udpSocketChannel.close();
    }

    @Override
    public String readString() throws IOException {
        this.udpSocketChannel.connect();
        String result = this.udpSocketChannel.readString();
        this.udpSocketChannel.close();
        return result;
    }

    @Override
    public boolean isValid() {
        return this.udpSocketChannel != null && this.udpSocketChannel.isValid();
    }

    @Override
    public String getVersion() {
        return "";
    }

    @Override
    public void setTimeout(int timeout) {
        try {
            this.udpSocketChannel.setTimeout(timeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public void setVerbosity(boolean verbose) {
        this.udpSocketChannel.setVerbosity(verbose);
    }

    public static void main(String[] args) {
        try {
            UdpSocketPort port = new UdpSocketPort("irtrans", 21000, 2000, true);
            port.sendString("snd philips_37pfl9603,power_toggle");
            String result = port.readString();
            System.out.println(result);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    @Override
    public void open() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean ready() {
        return true;
    }
}

