/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IStringCommand;

public class UrlPort
implements IStringCommand {
    String answer = null;
    int timeout;
    boolean verbose;
    String hostIp;
    int portNumber;
    String prefix;
    String suffix;
    String protocol;

    public UrlPort(String protocol, String hostIp, int portNumber, String prefix, String suffix, int timeout, boolean verbose) {
        this.protocol = protocol;
        this.hostIp = hostIp;
        this.portNumber = portNumber;
        this.prefix = prefix;
        this.suffix = suffix;
        this.verbose = verbose;
        this.timeout = timeout;
    }

    public void connect() throws IOException {
    }

    @Override
    public void close() {
    }

    @Override
    public void sendString(String payload) throws IOException {
        URL url = new URL(this.protocol, this.hostIp, this.portNumber, this.prefix + payload + this.suffix);
        if (this.verbose) {
            System.err.println("Getting " + url);
        }
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(this.timeout);
        this.answer = (String)connection.getContent();
    }

    @Override
    public String readString() {
        String s = this.answer;
        this.answer = null;
        return s;
    }

    public static void main(String[] args) {
        UrlPort port = new UrlPort("http", "t10", -1, "/preset?switch=", "&value=ON", 2000, true);
        try {
            port.sendString("4");
            String str = port.readString();
            System.out.println("-->" + str + "<--");
            str = port.readString();
            System.out.println("-->" + str + "<--");
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    @Override
    public String getVersion() throws IOException {
        return null;
    }

    @Override
    public void setVerbosity(boolean verbosity) {
        this.verbose = verbosity;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void open() throws HarcHardwareException, IOException {
    }

    @Override
    public boolean ready() throws IOException {
        return this.answer != null;
    }
}

