/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.misc.Ethers;
import wol.WakeUpUtil;
import wol.configuration.EthernetAddress;
import wol.configuration.IllegalEthernetAddressException;

public class Wol {
    private static Ethers ethers = null;
    private EthernetAddress ethernetAddress;
    private boolean verbose = false;

    private synchronized void setupEthers() throws FileNotFoundException {
        if (ethers == null) {
            ethers = new Ethers();
        }
    }

    public Wol(String str) throws FileNotFoundException, HarcHardwareException {
        this(str, false);
    }

    public Wol(String str, boolean verbose) throws FileNotFoundException, HarcHardwareException {
        this.verbose = verbose;
        try {
            this.ethernetAddress = new EthernetAddress(str);
        }
        catch (IllegalEthernetAddressException ex) {
            this.setupEthers();
            String mac = ethers.getMac(str);
            if (mac == null) {
                throw new HarcHardwareException("No MAC address for " + str + " found");
            }
            try {
                this.ethernetAddress = new EthernetAddress(mac);
            }
            catch (IllegalEthernetAddressException ex1) {
                throw new RuntimeException(ex1);
            }
        }
    }

    public void wol() throws IOException {
        if (this.verbose) {
            System.err.println("Sent WOL to " + this.ethernetAddress.toString());
        }
        WakeUpUtil.wakeup((EthernetAddress)this.ethernetAddress);
    }

    public static void wol(String str) throws IOException, FileNotFoundException, FileNotFoundException, HarcHardwareException {
        new Wol(str).wol();
    }

    public static void wol(String str, boolean verbose) throws IOException, FileNotFoundException, FileNotFoundException, HarcHardwareException {
        new Wol(str, verbose).wol();
    }

    public String toString() {
        return "wol " + this.ethernetAddress.toString();
    }

    public static void main(String[] args) {
        try {
            int arg_i = 0;
            if (args[arg_i].equals("-f")) {
                int n = ++arg_i;
                ++arg_i;
                String ethersPath = args[n];
                Ethers.setPathname(ethersPath);
            }
            String thing = args[arg_i];
            Wol.wol(thing, true);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch (HarcHardwareException ex) {
            System.err.println(ex.getMessage());
        }
    }
}

