/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IStringCommand;
import org.harctoolbox.harchardware.comm.LocalSerialPort;
import org.harctoolbox.harchardware.comm.LocalSerialPortBuffered;
import org.harctoolbox.harchardware.ir.ICapture;
import org.harctoolbox.harchardware.ir.IRawIrSender;
import org.harctoolbox.harchardware.ir.IrSerial;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;

public class Arduino
extends IrSerial<LocalSerialPortBuffered>
implements IRawIrSender,
ICapture,
IStringCommand {
    private static final int defaultBeginTimeout = 5000;
    private static final int defaultMiddleTimeout = 1000;
    private static final int defaultEndingTimeout = 500;
    private static final String sendCommand = "send";
    private static final String captureCommand = "analyze";
    private static final String versionCommand = "version";
    public static final String defaultPortName = "/dev/ttyACM0";
    public static final String okString = "OK";
    private String lineEnding = "\r";
    private static final String separator = " ";
    public static final int defaultBaudRate = 115200;
    private static final int dataSize = 8;
    private static final int stopBits = 1;
    private double fallbackFrequency = 38000.0;
    private static final LocalSerialPort.Parity parity = LocalSerialPort.Parity.NONE;
    private static final LocalSerialPort.FlowControl defaultFlowControl = LocalSerialPort.FlowControl.NONE;
    private boolean stopRequested = false;
    private String versionString = "n/a";
    private static final int serialTimeout = 12345;
    private boolean pendingCapture = false;

    public void setLineEnding(String lineEnding) {
        this.lineEnding = lineEnding;
    }

    public void setFallbackFrequency(double fallbackFrequency) {
        this.fallbackFrequency = fallbackFrequency;
    }

    @Override
    public synchronized boolean sendIr(IrSignal irSignal, int count, Transmitter transmitter) throws NoSuchTransmitterException, IrpMasterException, IOException {
        String response;
        String payload = this.formatString(irSignal, count);
        ((LocalSerialPortBuffered)this.serialPort).sendString(payload + this.lineEnding);
        if (this.verbose) {
            System.err.println(payload);
        }
        return (response = ((LocalSerialPortBuffered)this.serialPort).readString()) != null && response.trim().equals(okString);
    }

    public Arduino() throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(defaultPortName, 115200, 5000, 1000, 500, false);
    }

    public Arduino(String portName) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, 115200, 5000, 1000, 500, false);
    }

    public Arduino(String portName, int baudRate, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, baudRate, 5000, 1000, 500, verbose);
    }

    public Arduino(String portName, int baudRate, int beginTimeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, baudRate, beginTimeout, 1000, 500, verbose);
    }

    public Arduino(String portName, int beginTimeout, int middleTimeout, int endingTimeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, 115200, beginTimeout, 1000, 500, verbose);
    }

    public Arduino(String portName, int baudRate, int beginTimeout, int middleTimeout, int endingTimeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        super(LocalSerialPortBuffered.class, portName, baudRate, 8, 1, parity, defaultFlowControl, 12345, verbose);
    }

    @Override
    public void open() throws IOException, HarcHardwareException {
        super.open();
        ((LocalSerialPortBuffered)this.serialPort).waitFor(okString, this.lineEnding, 100, 10);
        ((LocalSerialPortBuffered)this.serialPort).sendString(versionCommand + this.lineEnding);
        this.versionString = ((LocalSerialPortBuffered)this.serialPort).readString(true).trim();
        if (this.verbose) {
            System.err.println("version returned '" + this.versionString + "'.");
        }
    }

    private StringBuilder join(IrSequence irSequence, String separator) {
        if (irSequence == null || irSequence.isEmpty()) {
            return new StringBuilder();
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < irSequence.getLength(); ++i) {
            str.append(separator).append(Integer.toString(irSequence.iget(i)));
        }
        return str;
    }

    private String formatString(IrSignal irSignal, int count) {
        if (irSignal == null) {
            throw new IllegalArgumentException("irSignal cannot be null");
        }
        StringBuilder str = new StringBuilder(sendCommand);
        str.append(separator).append(Integer.toString(count));
        str.append(separator).append(Integer.toString((int)irSignal.getFrequency()));
        str.append(separator).append(Integer.toString(2 * irSignal.getIntroBursts()));
        str.append(separator).append(Integer.toString(2 * irSignal.getRepeatBursts()));
        str.append(separator).append(Integer.toString(2 * irSignal.getEndingBursts()));
        str.append((CharSequence)this.join((IrSequence)irSignal.getIntroSequence(), separator));
        str.append((CharSequence)this.join((IrSequence)irSignal.getRepeatSequence(), separator));
        str.append((CharSequence)this.join((IrSequence)irSignal.getEndingSequence(), separator));
        return str.toString();
    }

    @Override
    public String getVersion() {
        return this.versionString;
    }

    @Override
    public ModulatedIrSequence capture() throws IOException, HarcHardwareException {
        if (this.stopRequested) {
            return null;
        }
        if (!this.isValid()) {
            throw new HarcHardwareException("Port not initialized");
        }
        if (!this.pendingCapture) {
            ((LocalSerialPortBuffered)this.serialPort).sendString(captureCommand + this.lineEnding);
            this.pendingCapture = true;
        }
        ModulatedIrSequence seq = null;
        try {
            String str = ((LocalSerialPortBuffered)this.serialPort).readString(true);
            this.pendingCapture = false;
            if (str == null || str.length() == 0 || str.startsWith("null")) {
                return null;
            }
            str = str.trim();
            double frequency = this.fallbackFrequency;
            if (str.startsWith("f=")) {
                int indx = str.indexOf(32);
                frequency = Integer.parseInt(str.substring(2, indx));
                str = str.substring(indx + 1);
            }
            seq = new ModulatedIrSequence(new IrSequence(str), frequency, -1.0);
        }
        catch (IOException ex) {
            if (ex.getMessage().equals("Underlying input stream returned zero bytes")) {
                return null;
            }
            throw ex;
        }
        catch (IncompatibleArgumentException ex) {
            throw new HarcHardwareException(ex);
        }
        return seq;
    }

    @Override
    public boolean stopCapture() {
        this.stopRequested = true;
        return true;
    }

    @Override
    public void setTimeout(int beginTimeout, int middleTimeout, int endingTimeout) throws IOException {
        this.setTimeout(beginTimeout);
    }

    public void reset() {
        ((LocalSerialPortBuffered)this.serialPort).dropDTR(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String portName = defaultPortName;
        Arduino w = null;
        boolean verbose = true;
        try {
            w = new Arduino(portName, 10000, verbose);
            w.open();
            System.out.println(w.getVersion());
            ModulatedIrSequence seq = w.capture();
            if (seq == null) {
                System.err.println("No input");
                w.close();
                System.exit(1);
            }
            System.out.println(seq);
            DecodeIR.invoke((ModulatedIrSequence)seq);
        }
        catch (IOException ex) {
            System.err.println("exception: " + ex.toString() + ex.getMessage());
        }
        catch (NoSuchPortException ex) {
            System.err.println("No such port: " + portName);
        }
        catch (HarcHardwareException ex) {
            System.err.println(ex.getMessage());
        }
        catch (PortInUseException ex) {
            System.err.println("Port " + portName + " in use.");
        }
        catch (UnsupportedCommOperationException ex) {
            System.err.println(ex.getMessage());
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException ex) {}
            }
        }
        System.exit(0);
    }

    @Override
    public void sendString(String cmd) throws IOException {
        ((LocalSerialPortBuffered)this.serialPort).sendString(cmd);
    }

    @Override
    public String readString() throws IOException {
        return ((LocalSerialPortBuffered)this.serialPort).readString();
    }

    public String readString(boolean wait) throws IOException {
        return ((LocalSerialPortBuffered)this.serialPort).readString(wait);
    }

    @Override
    public boolean ready() throws IOException {
        return ((LocalSerialPortBuffered)this.serialPort).ready();
    }
}

