/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.IrpMaster.Pronto;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.IStringCommand;
import org.harctoolbox.harchardware.Utils;
import org.harctoolbox.harchardware.beacon.AmxBeaconListener;
import org.harctoolbox.harchardware.comm.IBytesCommand;
import org.harctoolbox.harchardware.comm.IWeb;
import org.harctoolbox.harchardware.comm.TcpSocketChannel;
import org.harctoolbox.harchardware.comm.TcpSocketPort;
import org.harctoolbox.harchardware.ir.ICapture;
import org.harctoolbox.harchardware.ir.IRawIrSenderStop;
import org.harctoolbox.harchardware.ir.ITransmitter;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;

public class GlobalCache
implements IHarcHardware,
IRawIrSenderStop,
ITransmitter,
ICapture,
IWeb {
    private static final int smallDelay = 10;
    private static final int gcPort = 4998;
    private static final int gcFirstSerialPort = 4999;
    public static final String defaultGlobalCacheIP = "192.168.1.70";
    public static final int defaultGlobalCachePort = 1;
    public static final String sendIrPrefix = "sendir";
    private static final int defaultSocketTimeout = 2000;
    private static final int beaconTimeout = 60000;
    private static final int invalidDevice = -1;
    public static final int connectorMin = 1;
    public static final int connectorsPerModule = 3;
    public static final int maxCompressedLetters = 15;
    private static final String apiAddressFragment = "/api/v1/";
    private String hostIp;
    private InetAddress inetAddress;
    private int timeout = 2000;
    private boolean verbose = true;
    private String[] getdevicesResult = null;
    private TcpSocketChannel tcpSocketChannel;
    private SerialPort[] serialPorts;
    private ArrayList<Integer> irModules;
    private ArrayList<Integer> serialModules;
    private ArrayList<Integer> relayModules;
    private boolean compressed = false;
    private int firstIrModule = 2;
    private int defaultRelayModule = 3;
    private int defaultSerialModule = 1;
    private static final int defaultConnector = 1;
    private int sendIndex;

    private static String camelCase2uppercase(String cc) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < cc.length(); ++i) {
            char ch = cc.charAt(i);
            if (Character.isUpperCase(ch)) {
                result.append('_');
            }
            result.append(Character.toUpperCase(ch));
        }
        return result.toString();
    }

    @Override
    public URI getUri(String user, String password) {
        try {
            return new URI("http", this.hostIp, null, null);
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public synchronized SerialPort getSerialPort(int portNumber) throws NoSuchTransmitterException {
        int portIndex = portNumber - 1;
        if (portIndex < 0 || portIndex > this.serialPorts.length - 1) {
            throw new NoSuchTransmitterException(Integer.toString(portNumber));
        }
        if (this.serialPorts[portIndex] != null) {
            throw new NoSuchTransmitterException("Requested port " + portNumber + " in GlobalCache " + this.hostIp + " is already in use.");
        }
        this.serialPorts[portIndex] = new SerialPort(portNumber);
        return this.serialPorts[portIndex];
    }

    @Override
    public GlobalCacheIrTransmitter getTransmitter(String str) throws NoSuchTransmitterException {
        if (str == null || str.isEmpty()) {
            return new GlobalCacheIrTransmitter();
        }
        String[] s = str.trim().split(":");
        return s.length == 1 ? new GlobalCacheIrTransmitter(Integer.parseInt(s[0])) : new GlobalCacheIrTransmitter(Integer.parseInt(s[0]), Integer.parseInt(s[1]));
    }

    @Override
    public GlobalCacheIrTransmitter getTransmitter() {
        return new GlobalCacheIrTransmitter();
    }

    public GlobalCacheIrTransmitter newTransmitter(int module, int port) throws NoSuchTransmitterException {
        return new GlobalCacheIrTransmitter(module, port);
    }

    @Override
    public String[] getTransmitterNames() {
        String[] result = new String[this.irModules.size() * 3];
        int index = 0;
        for (Integer module : this.irModules) {
            for (int trans = 0; trans < 3; ++trans) {
                result[index++] = module.toString() + ":" + (trans + 1);
            }
        }
        return result;
    }

    private GlobalCacheIrTransmitter newGlobalCacheIrTransmitter(Transmitter trans) {
        if (trans == null) {
            return new GlobalCacheIrTransmitter();
        }
        GlobalCacheIrTransmitter tr = (GlobalCacheIrTransmitter)trans;
        tr.normalize(this.firstIrModule);
        return tr;
    }

    private static boolean validConnector(int c) {
        return c >= 1 && c <= 3;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
        if (this.tcpSocketChannel != null && this.tcpSocketChannel.isValid()) {
            try {
                this.tcpSocketChannel.setTimeout(timeout);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    private static String gcJoiner(int[] array) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            result.append(",").append(array[i]);
        }
        return result.toString();
    }

    private static String gcCompressedJoiner(int[] intro, int[] repeat) {
        LinkedHashMap<String, Character> index = new LinkedHashMap<String, Character>();
        return GlobalCache.gcCompressedJoiner(intro, index) + GlobalCache.gcCompressedJoiner(repeat, index);
    }

    private static String gcCompressedJoiner(int[] seq, HashMap<String, Character> index) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < seq.length / 2; ++i) {
            String key = "," + seq[2 * i] + "," + seq[2 * i + 1];
            if (index.containsKey(key)) {
                result.append(index.get(key));
                continue;
            }
            if (index.size() < 15) {
                Character letter = Character.valueOf((char)(65 + (char)index.size()));
                index.put(key, letter);
            }
            result.append(key);
        }
        return result.toString();
    }

    private static String globalCacheString(IrSignal code, int count, boolean compressed) {
        int[] intro = code.getIntroPulses();
        int[] repeat = code.getRepeatPulses();
        return (int)code.getFrequency() + "," + count + "," + (1 + intro.length) + (compressed ? GlobalCache.gcCompressedJoiner(intro, repeat) : GlobalCache.gcJoiner(intro) + GlobalCache.gcJoiner(repeat));
    }

    public GlobalCache(String hostIp, boolean verbose, int timeout, boolean compressed) throws UnknownHostException, IOException {
        this.timeout = timeout;
        this.hostIp = hostIp != null ? hostIp : defaultGlobalCacheIP;
        this.inetAddress = InetAddress.getByName(hostIp);
        this.verbose = verbose;
        this.compressed = compressed;
        this.open();
    }

    @Override
    public final void open() throws UnknownHostException, IOException {
        this.tcpSocketChannel = new TcpSocketChannel(this.hostIp, 4998, this.timeout, this.verbose, TcpSocketPort.ConnectionMode.keepAlive);
        this.getdevicesResult = this.sendCommand("getdevices", -1);
        this.irModules = this.getIrModules();
        this.firstIrModule = this.irModules.isEmpty() ? -1 : this.irModules.get(0);
        this.serialModules = this.getSerialModules();
        this.defaultSerialModule = this.serialModules.isEmpty() ? -1 : this.serialModules.get(0);
        this.serialPorts = new SerialPort[this.serialModules.size()];
        this.relayModules = this.getRelayModules();
        this.defaultRelayModule = this.relayModules.isEmpty() ? -1 : this.relayModules.get(0);
    }

    public GlobalCache(String hostIp, boolean verbose, int timeout) throws UnknownHostException, IOException {
        this(hostIp, verbose, timeout, false);
    }

    public GlobalCache(String hostname) throws UnknownHostException, IOException {
        this(hostname, false, 2000, false);
    }

    public GlobalCache(String hostname, boolean verbose, boolean compressed) throws UnknownHostException, IOException {
        this(hostname, verbose, 2000, compressed);
    }

    public GlobalCache(String hostname, boolean verbose) throws UnknownHostException, IOException {
        this(hostname, verbose, 2000, false);
    }

    public String getIp() {
        return this.hostIp;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.tcpSocketChannel != null) {
            this.tcpSocketChannel.close(true);
        }
        this.getdevicesResult = null;
    }

    @Override
    public void setVerbosity(boolean verbosity) {
        this.verbose = verbosity;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    private static String transmitterAddress(int module, int connector) throws NoSuchTransmitterException {
        if (connector < 1 || connector > 3) {
            throw new NoSuchTransmitterException("" + module + ":" + connector);
        }
        return "" + module + ":" + connector;
    }

    private static String transmitterAddress(int module) {
        return "" + module + ":1";
    }

    private synchronized String[] sendCommand(String cmd, int noLines, int delay, String expectedFirstLine) throws IOException {
        String[] result;
        if (this.verbose) {
            System.err.println("Sending command " + cmd + " to GlobalCache (" + this.hostIp + ")");
        }
        this.tcpSocketChannel.connect();
        if (noLines != 0) {
            while (this.tcpSocketChannel.getBufferedIn().ready()) {
                this.tcpSocketChannel.readString();
            }
        }
        this.tcpSocketChannel.sendString(cmd + '\r');
        if (delay > 0) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (noLines >= 0) {
            result = new String[noLines];
            for (int i = 0; i < noLines; ++i) {
                result[i] = this.tcpSocketChannel.readString();
                if (this.verbose) {
                    System.err.println(result[i]);
                }
                if (i != 0 || expectedFirstLine == null || result[0].startsWith(expectedFirstLine)) continue;
                System.err.println("Expected \"" + expectedFirstLine + "\", returning immediately.");
                break;
            }
        } else {
            ArrayList<String> array = new ArrayList<String>();
            array.add(this.tcpSocketChannel.readString());
            while (this.tcpSocketChannel.getBufferedIn().ready()) {
                String resp = this.tcpSocketChannel.readString();
                array.add(resp);
            }
            result = array.toArray(new String[array.size()]);
        }
        this.tcpSocketChannel.close(false);
        return result;
    }

    private String sendCommand(String cmd) throws IOException {
        return this.sendCommand(cmd, 1, 10, null)[0];
    }

    private String[] sendCommand(String cmd, int noLines) throws IOException {
        return this.sendCommand(cmd, noLines, 10, null);
    }

    public boolean stopIr(int module, int connector) throws IOException, NoSuchTransmitterException {
        this.sendCommand("stopir," + GlobalCache.transmitterAddress(module, connector), 1);
        return true;
    }

    @Override
    public boolean stopIr(Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        GlobalCacheIrTransmitter gctransmitter = this.newGlobalCacheIrTransmitter(transmitter);
        return this.stopIr(gctransmitter.module, gctransmitter.port);
    }

    public boolean sendIr(String cmd) throws IOException {
        String result = this.sendCommand(cmd);
        return result.startsWith("completeir");
    }

    public static String sendIrString(IrSignal code, int count, int module, int connector, int sendIndex, boolean compressed) throws NoSuchTransmitterException {
        return "sendir," + GlobalCache.transmitterAddress(module, connector) + "," + sendIndex % 65536 + "," + GlobalCache.globalCacheString(code, count, compressed);
    }

    public String sendIrString(IrSignal code, int count, int module, int connector) throws NoSuchTransmitterException {
        String cmd = GlobalCache.sendIrString(code, count, module, connector, this.sendIndex, this.compressed);
        this.sendIndex = (this.sendIndex + 1) % 65536;
        return cmd;
    }

    public boolean sendIr(IrSignal code, int count, int module, int connector) throws NoSuchTransmitterException, IOException {
        if (!GlobalCache.validConnector(connector)) {
            throw new NoSuchTransmitterException(Integer.toString(connector));
        }
        String cmd = this.sendIrString(code, count, module, connector);
        return this.sendIr(cmd);
    }

    public boolean sendIr(IrSignal code, int count, int connector) throws IOException, NoSuchTransmitterException {
        return this.sendIr(code, count, new GlobalCacheIrTransmitter(connector));
    }

    public boolean sendIr(IrSignal code, int connector) throws IOException, NoSuchTransmitterException {
        return this.sendIr(code, 1, new GlobalCacheIrTransmitter(connector));
    }

    public boolean sendIr(IrSignal code) throws IOException, NoSuchTransmitterException {
        return this.sendIr(code, 1, null);
    }

    @Override
    public boolean sendIr(IrSignal code, int count, Transmitter transmitter) throws NoSuchTransmitterException, IOException {
        GlobalCacheIrTransmitter gct = this.newGlobalCacheIrTransmitter(transmitter);
        return this.sendIr(code, count, gct.module, gct.port);
    }

    public boolean sendIr(String ccf, int count, int module, int connector) throws IrpMasterException, NoSuchTransmitterException, IOException {
        return this.sendIr(Pronto.ccfSignal((String)ccf), count, module, connector);
    }

    public boolean sendCcf(String ccfString, int count, Transmitter transmitter) throws IOException, IrpMasterException, NoSuchTransmitterException {
        GlobalCacheIrTransmitter gctransmitter = this.newGlobalCacheIrTransmitter(transmitter);
        return this.sendIr(ccfString, count, gctransmitter.module, gctransmitter.port);
    }

    public boolean sendCcfRepeat(String ccfString, Transmitter transmitter) throws IOException, IrpMasterException, NoSuchTransmitterException {
        GlobalCacheIrTransmitter gctransmitter = this.newGlobalCacheIrTransmitter(transmitter);
        return this.sendIr(ccfString, 1000, gctransmitter.module, gctransmitter.port);
    }

    public String[] getDevices() {
        return (String[])this.getdevicesResult.clone();
    }

    public String getVersion(int module) throws IOException {
        return this.sendCommand("getversion," + module);
    }

    @Override
    public String getVersion() throws IOException {
        return this.getVersion(0);
    }

    public String getNet() throws IOException {
        return this.sendCommand("get_NET,0:1");
    }

    public String setNet(String arg) throws IOException {
        return this.sendCommand("set_NET,0:1," + arg);
    }

    public String getIr(int module, int connector) throws IOException, NoSuchTransmitterException {
        return this.sendCommand("get_IR," + GlobalCache.transmitterAddress(module, connector));
    }

    private ArrayList<Integer> getModules(String moduleType) {
        ArrayList<Integer> modules = new ArrayList<Integer>();
        for (String devicesResult : this.getdevicesResult) {
            String[] s = devicesResult.split(" ");
            if (s.length <= 1 || !s[1].startsWith(moduleType)) continue;
            modules.add(Integer.parseInt(devicesResult.substring(7, 8)));
        }
        return modules;
    }

    public final ArrayList<Integer> getIrModules() {
        return this.getModules("IR");
    }

    public final ArrayList<Integer> getSerialModules() {
        return this.getModules("SERIAL");
    }

    public final ArrayList<Integer> getRelayModules() {
        return this.getModules("RELAY");
    }

    public String setIr(int module, int connector, String modestr) throws IOException, NoSuchTransmitterException {
        return this.sendCommand("set_IR," + GlobalCache.transmitterAddress(module, connector) + "," + modestr.toUpperCase(IrpUtils.dumbLocale));
    }

    public String setIr(int module, int connector, IrConfiguration mode) throws IOException, NoSuchTransmitterException {
        return this.setIr(module, connector, mode.toString());
    }

    public String getSerial(int module) throws IOException {
        return this.sendCommand("get_SERIAL," + GlobalCache.transmitterAddress(module));
    }

    public String getSerial() throws IOException {
        return this.getSerial(this.defaultSerialModule);
    }

    public String setSerial(int module, String arg) throws IOException {
        return this.sendCommand("set_SERIAL," + GlobalCache.transmitterAddress(module) + "," + arg);
    }

    public String setSerial(String arg) throws IOException {
        return this.setSerial(this.defaultSerialModule, arg);
    }

    public String setSerial(int module, int baudrate) throws IOException {
        return this.sendCommand("set_SERIAL," + GlobalCache.transmitterAddress(module) + "," + baudrate);
    }

    public String setSerial(int baudrate) throws IOException {
        return this.setSerial(this.defaultSerialModule, baudrate);
    }

    public int getState(int module, int connector) throws IOException, NoSuchTransmitterException {
        return Integer.parseInt(this.sendCommand("getstate," + GlobalCache.transmitterAddress(module, connector)).substring(10, 11));
    }

    public int getState(int connector) throws IOException, NoSuchTransmitterException {
        return this.getState(this.firstIrModule + (connector - 1) / 3, (connector - 1) % 3 + 1);
    }

    public boolean toggleState(int module, int connector) throws IOException, NoSuchTransmitterException {
        return this.setState(module, connector, 1 - this.getState(module, connector));
    }

    public boolean toggleState(int connector) throws IOException, NoSuchTransmitterException {
        return this.toggleState(this.defaultRelayModule, connector);
    }

    public boolean setState(int module, int connector, int state) throws IOException, NoSuchTransmitterException {
        String result = this.sendCommand("setstate," + GlobalCache.transmitterAddress(module, connector) + "," + (state == 0 ? 0 : 1));
        if (this.verbose) {
            System.err.println(result.substring(0, 5));
        }
        return result.substring(0, 5).equals("state");
    }

    public boolean setState(int connector, int state) throws IOException, NoSuchTransmitterException {
        return this.setState(this.defaultRelayModule, connector, state);
    }

    public boolean setState(int connector, boolean onOff) throws IOException, NoSuchTransmitterException {
        return this.setState(connector, onOff ? 1 : 0);
    }

    public boolean pulseState(int module, int connector) throws NoSuchTransmitterException, IOException {
        this.sendCommand("setstate," + GlobalCache.transmitterAddress(module, connector) + ",1", 0, 300, null);
        this.sendCommand("setstate," + GlobalCache.transmitterAddress(module, connector) + ",0", 0, 0, null);
        return true;
    }

    public boolean pulseState(int connector) throws NoSuchTransmitterException, IOException {
        return this.pulseState(this.defaultRelayModule, connector);
    }

    public void setBlink(int arg) throws IOException {
        this.sendCommand("blink," + arg, 0);
    }

    @Override
    public boolean isValid() {
        return this.getdevicesResult != null;
    }

    @Override
    public synchronized ModulatedIrSequence capture() throws HarcHardwareException {
        try {
            String[] result = this.sendCommand("get_IRL", 2, 10, "IR Learner Enabled");
            if (!result[0].equals("IR Learner Enabled")) {
                throw new HarcHardwareException("Hardware does not appear to support sending");
            }
            IrSignal signal = GlobalCache.parse(result[1]);
            return signal != null ? signal.toModulatedIrSequence(1) : null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public synchronized void setTimeout(int beginTimeout, int maxLength, int endTimeout) {
        this.setTimeout(beginTimeout);
    }

    @Override
    public boolean stopCapture() {
        String response;
        try {
            response = this.sendCommand("stop_IRL");
        }
        catch (IOException ex) {
            return false;
        }
        return response.startsWith("IR Learner Disabled");
    }

    public static AmxBeaconListener.Node listenBeacon(int timeout) {
        return AmxBeaconListener.listenFor("-Make", "GlobalCache", timeout);
    }

    public static AmxBeaconListener.Node listenBeacon() {
        return GlobalCache.listenBeacon(60000);
    }

    public static AmxBeaconListener newListener(AmxBeaconListener.Callback callback, boolean debug) {
        AmxBeaconListener abl = new AmxBeaconListener(callback, "-Make", "GlobalCache", debug);
        abl.start();
        return abl;
    }

    private InputStreamReader getJsonReader(String thing) throws IOException {
        URL url = new URL("http", this.hostIp, apiAddressFragment + thing);
        URLConnection urlConnection = url.openConnection();
        return new InputStreamReader(urlConnection.getInputStream(), IrpUtils.dumbCharset);
    }

    private JsonObject getJsonObject(String thing) throws IOException {
        return JsonObject.readFrom((Reader)this.getJsonReader(thing));
    }

    private JsonArray getJsonArray(String thing) throws IOException {
        return JsonArray.readFrom((Reader)this.getJsonReader(thing));
    }

    private JsonObject getJsonVersion() throws IOException {
        return this.getJsonObject("version");
    }

    private JsonObject getJsonNetwork() throws IOException {
        return this.getJsonObject("network");
    }

    private JsonArray getJsonSsid() throws IOException {
        try {
            return this.getJsonArray("network/ssid");
        }
        catch (UnsupportedOperationException ex) {
            return null;
        }
    }

    private JsonArray getJsonConnectors() throws IOException {
        return this.getJsonArray("connectors");
    }

    private JsonArray getJsonFiles() throws IOException {
        return this.getJsonArray("files");
    }

    public static IrSignal parse(String gcString) {
        String[] chunks = gcString.split(",");
        int index = 0;
        if (!chunks[index++].trim().equals(sendIrPrefix)) {
            return null;
        }
        ++index;
        int n = ++index;
        ++index;
        int frequency = Integer.parseInt(chunks[n].trim());
        int n2 = ++index;
        int repIndex = Integer.parseInt(chunks[n2].trim());
        int[] durations = new int[chunks.length - ++index];
        double T = 1000000.0 / (double)frequency;
        for (int i = 0; i < chunks.length - index; ++i) {
            durations[i] = (int)Math.round((double)Integer.parseInt(chunks[i + index]) * T);
        }
        return new IrSignal(durations, (repIndex - 1) / 2, (durations.length - repIndex + 1) / 2, frequency);
    }

    private static void usage() {
        System.err.println("Usagex:");
        System.err.println("GlobalCache [options] <command> [<argument>]");
        System.err.println("where options=-# <count>,-h <hostname>,-c <connector>,-m <module>,-b <baudrate>,-t <timeout>,-p <sendirstring>,-v,-B,-j");
        System.err.println("and command=send_ir,send_serial,listen_serial,set_relay,get_devices,get_version,set_blink,[set|get]_serial,[set|get]_ir,[set|get]_net,[get|set]_state,get_learn,ccf");
        GlobalCache.doExit(1);
    }

    private static void doExit(int exitcode) {
        System.exit(exitcode);
    }

    public static void main(String[] args) {
        String hostname = defaultGlobalCacheIP;
        int connector = 1;
        int module = 2;
        int count = 1;
        boolean verbose = false;
        boolean beacon = false;
        int baudrate = 0;
        GlobalCache gc = null;
        String cmd = null;
        String arg = null;
        int arg_i = 0;
        int timeout = 2000;
        String parserFood = null;
        boolean json = false;
        if (args.length == 0) {
            GlobalCache.usage();
        }
        try {
            while (arg_i < args.length && args[arg_i].charAt(0) == '-') {
                if (args[arg_i].equals("-h")) {
                    hostname = args[arg_i + 1];
                    arg_i += 2;
                    continue;
                }
                if (args[arg_i].equals("-m")) {
                    module = Integer.parseInt(args[arg_i + 1]);
                    arg_i += 2;
                    continue;
                }
                if (args[arg_i].equals("-c")) {
                    connector = Integer.parseInt(args[arg_i + 1]);
                    arg_i += 2;
                    continue;
                }
                if (args[arg_i].equals("-#")) {
                    count = Integer.parseInt(args[arg_i + 1]);
                    arg_i += 2;
                    continue;
                }
                if (args[arg_i].equals("-b")) {
                    baudrate = Integer.parseInt(args[arg_i + 1]);
                    arg_i += 2;
                    continue;
                }
                if (args[arg_i].equals("-v")) {
                    verbose = true;
                    ++arg_i;
                    continue;
                }
                if (args[arg_i].equals("-t")) {
                    timeout = Integer.parseInt(args[arg_i + 1]);
                    arg_i += 2;
                    continue;
                }
                if (args[arg_i].equals("-B")) {
                    beacon = true;
                    ++arg_i;
                    continue;
                }
                if (args[arg_i].equals("-j")) {
                    json = true;
                    ++arg_i;
                    continue;
                }
                if (args[arg_i].equals("-p")) {
                    parserFood = args[arg_i + 1];
                    arg_i += 2;
                    continue;
                }
                GlobalCache.usage();
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            GlobalCache.usage();
        }
        catch (NumberFormatException ex) {
            System.err.println(ex.getMessage());
        }
        if (parserFood != null) {
            IrSignal sig = GlobalCache.parse(parserFood);
            System.out.println(sig);
            System.exit(0);
        }
        String output = "";
        if (beacon) {
            AmxBeaconListener.Node r = GlobalCache.listenBeacon();
            if (r != null) {
                String model = r.get("-Model");
                hostname = r.getInetAddress().getHostName();
            } else {
                System.err.println("none found");
                System.exit(1);
            }
        }
        try {
            gc = new GlobalCache(hostname, verbose, timeout);
            if (json) {
                try {
                    JsonObject obj = gc.getJsonVersion();
                    System.out.println(obj);
                    System.out.println(obj.get("firmwareVersion").asString());
                    System.out.println(gc.getJsonNetwork());
                    System.out.println(gc.getJsonSsid());
                    System.out.println(gc.getJsonConnectors());
                    System.out.println(gc.getJsonFiles());
                }
                catch (IOException ex) {
                    System.err.println(ex.getMessage());
                }
                System.exit(0);
            }
            if (args.length - 1 < arg_i) {
                System.exit(0);
            }
            cmd = args[arg_i];
            String string = arg = args.length > arg_i + 1 ? args[arg_i + 1] : null;
            if (cmd.equals("set_blink")) {
                if (arg == null || !arg.equals("1")) {
                    gc.setBlink(0);
                } else {
                    gc.setBlink(1);
                }
            } else if (cmd.equals("get_devices")) {
                output = IrpUtils.join((String[])gc.getDevices(), (String)System.getProperty("line.separator"));
            } else if (cmd.equals("get_version")) {
                output = gc.getVersion(module);
            } else if (cmd.equals("get_net")) {
                output = gc.getNet();
            } else if (cmd.equals("set_net")) {
                output = gc.setNet(arg);
            } else if (cmd.equals("get_ir")) {
                output = gc.getIr(module, connector);
            } else if (cmd.equals("set_ir")) {
                output = gc.setIr(module, connector, arg);
            } else if (cmd.equals("get_serial")) {
                output = gc.getSerial(module);
            } else if (cmd.equals("set_serial")) {
                output = baudrate > 0 ? gc.setSerial(module, baudrate) : gc.setSerial(module, arg);
            } else if (cmd.equals("get_state")) {
                output = gc.getState(module, connector) == 1 ? "on" : "off";
            } else if (cmd.equals("toggle_state")) {
                output = gc.toggleState(connector) ? "ok" : "not ok";
            } else if (cmd.equals("set_state")) {
                output = gc.setState(connector, arg == null || arg.equals("0") ? 0 : 1) ? "on" : "off";
            } else if (cmd.equals("set_relay")) {
                output = gc.setState(connector, arg == null || arg.equals("0") ? 0 : 1) ? "on" : "off";
            } else if (cmd.equals("send_ir")) {
                if (arg_i + 2 == args.length) {
                    output = gc.sendIr(args[arg_i + 1]) ? "ok" : "error";
                } else {
                    StringBuilder ccf = new StringBuilder();
                    for (int i = arg_i + 1; i < args.length; ++i) {
                        ccf.append(' ').append(args[i]);
                    }
                    output = gc.sendIr(ccf.toString(), count, module, connector) ? "ok" : "error";
                }
            } else if (cmd.equals("send_serial")) {
                StringBuilder transmit = new StringBuilder();
                for (int i = arg_i + 1; i < args.length; ++i) {
                    transmit.append(' ').append(args[i]);
                }
            } else if (cmd.equals("stop_ir")) {
                gc.stopIr(module, connector);
            } else if (cmd.equals("get_learn")) {
                ModulatedIrSequence seq = gc.capture();
                System.out.println(seq);
                if (seq != null) {
                    System.out.println(DecodeIR.DecodedSignal.toPrintString((DecodeIR.DecodedSignal[])DecodeIR.decode((ModulatedIrSequence)seq)));
                }
            } else if (cmd.equals("listen_serial")) {
                System.err.println("Press Ctrl-C to interrupt.");
            } else {
                GlobalCache.usage();
            }
            gc.close();
        }
        catch (HarcHardwareException e) {
            System.err.println(e.getMessage());
        }
        catch (UnknownHostException e) {
            System.err.println("Host " + hostname + " does not resolve.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("IOException occured.");
            System.exit(1);
        }
        catch (IrpMasterException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        System.err.println(output);
    }

    public static class GlobalCacheIrTransmitter
    extends Transmitter {
        private int module;
        private int port;

        private GlobalCacheIrTransmitter(int module, int port) throws NoSuchTransmitterException {
            if (!GlobalCache.validConnector(port)) {
                throw new NoSuchTransmitterException(Integer.toString(port));
            }
            this.module = module;
            this.port = port;
        }

        private GlobalCacheIrTransmitter(int port) throws NoSuchTransmitterException {
            this(-1, port);
        }

        private GlobalCacheIrTransmitter() {
            this.module = -1;
            this.port = 1;
        }

        private void normalize(int defaultIrModule) {
            if (this.module == -1) {
                this.module = (this.port - 1) / 3 + defaultIrModule;
                this.port = (this.port - 1) % 3 + 1;
            }
        }

        public String toString() {
            return Integer.toString(this.module) + ":" + Integer.toString(this.port);
        }
    }

    public class SerialPort
    implements IStringCommand,
    IBytesCommand {
        private int portIndex;
        private TcpSocketChannel tcpSocketChannel;

        private SerialPort(int portNumber) throws NoSuchTransmitterException {
            this.portIndex = portNumber - 1;
            if (this.portIndex < 0 || this.portIndex > GlobalCache.this.serialPorts.length - 1) {
                throw new NoSuchTransmitterException(Integer.toString(portNumber));
            }
            this.tcpSocketChannel = new TcpSocketChannel(GlobalCache.this.inetAddress, 4999 + this.portIndex, GlobalCache.this.timeout, GlobalCache.this.verbose, TcpSocketPort.ConnectionMode.keepAlive);
        }

        @Override
        public void sendString(String cmd) throws IOException {
            this.sendBytes(cmd.getBytes(IrpUtils.dumbCharset));
        }

        @Override
        public synchronized String readString() throws IOException {
            this.tcpSocketChannel.connect();
            String result = this.tcpSocketChannel.getBufferedIn().readLine();
            this.tcpSocketChannel.close(false);
            return result;
        }

        @Override
        public synchronized void close() throws IOException {
            this.tcpSocketChannel.close(true);
            ((GlobalCache)GlobalCache.this).serialPorts[this.portIndex] = null;
        }

        @Override
        public synchronized void sendBytes(byte[] cmd) throws IOException {
            this.tcpSocketChannel.connect();
            this.tcpSocketChannel.getOut().write(cmd);
            this.tcpSocketChannel.close(false);
        }

        @Override
        public synchronized byte[] readBytes(int length) throws IOException {
            this.tcpSocketChannel.connect();
            byte[] result = Utils.readBytes(this.tcpSocketChannel.getIn(), length);
            this.tcpSocketChannel.close(false);
            return result;
        }

        @Override
        public String getVersion() {
            return this.tcpSocketChannel.getVersion();
        }

        @Override
        public void setVerbosity(boolean verbosity) {
            this.tcpSocketChannel.setVerbosity(GlobalCache.this.verbose);
        }

        @Override
        public void setTimeout(int timeout) throws SocketException {
            this.tcpSocketChannel.setTimeout(timeout);
        }

        @Override
        public boolean isValid() {
            return this.tcpSocketChannel.isValid();
        }

        @Override
        public void open() {
            this.tcpSocketChannel.open();
        }

        @Override
        public boolean ready() throws IOException {
            return this.tcpSocketChannel.ready();
        }
    }

    public static enum ModuleType {
        unknown,
        ir,
        serial,
        relay,
        wifi,
        ethernet,
        net;


        public String toString() {
            return GlobalCache.camelCase2uppercase(this.name());
        }
    }

    public static enum IrConfiguration {
        ir,
        sensor,
        sensorNotify,
        irNocarrier,
        serial,
        irBlaster,
        irtriport,
        irtriportBlaster,
        ledLighting;


        public String toString() {
            return GlobalCache.camelCase2uppercase(this.name());
        }
    }
}

