/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import java.io.IOException;
import javax.sound.sampled.LineUnavailableException;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.IrpMaster.Wave;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.ir.IRawIrSender;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;

public class IrAudioDevice
implements IHarcHardware,
IRawIrSender {
    private int sampleFrequency;
    private int sampleSize;
    private int channels;
    private boolean bigEndian;
    private boolean omitTail;
    private boolean square;
    private boolean divide;
    private boolean verbose;

    public IrAudioDevice(int sampleFrequency, int sampleSize, int channels, boolean bigEndian, boolean omitTail, boolean square, boolean divide, boolean verbose) {
        this.sampleFrequency = sampleFrequency;
        this.sampleSize = sampleSize;
        this.channels = channels;
        this.bigEndian = bigEndian;
        this.omitTail = omitTail;
        this.square = square;
        this.divide = divide;
        this.verbose = verbose;
    }

    public IrAudioDevice(int sampleFrequency, int channels, boolean omitTail, boolean verbose) {
        this(sampleFrequency, 8, channels, false, omitTail, true, true, verbose);
    }

    @Override
    public boolean sendIr(IrSignal irSignal, int count, Transmitter transmitter) throws NoSuchTransmitterException, IrpMasterException, IOException {
        ModulatedIrSequence seq = irSignal.toModulatedIrSequence(count);
        Wave wave = new Wave(seq, this.sampleFrequency, this.sampleSize, this.channels, this.bigEndian, this.omitTail, this.square, this.divide);
        try {
            wave.play();
            if (this.verbose) {
                System.err.println("Sent IrSignal @ " + this.sampleFrequency + "Hz, " + this.sampleSize + "bits to audio device");
            }
            return true;
        }
        catch (LineUnavailableException ex) {
            return false;
        }
    }

    @Override
    public String getVersion() throws IOException {
        return null;
    }

    @Override
    public void setVerbosity(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void setTimeout(int timeout) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public Transmitter getTransmitter() {
        return null;
    }
}

