/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.harchardware.comm.LocalSerialPort;
import org.harctoolbox.harchardware.comm.LocalSerialPortBuffered;
import org.harctoolbox.harchardware.ir.IRawIrSender;
import org.harctoolbox.harchardware.ir.IrSerial;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;

public class IrGenericSerial
extends IrSerial<LocalSerialPortBuffered>
implements IRawIrSender {
    private String command;
    private boolean useSigns;
    private String separator;
    private String lineEnding;
    private boolean raw;

    public void setCommand(String command) {
        this.command = command;
    }

    public void setUseSigns(boolean useSigns) {
        this.useSigns = useSigns;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setLineEnding(String lineEnding) {
        this.lineEnding = lineEnding;
    }

    public void setRaw(boolean raw) {
        this.raw = raw;
    }

    @Override
    public synchronized boolean sendIr(IrSignal irSignal, int count, Transmitter transmitter) throws NoSuchTransmitterException, IrpMasterException, IOException {
        String payload = this.formatString(irSignal, count);
        ((LocalSerialPortBuffered)this.serialPort).sendString(payload);
        if (this.verbose) {
            System.err.print(payload);
        }
        return true;
    }

    public IrGenericSerial(String portName, int baudRate, int dataSize, int stopBits, LocalSerialPort.Parity parity, LocalSerialPort.FlowControl flowControl, int timeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        super(LocalSerialPortBuffered.class, portName, baudRate, dataSize, stopBits, parity, flowControl, timeout, verbose);
    }

    private String formatString(IrSignal irSignal, int count) {
        if (irSignal == null) {
            throw new IllegalArgumentException("irSignal cannot be null");
        }
        StringBuilder str = new StringBuilder(this.command);
        str.append(" ");
        ModulatedIrSequence seq = irSignal.toModulatedIrSequence(count);
        if (this.raw) {
            str.append(seq.toPrintString(this.useSigns, !this.useSigns, this.separator));
        } else {
            try {
                IrSignal signal = new IrSignal(seq.getFrequency(), seq.getDutyCycle(), (IrSequence)seq, null, null);
                str.append(signal.ccfString());
            }
            catch (IncompatibleArgumentException ex) {
                throw new RuntimeException("Silly IrSignal/CCF");
            }
        }
        str.append(this.lineEnding);
        return str.toString();
    }
}

