/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.comm.IWeb;
import org.harctoolbox.harchardware.ir.IRawIrSender;
import org.harctoolbox.harchardware.ir.ITransmitter;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;

public class IrTrans
implements IHarcHardware,
IRawIrSender,
ITransmitter,
IWeb {
    public static final String defaultIrTransIP = "192.168.0.32";
    protected static final int dummyDelay = 10;
    protected static final int defaultTimeout = 2000;
    protected int timeout = 2000;
    protected String irTransIP;
    protected InetAddress inetAddress = null;
    protected boolean verbose = true;
    public static final int portNumber = 21000;
    protected Interface interfaze = Interface.tcpAscii;

    @Override
    public void close() {
    }

    @Override
    public URI getUri(String user, String password) {
        try {
            return new URI("http", this.irTransIP, null, null);
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    @Override
    public void open() {
    }

    @Override
    public IrTransTransmitter getTransmitter() {
        return new IrTransTransmitter();
    }

    public IrTransTransmitter newTransmitter(Led led) {
        return new IrTransTransmitter(led);
    }

    @Override
    public IrTransTransmitter getTransmitter(String port) throws NoSuchTransmitterException {
        return new IrTransTransmitter(Led.parse(port));
    }

    @Override
    public String[] getTransmitterNames() {
        String[] result = new String[Led.values().length];
        int i = 0;
        for (Led led : Led.values()) {
            result[i++] = led.name();
        }
        return result;
    }

    public IrTrans(String hostname, boolean verbose, int timeout, Interface interfaze) throws UnknownHostException {
        this.timeout = timeout;
        this.irTransIP = hostname != null ? hostname : defaultIrTransIP;
        this.inetAddress = InetAddress.getByName(this.irTransIP);
        this.verbose = verbose;
        this.interfaze = interfaze;
    }

    public IrTrans(String hostname, boolean verbose, int timeout) throws UnknownHostException {
        this(hostname, verbose, timeout, Interface.tcpAscii);
    }

    public IrTrans(String hostname, boolean verbose) throws UnknownHostException {
        this(hostname, verbose, 2000, Interface.tcpAscii);
    }

    public IrTrans(String hostname) throws UnknownHostException {
        this(hostname, false, 2000, Interface.tcpAscii);
    }

    @Override
    public boolean isValid() {
        return this.inetAddress != null;
    }

    @Override
    public void setVerbosity(boolean verbosity) {
        this.verbose = verbosity;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String sendCommand(String cmd) throws IOException {
        if (this.verbose) {
            System.err.println("Sending command `" + cmd + "' to IrTrans (tcp ascii)");
        }
        Socket sock = null;
        PrintStream outToServer = null;
        BufferedReader inFromServer = null;
        String result = "";
        try {
            sock = new Socket();
            sock.connect(new InetSocketAddress(this.inetAddress, 21000), this.timeout);
            sock.setSoTimeout(this.timeout);
            outToServer = new PrintStream(sock.getOutputStream(), false, "US-ASCII");
            inFromServer = new BufferedReader(new InputStreamReader(sock.getInputStream(), IrpUtils.dumbCharset));
            outToServer.print("ASCI");
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            outToServer.print(cmd);
            while (!inFromServer.ready()) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException ex) {}
            }
            result = inFromServer.readLine();
        }
        finally {
            if (outToServer != null) {
                outToServer.close();
            }
            if (inFromServer != null) {
                inFromServer.close();
            }
            if (sock != null) {
                sock.close();
            }
        }
        if (this.verbose) {
            System.err.println(result);
        }
        return result;
    }

    @Override
    public String getVersion() throws IOException {
        return this.sendCommand("Aver");
    }

    protected boolean getUrl(String url) throws MalformedURLException, IOException {
        if (this.verbose) {
            System.err.println("Getting URL " + url);
        }
        new URL(url).openStream();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendCommandUdp(String cmd) throws IOException {
        boolean success = false;
        if (this.verbose) {
            System.err.println("Sending command `" + cmd + "' to IrTrans over UDP");
        }
        DatagramSocket sock = null;
        try {
            sock = new DatagramSocket();
            sock.setSoTimeout(this.timeout);
            byte[] buf = cmd.getBytes("US-ASCII");
            DatagramPacket dp = new DatagramPacket(buf, buf.length, this.inetAddress, 21000);
            sock.send(dp);
            success = true;
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
        return success;
    }

    public boolean sendCcf(String ccf, int count, Led led) throws IOException {
        boolean success = true;
        for (int c = 0; c < count; ++c) {
            success = success && this.sendCcf(ccf, c > 0, led);
        }
        return success;
    }

    public boolean sendCcf(String ccf, int count, Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        if (!IrTransTransmitter.class.isInstance(transmitter)) {
            throw new NoSuchTransmitterException(transmitter);
        }
        IrTransTransmitter trans = (IrTransTransmitter)transmitter;
        return this.sendCcf(ccf, count, trans.led);
    }

    public boolean sendCcfRepeat(String ccf, Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        return this.sendCcf(ccf, 1000, transmitter);
    }

    private boolean sendCcf(String ccf, boolean repeat, Led led) throws IOException {
        return this.sendCommandUdp((repeat ? "sndccfr " : "sndccf ") + ccf.trim() + "," + Led.ledChar(led));
    }

    private boolean sendIr(IrSignal code, boolean repeat, Led led) throws IncompatibleArgumentException, IOException {
        return this.sendCcf(code.ccfString(), repeat, led);
    }

    public boolean sendIr(IrSignal code, int count, Led led) throws IncompatibleArgumentException, IOException {
        boolean success = true;
        for (int c = 0; c < count; ++c) {
            success = success && this.sendIr(code, c > 0, led);
        }
        return success;
    }

    @Override
    public boolean sendIr(IrSignal code, int count, Transmitter transmitter) throws IrpMasterException, IOException, NoSuchTransmitterException {
        if (!IrTransTransmitter.class.isInstance(transmitter)) {
            throw new NoSuchTransmitterException(transmitter);
        }
        return this.sendIr(code, count, ((IrTransTransmitter)transmitter).led);
    }

    private static void usage(int exitstatus) {
        System.err.println("Usage:");
        System.err.println("\tIrTrans [-v][-h <hostname>] -r [<remotename>]");
        IrTrans.doExit(exitstatus);
    }

    private static void doExit(int exitcode) {
        System.exit(exitcode);
    }

    public static void main(String[] args) {
        boolean verbose = false;
        String IrTransHost = defaultIrTransIP;
        int optarg = 0;
        if (args.length > optarg && args[optarg].equals("-v")) {
            ++optarg;
            verbose = true;
        }
        if (args.length > optarg + 1 && args[optarg].equals("-h")) {
            IrTransHost = args[optarg + 1];
            optarg += 2;
        }
        try {
            IrTrans irt = new IrTrans(IrTransHost, verbose, 2000, Interface.tcpAscii);
            if (verbose) {
                System.out.println(irt.getVersion());
            }
            if (args.length > optarg && args[optarg].equals("-c")) {
                StringBuilder ccf = new StringBuilder();
                for (int i = optarg + 1; i < args.length; ++i) {
                    ccf.append(' ').append(args[i]);
                }
                irt.sendCcf(ccf.toString(), 1, Led.intern);
            }
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            IrTrans.usage(1);
        }
    }

    public static enum Led {
        intern,
        extern,
        led0,
        led1,
        led2,
        led3,
        led4,
        led5,
        led6,
        led7,
        led8,
        led9,
        led10,
        led11,
        led12,
        led13,
        led14,
        led15,
        all;


        public static String ledChar(Led l) {
            return "l" + (l == intern ? "i" : (l == extern ? "e" : (l == all ? "b" : l.toString().substring(4))));
        }

        public static Led parse(String s) throws NoSuchTransmitterException {
            try {
                return Led.valueOf(s);
            }
            catch (IllegalArgumentException ex) {
                throw new NoSuchTransmitterException(s);
            }
        }
    }

    public static class IrTransTransmitter
    extends Transmitter {
        private Led led = Led.intern;

        private IrTransTransmitter(Led led) {
            this.led = led;
        }

        private IrTransTransmitter(String str) throws NoSuchTransmitterException {
            this.led = Led.parse(str);
        }

        private IrTransTransmitter() {
            this.led = Led.intern;
        }

        private IrTransTransmitter(int c) {
            this.led = Led.values()[c - 1];
        }

        public Led getLed() {
            return this.led;
        }
    }

    public static enum Interface {
        tcp,
        tcpAscii,
        udp,
        http,
        serial,
        usb;

    }
}

