/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import java.io.IOException;
import java.net.UnknownHostException;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.harchardware.ir.IRawIrSenderStop;
import org.harctoolbox.harchardware.ir.LircClient;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;

public class LircCcfClient
extends LircClient
implements IRawIrSenderStop {
    public LircCcfClient(String hostname, int port, boolean verbose, int timeout) throws UnknownHostException {
        super(hostname, port, verbose, timeout);
    }

    public LircCcfClient(String hostname, boolean verbose, int timeout) throws UnknownHostException {
        super(hostname, verbose, timeout);
    }

    public LircCcfClient(String hostname, boolean verbose) throws UnknownHostException {
        super(hostname, verbose);
    }

    public LircCcfClient(String hostname) throws UnknownHostException {
        super(hostname, false);
    }

    public boolean sendCcf(String ccf, int count, Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        return this.setTransmitters(transmitter) && this.sendCommand("SEND_CCF_ONCE " + (count - 1) + " " + ccf, false) != null;
    }

    public boolean sendCcf(String ccf, int count, int port) throws IOException, NoSuchTransmitterException {
        return this.sendCcf(ccf, count, this.getTransmitter(port));
    }

    public boolean sendCcfRepeat(String ccf, Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        return this.setTransmitters(transmitter) && this.sendCommand("SEND_CCF_START " + ccf, false) != null;
    }

    @Override
    public boolean sendIr(IrSignal irSignal, int count, Transmitter transmitter) throws IOException, IncompatibleArgumentException, NoSuchTransmitterException {
        return this.sendCcf(irSignal.ccfString(), count, transmitter);
    }

    @Override
    public boolean stopIr(Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        return this.setTransmitters(transmitter) && this.sendCommand("SEND_STOP", false) != null;
    }

    public boolean stopIr(int port) throws NoSuchTransmitterException, IOException {
        return this.stopIr(this.getTransmitter(port));
    }
}

