/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.comm.TcpSocketChannel;
import org.harctoolbox.harchardware.comm.TcpSocketPort;
import org.harctoolbox.harchardware.ir.IRemoteCommandIrSenderStop;
import org.harctoolbox.harchardware.ir.ITransmitter;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;

public class LircClient
implements IHarcHardware,
IRemoteCommandIrSenderStop,
ITransmitter {
    private String lircServerIp;
    public static final int lircDefaultPort = 8765;
    private int lircPort;
    public static final String defaultLircIP = "127.0.0.1";
    public static final int defaultTimeout = 5000;
    private final int portMin = 1;
    private final int portMax = 8;
    private boolean verbose = true;
    private int timeout = 5000;
    private InetAddress inetAddress = null;
    private LircIrTransmitter lircIrTransmitter = new LircIrTransmitter();
    private static final int P_BEGIN = 0;
    private static final int P_MESSAGE = 1;
    private static final int P_STATUS = 2;
    private static final int P_DATA = 3;
    private static final int P_N = 4;
    private static final int P_DATA_N = 5;
    private static final int P_END = 6;

    public LircClient(String hostname, int port, boolean verbose, int timeout) throws UnknownHostException {
        this.timeout = timeout;
        this.lircServerIp = hostname != null ? hostname : defaultLircIP;
        this.inetAddress = InetAddress.getByName(hostname);
        this.lircPort = port;
        this.verbose = verbose;
    }

    public LircClient(String hostname, boolean verbose, int timeout) throws UnknownHostException {
        this(hostname, 8765, verbose, timeout);
    }

    public LircClient(String hostname, boolean verbose) throws UnknownHostException {
        this(hostname, verbose, 5000);
    }

    public LircClient(String hostname) throws UnknownHostException {
        this(hostname, false);
    }

    @Override
    public void close() {
    }

    @Override
    public void open() {
    }

    @Override
    public LircIrTransmitter getTransmitter() {
        return new LircIrTransmitter();
    }

    public LircIrTransmitter getTransmitter(int portNo) throws NoSuchTransmitterException {
        if (portNo < 1 || portNo > 8) {
            throw new NoSuchTransmitterException(Integer.toString(portNo));
        }
        return new LircIrTransmitter(portNo);
    }

    @Override
    public LircIrTransmitter getTransmitter(String port) throws NoSuchTransmitterException {
        try {
            int portNo = Integer.parseInt(port);
            return this.getTransmitter(portNo);
        }
        catch (NumberFormatException ex) {
            throw new NoSuchTransmitterException(port);
        }
    }

    @Override
    public String[] getTransmitterNames() {
        String[] result = new String[8];
        int index = 0;
        for (int i = 1; i <= 8; ++i) {
            result[index++] = Integer.toString(i);
        }
        return result;
    }

    @Override
    public void setVerbosity(boolean verbosity) {
        this.verbose = verbosity;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] sendCommand(String packet, boolean oneWord) throws IOException {
        if (this.verbose) {
            System.err.println("Sending command `" + packet + "' to Lirc@" + this.lircServerIp);
        }
        TcpSocketChannel tcpSocketChannel = new TcpSocketChannel(this.lircServerIp, this.lircPort, this.timeout, this.verbose, TcpSocketPort.ConnectionMode.justInTime);
        tcpSocketChannel.connect();
        OutputStream outToServer = tcpSocketChannel.getOut();
        BufferedReader inFromServer = tcpSocketChannel.getBufferedIn();
        if (outToServer == null || inFromServer == null) {
            throw new IOException("Could not open socket connection to LIRC server " + this.lircServerIp);
        }
        tcpSocketChannel.sendString(packet + '\n');
        ArrayList<String> result = new ArrayList<String>();
        int status = 0;
        try {
            int state = 0;
            int n = 0;
            boolean done = false;
            int dataN = -1;
            block28: while (!done) {
                String string = inFromServer.readLine();
                if (string == null) {
                    done = true;
                    status = -1;
                    continue;
                }
                switch (state) {
                    case 0: {
                        if (!string.equals("BEGIN")) {
                            System.err.println("!begin");
                            continue block28;
                        }
                        state = 1;
                        continue block28;
                    }
                    case 1: {
                        if (!string.equals(packet)) {
                            state = 0;
                            continue block28;
                        }
                        state = 2;
                        continue block28;
                    }
                    case 2: {
                        if (string.equals("SUCCESS")) {
                            status = 0;
                        } else if (string.equals("END")) {
                            status = 0;
                            done = true;
                        } else if (string.equals("ERROR")) {
                            System.err.println("command failed: " + packet);
                            status = -1;
                        } else {
                            throw new BadPacketException();
                        }
                        state = 3;
                        continue block28;
                    }
                    case 3: {
                        if (string.equals("END")) {
                            done = true;
                            continue block28;
                        }
                        if (string.equals("DATA")) {
                            state = 4;
                            continue block28;
                        }
                        throw new BadPacketException();
                    }
                    case 4: {
                        dataN = Integer.parseInt(string);
                        state = dataN == 0 ? 6 : 5;
                        continue block28;
                    }
                    case 5: {
                        if (this.verbose) {
                            System.err.println(string);
                        }
                        result.add(oneWord ? string.replaceAll("\\S*\\s+", "") : string);
                        if (++n != dataN) continue block28;
                        state = 6;
                        continue block28;
                    }
                    case 6: {
                        if (string.equals("END")) {
                            done = true;
                            continue block28;
                        }
                        throw new BadPacketException();
                    }
                }
                assert (false) : "Unhandled case";
            }
        }
        catch (BadPacketException e) {
            System.err.println("bad return packet");
            status = -1;
        }
        catch (SocketTimeoutException e) {
            System.err.println("Sockettimeout Lirc: " + e.getMessage());
            result = null;
            status = -1;
        }
        catch (IOException e) {
            System.err.println("Couldn't read from " + this.lircServerIp);
            status = -1;
        }
        finally {
            try {
                tcpSocketChannel.close(true);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        if (this.verbose) {
            System.err.println(status == 0 ? "Lirc command succeded." : "Lirc command failed.");
        }
        if (result != null && !result.isEmpty() && this.verbose) {
            System.err.println("result[0] = " + (String)result.get(0));
        }
        return status == 0 && result != null ? result.toArray(new String[result.size()]) : null;
    }

    @Override
    public boolean sendIrCommand(String remote, String command, int count, Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        boolean result = true;
        if (!LircIrTransmitter.class.isInstance(transmitter)) {
            throw new NoSuchTransmitterException(transmitter);
        }
        LircIrTransmitter trans = (LircIrTransmitter)transmitter;
        if (trans.transmitters != null && (this.lircIrTransmitter.transmitters == null || this.lircIrTransmitter.transmitters[0] != trans.transmitters[0])) {
            result = this.setTransmitters(transmitter);
        }
        return result && this.sendCommand("SEND_ONCE " + remote + " " + command + " " + (count - 1), false) != null;
    }

    public boolean sendIrCommand(String remote, String command, int count, int connector) throws IOException, NoSuchTransmitterException {
        return this.sendIrCommand(remote, command, count, new LircIrTransmitter(connector));
    }

    @Override
    public boolean sendIrCommandRepeat(String remote, String command, Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        return this.setTransmitters(transmitter) && this.sendCommand("SEND_START " + remote + " " + command, false) != null;
    }

    @Override
    public boolean stopIr(String remote, String command, Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        return this.setTransmitters(transmitter) && this.sendCommand("SEND_STOP " + remote + " " + command, false) != null;
    }

    public boolean stopIr(String remote, String command, int port) throws IOException, NoSuchTransmitterException {
        return this.stopIr(remote, command, new LircIrTransmitter(port));
    }

    @Override
    public String[] getRemotes() throws IOException {
        return this.sendCommand("LIST", false);
    }

    @Override
    public String[] getCommands(String remote) throws IOException {
        return this.sendCommand("LIST " + remote, true);
    }

    public boolean setTransmitters(Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        LircIrTransmitter trans;
        if (!LircIrTransmitter.class.isInstance(transmitter)) {
            throw new NoSuchTransmitterException(transmitter);
        }
        this.lircIrTransmitter = trans = (LircIrTransmitter)transmitter;
        return this.setTransmitters();
    }

    public boolean setTransmitters(int port) throws IOException, NoSuchTransmitterException {
        return this.setTransmitters(new LircIrTransmitter(port));
    }

    public boolean setTransmitters(boolean[] ports) throws NoSuchTransmitterException, IOException {
        LircIrTransmitter transmitter = new LircIrTransmitter(ports);
        if (transmitter.transmitters.length == 0) {
            throw new NoSuchTransmitterException("Cannot disable all transmitters");
        }
        return this.setTransmitters(transmitter);
    }

    private boolean setTransmitters() throws IOException {
        if (this.lircIrTransmitter.transmitters != null) {
            String s = "SET_TRANSMITTERS" + this.lircIrTransmitter.toString();
            return this.sendCommand(s, false) != null;
        }
        return true;
    }

    @Override
    public String getVersion() throws IOException {
        String[] result = this.sendCommand("VERSION", false);
        return result == null || result.length == 0 ? null : result[0];
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private static class BadPacketException
    extends Exception {
        private static final long serialVersionUID = 1L;

        BadPacketException() {
        }

        BadPacketException(String message) {
            super(message);
        }
    }

    public static class LircIrTransmitter
    extends Transmitter {
        private int[] transmitters;

        private LircIrTransmitter() {
            this.transmitters = null;
        }

        private LircIrTransmitter(int[] transmitters) {
            this.transmitters = transmitters;
        }

        private LircIrTransmitter(int selectedTransmitter) {
            if (selectedTransmitter >= 0) {
                this.transmitters = new int[1];
                this.transmitters[0] = selectedTransmitter;
            }
        }

        private LircIrTransmitter(boolean[] ports) {
            int i;
            ArrayList<Integer> prts = new ArrayList<Integer>();
            for (i = 0; i < ports.length; ++i) {
                if (!ports[i]) continue;
                prts.add(i + 1);
            }
            this.transmitters = new int[prts.size()];
            for (i = 0; i < prts.size(); ++i) {
                this.transmitters[i] = (Integer)prts.get(i);
            }
        }

        public String toString() {
            if (this.transmitters == null || this.transmitters.length == 0) {
                return null;
            }
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.transmitters.length; ++i) {
                s.append(' ').append(this.transmitters[i]);
            }
            return s.toString();
        }
    }
}

