/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.ir.ICapture;

public final class LircMode2
implements IHarcHardware,
ICapture {
    private double dummyFrequency;
    private boolean verbose;
    private final ArrayList<Integer> data = new ArrayList();
    private boolean stopRequest;
    private Date lastRead;
    private Date currentStart;
    private ProgThread progThread;
    private int beginTimeout;
    private int maxLearnedLength;
    private int endTimeout;
    private boolean ignoreSillyLines;
    private String cmd;
    private String[] cmdArray;

    private LircMode2(String cmd, String[] cmdArray, boolean verbose, int beginTimeout, int maxLearnLength, int endTimeout, double dummyFrequency, boolean ignoreSillyLines) {
        this.verbose = verbose;
        this.beginTimeout = beginTimeout;
        this.maxLearnedLength = maxLearnLength;
        this.endTimeout = endTimeout;
        this.dummyFrequency = dummyFrequency;
        this.ignoreSillyLines = ignoreSillyLines;
        this.cmd = cmd;
        this.cmdArray = cmdArray;
    }

    public LircMode2(String cmd, boolean verbose, int beginTimeout, int maxLearnLength, int endTimeout, double dummyFrequency) {
        this(cmd, null, verbose, beginTimeout, maxLearnLength, endTimeout, dummyFrequency, false);
    }

    public LircMode2(String[] cmdArray, boolean verbose, int beginTimeout, int maxLearnLength, int endTimeout, double dummyFrequency) {
        this(null, cmdArray, verbose, beginTimeout, maxLearnLength, endTimeout, dummyFrequency, false);
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public void setVerbosity(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void setTimeout(int timeout) {
        this.maxLearnedLength = timeout;
    }

    public void setCommand(String command) {
        this.cmd = command;
        this.cmdArray = null;
    }

    @Override
    public boolean isValid() {
        return this.progThread != null;
    }

    @Override
    public void close() {
        this.stopRequest = true;
        this.progThread = null;
    }

    private static int parseMode2Line(String str) {
        return str == null ? 0 : (str.startsWith("pulse") ? Integer.parseInt(str.substring(6)) : (str.startsWith("space") ? -Integer.parseInt(str.substring(6)) : 0));
    }

    @Override
    public void open() throws IOException {
        this.currentStart = new Date();
        this.progThread = new ProgThread(this);
        this.stopRequest = false;
    }

    public boolean isAlive() {
        return this.progThread.isAlive();
    }

    private static int timeleft(int timeout, Date old) {
        return timeout - (int)(new Date().getTime() - old.getTime());
    }

    private void waitInitialSilence() {
        while (this.data.isEmpty() && LircMode2.timeleft(this.beginTimeout, this.currentStart) > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void waitEndingSilence() {
        while (LircMode2.timeleft(this.endTimeout, this.lastRead) > 0) {
            try {
                Thread.sleep(LircMode2.timeleft(this.endTimeout, this.lastRead));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void waitMaxLengthOrEndTimeout() {
        while (LircMode2.timeleft(this.maxLearnedLength, this.currentStart) > 0 && LircMode2.timeleft(this.endTimeout, this.lastRead) > 0) {
            try {
                Thread.sleep(Math.min(LircMode2.timeleft(this.maxLearnedLength, this.currentStart), LircMode2.timeleft(this.endTimeout, this.lastRead)));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void setTimeout(int beginTimeout, int maxLearnedLength, int endTimeout) {
        this.beginTimeout = beginTimeout;
        this.maxLearnedLength = maxLearnedLength;
        this.endTimeout = endTimeout;
    }

    @Override
    public ModulatedIrSequence capture() throws HarcHardwareException {
        if (this.progThread == null) {
            throw new HarcHardwareException("LircMode2 not open");
        }
        if (!this.progThread.isAlive()) {
            this.progThread.start();
        }
        this.reset();
        this.waitInitialSilence();
        if (this.data.isEmpty()) {
            this.currentStart = new Date();
            return null;
        }
        this.waitMaxLengthOrEndTimeout();
        this.waitEndingSilence();
        int[] durations = this.getDurations();
        try {
            ModulatedIrSequence seq = new ModulatedIrSequence(durations, this.dummyFrequency);
            return seq.getLength() > 0 ? seq : null;
        }
        catch (IncompatibleArgumentException incompatibleArgumentException) {
            return null;
        }
    }

    private synchronized int[] getDurations() {
        int length = this.data.size();
        if (length % 2 == 1) {
            ++length;
        }
        int[] result = new int[length];
        for (int i = 0; i < this.data.size(); ++i) {
            result[i] = this.data.get(i);
        }
        if (this.data.size() % 2 == 1) {
            result[this.data.size()] = -100000;
        }
        this.reset();
        return result;
    }

    public synchronized void reset() {
        this.data.clear();
        this.currentStart = new Date();
    }

    @Override
    public boolean stopCapture() {
        this.close();
        return true;
    }

    public static void main(String[] args) {
        String[] cmd = new String[]{"/usr/local/bin/mode2", "-H", "commandIR"};
        try {
            LircMode2 lircMode2 = new LircMode2(cmd, true, 3000, 1000, 300, 38000.0);
            lircMode2.open();
            int noNulls = 0;
            for (int i = 0; i < 20 && noNulls < 3; ++i) {
                lircMode2.setTimeout(5000, 1000, 300);
                ModulatedIrSequence seq = lircMode2.capture();
                if (seq == null) {
                    System.err.println("Got null");
                    ++noNulls;
                    continue;
                }
                noNulls = 0;
                System.out.println(seq);
                DecodeIR.invoke((ModulatedIrSequence)seq);
            }
            lircMode2.close();
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            System.err.println(ex);
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        catch (HarcHardwareException ex) {
            System.err.println(ex);
        }
    }

    private static class ProgThread
    extends Thread {
        final BufferedReader outFromProc;
        final Process process;
        final LircMode2 lircMode2;

        ProgThread(LircMode2 lircMode2) throws IOException {
            this.process = lircMode2.cmd != null ? Runtime.getRuntime().exec(lircMode2.cmd) : Runtime.getRuntime().exec(lircMode2.cmdArray);
            this.lircMode2 = lircMode2;
            this.outFromProc = new BufferedReader(new InputStreamReader(this.process.getInputStream(), "US-ASCII"));
            if (lircMode2.verbose) {
                if (lircMode2.cmd != null) {
                    System.err.println("Now started shell command \"" + lircMode2.cmd + "\"");
                } else {
                    System.err.print("Now started shell command ");
                    for (String s : lircMode2.cmdArray) {
                        System.err.print(s + " ");
                    }
                    System.err.println();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.lircMode2.currentStart = new Date();
            boolean hasWarned = false;
            while (!this.lircMode2.stopRequest) {
                try {
                    String line = this.outFromProc.readLine();
                    int duration = LircMode2.parseMode2Line(line);
                    if (duration == 0) {
                        if (this.lircMode2.ignoreSillyLines) {
                            continue;
                        }
                        break;
                    }
                    ArrayList arrayList = this.lircMode2.data;
                    synchronized (arrayList) {
                        if (this.lircMode2.data.isEmpty()) {
                            if (duration <= 0) {
                                continue;
                            }
                            int next = LircMode2.parseMode2Line(this.outFromProc.readLine());
                            if (next < 0) {
                                this.lircMode2.data.add(duration);
                            }
                            this.lircMode2.data.add(next);
                            this.lircMode2.currentStart = new Date();
                            hasWarned = false;
                        } else if (LircMode2.timeleft(this.lircMode2.maxLearnedLength, this.lircMode2.currentStart) > 0) {
                            this.lircMode2.data.add(duration);
                        } else if (!hasWarned && this.lircMode2.verbose) {
                            System.err.println("Warning. Max capture length = " + this.lircMode2.maxLearnedLength + "ms exceeded. Ignoring excess pairs. Capture will resume after next silence period.");
                            hasWarned = true;
                        }
                        this.lircMode2.lastRead = new Date();
                    }
                }
                catch (IOException ex) {
                    System.err.println(ex);
                    break;
                }
            }
            if (this.lircMode2.verbose) {
                System.err.println("done, killing process");
            }
            this.process.destroy();
        }
    }
}

