/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.Pronto;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.ir.IRawIrSender;
import org.harctoolbox.harchardware.ir.Transmitter;

class Tira
implements IHarcHardware,
IRawIrSender {
    private CommPort commPort;
    public static final String defaultPortName = "/dev/ttyUSB0";
    private static final int baudRate = 9600;
    private static final int flowControl = 3;
    private static final int bufsize = 255;
    private static final double oscillatorFrequency = 4.8E7;
    private static final double period = 21.3333;
    private static final byte dutyCycle = 0;
    private String portName;
    private static final boolean transmitNotifyEnabled = true;
    private static final boolean transmitByteCountReportEnabled = true;
    private static final boolean transmitHandshakeEnabled = true;
    private static final byte cmdReset = 0;
    private static final byte cmdTransmit = 3;
    private static final byte cmdSetFrequency = 6;
    private static final byte cmdLedMuteOn = 16;
    private static final byte cmdLedMuteOff = 17;
    private static final byte cmdLedOn = 18;
    private static final byte cmdLedOff = 19;
    private static final byte cmdTransmitByteCountReport = 36;
    private static final byte cmdTransmitNotify = 37;
    private static final byte cmdTransmitHandshake = 38;
    private static final byte cmdSamplingMode = 115;
    private static final byte cmdSelfTest = 116;
    private static final byte cmdVersion = 118;
    private static final byte cmdBootloaderMode = 36;
    private static final byte endOfData = -1;
    private static final int transmitByteCountToken = 116;
    private static final int transmitCompleteSuccess = 67;
    private static final int transmitCompleteFailure = 70;
    private OutputStream out;
    private InputStream in;
    private String version;

    Tira() throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException, InterruptedException {
        this(defaultPortName);
    }

    Tira(String portName) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException, InterruptedException {
        this.portName = portName;
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)portName);
        this.commPort = portIdentifier.open(this.getClass().getName(), 2000);
        if (this.commPort instanceof SerialPort) {
            SerialPort serialPort = (SerialPort)this.commPort;
            serialPort.setSerialPortParams(9600, 8, 1, 0);
            serialPort.setFlowControlMode(3);
            this.out = serialPort.getOutputStream();
            this.in = serialPort.getInputStream();
            this.send(new byte[]{73, 86});
            Thread.sleep(50L);
            this.version = this.readString();
        }
    }

    public final void reset() throws IOException, InterruptedException {
        this.send(new byte[]{0, 0, 0, 0, 0});
        Thread.sleep(100L);
    }

    private void send(byte[] buf) throws IOException {
        this.out.write(buf);
        this.out.flush();
    }

    private void send(byte[] buf, int offset, int length) throws IOException {
        this.out.write(buf, offset, length);
        this.out.flush();
    }

    private void send(byte b) throws IOException {
        this.out.write(b);
        this.out.flush();
    }

    private byte[] toByteArray(int[] data) {
        byte[] buf = new byte[2 * data.length + 2];
        for (int i = 0; i < data.length; ++i) {
            int periods = (int)Math.round((double)data[i] / 21.3333);
            buf[2 * i] = (byte)(periods / 256);
            buf[2 * i + 1] = (byte)(periods % 256);
        }
        buf[2 * data.length] = -1;
        buf[2 * data.length + 1] = -1;
        return buf;
    }

    private boolean transmit(double frequency, int[] data) throws IOException {
        if (frequency > 0.0) {
            this.setFrequency(frequency);
        }
        return this.transmit(data);
    }

    private boolean transmit(int[] data) throws IOException {
        int lsb;
        int toSend;
        this.send((byte)3);
        byte[] buf = this.toByteArray(data);
        for (int bytesSent = 0; bytesSent < buf.length; bytesSent += toSend) {
            int noBytes = this.readByte();
            toSend = Math.min(noBytes, buf.length - bytesSent);
            this.send(buf, bytesSent, toSend);
        }
        this.readByte();
        int token = this.readByte();
        if (token != 116) {
            return false;
        }
        int msb = this.readByte();
        int bytesSent = 256 * msb + (lsb = this.readByte());
        if (bytesSent != data.length * 2 + 2) {
            return false;
        }
        token = this.readByte();
        return token == 67;
    }

    private String readString() throws IOException {
        byte[] buf = new byte[255];
        int length = this.in.read(buf);
        return new String(buf, 0, length, IrpUtils.dumbCharset);
    }

    private int readByte() throws IOException {
        return this.in.read();
    }

    public String selftest() throws IOException, InterruptedException {
        this.reset();
        this.send((byte)116);
        byte[] buf = new byte[4];
        for (int i = 0; i < 4; ++i) {
            buf[i] = (byte)this.readByte();
        }
        return new String(buf, IrpUtils.dumbCharset);
    }

    public void bootloaderMode() throws IOException, InterruptedException {
        this.reset();
        this.send((byte)36);
    }

    @Override
    public void close() {
        try {
            this.out.flush();
            this.out.close();
            this.in.close();
            Thread.sleep(1000L);
            this.commPort.close();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch (InterruptedException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public String getPortName() {
        return this.portName;
    }

    public void setLedMute(boolean status) throws IOException {
        this.send(status ? (byte)16 : 17);
    }

    public void setLed(boolean status) throws IOException {
        this.send(status ? (byte)18 : 19);
    }

    private void setFrequency(double frequency) throws IOException {
        byte pr2 = (byte)Math.round(4.8E7 / (16.0 * frequency) - 1.0);
        byte[] buf = new byte[]{6, pr2, 0};
        this.send(buf);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVerbosity(boolean verbosity) {
    }

    @Override
    public void setTimeout(int timeout) {
    }

    @Override
    public boolean isValid() {
        return this.commPort != null;
    }

    @Override
    public boolean sendIr(IrSignal code, int count, Transmitter transmitter) throws IrpMasterException, IOException {
        return this.transmit(code.getFrequency(), code.toIntArray(count - 1));
    }

    public boolean sendCcf(String ccf, int count, Transmitter transmitter) throws IOException, IrpMasterException {
        return this.sendIr(Pronto.ccfSignal((String)ccf), count, transmitter);
    }

    public boolean sendCcfRepeat(String ccf, Transmitter transmitter) {
        throw new UnsupportedOperationException("Not supported due to hardware restrictions.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Tira tira = null;
        try {
            tira = new Tira();
            System.out.println(tira.getVersion());
        }
        catch (NoSuchPortException ex) {
            System.err.println("Port for IRToy /dev/ttyUSB0 was not found");
        }
        catch (PortInUseException ex) {
            System.err.println("Port for IRToy in use");
        }
        catch (UnsupportedCommOperationException ex) {
            System.err.println("xxx" + ex.getMessage());
        }
        catch (IOException ex) {
            System.err.println("xxx" + ex.getMessage());
        }
        catch (InterruptedException ex) {
            System.err.println("xxx" + ex.getMessage());
        }
        finally {
            if (tira != null) {
                tira.close();
            }
        }
    }

    @Override
    public Transmitter getTransmitter() {
        return null;
    }

    @Override
    public void open() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

