/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.misc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;

public class Ethers {
    public static final String defaultPathname;
    private static String pathname;
    private HashMap<String, String> table = new HashMap();

    public static void setPathname(String pathname_) {
        pathname = pathname_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ethers(String filename) throws FileNotFoundException {
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), Charset.defaultCharset()));
        try {
            String line = r.readLine();
            while (line != null) {
                String[] str;
                if (!line.startsWith("#") && (str = line.split("[\\s]+")).length == 2) {
                    String mac = str[0];
                    String hostname = str[1];
                    this.table.put(hostname, mac);
                }
                line = r.readLine();
            }
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        finally {
            try {
                r.close();
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
        }
    }

    public Ethers() throws FileNotFoundException {
        this(pathname);
    }

    public String getMac(String hostname) {
        return this.table.get(hostname);
    }

    public static String getEtherAddress(String hostname, String ethersPathname) {
        try {
            return new Ethers(ethersPathname).getMac(hostname);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static String getEtherAddress(String hostname) {
        return Ethers.getEtherAddress(hostname, defaultPathname);
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            String result = Ethers.getEtherAddress(args[0]);
            System.out.println(result != null ? result : "Not found");
        } else {
            System.err.println("Usage:\n\tethers host");
        }
    }

    static {
        pathname = defaultPathname = System.getProperty("os.name").startsWith("Windows") ? System.getenv("WINDIR") + File.separator + "ethers" : "/etc/ethers";
    }
}

