/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.misc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Locale;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.XmlUtils;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.comm.IWeb;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EzControlT10
implements IHarcHardware,
IWeb {
    private String ezcontrolIP;
    public static final String defaultEzcontrolIP = "192.168.1.42";
    private int soTimeout = 1000;
    private static final int ezcontrolPortno = 7042;
    private static final int ezcontrolQueryPortno = 7044;
    private boolean verbose = true;
    private static final int bufferSize = 352;
    private Interface interfaze = Interface.http;
    public static final int t10NumberPresets = 32;
    private Status[] state = null;
    private static final String[] daynames = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    public static final int t10NumberTimers = 26;
    private Timer[] timers = null;

    @Override
    public void close() {
    }

    @Override
    public URI getUri(String user, String password) {
        try {
            return new URI("http", this.ezcontrolIP, null, null);
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    @Override
    public void open() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    @Override
    public String getVersion() {
        return "unknown";
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public EzControlT10(String hostname, boolean verbose, Interface interfaze) {
        this.ezcontrolIP = hostname != null && !hostname.isEmpty() ? hostname : defaultEzcontrolIP;
        this.verbose = verbose;
        this.interfaze = interfaze;
    }

    public EzControlT10(String hostname) {
        this(hostname, false, Interface.http);
    }

    @Override
    public void setVerbosity(boolean verbosity) {
        this.verbose = verbosity;
    }

    public void setInterface(Interface interfaze) {
        this.interfaze = interfaze;
    }

    public boolean sendManual(EZSystem system, String house, int device, int value, int arg, int n) throws HarcHardwareException {
        try {
            this.getUrl(this.urlManual(system, house, device, value, arg, n));
            return true;
        }
        catch (MalformedURLException ex) {
            throw new HarcHardwareException(ex);
        }
        catch (IOException ex) {
            throw new HarcHardwareException(ex);
        }
    }

    private static int fs20Time(double secs) {
        int quartersecs = (int)(4.0 * secs);
        int qMin = (int)(Math.log(quartersecs / 15) / Math.log(2.0)) + 1;
        if (qMin < 0) {
            qMin = 0;
        }
        int mult = ((qMin & 1) == 1 ? 2 : 1) * ((qMin & 2) == 2 ? 4 : 1) * ((qMin & 4) == 4 ? 16 : 1) * ((qMin & 8) == 8 ? 256 : 1);
        int m = quartersecs / mult;
        int res = (qMin << 4) + m;
        return res;
    }

    public boolean sendManual(EZSystem system, String house, int device, Command cmd, int power, int arg, int n) throws HarcHardwareException {
        return cmd == Command.set_power ? this.sendManual(system, house, device, power * 16 / 100, -1, n) : (cmd == Command.dim_max_time ? this.sendManual(system, house, device, 48, EzControlT10.fs20Time(arg), n) : (cmd == Command.dim_off_time ? this.sendManual(system, house, device, 32, EzControlT10.fs20Time(arg), n) : (cmd == Command.dim_value_time ? this.sendManual(system, house, device, 32 + power * 16 / 100, EzControlT10.fs20Time(arg), n) : this.sendManual(system, house, device, EzControlT10.encodeCommand(system, cmd), arg, n))));
    }

    public boolean sendManual(EZSystem system, String house, int device, Command cmd, int arg, int n) throws HarcHardwareException {
        return this.sendManual(system, house, device, EzControlT10.encodeCommand(system, cmd), arg, n);
    }

    public String urlManual(String systemName, String house, int device, int value, int arg, int n) {
        return this.urlManual(EZSystem.parse(systemName), house, device, value, arg, n);
    }

    public String urlManual(EZSystem system, String house, int device, int value, int arg, int n) {
        String url = null;
        switch (system) {
            case FS20: {
                url = this.fs20Url(house, device, value, arg, n);
                break;
            }
            case RS200: {
                url = this.rs200Url(house, device, value, n);
                break;
            }
            case AB400: {
                url = this.ab400Url(house, device, value, n);
                break;
            }
            case IT: {
                url = this.intertechnoUrl(house.charAt(0), device, value, n);
                break;
            }
            case MARMI: {
                url = this.x10Url(house.charAt(0), device, value, n);
                break;
            }
            default: {
                System.err.println("Sorry, system " + (Object)((Object)system) + " is not yet implemented.");
            }
        }
        return url;
    }

    public String powerToggle(String preset) throws HarcHardwareException {
        return this.sendPreset(Integer.parseInt(preset), Command.power_toggle) ? "" : null;
    }

    public boolean sendPreset(int switchNumber, Command cmd) throws HarcHardwareException {
        Command actualCommand = cmd != Command.power_toggle ? cmd : (this.getStatus(switchNumber) == 0 ? Command.power_on : Command.power_off);
        try {
            return this.interfaze == Interface.udp ? this.udpSendPreset(switchNumber, actualCommand) : this.getUrl(this.urlPreset(switchNumber, actualCommand));
        }
        catch (MalformedURLException ex) {
            throw new HarcHardwareException(ex);
        }
        catch (IOException ex) {
            throw new HarcHardwareException(ex);
        }
    }

    public boolean sendPreset(int switchNumber, Command cmd, int count) throws HarcHardwareException {
        boolean result = true;
        for (int i = 0; i < count; ++i) {
            boolean stat = this.sendPreset(switchNumber, cmd);
            result &= stat;
        }
        return result;
    }

    public boolean sendPreset(int switchNumber, int value) throws IllegalArgumentException, HarcHardwareException {
        try {
            return this.getUrl(this.urlPreset(switchNumber, value));
        }
        catch (MalformedURLException ex) {
            throw new HarcHardwareException(ex);
        }
        catch (IOException ex) {
            throw new HarcHardwareException(ex);
        }
    }

    public boolean sendPreset(int switchNumber, int value, int count) throws HarcHardwareException {
        boolean result = true;
        for (int i = 0; i < count; ++i) {
            boolean stat = this.sendPreset(switchNumber, value);
            result &= stat;
        }
        return result;
    }

    private boolean udpSendPreset(int switchNumber, Command cmd) {
        InetAddress addr;
        if (this.verbose) {
            System.err.println("Sending command `" + (Object)((Object)cmd) + "' to preprogrammed " + switchNumber + " to T10 `" + this.ezcontrolIP + "' over UDP.");
        }
        try {
            addr = InetAddress.getByName(this.ezcontrolIP);
        }
        catch (UnknownHostException ex) {
            System.err.println("Unknown host: " + this.ezcontrolIP);
            return false;
        }
        byte[] buf = new byte[8];
        buf[2] = 1;
        buf[3] = -85;
        buf[4] = (byte)(switchNumber - 1);
        buf[5] = 0;
        buf[6] = (byte)(cmd == Command.power_off ? 0 : 255);
        buf[7] = 0;
        int sum = this.checksum(buf);
        buf[0] = (byte)(sum & 0xFF);
        buf[1] = (byte)(sum >> 8);
        DatagramPacket dp = new DatagramPacket(buf, buf.length, addr, 7042);
        return this.udpSendCheck(dp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean udpSendCheck(DatagramPacket dp) {
        boolean success = false;
        DatagramSocket sock = null;
        try {
            sock = new DatagramSocket();
            sock.setSoTimeout(this.soTimeout);
            sock.send(dp);
            byte[] error = new byte[6];
            DatagramPacket errorPacket = new DatagramPacket(error, error.length);
            sock.receive(errorPacket);
            int sum = this.checksum(error);
            if ((sum & 0xFF) != error[0] || sum >> 8 != error[1] || error[4] != 0 || error[5] != 0) {
                System.err.println("Erroneous response from T10");
            } else {
                success = true;
            }
        }
        catch (IOException e) {
            if (e.getClass() == SocketTimeoutException.class) {
                System.err.println("UDP socket timeout from " + this.ezcontrolIP);
            } else {
                System.err.println(e.getMessage());
            }
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
        return success;
    }

    private int checksum(byte[] buf) {
        int sum = 0;
        for (int i = 2; i < buf.length; i += 2) {
            sum += this.ubyte(buf[i]) + 256 * this.ubyte(buf[i + 1]);
        }
        return sum;
    }

    private int ubyte(byte b) {
        return b < 0 ? b + 256 : b;
    }

    private boolean udpExtractState(byte[] buf) {
        return buf != null ? buf[66] != 0 : false;
    }

    private String udpExtractName(byte[] buf) {
        try {
            return buf != null ? new String(buf, 6, 32, "US-ASCII").replaceAll("\u0000", "") : null;
        }
        catch (UnsupportedEncodingException ex) {
            assert (false);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] udpStatusInquiry(int n) {
        InetAddress addr;
        if (this.verbose) {
            System.err.println("Inquiring state from T10 `" + this.ezcontrolIP + "' on preset " + n + " using UDP.");
        }
        byte[] buf = new byte[352];
        buf[0] = 17;
        buf[1] = 103;
        buf[2] = 2;
        buf[3] = 0;
        buf[4] = (byte)(n - 1);
        buf[5] = 0;
        buf[348] = -1;
        buf[349] = -1;
        try {
            addr = InetAddress.getByName(this.ezcontrolIP);
        }
        catch (UnknownHostException ex) {
            System.err.println("Unknown host: " + this.ezcontrolIP);
            return null;
        }
        DatagramPacket dp = new DatagramPacket(buf, buf.length, addr, 7044);
        DatagramSocket sock = null;
        try {
            sock = new DatagramSocket();
            sock.setSoTimeout(this.soTimeout);
            sock.send(dp);
            sock.receive(dp);
        }
        catch (IOException e) {
            if (e.getClass() == SocketTimeoutException.class) {
                System.err.println("UDP socket timeout from " + this.ezcontrolIP);
            } else {
                System.err.println(e.getMessage());
            }
            buf = null;
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
        return buf;
    }

    private String fs20Url(String houseRaw, int device, int value, int arg, int n) {
        try {
            String house = houseRaw.replaceAll("\\s+", "");
            int hc1 = Integer.parseInt(house.substring(0, 4));
            int hc2 = Integer.parseInt(house.substring(4));
            return this.urlManual(EZSystem.FS20, hc1, hc2, device, value, arg, n);
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("String \"" + houseRaw + "\" is not a valid housenumber for FS20.");
        }
    }

    private String ab400Url(String house, int device, int value, int n) {
        try {
            int hc1 = Integer.parseInt(house);
            return this.urlManual(EZSystem.AB400, hc1, 0, device + 1, value, -1, n);
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("String \"" + house + "\" is not a valid housenumber for AB400.");
        }
    }

    private String intertechnoUrl(char house, int device, int value, int n) {
        return this.intertechnoUrl(Character.toUpperCase(house) - 65 + 1, (device - 1) / 4 + 1, (device - 1) % 4 + 1, value, n);
    }

    private String intertechnoUrl(int hc1, int hc2, int addr, int value, int n) {
        return this.urlManual(EZSystem.IT, hc1, hc2, addr, value, -1, n);
    }

    private String x10Url(char house, int device, int value, int n) {
        return this.x10Url(Character.toUpperCase(house) - 65 + 1, device, value, n);
    }

    private String x10Url(int hc1, int addr, int value, int n) {
        return this.urlManual(EZSystem.MARMI, hc1, 0, addr, value, -1, n);
    }

    private String rs200Url(String house, int device, int value, int n) {
        return this.urlManual(EZSystem.RS200, Integer.parseInt(house), 0, device, value, -1, n);
    }

    private String urlManual(EZSystem system, int hc1, int hc2, int device, int value, int arg, int n) {
        return "http://" + this.ezcontrolIP + "/send?system=" + system.systemNumber() + "&hc1=" + hc1 + (hc2 != 0 ? "&hc2=" + hc2 : "") + "&addr=" + device + "&value=" + value + (arg >= 0 ? "&arg=" + arg : "") + (n > 1 ? "&n=" + n : "");
    }

    public String urlPreset(int switchNumber, Command cmd) {
        if (cmd != Command.power_on && cmd != Command.power_off) {
            throw new IllegalArgumentException("Command " + (Object)((Object)cmd) + " not allowed here.");
        }
        return this.urlPreset(switchNumber, cmd == Command.power_on ? "on" : "off");
    }

    public String urlPreset(int switchNumber, int value) throws IllegalArgumentException {
        if (value < 0 || value > 100) {
            throw new IllegalArgumentException("value out of range");
        }
        return this.urlPreset(switchNumber, Integer.toString(value));
    }

    private String urlPreset(int switchNumber, String val) {
        return "http://" + this.ezcontrolIP + "/preset?switch=" + switchNumber + "&value=" + val;
    }

    private static int encodeCommand(EZSystem system, Command cmd) {
        return system == EZSystem.FS20 ? EzControlT10.fs20EncodeCommand(cmd) : EzControlT10.simpleEncodeCommand(cmd);
    }

    private static int fs20EncodeCommand(Command cmd) {
        return cmd == Command.power_on ? 255 : (cmd == Command.power_off ? 0 : (cmd == Command.power_toggle ? 18 : (cmd == Command.dim_up ? 19 : (cmd == Command.dim_down ? 20 : (cmd == Command.dim_max_time ? 48 : (cmd == Command.dim_off_time ? 32 : (cmd == Command.set_time ? 54 : -1)))))));
    }

    private static int simpleEncodeCommand(Command cmd) {
        return cmd == Command.power_on ? 1 : (cmd == Command.power_off ? 0 : -1);
    }

    private boolean getUrl(String url) throws MalformedURLException, IOException {
        if (this.verbose) {
            System.err.println("Getting URL " + url);
        }
        new URL(url).openStream();
        return true;
    }

    public String getStatus() {
        this.setupStatus();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            if (this.state[i] == null) continue;
            result.append(i).append(".\t").append(this.state[i].toString()).append("\n");
        }
        return result.toString();
    }

    public int getStatus(int n) {
        if (this.interfaze == Interface.udp) {
            return this.udpExtractState(this.udpStatusInquiry(n)) ? 1 : 0;
        }
        this.setupStatus();
        return this.state[n].state;
    }

    public String getPresetStatus(int n) {
        if (this.interfaze == Interface.udp) {
            return this.udpExtractState(this.udpStatusInquiry(n)) ? "on" : "off";
        }
        this.setupStatus();
        return this.state[n] != null ? this.state[n].stateStr() : "n/a";
    }

    public String getPresetName(int n) {
        if (this.interfaze == Interface.udp) {
            byte[] buf = this.udpStatusInquiry(n);
            return this.udpExtractName(buf);
        }
        this.setupStatus();
        return this.state[n] != null ? this.state[n].name : "**not assigned**";
    }

    public String getPresetString(int n) {
        if (this.interfaze == Interface.udp) {
            byte[] buf = this.udpStatusInquiry(n);
            return buf != null ? this.udpExtractName(buf) + (this.udpExtractState(buf) ? ": on" : ": off") : "**error**";
        }
        this.setupStatus();
        return this.state[n] != null ? this.state[n].toString() : "Preset " + n + " not assigned.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setupStatus() {
        if (this.state != null) {
            return true;
        }
        String url = "http://" + this.ezcontrolIP + "/";
        if (this.verbose) {
            System.err.println("Getting URL " + url);
        }
        StringBuilder data = new StringBuilder();
        BufferedReader r = null;
        boolean success = true;
        try {
            String str;
            InputStream is = new URL(url).openStream();
            r = new BufferedReader(new InputStreamReader(is, IrpUtils.dumbCharset));
            do {
                str = r.readLine();
                data.append(str);
            } while (str != null);
        }
        catch (MalformedURLException e) {
            System.err.println(e.getMessage());
            success = false;
        }
        catch (IOException e) {
            System.err.println("IOException: " + e.getMessage());
            success = false;
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
        }
        if (!success) {
            return false;
        }
        String[] snork = data.toString().split("<tr>");
        this.state = new Status[33];
        for (int i = 1; i < snork.length; ++i) {
            int p1 = snork[i].indexOf(62);
            int p2 = snork[i].indexOf(60, p1);
            int n = Integer.parseInt(snork[i].substring(p1 + 1, p2));
            p1 = snork[i].indexOf(62, p2 + 5);
            p2 = snork[i].indexOf(60, p1);
            String name = snork[i].substring(p1 + 1, p2);
            int stat = snork[i].matches(".*background:lime.*") ? 1 : (snork[i].matches(".*background:red.*") ? 0 : -1);
            this.state[n] = new Status(name, stat);
        }
        return true;
    }

    private int extractValue(String str) {
        int res = -1;
        if (str.matches(".*value.*")) {
            int p1 = str.indexOf("value");
            int p2 = str.indexOf(34, p1 + 7);
            res = Integer.parseInt(str.substring(p1 + 7, p2));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setupTimers() {
        if (this.timers != null) {
            return true;
        }
        String url = "http://" + this.ezcontrolIP + "/timer.html";
        if (this.verbose) {
            System.err.println("Getting URL " + url);
        }
        StringBuilder data = new StringBuilder();
        BufferedReader r = null;
        try {
            String str;
            InputStream is = new URL(url).openStream();
            r = new BufferedReader(new InputStreamReader(is, IrpUtils.dumbCharset));
            do {
                str = r.readLine();
                data.append(str);
            } while (str != null);
        }
        catch (MalformedURLException e) {
            System.err.println(e.getMessage());
            boolean str = false;
            return str;
        }
        catch (IOException e) {
            System.err.println("IOException: " + e.getMessage());
            boolean str = false;
            return str;
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
        }
        String[] snork = data.toString().split("<table");
        this.timers = new Timer[26];
        for (int i = 1; i < 27; ++i) {
            boolean enabled = snork[i].matches(".*background:lime.*");
            String[] inputs = snork[i].split(">");
            boolean[] presets = new boolean[33];
            boolean[] days = new boolean[7];
            int indx = 0;
            while (!inputs[indx++].matches("Switches.*")) {
            }
            int j = 1;
            while (j <= 32) {
                if (inputs[indx].matches(".*<input.*")) {
                    presets[j] = inputs[indx].matches(".*checked.*");
                    ++j;
                }
                ++indx;
            }
            while (!inputs[indx++].matches("Weekdays.*")) {
            }
            j = 0;
            while (j < 7) {
                if (inputs[indx].matches(".*<input.*")) {
                    days[j] = inputs[indx].matches(".*checked.*");
                    ++j;
                }
                ++indx;
            }
            while (!inputs[indx++].matches("ON Time.*")) {
            }
            int onH = this.extractValue(inputs[indx++]);
            int onM = this.extractValue(inputs[indx++]);
            while (!inputs[indx++].matches("OFF Time.*")) {
            }
            int offH = this.extractValue(inputs[indx++]);
            int offM = this.extractValue(inputs[indx++]);
            this.timers[i - 1] = new Timer(presets, days, enabled, onH, onM, offH, offM);
        }
        return true;
    }

    public String getTimers() {
        boolean ok;
        boolean bl = ok = this.setupStatus() && this.setupTimers();
        if (!ok) {
            System.err.println("Could not get timers");
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 26; ++i) {
            if (!this.timers[i].enabled) continue;
            result.append((char)(i + 65)).append(": ").append(this.timers[i].toString()).append("\n");
        }
        return result.toString();
    }

    public String getTimer(int n) {
        boolean ok;
        boolean bl = ok = this.setupStatus() && this.setupTimers();
        if (!ok) {
            return null;
        }
        return this.timers[n].toString();
    }

    public String getTimer(String name) {
        int n = (name.charAt(0) - 65) % 32;
        String result = "";
        if (n >= 0 && n < 26) {
            result = this.getTimer((name.charAt(0) - 65) % 32);
        } else {
            System.err.println("Erroneous timer name \"" + name + "\".");
        }
        return result;
    }

    public static String getTimers(String hostname) {
        return new EzControlT10(hostname).getTimers();
    }

    public static String getTimer(String hostname, int n) {
        return new EzControlT10(hostname).getTimer(n);
    }

    public static String getTimer(String hostname, String name) {
        return new EzControlT10(hostname).getTimer(name);
    }

    public static String getStatus(String hostname) {
        return new EzControlT10(hostname).getStatus();
    }

    public Document xmlConfig() {
        Document doc = XmlUtils.newDocument();
        Element root = doc.createElement("ezcontrol_t10");
        root.setAttribute("hostname", this.ezcontrolIP);
        doc.appendChild(root);
        Element presets = doc.createElement("presets");
        root.appendChild(presets);
        this.setupStatus();
        for (int i = 1; i <= 32; ++i) {
            if (this.state[i] == null) continue;
            Element p = doc.createElement("preset");
            p.setAttribute("id", "preset_" + i);
            p.setAttribute("number", "" + i);
            p.setAttribute("state", this.state[i].stateStr());
            p.setTextContent(this.state[i].name);
            presets.appendChild(p);
        }
        Element presetConfiguration = doc.createElement("preset_configuration");
        root.appendChild(presetConfiguration);
        Element timersEle = doc.createElement("timers");
        root.appendChild(timersEle);
        this.setupTimers();
        for (int i = 0; i < 26; ++i) {
            int j;
            if (this.timers[i] == null) continue;
            Element t = doc.createElement("timer");
            t.setAttribute("name", "" + (char)(i + 65));
            t.setAttribute("enabled", this.timers[i].enabled ? "yes" : "no");
            if (this.timers[i].onTime.hour != -1) {
                Element on = doc.createElement("on");
                on.setAttribute("hour", "" + this.timers[i].onTime.hour);
                on.setAttribute("minute", "" + this.timers[i].onTime.minute);
                t.appendChild(on);
            }
            if (this.timers[i].offTime.hour != -1) {
                Element off = doc.createElement("off");
                off.setAttribute("hour", "" + this.timers[i].offTime.hour);
                off.setAttribute("minute", "" + this.timers[i].offTime.minute);
                t.appendChild(off);
            }
            boolean atLeastOneDay = false;
            for (int j2 = 0; j2 < 7; ++j2) {
                atLeastOneDay = atLeastOneDay || this.timers[i].days[j2];
            }
            if (atLeastOneDay) {
                Element days = doc.createElement("days");
                for (j = 0; j < 7; ++j) {
                    if (!this.timers[i].days[j]) continue;
                    Element day = doc.createElement("day");
                    day.setAttribute("weekday", "" + (j + 1));
                    day.setAttribute("name", daynames[j]);
                    days.appendChild(day);
                }
                t.appendChild(days);
            }
            boolean atLeastOnePreset = false;
            for (j = 1; j <= 32; ++j) {
                atLeastOnePreset = atLeastOnePreset || this.timers[i].presets[j];
            }
            if (atLeastOnePreset) {
                Element presetrefs = doc.createElement("presetrefs");
                for (int j3 = 1; j3 <= 32; ++j3) {
                    if (!this.timers[i].presets[j3]) continue;
                    Element presetref = doc.createElement("presetref");
                    presetref.setAttribute("preset", "preset_" + j3);
                    presetref.setTextContent(this.state[j3].name);
                    presetrefs.appendChild(presetref);
                }
                t.appendChild(presetrefs);
            }
            timersEle.appendChild(t);
        }
        Element network = doc.createElement("network");
        root.appendChild(network);
        return doc;
    }

    private void generateXml() {
        XmlUtils.printDOM((OutputStream)System.out, (Document)this.xmlConfig(), (String)"ezcontrol_t10_config.dtd", null);
    }

    public void generateXml(File file) throws FileNotFoundException {
        XmlUtils.printDOM((File)file, (Document)this.xmlConfig(), (String)"ezcontrol_t10_config.dtd", null);
    }

    public void getConfiguration(File file) {
        try {
            XmlUtils.printDOM((File)file, (Document)this.xmlConfig(), (String)"ezcontrol_t10_config.dtd", null);
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
        }
    }

    private static void usage() {
        System.err.println("Usage:\nezcontrol [<options>] get_status [<presetNumber>]\nor\nezcontrol [<options>] get_timer [<timername>]\nor\nezcontrol [<options>] <presetNumber> <command>\nor\nezcontrol [<options>] <presetNumber> <value_in_percent>\nor\nezcontrol [<options>] <systemName> <housecode> <deviceNumber> <command> [<arg>]\nor\nezcontrol [<options>] xml\n\nwhere options=-h <hostname>,-d <debugcode>,-# <count>,-v, -u\nand command=power_on,power_off,power_toggle,get_status,...");
        EzControlT10.doExit(1);
    }

    private static void doExit(int exitcode) {
        System.exit(exitcode);
    }

    public static void main(String[] args) {
        boolean verbose = false;
        String ezcontrolHost = defaultEzcontrolIP;
        int arg_i = 0;
        int count = 1;
        boolean presetMode = false;
        boolean doGetStatus = false;
        boolean doGetTimers = false;
        boolean doXml = false;
        Command cmd = Command.invalid;
        String timerName = null;
        EZSystem system = null;
        String housecode = null;
        int deviceNumber = -1;
        int numArg = -1;
        int percentValue = -1;
        int value = -1;
        int arg = -1;
        boolean udp = false;
        try {
            while (arg_i < args.length && args[arg_i].length() > 0 && args[arg_i].charAt(0) == '-') {
                if (args[arg_i].equals("-v")) {
                    verbose = true;
                    ++arg_i;
                    continue;
                }
                if (args[arg_i].equals("-u")) {
                    ++arg_i;
                    udp = true;
                    continue;
                }
                if (args[arg_i].equals("-h")) {
                    int n = ++arg_i;
                    ++arg_i;
                    ezcontrolHost = args[n];
                    continue;
                }
                if (args[arg_i].equals("-d")) {
                    ++arg_i;
                    continue;
                }
                if (args[arg_i].equals("-#")) {
                    int n = ++arg_i;
                    ++arg_i;
                    count = Integer.parseInt(args[n]);
                    continue;
                }
                EzControlT10.usage();
            }
            if (args[arg_i].equals("getStatus")) {
                doGetStatus = true;
                if (args.length - arg_i > 1) {
                    numArg = Integer.parseInt(args[arg_i + 1]);
                }
            } else if (args[arg_i].equals("getTimer")) {
                doGetTimers = true;
                if (args.length - arg_i > 1) {
                    timerName = args[arg_i + 1];
                }
            } else if (args[arg_i].equals("xml")) {
                doXml = true;
            } else if (args.length - arg_i == 2) {
                presetMode = true;
                numArg = Integer.parseInt(args[arg_i]);
                try {
                    cmd = Command.valueOf(args[arg_i + 1]);
                }
                catch (IllegalArgumentException e) {
                    cmd = Command.set_power;
                    percentValue = Integer.parseInt(args[arg_i + 1]);
                }
            } else {
                system = EZSystem.valueOf(args[arg_i].toUpperCase(Locale.US));
                housecode = args[arg_i + 1];
                String devString = args[arg_i + 2];
                deviceNumber = devString.charAt(0) > '9' ? devString.toUpperCase(Locale.US).charAt(0) - 65 : Integer.parseInt(devString);
                cmd = Command.valueOf(args[arg_i + 3].toLowerCase(Locale.US));
                value = EzControlT10.encodeCommand(system, cmd);
                int n = arg = args.length > arg_i + 4 ? Integer.parseInt(args[arg_i + 4]) : -1;
                if (cmd.hasTimeArgument()) {
                    arg = EzControlT10.fs20Time(arg);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            EzControlT10.usage();
        }
        catch (NumberFormatException ex) {
            EzControlT10.usage();
        }
        if (numArg != -1 && (numArg < 1 || numArg > 32)) {
            System.err.println("Numerical argument not valid.");
            System.exit(45);
        }
        if (deviceNumber != -1 && value == -1) {
            System.err.println("Only commands power_on and power_off allowed.");
            System.exit(46);
        }
        EzControlT10 ez = new EzControlT10(ezcontrolHost, verbose, udp ? Interface.udp : Interface.http);
        try {
            if (doGetStatus) {
                if (numArg > 0) {
                    System.out.println(ez.getPresetString(numArg));
                    System.out.println(ez.getPresetName(numArg));
                } else {
                    System.out.println(ez.getStatus());
                }
            } else if (doGetTimers) {
                if (timerName != null) {
                    System.out.println(ez.getTimer(timerName));
                } else {
                    System.out.println(ez.getTimers());
                }
            } else if (doXml) {
                ez.generateXml();
            } else if (presetMode) {
                if (cmd == Command.set_power) {
                    ez.sendPreset(numArg, percentValue);
                } else {
                    ez.sendPreset(numArg, cmd);
                }
            } else {
                ez.sendManual(system, housecode, deviceNumber, value, arg, count);
            }
        }
        catch (HarcHardwareException ex) {
            System.err.println(ex.getMessage());
        }
    }

    private class Timer {
        boolean[] presets;
        boolean[] days;
        boolean enabled;
        Clock onTime;
        Clock offTime;

        Timer(boolean[] presets, boolean[] days, boolean enabled, int onH, int onM, int offH, int offM) {
            this.presets = presets;
            this.days = days;
            this.enabled = enabled;
            this.onTime = new Clock(onH, onM);
            this.offTime = new Clock(offH, offM);
        }

        public String toString() {
            int i;
            StringBuilder result = new StringBuilder(this.onTime.toString() + "-" + this.offTime.toString() + " ");
            boolean virgin = true;
            for (i = 0; i < 7; ++i) {
                if (!this.days[i]) continue;
                if (i == 0 || !this.days[i - 1] || i == 6 || !this.days[i + 1]) {
                    result.append(virgin ? "" : (this.days[i - 1] ? "-" : ",")).append(daynames[i]);
                }
                virgin = false;
            }
            for (i = result.length(); i < 30; ++i) {
                result.append(" ");
            }
            result.append(" ");
            virgin = true;
            for (i = 1; i < 32; ++i) {
                if (!this.presets[i]) continue;
                result.append(virgin ? "" : ", ").append(((EzControlT10)EzControlT10.this).state[i].name);
                virgin = false;
            }
            for (i = result.length(); i < 65; ++i) {
                result.append(" ");
            }
            return result.append(" ").append(this.enabled ? "(enabled)" : "(disabled)").toString();
        }

        private class Clock {
            int hour;
            int minute;

            Clock(int h, int m) {
                this.hour = h;
                this.minute = m;
            }

            public String toString() {
                return "" + (this.hour >= 0 ? (this.hour < 10 ? "0" : "") + this.hour + ":" + (this.minute < 10 ? "0" : "") + this.minute : "     ");
            }
        }
    }

    public static enum Command {
        power_on,
        power_off,
        power_toggle,
        dim_up,
        dim_down,
        dim_max_time,
        dim_off_time,
        set_time,
        dim_value_time,
        set_power,
        get_status,
        invalid;


        public boolean isPresetCommand() {
            return this == get_status || this == set_power || this == power_toggle || this == power_on || this == power_off;
        }

        public boolean hasTimeArgument() {
            return this == dim_max_time || this == dim_off_time || this == set_time;
        }
    }

    public static enum EZSystem {
        FS10,
        FS20,
        RS200,
        AB400,
        AB601,
        IT,
        REV,
        BS_QU,
        MARMI,
        OA_FM,
        KO_FC,
        RS862;


        public static EZSystem parse(String systemName) {
            return systemName.toLowerCase(IrpUtils.dumbLocale).equals("intertechno") ? IT : (systemName.toLowerCase(IrpUtils.dumbLocale).equals("conrad") ? RS200 : (systemName.toLowerCase(IrpUtils.dumbLocale).equals("x10") ? MARMI : EZSystem.valueOf(systemName.replace('-', '_').toUpperCase(IrpUtils.dumbLocale))));
        }

        public int systemNumber() {
            return this.ordinal() + 1;
        }

        public boolean hasHouseLetter() {
            return this == AB601 || this == IT || this == MARMI;
        }

        public boolean hasDeviceLetter() {
            return this == AB400;
        }
    }

    private static class Status {
        public static final int on = 1;
        public static final int off = 0;
        public static final int unknown = -1;
        public String name;
        public int state;

        Status(String n, int s) {
            this.name = n;
            this.state = s;
        }

        public String stateStr() {
            return this.state == 1 ? "on" : (this.state == 0 ? "off" : "?");
        }

        public String toString() {
            return this.name + ": " + this.stateStr();
        }
    }

    public static enum Interface {
        udp,
        http;

    }
}

