/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.decodeir;

import java.io.File;

public class DecodeIRCaller {
    private int[] bursts;
    private int repeatPart;
    private int extraPart;
    private int frequency;
    private int[] decoder_ctx = new int[2];
    private int device;
    private int subDevice;
    private int obc;
    private int[] hex = new int[4];
    private String protocolName = new String("");
    private String miscMessage = new String("");
    private String errorMessage = new String("");
    private static final String libraryName = "DecodeIR";

    public DecodeIRCaller(File folder) {
    }

    public DecodeIRCaller() {
    }

    public void setBursts(int[] b, int r) {
        this.bursts = b;
        this.repeatPart = r;
        this.extraPart = 0;
    }

    public void setBursts(int[] b, int r, int e) {
        this.bursts = b;
        this.repeatPart = r;
        this.extraPart = e;
    }

    public void setFrequency(int f) {
        this.frequency = f;
    }

    public void initDecoder() {
        this.decoder_ctx[1] = 0;
        this.decoder_ctx[0] = 0;
    }

    public synchronized boolean decode() {
        return this.decode2(this.decoder_ctx, this.bursts, this.repeatPart, this.extraPart, this.frequency);
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public int getDevice() {
        return this.device;
    }

    public int getSubDevice() {
        return this.subDevice;
    }

    public int getOBC() {
        return this.obc;
    }

    public int[] getHex() {
        return this.hex;
    }

    public String getMiscMessage() {
        return this.miscMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int decodeStart() {
        return this.decoder_ctx[0] & 0xFFFFF;
    }

    public int decodeSize() {
        return 2 + (this.decoder_ctx[1] >> 16);
    }

    public native String getVersion();

    private native boolean decode(int[] var1, int[] var2, int var3, int var4);

    private native boolean decode2(int[] var1, int[] var2, int var3, int var4, int var5);
}

