/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.exchangeir;

import com.hifiremote.exchangeir.Exchange;
import com.hifiremote.exchangeir.RepeatFinder;
import java.util.ArrayList;

public class Analyzer
extends Exchange {
    int m_unit;
    int m_unit2;
    int[] m_databits = new int[3];
    int[] m_biphase = new int[3];
    int[] m_RC6 = new int[3];
    int m_type;
    static final int DATASIZE = 40;
    int[] m_data = new int[40];
    int[] m_datacounts = new int[26];
    int m_dataNdx;
    String m_altLeadout;
    int numberDistinctBursts;
    int basis;
    private ArrayList<Burst> m_Bursts = new ArrayList();
    private StringBuffer irp = new StringBuffer();
    private int[] signal_as_burst_indices = null;
    private int[] cleansed_signal = null;

    private void dumpBursts() {
        for (int i = 0; i < this.m_Bursts.size(); ++i) {
            this.m_Bursts.get(i).dump();
        }
        this.outputDebugString("");
    }

    private void dump() {
        this.outputDebugString("");
        this.outputDebugString(this.m_unit + "\t" + this.m_unit2 + "\t" + this.m_type + "\t" + this.m_dataNdx + "\t" + this.m_altLeadout);
        this.dumpIntArray(this.m_databits);
        this.dumpIntArray(this.m_biphase);
        this.dumpIntArray(this.m_RC6);
        this.outputDebugString("");
        this.dumpIntArray(this.m_data);
        this.outputDebugString("");
        this.dumpIntArray(this.m_datacounts);
        this.outputDebugString("");
        this.outputDebugString(Integer.toString(this.m_datacounts[25]));
    }

    private void dumpIntArray(int[] array) {
        for (int i : array) {
            this.outputDebugString(i + "\t");
        }
    }

    private void dumpShortArray(short[] array) {
        for (short i : array) {
            this.outputDebugString(i + "\t");
        }
    }

    private void dumpDoubleArray(double[] array) {
        for (double x : array) {
            this.outputDebugString(x + "\t");
        }
    }

    private static void chop(StringBuffer sb) {
        sb.setLength(sb.length() - 1);
    }

    private static int log2(int x) {
        return (int)Math.round(Math.log(x) / Math.log(2.0));
    }

    private static double modf(double x) {
        return x - Math.floor(x);
    }

    private static String basisPrefix(int basis) {
        return basis == 2 ? "0b" : (basis == 4 ? "0q" : (basis == 8 ? "0" : (basis == 16 ? "0x" : "$")));
    }

    public String toString() {
        return this.getIrpWithAltLeadout();
    }

    public Analyzer(int[] times, int freq, int errlimit, int basis) {
        super(errlimit);
        RepeatFinder repeatFinder = new RepeatFinder(times, errlimit);
        this.setup(times, repeatFinder.getNoIntroBursts(), repeatFinder.getNoRepeatBursts(), repeatFinder.getNoEndingBursts(), repeatFinder.getNoRepeats(), freq, basis);
    }

    public Analyzer(int[] times, int sngl_count, int rpt_count, int extra_count, int rpts, int freq, int errlimit, int basis) {
        super(errlimit);
        this.setup(times, sngl_count, rpt_count, extra_count, rpts, freq, basis);
    }

    private void setup(int[] times, int sngl_count, int rpt_count, int extra_count, int rpts, int freq, int basis) {
        this.basis = basis;
        int burst_ndx = 0;
        int i = 0;
        int ii = 0;
        int j = 0;
        int iEnd = sngl_count + rpts * rpt_count + extra_count;
        int rpt_offset = 0;
        this.m_Bursts.clear();
        int[] signal_out = new int[2 * iEnd];
        for (i = 0; i < sngl_count + rpt_count + extra_count; ++i) {
            boolean found = false;
            if (i == sngl_count + rpt_count) {
                ii = sngl_count + rpts * rpt_count;
            }
            for (j = 0; j < burst_ndx; ++j) {
                if (!this.equalTimes(this.m_Bursts.get((int)j).times, 0, times, 2 * ii, 2)) continue;
                signal_out[2 * i] = j;
                signal_out[2 * i + 1] = 0;
                found = true;
                if (i < sngl_count) {
                    this.m_Bursts.get((int)j).sect_counts[0] = (short)(this.m_Bursts.get((int)j).sect_counts[0] + 1);
                    break;
                }
                if (i < sngl_count + rpt_count) {
                    this.m_Bursts.get((int)j).sect_counts[1] = (short)(this.m_Bursts.get((int)j).sect_counts[1] + 1);
                    break;
                }
                this.m_Bursts.get((int)j).sect_counts[2] = (short)(this.m_Bursts.get((int)j).sect_counts[2] + 1);
                break;
            }
            if (!found) {
                this.m_Bursts.add(burst_ndx, new Burst(times[2 * ii], times[2 * ii + 1]));
                if (i < sngl_count) {
                    this.m_Bursts.get((int)burst_ndx).sect_counts[0] = (short)(this.m_Bursts.get((int)burst_ndx).sect_counts[0] + 1);
                } else if (i < sngl_count + rpt_count) {
                    this.m_Bursts.get((int)burst_ndx).sect_counts[1] = (short)(this.m_Bursts.get((int)burst_ndx).sect_counts[1] + 1);
                } else {
                    this.m_Bursts.get((int)burst_ndx).sect_counts[2] = (short)(this.m_Bursts.get((int)burst_ndx).sect_counts[2] + 1);
                }
                signal_out[2 * i] = burst_ndx++;
                signal_out[2 * i + 1] = 0;
            }
            ++ii;
        }
        this.dumpBursts();
        for (int i1 = 0; i1 < iEnd; ++i1) {
            this.outputDebugString(Integer.toString(signal_out[i1]));
        }
        this.outputDebugString("");
        ii = 0;
        for (i = 0; i < iEnd; ++i) {
            if (i > sngl_count && i < sngl_count + rpts * rpt_count && rpt_count > 0 && (i - sngl_count) % rpt_count == 0) {
                ii = sngl_count;
            }
            this.m_Bursts.get((int)signal_out[2 * ii]).totals[0] = this.m_Bursts.get((int)signal_out[2 * ii]).totals[0] + (double)Math.abs(times[2 * i]);
            if (rpt_count == 0 || rpts < 2 || extra_count > 0 || i < iEnd - 1) {
                this.m_Bursts.get((int)signal_out[2 * ii]).totals[1] = this.m_Bursts.get((int)signal_out[2 * ii]).totals[1] + (double)Math.abs(times[2 * i + 1]);
            }
            this.m_Bursts.get((int)signal_out[2 * ii]).count = (short)(this.m_Bursts.get((int)signal_out[2 * ii]).count + 1);
            ++ii;
        }
        this.dumpBursts();
        this.m_unit = 99999;
        int min_off = 99999;
        for (i = 0; i < this.m_Bursts.size(); ++i) {
            if (this.m_Bursts.get((int)i).count <= 0) continue;
            int n = this.m_Bursts.get((int)i).count;
            this.m_Bursts.get((int)i).times[0] = (int)(this.m_Bursts.get((int)i).totals[0] / (double)n + 0.5);
            if (rpt_count > 0 && rpts > 1 && extra_count == 0 && i == signal_out[2 * (sngl_count + rpt_count - 1)]) {
                --n;
            }
            if (n > 0) {
                this.m_Bursts.get((int)i).times[1] = (int)(this.m_Bursts.get((int)i).totals[1] / (double)n + 0.5);
            }
            this.m_unit = Math.min(this.m_unit, this.m_Bursts.get((int)i).times[0]);
            min_off = Math.min(min_off, this.m_Bursts.get((int)i).times[1]);
        }
        this.dumpBursts();
        this.m_altLeadout = "";
        for (i = 0; i < this.m_Bursts.size(); ++i) {
            int li_ndx;
            short[] c = this.m_Bursts.get((int)i).sect_counts;
            int n = li_ndx = rpt_count > 0 ? signal_out[2 * sngl_count] : 0;
            if (rpt_count > 0 && i == signal_out[2 * (sngl_count + rpt_count - 1)] && (double)(this.m_Bursts.get((int)i).times[0] + this.m_Bursts.get((int)i).times[1]) > 0.75 * (double)(this.m_Bursts.get((int)li_ndx).times[0] + this.m_Bursts.get((int)li_ndx).times[1])) {
                this.m_Bursts.get((int)i).type = (short)101;
            }
            if (i == signal_out[2 * (sngl_count + rpt_count + extra_count - 1)] && c[0] == 0 && c[1] == 0 && c[2] == 1) {
                this.m_Bursts.get((int)i).type = (short)101;
            }
            if (sngl_count > 0 && i == signal_out[2 * (sngl_count - 1)] && c[0] == 1 && c[1] == 0 && c[2] == 0) {
                this.m_Bursts.get((int)i).type = (short)101;
            }
            if (this.m_Bursts.get((int)i).times[1] <= 10 * min_off || this.m_Bursts.get((int)i).type != -1 || !((double)this.m_Bursts.get((int)i).times[0] > 0.9 * (double)this.m_Bursts.get((int)signal_out[2 * (sngl_count + rpt_count - 1)]).times[0]) || !((double)this.m_Bursts.get((int)i).times[0] < 1.1 * (double)this.m_Bursts.get((int)signal_out[2 * (sngl_count + rpt_count - 1)]).times[0]) || c[0] >= 2 || c[1] >= 2 || c[2] >= 2 || c[0] + c[1] + c[2] <= 0) continue;
            this.m_Bursts.get((int)i).type = (short)102;
        }
        for (i = 0; i < this.m_Bursts.size(); ++i) {
            this.m_Bursts.get((int)i).cumulative[2] = 0;
            this.m_Bursts.get((int)i).cumulative[1] = 0;
            this.m_Bursts.get((int)i).cumulative[0] = 0;
        }
        this.dumpBursts();
        int cumul = 0;
        int sect = 0;
        for (i = 0; i < sngl_count + rpt_count + extra_count; ++i) {
            if (i == sngl_count) {
                cumul = 0;
                sect = 1;
            } else if (i == sngl_count + rpt_count) {
                cumul = 0;
                sect = 2;
            }
            Burst b = this.m_Bursts.get(signal_out[2 * i]);
            cumul += b.times[0] + b.times[1];
            if (b.type <= 100 || b.type >= 103) continue;
            b.cumulative[sect] = cumul;
            cumul = 0;
        }
        int iMainLead = signal_out[2 * (sngl_count + rpt_count - 1)];
        int consistent = 0;
        cumul = this.m_Bursts.get((int)iMainLead).cumulative[1];
        if (cumul > 0) {
            for (i = 0; i < this.m_Bursts.size(); ++i) {
                if (this.m_Bursts.get((int)i).type <= 100 || i == iMainLead) continue;
                for (int j1 = 0; j1 < 2; ++j1) {
                    if (!((double)this.m_Bursts.get((int)i).cumulative[j1] > 0.95 * (double)cumul) || !((double)this.m_Bursts.get((int)i).cumulative[j1] < 1.05 * (double)cumul)) continue;
                    ++consistent;
                }
            }
        }
        if (consistent > 0) {
            for (i = 0; i < this.m_Bursts.size(); ++i) {
                for (int j2 = 0; j2 < 3; ++j2) {
                    if (!((double)this.m_Bursts.get((int)i).cumulative[j2] > 0.95 * (double)cumul) || !((double)this.m_Bursts.get((int)i).cumulative[j2] < 1.05 * (double)cumul)) continue;
                    this.m_Bursts.get((int)i).type = (short)103;
                }
            }
        } else if (cumul > 0 && (sngl_count < 4 || rpt_count < 4)) {
            this.m_altLeadout = String.format("^%dm", (cumul + 500) / 1000);
        }
        for (i = 0; i < this.m_Bursts.size(); ++i) {
            if (this.m_Bursts.get((int)i).type != 102) continue;
            this.m_altLeadout = "";
        }
        if (this.m_Bursts.size() > 3) {
            this.seekLeadin(sngl_count, rpt_count, extra_count, signal_out, 0, 100);
        }
        this.dumpBursts();
        this.m_type = 0;
        rpt_offset = this.identify(sngl_count, rpt_count, extra_count, signal_out, freq, this.irp);
        if (this.m_type == 99) {
            rpt_offset = this.identify(sngl_count, rpt_count, extra_count, signal_out, freq, this.irp);
        }
        if (this.m_type == 99) {
            this.m_type = 0;
        }
        if (this.m_type == 0 && this.m_Bursts.size() > 3 && this.seekLeadin(sngl_count, rpt_count, extra_count, signal_out, 1, 104)) {
            rpt_offset = this.identify(sngl_count, rpt_count, extra_count, signal_out, freq, this.irp);
        }
        this.signal_as_burst_indices = new int[sngl_count + rpt_count + extra_count];
        for (i = 0; i < sngl_count + rpt_count + extra_count; ++i) {
            this.signal_as_burst_indices[i] = signal_out[2 * i];
        }
        this.cleansed_signal = new int[2 * (sngl_count + rpt_count + extra_count)];
        for (i = 0; i < sngl_count + rpt_count + extra_count; ++i) {
            int ndx = signal_out[2 * i];
            for (int z = 0; z < 2; ++z) {
                this.cleansed_signal[2 * i + z] = this.m_Bursts.get((int)ndx).times[z];
            }
        }
        this.dumpBursts();
        this.dump();
        this.numberDistinctBursts = freq > -2 ? this.m_Bursts.size() : rpt_offset;
    }

    public int[] getCleansedSignal() {
        return this.cleansed_signal;
    }

    public int getNumberDistinctBursts() {
        return this.numberDistinctBursts;
    }

    public int[] getSignalAsBurstIndices() {
        return this.signal_as_burst_indices;
    }

    public int[] getSignal() {
        int[] signal = new int[2 * this.signal_as_burst_indices.length];
        for (int i = 0; i < this.signal_as_burst_indices.length; ++i) {
            int ndx = this.signal_as_burst_indices[i];
            signal[2 * i] = this.m_Bursts.get((int)ndx).times[0];
            signal[2 * i + 1] = this.m_Bursts.get((int)ndx).times[1];
        }
        return signal;
    }

    public int[][] getBursts() {
        int[][] bursts = new int[this.m_Bursts.size()][2];
        for (int i = 0; i < this.m_Bursts.size(); ++i) {
            bursts[i][0] = this.m_Bursts.get((int)i).times[0];
            bursts[i][1] = this.m_Bursts.get((int)i).times[1];
        }
        return bursts;
    }

    public String getIrp() {
        return new String(this.irp);
    }

    public String getAltLeadout() {
        return this.m_altLeadout.isEmpty() ? null : this.m_altLeadout;
    }

    public String getIrpWithAltLeadout() {
        return this.getIrp() + (this.m_altLeadout.isEmpty() ? "" : "; Alt leadout form: " + this.m_altLeadout);
    }

    private int calcUnit(int provUnit, int tolerance, Integer unit) {
        double fracpart;
        this.outputDebugString("");
        this.dumpBursts();
        double tot = 0.0;
        int nmax = 0;
        int nmin = 0;
        int no = 0;
        for (int i = 0; i < this.m_Bursts.size(); ++i) {
            if (this.m_Bursts.get((int)i).type != -1) continue;
            for (int j = 0; j < 2; ++j) {
                double x = (double)this.m_Bursts.get((int)i).times[j] / (double)provUnit + 0.5;
                tot += (double)this.m_Bursts.get((int)i).times[j];
                nmax += (int)x;
            }
        }
        nmin = (int)((1.0 - Math.max((double)tolerance / 100.0, Math.min(3.0 / (double)provUnit, 0.3))) * (double)nmax + 0.5) - 1;
        this.outputDebugString("prov = %d tot=%f nmin=%d nmax=%d", provUnit, tot, nmin, nmax);
        double fracmax = 0.0;
        double fracminmax = 1.0;
        for (int n = nmax; n >= nmin; --n) {
            fracmax = 0.0;
            int testunit = (int)(tot / (double)n + 0.5);
            for (int i = 0; i < this.m_Bursts.size(); ++i) {
                if (this.m_Bursts.get((int)i).type != -1) continue;
                for (int j = 0; j < 2; ++j) {
                    fracpart = Analyzer.modf((double)this.m_Bursts.get((int)i).times[j] / (double)testunit + 0.5) - 0.5;
                    fracmax = Math.max(fracmax, Math.abs(fracpart));
                }
            }
            if (!(fracmax < fracminmax)) continue;
            this.outputDebugString("n=%d fracminmax=%f fracmax=%f testunit=%d", n, fracminmax, fracmax, testunit);
            fracminmax = fracmax;
            unit = testunit;
        }
        for (int i = 0; i < this.m_Bursts.size(); ++i) {
            for (int j = 0; j < 2; ++j) {
                fracpart = Analyzer.modf((double)this.m_Bursts.get((int)i).times[j] / (double)unit.intValue() + 0.5) - 0.5;
                this.m_Bursts.get((int)i).units[j] = (int)((double)this.m_Bursts.get((int)i).times[j] / (double)unit.intValue() + 0.5);
                this.m_Bursts.get((int)i).fracs[j] = (short)(100.0 * fracpart);
                if (this.m_Bursts.get((int)i).type != -1 || Math.abs(this.m_Bursts.get((int)i).fracs[j]) <= tolerance) continue;
                ++no;
            }
        }
        this.dumpBursts();
        this.outputDebugString("Unit=%d no=%d", unit, no);
        return no;
    }

    private void addBits(int bits, int num) {
        if (this.m_dataNdx + num > 320) {
            return;
        }
        for (int i = 0; i < num; ++i) {
            int n = this.m_dataNdx / 8;
            this.m_data[n] = this.m_data[n] & 255 - (1 << 7 - this.m_dataNdx % 8);
            int n2 = this.m_dataNdx / 8;
            this.m_data[n2] = this.m_data[n2] | (bits >> num - i - 1 & 1) << 7 - this.m_dataNdx % 8;
            ++this.m_dataNdx;
        }
    }

    private void outbits(StringBuffer str, int num) {
        while (num > 0) {
            int n = (num - 1) % (this.basis == 0 ? 4 : Analyzer.log2(this.basis)) + 1;
            if (str != null) {
                str.append(Integer.toHexString(this.m_data[0] >> 8 - n));
            }
            for (int i = 0; i < 40; ++i) {
                this.m_data[i] = (this.m_data[i] << n | (i < 39 ? this.m_data[i + 1] >> 8 - n : 0)) & 0xFF;
            }
            num -= n;
        }
    }

    private int identify(int sngl_count, int rpt_count, int extra_count, int[] signal_out, int freq, StringBuffer irp) {
        int tot;
        int i;
        int non_lead_count = 0;
        int offint_max = -1;
        int offint_max_ndx = -1;
        int offfrac_max = 0;
        int offint_min = 99999;
        int offint_min_ndx = -1;
        int offfrac_min = 99999;
        int onint_max = -1;
        int onint_max_ndx = -1;
        int onfrac_max = 0;
        int onint_min = 99999;
        int onint_min_ndx = -1;
        int onfrac_min = 99999;
        int burst_max = -1;
        int burst_min = 99999;
        boolean bursts_done = false;
        int rpt_offset = 0;
        for (i = 0; i < this.m_Bursts.size(); ++i) {
            if (this.m_Bursts.get((int)i).type != -1) continue;
            ++non_lead_count;
        }
        int oldunit = this.m_unit;
        int nonint = this.calcUnit(oldunit, 20, this.m_unit);
        if (non_lead_count <= 4) {
            nonint = this.calcUnit(oldunit, 8, this.m_unit);
            if (nonint > 0) {
                nonint = this.calcUnit(oldunit / 2, 15, this.m_unit);
            }
            if (nonint > 0) {
                nonint = this.calcUnit(oldunit / 3, 20, this.m_unit);
            }
            if (nonint > 0) {
                nonint = this.calcUnit(oldunit, 20, this.m_unit);
            }
        }
        for (i = 0; i < this.m_Bursts.size(); ++i) {
            if (this.m_Bursts.get((int)i).type != -1) continue;
            if (this.m_Bursts.get((int)i).units[1] > offint_max || this.m_Bursts.get((int)i).units[1] == offint_max && this.m_Bursts.get((int)i).fracs[1] > this.m_Bursts.get((int)offint_max_ndx).fracs[1]) {
                offint_max = this.m_Bursts.get((int)i).units[1];
                offint_max_ndx = i;
            }
            if (this.m_Bursts.get((int)i).units[1] < offint_min || this.m_Bursts.get((int)i).units[1] == offint_min && this.m_Bursts.get((int)i).fracs[1] < this.m_Bursts.get((int)offint_min_ndx).fracs[1]) {
                offint_min = this.m_Bursts.get((int)i).units[1];
                offint_min_ndx = i;
            }
            if (this.m_Bursts.get((int)i).units[0] > onint_max || this.m_Bursts.get((int)i).units[0] == onint_max && this.m_Bursts.get((int)i).fracs[0] > this.m_Bursts.get((int)onint_max_ndx).fracs[0]) {
                onint_max = this.m_Bursts.get((int)i).units[0];
                onint_max_ndx = i;
            }
            if (this.m_Bursts.get((int)i).units[0] < onint_min || this.m_Bursts.get((int)i).units[0] == onint_min && this.m_Bursts.get((int)i).fracs[0] < this.m_Bursts.get((int)onint_min_ndx).fracs[0]) {
                onint_min = this.m_Bursts.get((int)i).units[0];
                onint_min_ndx = i;
            }
            burst_max = Math.max(burst_max, this.m_Bursts.get((int)i).times[0] + this.m_Bursts.get((int)i).times[1]);
            burst_min = Math.min(burst_min, this.m_Bursts.get((int)i).times[0] + this.m_Bursts.get((int)i).times[1]);
            offfrac_max = Math.max(offfrac_max, this.m_Bursts.get((int)i).fracs[1]);
            offfrac_min = Math.min(offfrac_min, this.m_Bursts.get((int)i).fracs[1]);
            onfrac_max = Math.max(onfrac_max, this.m_Bursts.get((int)i).fracs[0]);
            onfrac_min = Math.min(onfrac_min, this.m_Bursts.get((int)i).fracs[0]);
        }
        this.outputDebugString("burst_max=%d burst_min=%d", burst_max, burst_min);
        this.outputDebugString("non_lead_count=%d onint_max=%d onint_min=%d offint_max=%d offint_min=%d nonint=%d", non_lead_count, onint_max, onint_min, offint_max, offint_min, nonint);
        this.m_unit2 = 0;
        this.m_databits[2] = 0;
        this.m_databits[1] = 0;
        this.m_databits[0] = 0;
        this.m_biphase[2] = 0;
        this.m_biphase[1] = 0;
        this.m_biphase[0] = 0;
        this.m_RC6[2] = 0;
        this.m_RC6[1] = 0;
        this.m_RC6[0] = 0;
        int n_best = -1;
        double y_minmax = 99.0;
        int[] outvec = new int[20];
        int specsize = 0;
        this.m_dataNdx = 0;
        for (i = 0; i < sngl_count + rpt_count + extra_count; ++i) {
            signal_out[2 * i + 1] = 0;
        }
        if (non_lead_count == 2 && onint_max == onint_min && nonint == 0 && offint_min < 50 * onint_max && Math.max(Math.abs(onfrac_max), Math.abs(onfrac_min)) <= 10 && Math.max(Math.abs(offfrac_max), Math.abs(offfrac_min)) <= 10 * (offint_max - offint_min)) {
            for (i = 0; i < this.m_Bursts.size(); ++i) {
                if (this.m_Bursts.get((int)i).type != -1) continue;
                this.m_Bursts.get((int)i).type = i == offint_max_ndx ? (short)1 : 0;
            }
            this.m_type = 1;
            bursts_done = true;
        } else if (non_lead_count == 2 && onint_max == onint_min && offint_min > 50 * onint_max) {
            tot = 0;
            for (i = 0; i < this.m_Bursts.size(); ++i) {
                if (this.m_Bursts.get((int)i).type != -1) continue;
                this.m_Bursts.get((int)i).type = i == offint_max_ndx ? (short)1 : 0;
                tot += this.m_Bursts.get((int)i).times[0];
                this.m_Bursts.get((int)i).units[0] = 1;
            }
            this.m_unit = tot / 2;
            this.m_type = 8;
            bursts_done = true;
        } else if (non_lead_count == 2 && offint_max == offint_min && nonint == 0 && Math.max(Math.abs(offfrac_max), Math.abs(offfrac_min)) <= 10 && Math.max(Math.abs(onfrac_max), Math.abs(onfrac_min)) <= 10 * (onint_max - onint_min)) {
            for (i = 0; i < this.m_Bursts.size(); ++i) {
                if (this.m_Bursts.get((int)i).type != -1) continue;
                this.m_Bursts.get((int)i).type = i == onint_max_ndx ? (short)1 : 0;
            }
            this.m_type = 2;
            bursts_done = true;
        } else if (non_lead_count == 2 && (double)burst_min > 0.9 * (double)burst_max && nonint == 0) {
            for (i = 0; i < this.m_Bursts.size(); ++i) {
                if (this.m_Bursts.get((int)i).type != -1) continue;
                this.m_Bursts.get((int)i).type = i == onint_max_ndx ? (short)1 : 0;
            }
            this.m_type = 3;
            bursts_done = true;
        }
        if (bursts_done) {
            this.m_dataNdx = 0;
            for (i = 0; i < this.m_Bursts.size(); ++i) {
                short t = this.m_Bursts.get((int)i).type;
                if (t < 2) {
                    outvec[2 * t] = this.m_Bursts.get((int)i).units[0];
                    outvec[2 * t + 1] = this.m_type != 8 ? -this.m_Bursts.get((int)i).units[1] : -this.m_Bursts.get((int)i).times[1];
                }
                specsize = 2;
            }
            for (i = 0; i < sngl_count + rpt_count + extra_count; ++i) {
                int off;
                Burst b = this.m_Bursts.get(signal_out[2 * i]);
                if (b.type < 100) {
                    this.addBits(b.type, 1);
                    signal_out[2 * i + 1] = 1;
                    continue;
                }
                if (this.m_type != 2 && this.m_type != 3 || i <= 0) continue;
                Burst b0 = this.m_Bursts.get(signal_out[2 * i - 2]);
                int on = b.units[0];
                int n = on == onint_min ? offint_max : (off = on == onint_max ? offint_min : -1);
                if (b0.type >= 100 || Math.abs(b.fracs[0]) > 10 || off <= 0 || b.units[1] <= off) continue;
                this.addBits(on == onint_max ? 1 : 0, 1);
                int n2 = 2 * i - 1;
                signal_out[n2] = signal_out[n2] + 1;
                signal_out[2 * i + 1] = (on << 8) + off;
            }
        }
        if (bursts_done && this.m_dataNdx < 4) {
            bursts_done = false;
            this.m_type = 0;
            for (i = 0; i < this.m_Bursts.size(); ++i) {
                if (this.m_Bursts.get((int)i).type >= 100) continue;
                this.m_Bursts.get((int)i).type = (short)-1;
            }
            this.m_dataNdx = 0;
            for (i = 0; i < sngl_count + rpt_count + extra_count; ++i) {
                signal_out[2 * i + 1] = 0;
            }
        }
        if (!bursts_done && non_lead_count >= 3 && non_lead_count <= 5 && nonint == 0 && offint_max <= 3 * offint_min && onint_max <= 3 * onint_min) {
            bursts_done = true;
            int[] types = new int[]{200, 201, 304, 202, 203, 305, 301, 302, 303};
            for (i = 0; i < this.m_Bursts.size(); ++i) {
                if (this.m_Bursts.get((int)i).type != -1) continue;
                if (this.m_Bursts.get((int)i).units[0] % onint_min != 0 || this.m_Bursts.get((int)i).units[1] % offint_min != 0) {
                    bursts_done = false;
                    continue;
                }
                this.m_Bursts.get((int)i).type = (short)types[3 * (this.m_Bursts.get((int)i).units[0] / onint_min - 1) + this.m_Bursts.get((int)i).units[1] / offint_min - 1];
            }
            int parity = 0;
            int last = 0;
            int sect = 0;
            int bitcount = 0;
            int RC6flag = 0;
            int RC6bit = 0;
            int[] u = null;
            boolean reset = false;
            int last1xx = -1;
            this.m_dataNdx = 0;
            int sectNdx = 0;
            if (bursts_done) {
                for (i = 0; i < sngl_count + rpt_count + extra_count; ++i) {
                    switch (this.m_Bursts.get((int)signal_out[2 * i]).type) {
                        case 200: {
                            ++bitcount;
                            this.addBits(last == 201 ? 0 : 1, 1);
                            signal_out[2 * i + 1] = 1;
                            if (RC6flag != 1) break;
                            RC6flag = -1;
                            break;
                        }
                        case 201: {
                            if (last == 0) {
                                parity = 2;
                            }
                            if (last == 201 && RC6flag == 0) {
                                RC6flag = 1;
                                this.addBits(0, 1);
                                signal_out[2 * i + 1] = 101;
                                RC6bit = ++bitcount;
                            } else if (last == 201 || RC6flag == 1) {
                                RC6flag = -1;
                            } else {
                                bitcount += 2;
                                this.addBits(2, 2);
                                signal_out[2 * i + 1] = 2;
                            }
                            last = 201;
                            break;
                        }
                        case 202: {
                            int x;
                            signal_out[2 * i + 1] = 0;
                            if (last == 0) {
                                if (last1xx < 0 || this.m_Bursts.get((int)signal_out[2 * last1xx]).units[1] >= offint_min + (signal_out[2 * last1xx + 1] & 0xFF)) {
                                    parity = 1;
                                    ++bitcount;
                                    x = this.m_dataNdx - sectNdx + 1;
                                    this.m_dataNdx = sectNdx;
                                    this.addBits(0, x);
                                    if (last1xx >= 0) {
                                        int n = 2 * last1xx + 1;
                                        signal_out[n] = signal_out[n] + offint_min;
                                    }
                                    signal_out[2 * i + 1] = 1;
                                } else {
                                    RC6flag = -1;
                                }
                            }
                            if (RC6flag == 1) {
                                RC6flag = 2;
                                ++bitcount;
                                this.addBits(0, 1);
                                signal_out[2 * i + 1] = 1;
                                break;
                            }
                            if (last == 202) {
                                RC6flag = -1;
                            } else {
                                ++bitcount;
                                this.addBits(1, 1);
                                int n = 2 * i + 1;
                                signal_out[n] = signal_out[n] + 1;
                            }
                            last = 202;
                            break;
                        }
                        case 203: {
                            int x;
                            signal_out[2 * i + 1] = 0;
                            if (last == 0) {
                                if (last1xx < 0 || this.m_Bursts.get((int)signal_out[2 * last1xx]).units[1] >= offint_min + (signal_out[2 * last1xx + 1] & 0xFF)) {
                                    last = 201;
                                    parity = 1;
                                    ++bitcount;
                                    x = this.m_dataNdx - sectNdx + 1;
                                    this.m_dataNdx = sectNdx;
                                    this.addBits(0, x);
                                    if (last1xx >= 0) {
                                        int n = 2 * last1xx + 1;
                                        signal_out[n] = signal_out[n] + offint_min;
                                    }
                                    signal_out[2 * i + 1] = 1;
                                } else {
                                    RC6flag = -1;
                                }
                            }
                            if (last == 202 && RC6flag == 0) {
                                RC6flag = 2;
                                this.addBits(1, 1);
                                signal_out[2 * i + 1] = 101;
                                RC6bit = ++bitcount;
                                break;
                            }
                            if (last == 202 || RC6flag == 1) {
                                RC6flag = -1;
                                break;
                            }
                            bitcount += 2;
                            this.addBits(2, 2);
                            int n = 2 * i + 1;
                            signal_out[n] = signal_out[n] + 2;
                            break;
                        }
                        case 301: {
                            if (RC6flag == 1) {
                                last = 202;
                                RC6flag = 2;
                                ++bitcount;
                                this.addBits(1, 1);
                                signal_out[2 * i + 1] = 1;
                                break;
                            }
                            RC6flag = -1;
                            break;
                        }
                        case 302: {
                            if (RC6flag == 1) {
                                last = 201;
                                bitcount += 2;
                                this.addBits(2, 2);
                                signal_out[2 * i + 1] = 2;
                                RC6flag = 2;
                                break;
                            }
                            if (last == 201 && RC6flag == 0) {
                                last = 202;
                                this.addBits(1, 1);
                                signal_out[2 * i + 1] = 101;
                                RC6flag = 2;
                                RC6bit = ++bitcount;
                                break;
                            }
                            RC6flag = -1;
                            break;
                        }
                        case 303: {
                            if (last == 201 && RC6flag == 0) {
                                this.addBits(2, 2);
                                signal_out[2 * i + 1] = 202;
                                RC6flag = 2;
                                RC6bit = (bitcount += 2) - 1;
                                break;
                            }
                            RC6flag = -1;
                            break;
                        }
                        case 304: {
                            if (last == 0 || last == 202 && RC6flag == 0) {
                                if (last == 0) {
                                    parity = 2;
                                }
                                this.addBits(2, 2);
                                signal_out[2 * i + 1] = 102;
                                RC6flag = 1;
                                RC6bit = bitcount += 2;
                                break;
                            }
                            RC6flag = -1;
                            break;
                        }
                        case 305: {
                            if (last == 0 || last == 202 && RC6flag == 0) {
                                if (last == 0) {
                                    parity = 2;
                                }
                                this.addBits(2, 2);
                                signal_out[2 * i + 1] = 202;
                                RC6flag = 2;
                                RC6bit = (bitcount += 2) - 1;
                                last = 201;
                                break;
                            }
                            RC6flag = -1;
                            break;
                        }
                        default: {
                            int x;
                            u = this.m_Bursts.get((int)signal_out[2 * i]).units;
                            if (last == 202 && u[0] == onint_min && u[1] >= offint_min) {
                                ++bitcount;
                                this.addBits(1, 1);
                                int n = 2 * i - 1;
                                signal_out[n] = signal_out[n] + 1;
                                signal_out[2 * i + 1] = (onint_min << 8) + offint_min;
                            } else if (last == 201 && u[0] == onint_min) {
                                signal_out[2 * i + 1] = onint_min << 8;
                            } else if (last == 201 && u[0] == 2 * onint_min && u[1] >= offint_min) {
                                ++bitcount;
                                this.addBits(1, 1);
                                int n = 2 * i - 1;
                                signal_out[n] = signal_out[n] + 1;
                                signal_out[2 * i + 1] = (2 * onint_min << 8) + offint_min;
                            } else if (last == 0 && i > last1xx + 1 && u[0] == onint_min && u[1] >= offint_min) {
                                parity = 2;
                                ++bitcount;
                                this.addBits(1, 1);
                                int n = 2 * i - 1;
                                signal_out[n] = signal_out[n] + 1;
                                signal_out[2 * i + 1] = (onint_min << 8) + offint_min;
                            } else if (last == 0 && i > last1xx + 1 && u[0] == 2 * onint_min && u[1] >= offint_min && (last1xx < 0 || this.m_Bursts.get((int)signal_out[2 * last1xx]).units[1] >= offint_min + (signal_out[2 * last1xx + 1] & 0xFF))) {
                                parity = 1;
                                bitcount += 2;
                                x = this.m_dataNdx - sectNdx + 1;
                                this.m_dataNdx = sectNdx;
                                this.addBits(1, x);
                                if (last1xx >= 0) {
                                    int n = 2 * last1xx + 1;
                                    signal_out[n] = signal_out[n] + offint_min;
                                }
                                int n = 2 * i - 1;
                                signal_out[n] = signal_out[n] + 2;
                                signal_out[2 * i + 1] = (2 * onint_min << 8) + offint_min;
                            } else if (i > last1xx + 1) {
                                RC6flag = -1;
                            }
                            last1xx = i;
                            sectNdx = this.m_dataNdx;
                            reset = true;
                        }
                    }
                    if (RC6flag == -1 || reset && RC6flag == 1) break;
                    if (i == sngl_count - 1) {
                        this.m_biphase[0] = parity;
                        this.m_databits[0] = bitcount;
                        bitcount = 0;
                        this.m_RC6[0] = RC6bit;
                        sect = 1;
                    } else if (i == sngl_count + rpt_count - 1) {
                        this.m_biphase[1] = parity;
                        this.m_databits[1] = bitcount;
                        bitcount = 0;
                        this.m_RC6[1] = RC6bit;
                        sect = 2;
                    } else if (i == sngl_count + rpt_count + extra_count - 1) {
                        this.m_biphase[2] = parity;
                        this.m_databits[2] = bitcount;
                        bitcount = 0;
                        this.m_RC6[2] = RC6bit;
                    }
                    if (!reset) continue;
                    RC6flag = 0;
                    parity = 0;
                    last = 0;
                    reset = false;
                }
            }
            if (bursts_done && RC6flag != -1 && RC6flag != 1) {
                this.m_type = 4;
                outvec[0] = -offint_min;
                outvec[1] = onint_min;
                outvec[2] = onint_min;
                outvec[3] = -offint_min;
                specsize = 2;
            } else {
                this.m_databits[2] = 0;
                this.m_databits[1] = 0;
                this.m_databits[0] = 0;
                this.m_biphase[2] = 0;
                this.m_biphase[1] = 0;
                this.m_biphase[0] = 0;
                this.m_dataNdx = 0;
                for (i = 0; i < sngl_count + rpt_count + extra_count; ++i) {
                    signal_out[2 * i + 1] = 0;
                }
                this.m_RC6[2] = 0;
                this.m_RC6[1] = 0;
                this.m_RC6[0] = 0;
                if (offint_max <= 2 * offint_min && onint_max <= 2 * onint_min) {
                    bursts_done = true;
                    for (i = 0; i < this.m_Bursts.size(); ++i) {
                        if (this.m_Bursts.get((int)i).type == -1) {
                            bursts_done = false;
                            break;
                        }
                        if (this.m_Bursts.get((int)i).type < 200) continue;
                        this.m_Bursts.get((int)i).type = (short)(this.m_Bursts.get((int)i).type - 200);
                    }
                    if (bursts_done) {
                        for (i = 0; i < sngl_count + rpt_count + extra_count; ++i) {
                            Burst b = this.m_Bursts.get(signal_out[2 * i]);
                            if (b.type >= 100) continue;
                            signal_out[2 * i + 1] = 2;
                            this.addBits(b.type, 2);
                        }
                        this.m_type = 5;
                        outvec[0] = outvec[2] = onint_min;
                        outvec[1] = outvec[5] = -offint_min;
                        outvec[3] = outvec[7] = -2 * offint_min;
                        outvec[4] = outvec[6] = 2 * onint_min;
                        specsize = 4;
                    }
                } else {
                    bursts_done = false;
                }
            }
            if (!bursts_done) {
                for (i = 0; i < this.m_Bursts.size(); ++i) {
                    if (this.m_Bursts.get((int)i).type >= 100 && this.m_Bursts.get((int)i).type < 200) continue;
                    this.m_Bursts.get((int)i).type = (short)-1;
                }
                this.m_dataNdx = 0;
                for (i = 0; i < sngl_count + rpt_count + extra_count; ++i) {
                    signal_out[2 * i + 1] = 0;
                }
            }
            if (bursts_done) {
                this.outputDebugString("RC6=%d %d %d biphase=%d %d %d databits=%d %d %d", this.m_RC6[0], this.m_RC6[1], this.m_RC6[2], this.m_biphase[0], this.m_biphase[1], this.m_biphase[2], this.m_databits[0], this.m_databits[1], this.m_databits[2]);
            }
        }
        if (!bursts_done && non_lead_count >= 3 && non_lead_count <= 16 && onint_max <= 2 * onint_min && Math.max(Math.abs(onfrac_max), Math.abs(onfrac_min)) <= 20) {
            int n;
            double delta = 0.0;
            bursts_done = true;
            for (i = 0; i < this.m_Bursts.size(); ++i) {
                if (this.m_Bursts.get((int)i).type == -1 && this.m_Bursts.get((int)i).units[0] % onint_min != 0) {
                    bursts_done = false;
                }
                if (this.m_Bursts.get((int)i).type != 105) continue;
                this.m_Bursts.get((int)i).type = (short)-1;
            }
            int min_time = onint_max == onint_min ? this.m_Bursts.get((int)offint_min_ndx).times[1] : 0;
            y_minmax = 99.0;
            if (bursts_done) {
                for (n = 2; n < 16; ++n) {
                    double y_max = -1.0;
                    delta = (double)(this.m_Bursts.get((int)offint_max_ndx).times[1] - min_time) / (double)n;
                    for (i = 0; i < this.m_Bursts.size(); ++i) {
                        double x;
                        double y;
                        if (this.m_Bursts.get((int)i).type != -1 || !(Math.abs(y = (x = (double)(this.m_Bursts.get((int)i).times[1] - min_time) / delta) - (double)((int)(x + 0.5))) > y_max)) continue;
                        y_max = Math.abs(y);
                    }
                    if (!(y_max < y_minmax)) continue;
                    y_minmax = y_max;
                    n_best = n;
                    this.m_unit2 = Math.abs(delta - (double)((int)(delta + 0.5))) < 0.2 * delta / (double)n ? (int)(delta + 0.5) : 0;
                }
            }
            if (y_minmax < 0.2) {
                delta = (double)(this.m_Bursts.get((int)offint_max_ndx).times[1] - min_time) / (double)n_best;
                for (i = 0; i < this.m_Bursts.size(); ++i) {
                    if (this.m_Bursts.get((int)i).type != -1) continue;
                    double x = (double)(this.m_Bursts.get((int)i).times[1] - min_time) / delta;
                    this.m_Bursts.get((int)i).type = (short)(x + 0.5);
                }
            } else {
                bursts_done = false;
            }
            if (bursts_done) {
                this.m_type = 6;
            }
            if (bursts_done && onint_max == onint_min && non_lead_count == 3) {
                int t0 = -1;
                int t1 = -1;
                int c0 = 0;
                int c1 = 0;
                boolean is_t = false;
                for (i = 0; i < sngl_count; ++i) {
                    if (this.m_Bursts.get((int)signal_out[2 * i]).type >= 100) continue;
                    if (t0 < 0) {
                        t0 = signal_out[2 * i];
                    }
                    if (is_t == (t0 == signal_out[2 * i])) continue;
                    ++c0;
                    is_t = !is_t;
                }
                is_t = false;
                for (i = sngl_count; i < sngl_count + rpt_count; ++i) {
                    if (this.m_Bursts.get((int)signal_out[2 * i]).type >= 100) continue;
                    if (t1 < 0) {
                        t1 = signal_out[2 * i];
                    }
                    if (is_t == (t1 == signal_out[2 * i])) continue;
                    ++c1;
                    is_t = !is_t;
                }
                if (c0 < 4 && c1 < 4 && c0 + c1 > 0 && (c0 == 0 || c1 == 0 || t0 == t1)) {
                    this.m_Bursts.get((int)Math.max((int)t0, (int)t1)).type = (short)105;
                    for (i = 0; i < this.m_Bursts.size(); ++i) {
                        if (this.m_Bursts.get((int)i).type >= 100) continue;
                        this.m_Bursts.get((int)i).type = (short)-1;
                    }
                    this.m_type = 99;
                } else {
                    for (i = this.m_Bursts.size() - 1; i >= 0; --i) {
                        if (this.m_Bursts.get((int)i).type >= 100 || this.m_Bursts.get((int)i).sect_counts[0] >= 2 || this.m_Bursts.get((int)i).sect_counts[1] >= 2 || this.m_Bursts.get((int)i).sect_counts[0] + this.m_Bursts.get((int)i).sect_counts[1] <= 0) continue;
                        this.m_Bursts.get((int)i).type = (short)105;
                        for (i = 0; i < this.m_Bursts.size(); ++i) {
                            if (this.m_Bursts.get((int)i).type >= 100) continue;
                            this.m_Bursts.get((int)i).type = (short)-1;
                        }
                        this.m_type = 99;
                        break;
                    }
                }
                if (this.m_type == 6 && nonint == 0) {
                    int ndx = 0;
                    int[] ndxi = new int[3];
                    for (i = 0; i < this.m_Bursts.size(); ++i) {
                        if (this.m_Bursts.get((int)i).type >= 100) continue;
                        if (ndx < 1 || this.m_Bursts.get((int)i).type > this.m_Bursts.get((int)ndxi[ndx - 1]).type) {
                            ndxi[ndx] = i;
                        } else if (ndx < 2 || this.m_Bursts.get((int)i).type > this.m_Bursts.get((int)ndxi[ndx - 2]).type) {
                            ndxi[ndx] = ndxi[ndx - 1];
                            ndxi[ndx - 1] = i;
                        } else if (ndx < 3 || this.m_Bursts.get((int)i).type > this.m_Bursts.get((int)ndxi[ndx - 3]).type) {
                            ndxi[ndx] = ndxi[ndx - 1];
                            ndxi[ndx - 1] = ndxi[ndx - 2];
                            ndxi[ndx - 2] = i;
                        }
                        ++ndx;
                    }
                    if (this.m_Bursts.get((int)ndxi[2]).units[1] == this.m_Bursts.get((int)ndxi[0]).units[1] + this.m_Bursts.get((int)ndxi[1]).units[1] + onint_min) {
                        boolean flag0 = false;
                        int first0 = -1;
                        int second0 = -1;
                        this.m_dataNdx = 0;
                        for (i = 0; i < sngl_count + rpt_count; ++i) {
                            Burst b1 = this.m_Bursts.get(signal_out[2 * i]);
                            Burst b0 = null;
                            if (i > 0) {
                                b0 = this.m_Bursts.get(signal_out[2 * (i - 1)]);
                            }
                            if (b1.type < 100) {
                                ndx = signal_out[2 * i];
                                if (ndx == ndxi[2]) {
                                    this.addBits(1, 1);
                                    signal_out[2 * i + 1] = 1;
                                    if (!flag0) continue;
                                    break;
                                }
                                if (flag0) {
                                    flag0 = false;
                                    if (second0 == -1) {
                                        second0 = ndx;
                                        continue;
                                    }
                                    if (ndx == second0) continue;
                                    break;
                                }
                                flag0 = true;
                                this.addBits(0, 1);
                                signal_out[2 * i + 1] = 1;
                                if (first0 == -1) {
                                    first0 = ndx;
                                    continue;
                                }
                                if (ndx == first0) continue;
                                break;
                            }
                            if (b0 == null || b0.type >= 100) continue;
                            if (b1.units[0] == onint_min && !flag0) {
                                this.addBits(1, 1);
                                int n3 = 2 * i - 1;
                                signal_out[n3] = signal_out[n3] + 1;
                            }
                            signal_out[2 * i + 1] = onint_min << 8;
                        }
                    }
                    if (i == sngl_count + rpt_count) {
                        this.m_type = 10;
                        outvec[2] = outvec[4] = onint_min;
                        outvec[0] = outvec[4];
                        outvec[1] = this.m_Bursts.get((int)ndxi[0]).units[1];
                        outvec[3] = this.m_Bursts.get((int)ndxi[1]).units[1];
                        outvec[5] = this.m_Bursts.get((int)ndxi[2]).units[1];
                    } else {
                        for (i = 0; i < sngl_count + rpt_count + extra_count; ++i) {
                            signal_out[2 * i + 1] = 0;
                        }
                    }
                }
            }
            if (this.m_type == 6 && (double)this.m_unit2 > 0.9 * (double)this.m_unit && (double)this.m_unit2 < 1.1 * (double)this.m_unit && n_best <= 6 && nonint == 0) {
                this.m_dataNdx = 0;
                int ndx = 0;
                for (i = 0; i < sngl_count + rpt_count; ++i) {
                    Burst b1 = this.m_Bursts.get(signal_out[2 * i]);
                    Burst b2 = null;
                    if (i < sngl_count + rpt_count - 1) {
                        b2 = this.m_Bursts.get(signal_out[2 * (i + 1)]);
                    }
                    if (b1.type < 100) {
                        if (b1.units[0] == 2) {
                            if (ndx != 0) break;
                            int n4 = 2 * i + 1;
                            signal_out[n4] = signal_out[n4] + 256;
                            ndx = 3;
                        }
                        if ((ndx = b1.units[1] - ndx) < 0) break;
                        int n5 = 2 * i + 1;
                        signal_out[n5] = signal_out[n5] + ndx;
                        if ((ndx = 3 - ndx) < 0) break;
                    }
                    if (b1.type < 100 && i != sngl_count + rpt_count - 1 || b2 == null || b2.type >= 100) continue;
                    if (b1.units[1] >= 4 || Math.abs(b1.fracs[1]) >= 20) break;
                    ndx = b1.units[1];
                    signal_out[2 * i + 3] = ndx + 1 << 16;
                    signal_out[2 * i + 1] = ndx;
                    ndx = 3 - ndx;
                }
                this.m_dataNdx = 0;
                if (i == sngl_count + rpt_count) {
                    for (i = 0; i < sngl_count + rpt_count; ++i) {
                        Burst b1 = this.m_Bursts.get(signal_out[2 * i]);
                        int signew = 0;
                        if (b1.type >= 100) continue;
                        if ((signal_out[2 * i + 1] & 0xFF0000) != 0) {
                            this.addBits((signal_out[2 * i + 1] >> 16) - 1, 2);
                            signew += 2;
                        }
                        if ((signal_out[2 * i + 1] & 0xFF00) != 0) {
                            this.addBits((signal_out[2 * i + 1] >> 8 & 0xFF) - 1, 2);
                            signew += 2;
                        }
                        this.addBits(signal_out[2 * i + 1] & 0xFF, 2);
                        signal_out[2 * i + 1] = signew += 2;
                    }
                    this.m_type = 9;
                } else {
                    for (i = 0; i < sngl_count + rpt_count + extra_count; ++i) {
                        signal_out[2 * i + 1] = 0;
                    }
                }
            }
            if (this.m_type == 6 && onint_max == 2 * onint_min) {
                for (i = 0; i < this.m_Bursts.size(); ++i) {
                    if (this.m_Bursts.get((int)i).type >= 100) continue;
                    this.m_Bursts.get((int)i).type = (short)(this.m_Bursts.get((int)i).type + 400 * (this.m_Bursts.get((int)i).units[0] == onint_max ? 1 : 0));
                }
                for (i = 0; i < sngl_count + rpt_count; ++i) {
                    signal_out[2 * i + 1] = 0;
                }
                boolean evenOK = true;
                boolean oddOK = true;
                int evensum = 0;
                int oddsum = 0;
                int eventot = 0;
                int finaltot = 0;
                int ndx = 0;
                int sectstart = 0;
                int last1xx = -1;
                Burst b1 = null;
                Burst b2 = null;
                for (i = 0; i < sngl_count + rpt_count; ++i) {
                    b1 = this.m_Bursts.get(signal_out[2 * i]);
                    b2 = i < sngl_count + rpt_count - 1 ? this.m_Bursts.get(signal_out[2 * (i + 1)]) : null;
                    int t = b1.type;
                    if (ndx & true && t < 100) {
                        evensum += t;
                        oddsum = t;
                        if (eventot == 0) {
                            eventot = evensum;
                        } else if (evensum != eventot) {
                            evenOK = false;
                        }
                        ++ndx;
                    } else if (ndx & true && t >= 400) {
                        if (eventot == 0) {
                            eventot = evensum;
                        } else if (evensum != eventot) {
                            evenOK = false;
                        }
                        evensum = oddsum = t % 100;
                        if (finaltot == 0) {
                            finaltot = oddsum;
                        } else if (oddsum != finaltot) {
                            oddOK = false;
                        }
                        signal_out[2 * i + 1] = 100 + t % 100;
                        ndx += 2;
                    } else if (!(ndx & true) && t < 100) {
                        evensum = t;
                        oddsum += t;
                        if (finaltot == 0) {
                            finaltot = oddsum;
                        } else if (oddsum != finaltot) {
                            oddOK = false;
                        }
                        signal_out[2 * i + 1] = 100 + t;
                        ++ndx;
                    } else if ((ndx & 1) == 0 && t >= 400) {
                        if (finaltot == 0) {
                            finaltot = oddsum;
                        } else if (oddsum != finaltot) {
                            oddOK = false;
                        }
                        oddsum = evensum = t % 100;
                        if (eventot == 0) {
                            eventot = evensum;
                        } else if (evensum != eventot) {
                            evenOK = false;
                        }
                        signal_out[2 * i + 1] = 100;
                        ndx += 2;
                    }
                    if (t >= 100 && t < 200 || i == sngl_count + rpt_count - 1) {
                        if (!evenOK && !oddOK) {
                            bursts_done = false;
                            break;
                        }
                        if (ndx > 0 && (evenOK && (ndx & 1) != 0 || oddOK && (ndx & 1) == 0)) {
                            if (b1.units[0] < 2) {
                                if ((ndx & 1) == 0) {
                                    evenOK = false;
                                } else {
                                    oddOK = false;
                                }
                            } else {
                                signal_out[2 * i + 1] = 256;
                                if (oddOK) {
                                    signal_out[2 * i - 1] = 0;
                                }
                            }
                        }
                        if (ndx > 0 && evenOK && !oddOK) {
                            for (int j = sectstart; j < i; ++j) {
                                if (signal_out[2 * j + 1] < 100) continue;
                                signal_out[2 * j + 1] = 200 + eventot - signal_out[2 * j + 1];
                            }
                            if (last1xx >= 0) {
                                signal_out[2 * last1xx + 1] = 0;
                            }
                        }
                        ndx = 0;
                        if (b2 != null) {
                            oddOK = true;
                            evenOK = true;
                            if (b2.type < 100 || b2.type >= 400) {
                                double x = (double)b1.times[1] / delta;
                                oddsum = (int)(x + 0.5);
                                if (Math.abs(x - (double)oddsum) > 0.2) {
                                    oddOK = false;
                                }
                                if ((double)b1.times[0] < 1.1 * (double)onint_min * (double)this.m_unit) {
                                    oddOK = false;
                                } else {
                                    signal_out[2 * i + 1] = 256 + oddsum;
                                }
                                last1xx = i;
                            }
                            sectstart = i + 1;
                        }
                    }
                    this.outputDebugString("i=%d evenOK=%b oddOK=%b eventot=%d finaltot=%d", i, evenOK, oddOK, eventot, finaltot);
                }
                if (bursts_done) {
                    if (!oddOK) {
                        finaltot = eventot;
                    }
                    for (i = 0; i < 20; ++i) {
                        outvec[i] = 0;
                    }
                    for (i = 0; i < sngl_count + rpt_count; ++i) {
                        b1 = this.m_Bursts.get(signal_out[2 * i]);
                        ndx = signal_out[2 * i + 1] - 100;
                        if (b1.type >= 100 && b1.type < 400 || ndx < 0) continue;
                        int n6 = ndx;
                        outvec[n6] = outvec[n6] + 1;
                    }
                    specsize = 0;
                    for (i = 0; i < 16; ++i) {
                        if (outvec[i] <= 0) continue;
                        ++specsize;
                    }
                    if (specsize > 4) {
                        bursts_done = false;
                    }
                }
                if (bursts_done) {
                    int j = 16;
                    for (i = 0; i < 16; ++i) {
                        if (outvec[i] <= 0) continue;
                        outvec[j++] = i;
                    }
                    this.outputDebugString("outvec16+ %d %d %d %d specsize %d", outvec[16], outvec[17], outvec[18], outvec[19], specsize);
                    int inserted = -1;
                    if (specsize == 3) {
                        if (outvec[0] == 0) {
                            inserted = 0;
                        } else if ((finaltot & 1) == 0 && outvec[finaltot / 2] == 0) {
                            inserted = finaltot / 2;
                        } else if ((finaltot & 1) != 0 && outvec[finaltot / 2] == 0 && outvec[(finaltot + 1) / 2] == 0) {
                            inserted = finaltot / 2;
                        } else if (outvec[finaltot - outvec[17]] == 0) {
                            inserted = finaltot - outvec[17];
                        } else if (outvec[finaltot - outvec[18]] == 0) {
                            inserted = finaltot - outvec[18];
                        }
                        if (inserted >= 0) {
                            outvec[inserted] = 1;
                            ++specsize;
                        }
                        if (specsize == 4) {
                            int j1 = 16;
                            for (i = 0; i < 16; ++i) {
                                if (i == inserted) {
                                    inserted = j1 - 16;
                                }
                                if (outvec[i] <= 0) continue;
                                outvec[j1++] = i;
                            }
                        }
                    }
                    this.outputDebugString("inserted = %d", inserted);
                    for (i = 0; i < 16; ++i) {
                        outvec[i] = -1;
                    }
                    if (nonint == 0) {
                        for (j = 0; j < specsize; ++j) {
                            int n7 = onint_min;
                            outvec[4 * j + 2] = n7;
                            outvec[4 * j] = n7;
                            for (i = 0; i < this.m_Bursts.size(); ++i) {
                                if (outvec[4 * j + 3] < 0 && this.m_Bursts.get((int)i).type == outvec[j + 16]) {
                                    outvec[4 * j + 3] = this.m_Bursts.get((int)i).units[1];
                                }
                                if (outvec[4 * j + 3] < 0 && this.m_Bursts.get((int)i).type == 400 + outvec[j + 16]) {
                                    outvec[4 * j + 3] = this.m_Bursts.get((int)i).units[1];
                                }
                                if (outvec[4 * j + 1] < 0 && this.m_Bursts.get((int)i).type == finaltot - outvec[j + 16]) {
                                    outvec[4 * j + 1] = this.m_Bursts.get((int)i).units[1];
                                }
                                if (outvec[4 * j + 1] >= 0 || this.m_Bursts.get((int)i).type != 400 + finaltot - outvec[j + 16]) continue;
                                outvec[4 * j + 1] = this.m_Bursts.get((int)i).units[1];
                            }
                            if (outvec[4 * j + 3] < 0 && outvec[j + 16] == 0) {
                                outvec[4 * j + 3] = 0;
                            }
                            if (outvec[4 * j + 1] >= 0 || outvec[j + 16] != finaltot) continue;
                            outvec[4 * j + 1] = 0;
                        }
                        j = inserted;
                        if (outvec[4 * j + 1] < 0 && outvec[4 * j + 3] < 0 && j > 0 && j < 3 && outvec[4 * j - 3] > outvec[4 * j + 5] + 1 && outvec[4 * j - 1] < outvec[4 * j + 7] - 1) {
                            outvec[4 * j + 1] = (outvec[4 * j - 3] + outvec[4 * j + 5]) / 2;
                            outvec[4 * j + 3] = outvec[4 * j - 1] + outvec[4 * j + 7] - outvec[4 * j + 1];
                        }
                        if (specsize > 1 && outvec[1] < 0 && outvec[3] >= 0 && outvec[5] >= 0 && outvec[7] >= 0) {
                            outvec[1] = outvec[5] + outvec[7] - outvec[3];
                        }
                        j = specsize - 1;
                        if (specsize > 1 && outvec[4 * j + 3] < 0 && outvec[4 * j + 1] >= 0 && outvec[4 * j - 1] >= 0 && outvec[4 * j - 3] >= 0) {
                            outvec[4 * j + 3] = outvec[4 * j - 1] + outvec[4 * j - 3] - outvec[4 * j + 1];
                        }
                    } else {
                        bursts_done = false;
                    }
                }
                if (bursts_done) {
                    this.m_dataNdx = 0;
                    for (i = 0; i < sngl_count + rpt_count; ++i) {
                        b1 = this.m_Bursts.get(signal_out[2 * i]);
                        if (b1.type >= 100 && (b1.type < 400 || signal_out[2 * i + 1] < 100)) continue;
                        for (int j = 0; j < specsize; ++j) {
                            if (outvec[16 + j] != signal_out[2 * i + 1] - 100) continue;
                            this.addBits(j, 2);
                            signal_out[2 * i + 1] = 2;
                        }
                    }
                }
                if (bursts_done) {
                    this.m_type = 7;
                } else {
                    int fourplus = 0;
                    int fourplusndx = 0;
                    for (i = 0; i < this.m_Bursts.size(); ++i) {
                        if (this.m_Bursts.get((int)i).type > 3 && this.m_Bursts.get((int)i).type < 100) {
                            ++fourplus;
                            fourplusndx = i;
                        }
                        if (this.m_Bursts.get((int)i).type >= 100) continue;
                        this.m_Bursts.get((int)i).type = (short)(this.m_Bursts.get((int)i).type + 400 * (this.m_Bursts.get((int)i).units[0] == onint_max ? 1 : 0));
                    }
                    if (this.m_type != 99 && fourplus == 1) {
                        this.m_type = 99;
                        for (i = 0; i < 3; ++i) {
                            if (this.m_Bursts.get((int)fourplusndx).sect_counts[i] <= 1) continue;
                            this.m_type = 0;
                        }
                        if (this.m_type == 99) {
                            this.m_Bursts.get((int)fourplusndx).type = (short)105;
                        }
                    }
                }
            }
            if (this.m_type == 6 && this.m_unit2 > 0 && onint_min == onint_max) {
                n = n_best < 4 ? 2 : (n_best < 8 ? 3 : 4);
                for (i = 0; i < sngl_count + rpt_count; ++i) {
                    short t = this.m_Bursts.get((int)signal_out[2 * i]).type;
                    if (t >= 100) continue;
                    this.addBits(t, n);
                    signal_out[2 * i + 1] = n;
                }
                specsize = n_best < 4 ? 4 : (n_best < 8 ? 8 : 16);
            } else if (this.m_type == 6) {
                bursts_done = false;
            }
            if (!bursts_done) {
                for (i = 0; i < this.m_Bursts.size(); ++i) {
                    if (this.m_Bursts.get((int)i).type >= 100 && this.m_Bursts.get((int)i).type < 200) continue;
                    this.m_Bursts.get((int)i).type = (short)-1;
                }
                this.m_dataNdx = 0;
                for (i = 0; i < sngl_count + rpt_count + extra_count; ++i) {
                    signal_out[2 * i + 1] = 0;
                }
                if (this.m_type != 99) {
                    this.m_type = 0;
                }
            }
        }
        if (n_best > 0) {
            this.outputDebugString("n_best=%d m_unit2=%d y_minmax=%f m_type=%d\n", n_best, this.m_unit2, y_minmax, this.m_type);
        }
        for (i = 0; i < this.m_Bursts.size(); ++i) {
            this.outputDebugString("Burst %d: On=%d/%d Off=%d/%d Type=%d s_count=%d r_count=%d e_count=%d", i, this.m_Bursts.get((int)i).units[0], this.m_Bursts.get((int)i).fracs[0], this.m_Bursts.get((int)i).units[1], this.m_Bursts.get((int)i).fracs[1], this.m_Bursts.get((int)i).type, this.m_Bursts.get((int)i).sect_counts[0], this.m_Bursts.get((int)i).sect_counts[1], this.m_Bursts.get((int)i).sect_counts[2]);
            if (this.m_Bursts.get((int)i).cumulative[0] + this.m_Bursts.get((int)i).cumulative[1] + this.m_Bursts.get((int)i).cumulative[2] <= 0) continue;
            this.outputDebugString("Cumulations %d %d %d\n", this.m_Bursts.get((int)i).cumulative[0], this.m_Bursts.get((int)i).cumulative[1], this.m_Bursts.get((int)i).cumulative[2]);
        }
        if (bursts_done && this.m_type > 0 && rpt_count > 0) {
            short rpt_start_type = this.m_Bursts.get((int)signal_out[2 * sngl_count]).type;
            short rpt_end_type = this.m_Bursts.get((int)signal_out[2 * (sngl_count + rpt_count - 1)]).type;
            if (rpt_start_type >= 100 && rpt_start_type < 200 && (rpt_end_type < 100 || rpt_end_type >= 200)) {
                rpt_offset = 1;
            }
        }
        if (!bursts_done && this.m_type == 0 && sngl_count == 0 && rpt_count > 1 && this.m_unit > 700) {
            for (i = 0; i < this.m_Bursts.size() && this.m_Bursts.get((int)i).fracs[0] <= 10 && this.m_Bursts.get((int)i).units[0] <= 12 && (this.m_Bursts.get((int)i).type == 101 || this.m_Bursts.get((int)i).fracs[1] <= 10 && this.m_Bursts.get((int)i).units[1] <= 12); ++i) {
            }
            if (i == this.m_Bursts.size()) {
                tot = 0;
                this.m_dataNdx = 0;
                for (i = 0; i < rpt_count - 1; ++i) {
                    Burst b = this.m_Bursts.get(signal_out[2 * i]);
                    if (b.type > 100) break;
                    this.addBits(255, b.units[0]);
                    this.addBits(0, b.units[1]);
                    signal_out[2 * i + 1] = b.units[0] + b.units[1];
                    if ((tot += b.units[0] + b.units[1]) > 40) break;
                }
                Burst b = this.m_Bursts.get(signal_out[2 * (rpt_count - 1)]);
                this.addBits(65535, b.units[0]);
                int n = 2 * rpt_count - 3;
                signal_out[n] = signal_out[n] + b.units[0];
                signal_out[2 * rpt_count - 1] = b.units[0] << 8;
                if (i == rpt_count - 1 && (tot += b.units[0]) < 40) {
                    this.m_type = 11;
                    bursts_done = true;
                } else {
                    this.m_dataNdx = 0;
                    for (i = 0; i < sngl_count + rpt_count + extra_count; ++i) {
                        signal_out[2 * i + 1] = 0;
                    }
                }
            }
        }
        if (irp != null) {
            irp.replace(0, irp.length(), "Undetermined");
        }
        if (irp != null && bursts_done) {
            int d_ndx = 0;
            int v_ndx = 0;
            int skip = 0;
            if (bursts_done) {
                if (irp.length() > 0) {
                    irp.replace(0, irp.length(), "");
                }
                irp.append(String.format("{%3.1fk,", (double)freq / 1000.0));
                irp.append(String.format(this.m_type == 6 ? "msb}<" : "%d,msb}<", this.m_unit));
                if (this.m_type <= 5) {
                    for (i = 0; i < specsize; ++i) {
                        irp.append(String.format("%d,%d|", outvec[2 * i], outvec[2 * i + 1]));
                    }
                } else if (this.m_type == 6) {
                    irp.append(String.format("-%du|%du,-%du>(<", this.m_unit2, this.m_Bursts.get((int)offint_min_ndx).times[0], this.m_Bursts.get((int)offint_min_ndx).times[1]));
                    for (i = 0; i < specsize; ++i) {
                        irp.append(String.format("1:-%d|", i + 1));
                    }
                } else if (this.m_type == 7) {
                    for (i = 0; i < specsize; ++i) {
                        irp.append(String.format("%d,-%d,%d,-%d|", outvec[4 * i], outvec[4 * i + 1], outvec[4 * i + 2], outvec[4 * i + 3]));
                    }
                } else if (this.m_type == 8) {
                    for (i = 0; i < specsize; ++i) {
                        irp.append(String.format("%d,%du|", outvec[2 * i], outvec[2 * i + 1]));
                    }
                } else if (this.m_type == 9) {
                    irp.append(String.format("1,-3|-1,1,-2|-2,1,-1|-3,1|", new Object[0]));
                } else if (this.m_type == 10) {
                    irp.append(String.format("%d,-%d,%d,-%d|%d,-%d|", outvec[0], outvec[1], outvec[2], outvec[3], outvec[4], outvec[5]));
                } else if (this.m_type == 11) {
                    irp.append(String.format("-1|1|", new Object[0]));
                }
                Analyzer.chop(irp);
                irp.append(">(");
                for (i = 0; i < sngl_count + rpt_count; ++i) {
                    if (i == sngl_count - rpt_count && rpt_count > 0 && this.m_type != 6 && this.m_Bursts.get((int)signal_out[2 * i]).type >= 100 && this.m_Bursts.get((int)signal_out[2 * i]).type < 200 && this.m_Bursts.get((int)signal_out[2 * sngl_count]).type >= 100 && this.m_Bursts.get((int)signal_out[2 * sngl_count]).type < 200 && this.m_Bursts.get((int)signal_out[2 * i]).units[0] > this.m_Bursts.get((int)signal_out[2 * sngl_count]).units[0] && this.m_Bursts.get((int)signal_out[2 * i]).units[1] == this.m_Bursts.get((int)signal_out[2 * sngl_count]).units[1]) {
                        int j;
                        boolean eq = true;
                        for (j = i + 1; j < sngl_count; ++j) {
                            if (signal_out[2 * j] == signal_out[2 * (j + rpt_count)]) continue;
                            eq = false;
                        }
                        if (eq) {
                            skip = 0;
                            irp.append(String.format("%d,", this.m_Bursts.get((int)signal_out[2 * i]).units[0] - this.m_Bursts.get((int)signal_out[2 * sngl_count]).units[0]));
                            for (j = i + 1; j < sngl_count; ++j) {
                                Burst b = this.m_Bursts.get(signal_out[2 * j]);
                                if (b.type >= 100 && b.type < 200) continue;
                                skip += signal_out[2 * j + 1] % 100;
                            }
                            i = sngl_count;
                            if (skip > 0) {
                                this.m_datacounts[v_ndx++] = -skip;
                            }
                        }
                    }
                    Burst b = this.m_Bursts.get(signal_out[2 * i]);
                    int bitcode = signal_out[2 * i + 1];
                    if (i == sngl_count && sngl_count > 0 && rpt_count > 0) {
                        irp.append("(");
                    }
                    if (this.m_type != 11 && (b.type < 100 || b.type >= 200) || this.m_type == 11 && i < rpt_count - 1) {
                        if (bitcode / 100 > 0) {
                            irp.append(String.format("%c", 65 + v_ndx - (skip > 0 ? 1 : 0)));
                            irp.append(String.format(":%d,", (d_ndx += bitcode % 100) - bitcode / 100));
                            this.m_datacounts[v_ndx++] = d_ndx - bitcode / 100;
                            irp.append(String.format("<-%d,%d|%d,-%d>(", 2 * offint_min, 2 * onint_min, 2 * onint_min, 2 * offint_min));
                            irp.append(String.format("%c", 65 + v_ndx - (skip > 0 ? 1 : 0)));
                            irp.append(String.format(":1),", new Object[0]));
                            this.m_datacounts[v_ndx++] = 1;
                            d_ndx = bitcode / 100 - 1;
                        } else {
                            d_ndx += bitcode % 100;
                        }
                    }
                    if (this.m_type != 11 && b.type >= 100 && b.type < 200 || i == sngl_count - 1 || i == sngl_count + rpt_count - 1) {
                        if (d_ndx > 0 && v_ndx < 26) {
                            irp.append(String.format("%c", 65 + v_ndx - (skip > 0 ? 1 : 0)));
                            irp.append(String.format(":%d,", d_ndx));
                            this.m_datacounts[v_ndx++] = d_ndx;
                        }
                        d_ndx = 0;
                    }
                    if (this.m_type != 11 && b.type >= 100 && b.type < 200 || this.m_type == 11 && i == rpt_count - 1) {
                        int x;
                        float y;
                        boolean tflag = this.m_type == 6 || this.m_type == 8;
                        int t0 = b.units[0] - (signal_out[2 * i + 1] >> 8);
                        int t1 = b.units[1] - (signal_out[2 * i + 1] & 0xFF);
                        boolean t0chk = false;
                        boolean t1chk = false;
                        float ratio = (float)t0 / (float)t1;
                        if (t0 > t1 && t1 > 0 && t1 <= 10 * offint_min && Math.abs(b.fracs[1] * offint_min) <= Math.max(5 * t1, 20 * offint_min) && (double)ratio < 4.5) {
                            int x2 = (int)((double)ratio + 0.5);
                            float y2 = ratio / (float)x2 - 1.0f;
                            if ((double)Math.abs(y2) < 0.1) {
                                t0 = x2 * t1;
                                t1chk = true;
                                t0chk = true;
                            }
                        } else if (t1 > t0 && t0 > 0 && t0 <= 10 * onint_min && Math.abs(b.fracs[0] * onint_min) <= Math.max(5 * t0, 20 * onint_min) && (double)(1.0f / ratio) < 4.5 && (double)Math.abs(y = 1.0f / ratio - (float)(x = (int)((double)(1.0f / ratio) + 0.5))) < 0.2) {
                            t1 = x * t0;
                            t1chk = true;
                            t0chk = true;
                        }
                        if (!t0chk && t0 <= 20 * onint_min && Math.abs(b.fracs[0] * onint_min) <= Math.max(5 * t0, 20 * onint_min)) {
                            t0chk = true;
                        }
                        if (!t1chk && t1 <= 20 * offint_min && Math.abs(b.fracs[1] * offint_min) <= Math.max(5 * t1, 20 * offint_min)) {
                            t1chk = true;
                        }
                        if (t0 > 0) {
                            if (!tflag && t0chk) {
                                irp.append(String.format("%d,", t0));
                            } else {
                                tflag = true;
                                if ((t0 = (int)(((double)t0 + (double)b.fracs[0] / 100.0) * (double)this.m_unit + 0.5)) < 10000) {
                                    irp.append(String.format("%du,", t0));
                                } else {
                                    t0 = (t0 + 50) / 100;
                                    irp.append(String.format("%d.%1dm,", t0 / 10, t0 % 10));
                                }
                            }
                        }
                        if (b.type == 103) {
                            irp.append(String.format("^%dm,", (b.cumulative[i >= sngl_count ? 1 : 0] + 500) / 1000));
                        } else if (t1 > 0) {
                            if (!tflag && t1chk) {
                                irp.append(String.format("-%d,", t1));
                            } else if ((t1 = (int)(((double)t1 + (double)b.fracs[1] / 100.0) * (double)this.m_unit + 0.5)) < 10000) {
                                irp.append(String.format("-%du,", t1));
                            } else {
                                t1 = (t1 + 50) / 100;
                                irp.append(String.format("-%d.%1dm,", t1 / 10, t1 % 10));
                            }
                        }
                    }
                    if (rpt_count > 0 && i == sngl_count + rpt_count - 1) {
                        Analyzer.chop(irp);
                        irp.append(")+");
                    }
                    if (sngl_count <= 0 || i != sngl_count + rpt_count - 1) continue;
                    if (rpt_count == 0) {
                        Analyzer.chop(irp);
                    }
                    irp.append(")");
                }
                if (this.m_type == 6) {
                    irp.append(")");
                }
                if (v_ndx > 0) {
                    skip = 0;
                    irp.append("{");
                    for (i = 0; i < v_ndx; ++i) {
                        if (this.m_datacounts[i] >= 0) {
                            irp.append(String.format("%c", 65 + i - skip));
                            irp.append(String.format("=%s", Analyzer.basisPrefix(this.basis)));
                            this.outbits(irp, this.m_datacounts[i]);
                            irp.append(String.format(i == v_ndx - 1 ? "}" : ",", new Object[0]));
                            continue;
                        }
                        this.outbits(null, -this.m_datacounts[i]);
                        ++skip;
                    }
                }
                if (rpt_count <= 0 || this.m_type >= 3 && (this.m_type <= 4 || this.m_type >= 7)) {
                    this.m_altLeadout = "";
                }
            }
            this.outputDebugString(new String(irp));
        }
        this.outputDebugString("%d", rpt_offset);
        this.dumpBursts();
        return rpt_offset;
    }

    private boolean seekLeadin(int sngl_count, int rpt_count, int extra_count, int[] signal_out, int li, int type) {
        boolean newleadin;
        boolean found = false;
        block0: do {
            newleadin = false;
            for (int i = 0; i < this.m_Bursts.size(); ++i) {
                short[] c = this.m_Bursts.get((int)i).sect_counts;
                if (this.m_Bursts.get((int)i).type != -1 || c[0] != 0 && (sngl_count <= li || c[0] != 1 || i != signal_out[2 * li]) || c[1] != 0 && (rpt_count <= li || c[1] != 1 || i != signal_out[2 * (sngl_count + li)]) || c[2] != 0 && (extra_count <= li || c[2] != 1 || i != signal_out[2 * (sngl_count + rpt_count + li)]) || c[0] + c[1] + c[2] <= 0) continue;
                int m0 = 0;
                int mm = 0;
                for (int j = 0; j < this.m_Bursts.size(); ++j) {
                    if (j == i || this.m_Bursts.get((int)j).type != -1) continue;
                    mm = Math.max(mm, this.m_Bursts.get((int)j).times[0] + this.m_Bursts.get((int)j).times[1]);
                    m0 = Math.max(m0, this.m_Bursts.get((int)j).times[0]);
                }
                if (this.m_Bursts.get((int)i).times[0] + this.m_Bursts.get((int)i).times[1] <= mm && this.m_Bursts.get((int)i).times[0] <= m0) continue;
                this.m_Bursts.get((int)i).type = (short)type;
                newleadin = true;
                found = true;
                continue block0;
            }
        } while (newleadin);
        this.outputDebugString("SeekLeadIn type %d, result=%b", type, found);
        return found;
    }

    private class Burst {
        int[] times = new int[2];
        double[] totals = new double[2];
        int[] units = new int[2];
        short[] fracs = new short[2];
        short count;
        short[] sect_counts = new short[3];
        int[] cumulative = new int[3];
        short type = (short)-1;

        private Burst() {
        }

        Burst(int iOn, int iOff) {
            this.times[0] = Math.abs(iOn);
            this.times[1] = Math.abs(iOff);
        }

        public void dump() {
            Analyzer.this.dumpIntArray(this.times);
            Analyzer.this.dumpDoubleArray(this.totals);
            Analyzer.this.dumpIntArray(this.units);
            Analyzer.this.dumpShortArray(this.fracs);
            Analyzer.this.outputDebugString(this.count + "\t");
            Analyzer.this.dumpShortArray(this.sect_counts);
            Analyzer.this.dumpIntArray(this.cumulative);
            Analyzer.this.outputDebugString(Short.toString(this.type));
        }
    }
}

