/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.exchangeir;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public abstract class Exchange {
    private static final String debugFilename = "debug.txt";
    public static final String versionString = "0.0.8.2";
    private PrintStream debugFile = null;
    protected int errlimit;
    private static boolean debug = false;

    public static void setDebug(boolean dbg) {
        debug = dbg;
    }

    public static String getVersion() {
        return versionString;
    }

    protected void outputDebugString(String s) {
        if (this.debugFile != null) {
            this.debugFile.println(s);
        }
    }

    protected void outputDebugString(String format, Object ... obj) {
        String str = String.format(format, obj);
        this.outputDebugString(str);
    }

    protected boolean equalTimes(int t1, int t2) {
        return !((double)Math.abs(t2) < Math.floor(0.975 * (double)Math.abs(t1)) && Math.abs(t2) < Math.abs(t1) - this.errlimit || (double)Math.abs(t2) > Math.ceil(1.025 * (double)Math.abs(t1)) && Math.abs(t2) > Math.abs(t1) + this.errlimit);
    }

    protected boolean equalTimes(int[] t1, int offset1, int[] t2, int offset2, int duration_count) {
        for (int i = 0; i < duration_count; ++i) {
            if (this.equalTimes(t1[i + offset1], t2[i + offset2])) continue;
            return false;
        }
        return true;
    }

    protected Exchange(int errlimit) {
        this.errlimit = errlimit;
        this.debugFile = null;
        if (debug) {
            try {
                this.debugFile = new PrintStream(debugFilename, "US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                assert (false);
            }
            catch (FileNotFoundException ex) {
                System.err.println(ex.getMessage());
            }
        }
    }
}

