/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.exchangeir;

import com.hifiremote.exchangeir.Analyzer;
import com.hifiremote.exchangeir.Exchange;

public class RepeatFinder
extends Exchange {
    private int sngl_count;
    private int rpt_count;
    private int extra_count;
    private int rpts;
    private static final int N = 6;

    public int getNoIntroBursts() {
        return this.sngl_count;
    }

    public int getNoRepeatBursts() {
        return this.rpt_count;
    }

    public int getNoEndingBursts() {
        return this.extra_count;
    }

    public int getNoRepeats() {
        return this.rpts;
    }

    public String toString() {
        return "{into = " + this.sngl_count + "; repeatLength = " + this.rpt_count + "; repeats = " + this.rpts + "; extra_count = " + this.extra_count + "}";
    }

    public RepeatFinder(int[] times, int errlimit) {
        super(errlimit);
        int i;
        int j = -1;
        int rpt_start = -1;
        this.sngl_count = times.length / 2;
        this.rpts = 0;
        this.rpt_count = 0;
        this.extra_count = 0;
        int iEnd = this.sngl_count + this.rpts * this.rpt_count + this.extra_count;
        int maxOff = -1;
        int maxOn = -1;
        int maxBurst = -1;
        int minBurst = 99999;
        int minOn = 99999;
        int maxOff2 = -1;
        int ndxOff = 0;
        int ndxOn = 0;
        int offset = 0;
        int[] maxOffPos = new int[6];
        int[] maxOnPos = new int[6];
        for (i = 0; i < iEnd - 1; ++i) {
            if (i <= 0 && times[0] + Math.abs(times[1]) >= Math.abs(times[3])) continue;
            maxBurst = Math.max(maxBurst, times[2 * i] + Math.abs(times[2 * i + 1]));
            minBurst = Math.min(minBurst, times[2 * i] + Math.abs(times[2 * i + 1]));
            if (i < 15) {
                this.outputDebugString("i=%d minBurst=%d maxBurst=%d abs(times[2*i+3]=%d", i, minBurst, maxBurst, Math.abs(times[2 * i + 3]));
            }
            if (Math.abs(times[2 * i + 3]) <= 2 * maxBurst - minBurst || i != iEnd - 2 && !((double)Math.abs(times[2 * i + 3]) > 1.2 * (double)(times[2 * i + 4] + Math.abs(times[2 * i + 5])))) continue;
            ++i;
        }
        for (i = 1; i < iEnd - 1; ++i) {
            if (Math.abs(times[2 * i + 1]) <= 2 * maxBurst - minBurst) continue;
            maxOff = Math.max(maxOff, Math.abs(times[2 * i + 1]));
        }
        for (i = 1; i < iEnd - 1; ++i) {
            if (Math.abs(times[2 * i + 1]) <= 2 * maxBurst - minBurst || !((double)Math.abs(times[2 * i + 1]) <= 0.9 * (double)maxOff)) continue;
            maxOff2 = Math.max(maxOff2, Math.abs(times[2 * i + 1]));
        }
        for (i = 1; i < iEnd - 1; ++i) {
            maxOn = Math.max(maxOn, times[2 * i]);
            minOn = Math.min(minOn, times[2 * i]);
        }
        this.outputDebugString("maxOff=%d maxOff2=%d maxOn=%d minOn=%d maxBurst=%d\n", maxOff, maxOff2, maxOn, minOn, maxBurst);
        for (i = 0; i < 6; ++i) {
            maxOnPos[i] = -999;
            maxOffPos[i] = -999;
        }
        maxOffPos[ndxOff++] = -1;
        for (i = 1; i < iEnd - 1; ++i) {
            if (maxOn > 0 && (double)times[2 * i] > 0.9 * (double)maxOn && ndxOn < 6) {
                maxOnPos[ndxOn++] = 2 * i;
            }
            if (maxOff <= 0 || !((double)Math.abs(times[2 * i + 1]) > 0.9 * (double)maxOff) || ndxOff >= 6) continue;
            maxOffPos[ndxOff++] = 2 * i + 1;
        }
        boolean match = false;
        boolean withLeadout = false;
        for (i = 0; !match && i < 5 && maxOffPos[i] > -3; ++i) {
            for (j = i + 1; !match && j < 6 && maxOffPos[j] > -3; ++j) {
                for (offset = 0; !match && offset < (i == 0 ? 3 : 1) && 2 * maxOffPos[j] - maxOffPos[i] - offset <= 2 * iEnd - 1; offset += 2) {
                    this.outputDebugString("Match test at i=%d j=%d offset=%d maxOffPos[i]=%d maxOffPos[j]=%d", i, j, offset, maxOffPos[i], maxOffPos[j]);
                    match = this.equalTimes(times, maxOffPos[i] + offset + 1, times, maxOffPos[j] + 1, maxOffPos[j] - maxOffPos[i] - offset - 1);
                }
            }
        }
        this.outputDebugString("max on 1st pos %d", maxOnPos[1]);
        if (!match && maxOnPos[1] >= 0) {
            this.outputDebugString("max on times %d %d", times[maxOnPos[0]], Math.abs(times[maxOnPos[0] + 1]));
        }
        if (match) {
            rpt_start = (maxOffPos[i - 1] + offset - 1) / 2;
            this.rpt_count = (maxOffPos[j - 1] - maxOffPos[i - 1] - offset + 2) / 2;
            withLeadout = true;
            if (rpt_start < 8 && this.rpt_count < 3 && maxOff < 10 * minBurst) {
                match = false;
                rpt_start = this.sngl_count;
                this.rpt_count = 0;
            }
        } else if (maxOnPos[0] >= 0 && maxOn > 5 * minOn && (double)times[maxOnPos[0]] > 0.9 * (double)Math.abs(times[maxOnPos[0] + 1])) {
            for (i = 0; !match && i < 5 && maxOnPos[i] >= 0; ++i) {
                for (j = i + 1; !match && j < 6 && maxOnPos[j] >= 0; ++j) {
                    match = this.equalTimes(times, maxOnPos[i], times, maxOnPos[j], maxOnPos[j] - maxOnPos[i]);
                }
            }
            if (match) {
                rpt_start = maxOnPos[i - 1] / 2;
                this.rpt_count = (maxOnPos[j - 1] - maxOnPos[i - 1]) / 2;
                this.outputDebugString("ON break: rpt_start=%d rpt_count=%d", rpt_start, this.rpt_count);
            }
        }
        if (match && rpt_start >= this.rpt_count && this.equalTimes(times, 2 * (rpt_start - this.rpt_count), times, 2 * rpt_start, 2 * this.rpt_count - (withLeadout ? 1 : 0))) {
            rpt_start -= this.rpt_count;
        }
        if (match && maxOff2 > 0) {
            int offtime;
            for (i = Math.max(0, this.rpt_count - rpt_start - 1); !(i >= this.rpt_count - 1 || (double)(offtime = Math.abs(times[2 * (rpt_start + i) + 1])) > 0.9 * (double)maxOff2 && (double)offtime < 1.1 * (double)maxOff2 && this.equalTimes(times, 2 * (rpt_start - this.rpt_count + i + 1), times, 2 * (rpt_start + i + 1), 2 * (this.rpt_count - i - 1) - (withLeadout ? 1 : 0))); ++i) {
            }
            if (i < this.rpt_count - 1) {
                rpt_start -= this.rpt_count - i - 1;
            }
        }
        if (match) {
            if (this.rpt_count > 0) {
                i = 0;
                while (rpt_start + (i + 2) * this.rpt_count <= iEnd && this.equalTimes(times, 2 * (rpt_start + i * this.rpt_count), times, 2 * (rpt_start + (i + 1) * this.rpt_count), 2 * this.rpt_count - (withLeadout || rpt_start + (i + 2) * this.rpt_count == iEnd ? 1 : 0))) {
                    ++i;
                }
                this.rpts = i + 1;
                this.extra_count = iEnd - rpt_start - this.rpts * this.rpt_count;
                this.sngl_count = rpt_start;
                this.outputDebugString("Burst counts: single = %d, repeat = %d, extra = %d.\nNo. of repeats = %d\n", this.sngl_count, this.rpt_count, this.extra_count, this.rpts);
            }
            if (!withLeadout && this.rpts > 0) {
                Analyzer analyzer = new Analyzer(times, this.sngl_count, this.rpt_count, this.extra_count, this.rpts, -2, errlimit, 10);
                int rpt_offset = analyzer.getNumberDistinctBursts();
                int[] signal_out = analyzer.getCleansedSignal();
                if (rpt_offset > 0 && (this.extra_count < 2 || signal_out[2 * (this.sngl_count + this.rpt_count)] == signal_out[2 * this.sngl_count])) {
                    if (this.extra_count < 2) {
                        signal_out[2 * (this.sngl_count + this.rpt_count)] = signal_out[2 * this.sngl_count];
                    }
                    this.sngl_count += rpt_offset;
                    this.extra_count = Math.max(this.extra_count - rpt_offset, 0);
                    if (this.sngl_count >= this.rpt_count && this.equalTimes(times, 2 * (this.sngl_count - this.rpt_count), times, 2 * this.sngl_count, 2 * this.rpt_count)) {
                        this.sngl_count -= this.rpt_count;
                    }
                }
            }
        }
    }
}

