/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.exchangeir;

import com.hifiremote.exchangeir.Analyzer;
import com.hifiremote.exchangeir.RepeatFinder;
import java.util.ArrayList;

public class UeiLearned {
    public static final int maxBursts = 16;
    public static final int maxLength = 128;
    private static final double frequencyConstant = 8000000.0;
    private static final int maxUnit = Short.MAX_VALUE;
    private ArrayList<Integer> learned = new ArrayList();

    public UeiLearned(int[] signal, int sngl_count, int rpt_count, int extra_count, int[][] bursts, int freq) {
        this.setup(signal, sngl_count, rpt_count, extra_count, bursts, freq);
    }

    public UeiLearned(int[] times, int freq, int errlimit) {
        RepeatFinder repeatFinder = new RepeatFinder(times, errlimit);
        Analyzer analyzer = new Analyzer(times, repeatFinder.getNoIntroBursts(), repeatFinder.getNoRepeatBursts(), repeatFinder.getNoEndingBursts(), repeatFinder.getNoRepeats(), freq, errlimit, 0);
        this.setup(analyzer.getSignalAsBurstIndices(), repeatFinder.getNoIntroBursts(), repeatFinder.getNoRepeatBursts(), repeatFinder.getNoEndingBursts(), analyzer.getBursts(), freq);
    }

    public UeiLearned(int[] times, int sngl_count, int rpt_count, int extra_count, int rpts, int freq, int errlimit) {
        Analyzer analyzer = new Analyzer(times, sngl_count, rpt_count, extra_count, rpts, freq, errlimit, 0);
        this.setup(analyzer.getSignalAsBurstIndices(), sngl_count, rpt_count, extra_count, analyzer.getBursts(), freq);
    }

    private UeiLearned() {
    }

    private void setup(int[] signal_out, int sngl_count, int rpt_count, int extra_count, int[][] bursts, int freq) {
        int x;
        int i;
        int unit;
        if (bursts.length > 16) {
            throw new IllegalArgumentException("There are " + bursts.length + " bursts, maximum permitted is " + 16);
        }
        int length = 3 + 4 * bursts.length;
        if (sngl_count > 0) {
            length += (sngl_count + 1) / 2 + 1;
        }
        if (rpt_count > 0) {
            length += (rpt_count + 1) / 2 + 1;
        }
        if (extra_count > 0) {
            length += (extra_count + 1) / 2 + 1;
        }
        if (length + 3 > 128) {
            throw new IllegalArgumentException("Total length is " + length + 3 + " bytes, maximum permitted is " + 128);
        }
        this.learned.add(0);
        this.learned.add(0);
        this.learned.add(length);
        int n = unit = freq > 0 ? (int)Math.round(8000000.0 / (double)freq) : 0;
        if (unit > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Nonzero frequency is less than 250Hz");
        }
        this.learned.add(unit >> 8);
        this.learned.add(unit & 0xFF);
        this.learned.add(bursts.length);
        for (i = 0; i < bursts.length; ++i) {
            this.addBurst(bursts[i][0]);
            this.addBurst(bursts[i][1]);
        }
        if (sngl_count > 0) {
            this.learned.add(sngl_count);
            i = 0;
            while (i < sngl_count) {
                x = signal_out[i++] << 4;
                if (i < sngl_count) {
                    x |= signal_out[i++];
                }
                this.learned.add(x);
            }
        }
        if (rpt_count > 0) {
            this.learned.add(rpt_count | 0x80);
            i = sngl_count;
            while (i < sngl_count + rpt_count) {
                x = signal_out[i++] << 4;
                if (i < sngl_count + rpt_count) {
                    x |= signal_out[i++];
                }
                this.learned.add(x);
            }
        }
        if (extra_count > 0) {
            this.learned.add(extra_count);
            i = sngl_count + rpt_count;
            while (i < sngl_count + rpt_count + extra_count) {
                x = signal_out[i++] << 4;
                if (i < sngl_count + rpt_count + extra_count) {
                    x |= signal_out[i++];
                }
                this.learned.add(x);
            }
        }
    }

    private void addBurst(int duration) {
        int t = Math.min(duration / 2, 65535);
        this.learned.add(t >> 8);
        this.learned.add(t & 0xFF);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int x : this.learned) {
            if (str.length() > 0) {
                str.append(" ");
            }
            str.append(String.format("%02X", x));
        }
        return str.toString();
    }

    public short[] toArray() {
        short[] result = new short[this.learned.size()];
        for (int i = 0; i < this.learned.size(); ++i) {
            result[i] = this.learned.get(i).shortValue();
        }
        return result;
    }
}

