/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.exchangeir;

import java.util.ArrayList;

public class UeiLearnedImporter {
    private int iFreq;
    private int iSngl_count;
    private int iRpt_count;
    private int iExtra_count;
    private ArrayList<Integer> signal_out = new ArrayList();
    private int[][] m_Bursts;
    private static final int[] romBursts = new int[]{419, 19073, 1679, 1680, 419, 1270, 419, 420, 210, 44812, 210, 17671, 631, 211, 210, 632, 131, 22683, 131, 923, 131, 393, 131, 23919, 131, 21799, 131, 923, 131, 393, 9, 64704, 9, 140, 9, 90, 9, 40, 9999, 2000, 499, 4000, 1999, 2000, 249, 1000, 249, 500, 280, 24777, 2249, 2250, 280, 845, 280, 281, 280, 20255, 4499, 2250, 280, 845, 280, 281, 280, 48669, 280, 23652, 2249, 2250, 280, 845, 280, 281, 280, 48358, 280, 20257, 4499, 2250, 4499, 1125, 280, 845, 280, 281, 280, 48358, 280, 22510, 4499, 2250, 4499, 1125, 280, 845, 280, 281, 280, 47253, 280, 11916, 4499, 2250, 280, 845, 280, 281, 266, 60990, 266, 10298, 266, 1335, 266, 534, 266, 267, 266, 60990, 266, 10298, 266, 1335, 533, 534, 266, 534, 266, 267, 266, 60990, 266, 10298, 242, 1335, 533, 534, 533, 267, 266, 534, 266, 267, 444, 45311, 889, 445, 444, 445, 444, 45311, 889, 445, 444, 890, 444, 445, 444, 45311, 889, 890, 889, 445, 444, 890, 444, 445, 9, 65535, 9, 7777, 9, 6222, 9, 4664, 9, 3106, 9, 1548, 9, 31589, 9, 4300, 9, 2860, 107, 65535, 107, 7679, 107, 6124, 107, 4566, 107, 3008, 107, 1450, 19, 31579, 19, 4290, 19, 2850};
    private static final int[] romIndex = new int[]{48, 56, 64, 74, 86, 8, 98, 16, 22, 30, 144, 150, 158, 108, 118, 130, 0, 38, 168, 170, 180, 186, 188, 198};

    public UeiLearnedImporter(String data) {
        String[] d = data.trim().split("[^\\w]+");
        int[] array = new int[d.length];
        for (int i = 0; i < d.length; ++i) {
            if (d[i].length() != 2) {
                throw new IllegalArgumentException("All digits must be two hexadecimal characters.");
            }
            array[i] = Integer.parseInt(d[i], 16);
        }
        this.setup(array);
    }

    public UeiLearnedImporter(int[] aiUEI) {
        this.setup(aiUEI);
    }

    private void setup(int[] aiUEI) {
        int count;
        int end;
        int iUEIsize = aiUEI.length;
        if (iUEIsize < 6 || iUEIsize < aiUEI[2] + 3) {
            throw new IllegalArgumentException("Invalid format for learned signal");
        }
        int unit = ((aiUEI[3] & 0x7F) << 8) + aiUEI[4];
        this.iFreq = unit == 0 ? 0 : 8000000 / unit;
        int noBursts = this.loadUEIBurstTable(aiUEI);
        this.iExtra_count = 0;
        this.iRpt_count = 0;
        this.iSngl_count = 0;
        int start = (aiUEI[5] & 0x80) != 0 ? 6 : 6 + 4 * noBursts;
        boolean bRepeat = false;
        while ((end = start + ((count = aiUEI[start] & 0x7F) + 1) / 2 + 1) <= aiUEI[2] + 3) {
            if (aiUEI[start] >> 7 != 0 && !bRepeat) {
                this.iRpt_count += count;
                bRepeat = true;
            } else if (!bRepeat) {
                this.iSngl_count += count;
            } else {
                this.iExtra_count += count;
            }
            for (int i = 0; i < count; ++i) {
                int ndx = aiUEI[start + i / 2 + 1];
                int n = ndx = (i & 1) != 0 ? ndx & 0xF : ndx >> 4;
                if (ndx >= this.m_Bursts.length) {
                    throw new IndexOutOfBoundsException();
                }
                this.signal_out.add(this.m_Bursts[ndx][0]);
                this.signal_out.add(this.m_Bursts[ndx][1]);
            }
            start = end;
            if (start < aiUEI[2] + 3) continue;
        }
    }

    private int loadUEIBurstTable(int[] ai) {
        int count;
        int burstNum = ai[5];
        if ((burstNum & 0x80) != 0) {
            int index = burstNum & 0x1F;
            if (index >= romIndex.length) {
                throw new IllegalArgumentException();
            }
            count = romBursts.length - (index = romIndex[index]);
            count = count > 32 ? 16 : count / 2;
            this.m_Bursts = new int[count][2];
            for (int i = 0; i < count; ++i) {
                this.m_Bursts[i][0] = 2 * romBursts[index + 2 * i];
                this.m_Bursts[i][1] = 2 * romBursts[index + 2 * i + 1];
            }
        } else {
            count = burstNum & 0x1F;
            if (count == 0 || count > 15 || 4 * count + 3 > ai[2]) {
                throw new IllegalArgumentException("Invalid format for learned signal: bursts extend beyond data");
            }
            this.m_Bursts = new int[count][2];
            for (int i = 0; i < count; ++i) {
                this.m_Bursts[i][0] = 2 * ((ai[6 + 4 * i] << 8) + ai[7 + 4 * i]);
                this.m_Bursts[i][1] = 2 * ((ai[8 + 4 * i] << 8) + ai[9 + 4 * i]);
            }
        }
        return count;
    }

    public int getFrequency() {
        return this.iFreq;
    }

    public int getNoIntroBursts() {
        return this.iSngl_count;
    }

    public int getNoRepeatBursts() {
        return this.iRpt_count;
    }

    public int getNoEndingBursts() {
        return this.iExtra_count;
    }

    public int[] getSignal() {
        int[] signal = new int[this.signal_out.size()];
        for (int i = 0; i < signal.length; ++i) {
            signal[i] = this.signal_out.get(i);
        }
        return signal;
    }

    public int[][] getBursts() {
        return this.m_Bursts;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("{ frequency = ");
        str.append(this.iFreq);
        str.append(", [");
        for (int i = 0; i < this.signal_out.size(); ++i) {
            str.append(this.signal_out.get(i)).append(" ");
        }
        str.append("]}");
        return str.toString();
    }

    public static void main(String[] args) {
        int[] data = new int[args.length];
        for (int i = 0; i < args.length; ++i) {
            data[i] = Integer.parseInt(args[i], 16);
        }
        System.out.println(new UeiLearnedImporter(data));
    }
}

