/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CRC16;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

class BufferedFile {
    private RandomAccessFile file;
    private byte[] buf;
    private long pos;
    private long flen;
    private boolean dirty;

    public BufferedFile() {
        this(new byte[0]);
    }

    public BufferedFile(byte[] byArray) {
        this.buf = byArray;
        this.flen = byArray.length;
        this.dirty = false;
        this.seek(0L);
    }

    public BufferedFile(String string, String string2) throws IOException {
        this.file = new RandomAccessFile(string, string2);
        this.buf = new byte[(int)this.file.length()];
        this.file.seek(0L);
        this.file.readFully(this.buf);
        if (string2.equalsIgnoreCase("r")) {
            this.file.close();
        }
        this.flen = this.buf.length;
        this.dirty = false;
        this.seek(0L);
    }

    public void setLength(int n) throws IOException {
        if (this.file != null) {
            this.file.setLength(n);
        }
        this.flen = n;
    }

    public void readFully(byte[] byArray) throws EOFException {
        if (this.pos + (long)byArray.length > this.flen) {
            throw new EOFException();
        }
        System.arraycopy(this.buf, (int)this.pos, byArray, 0, byArray.length);
        this.pos += (long)byArray.length;
    }

    public int getByte() {
        return this.read();
    }

    public int skipBytes(int n) {
        this.pos += (long)n;
        return n;
    }

    public long getFilePointer() {
        return this.pos;
    }

    public void seek(long l) {
        this.pos = l;
    }

    public long length() {
        if (this.file == null) {
            return this.flen;
        }
        try {
            return Math.max(this.file.length(), this.flen);
        }
        catch (Exception exception) {
            return this.flen;
        }
    }

    public int getShort() {
        short s = (short)((this.buf[(int)this.pos++] & 0xFF) << 8 | (this.buf[(int)this.pos++] & 0xFF) << 0);
        return s;
    }

    public int getInt() {
        return (this.buf[(int)this.pos++] & 0xFF) << 24 | (this.buf[(int)this.pos++] & 0xFF) << 16 | (this.buf[(int)this.pos++] & 0xFF) << 8 | (this.buf[(int)this.pos++] & 0xFF) << 0;
    }

    public int read() {
        return this.buf[(int)this.pos++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) {
        System.arraycopy(this.buf, (int)this.pos, byArray, n, n2);
        this.seek(this.pos + (long)n2);
        return n2;
    }

    public void putByte(int n) {
        this.write(n);
    }

    public void putShort(int n) {
        this.write(n >> 8);
        this.write(n >> 0);
    }

    public void putInt(int n) {
        this.write(n >> 24);
        this.write(n >> 16);
        this.write(n >> 8);
        this.write(n >> 0);
    }

    public void write(int n) {
        this.dirty = true;
        this.checkWritePos(this.pos, 1);
        this.buf[(int)this.pos] = (byte)(n & 0xFF);
        this.seek(this.pos + 1L);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) {
        this.dirty = true;
        this.checkWritePos(this.pos, n2);
        System.arraycopy(byArray, n, this.buf, (int)this.pos, n2);
        this.seek(this.pos + (long)n2);
    }

    private void checkWritePos(long l, int n) {
        if (l + (long)n > (long)this.buf.length) {
            byte[] byArray = new byte[(int)(l + (long)n + 16384L)];
            System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
            this.buf = byArray;
        }
        this.flen = Math.max(this.flen, l + (long)n);
    }

    public int getCRC(int n) {
        CRC16 cRC16 = new CRC16();
        for (int i = 0; i < n; ++i) {
            cRC16.update(this.buf[i]);
        }
        return cRC16.getValue();
    }

    public void close() {
        if (this.dirty && this.file != null) {
            try {
                this.file.seek(0L);
                this.file.write(this.buf, 0, (int)this.flen);
                this.file.close();
                this.dirty = false;
                this.file = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[(int)this.flen];
        System.arraycopy(this.buf, 0, byArray, 0, byArray.length);
        return byArray;
    }
}

