/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.ActionAliasButton;
import com.neuron.app.tonto.CCFAction;
import com.neuron.app.tonto.CCFActionList;
import com.neuron.app.tonto.CCFButton;
import com.neuron.app.tonto.CCFColor;
import com.neuron.app.tonto.CCFDevice;
import com.neuron.app.tonto.CCFException;
import com.neuron.app.tonto.CCFFrame;
import com.neuron.app.tonto.CCFHeader;
import com.neuron.app.tonto.CCFIRCode;
import com.neuron.app.tonto.CCFIcon;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFNodeState;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.CCFWalker;
import com.neuron.app.tonto.Comm;
import com.neuron.app.tonto.Debug;
import com.neuron.app.tonto.ICCFProvider;
import com.neuron.app.tonto.ITaskStatus;
import com.neuron.app.tonto.IWalker;
import com.neuron.app.tonto.ProntoModel;
import com.neuron.app.tonto.ScopeTask;
import com.neuron.app.tonto.Util;
import java.awt.Dimension;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CCF
implements ICCFProvider {
    static Debug debug = Debug.getInstance("ccf");
    private CCFNodeState state;
    private CCFHeader header;
    private ITaskStatus status;
    private ProntoModel conforms;
    private boolean useRemoteCapability;

    public CCF() {
        this((ProntoModel)null);
    }

    @Override
    public CCF ccf() {
        return this;
    }

    public CCF(ProntoModel prontoModel) {
        this(new CCFHeader());
        this.conformTo(prontoModel);
    }

    CCF(CCFHeader cCFHeader) {
        if (cCFHeader == null) {
            throw new IllegalArgumentException("header cannot be null");
        }
        this.header = cCFHeader;
        this.useRemoteCapability = true;
        this.checkPanels();
    }

    CCFHeader header() {
        return this.header;
    }

    public boolean usesUDB() {
        return this.header.hasUDB();
    }

    public boolean isColor() {
        return this.header.hasColor();
    }

    public boolean usesRemoteCapability() {
        return this.useRemoteCapability;
    }

    public void setUseRemoteCapability(boolean bl) {
        this.useRemoteCapability = bl;
    }

    public CCFNodeState getLastNodeState() {
        return this.state;
    }

    public CCFIRCode createIRCode(String string) {
        return new CCFIRCode(this.header, this.usesUDB() ? "0000 0000 0000 " + string : string);
    }

    public void setScreenSize(int n, int n2) {
        this.header.setScreenSize(n, n2);
    }

    public Dimension getScreenSize() {
        return this.getScreenSize(this.getConformsMatch()[0].getScreenSize());
    }

    public Dimension getScreenSize(Dimension dimension) {
        return this.header.getScreenSize(dimension);
    }

    public CCFColor getTransparentColor() {
        return this.header.getTransparentColor();
    }

    public void setTransparentColor(CCFColor cCFColor) {
        this.header.setTransparentColor(cCFColor);
    }

    public boolean isTransparentColor(CCFColor cCFColor) {
        return this.header.isTransparentColor(cCFColor);
    }

    public Dimension getScreenSize(ProntoModel prontoModel) {
        ProntoModel prontoModel2 = this.getConformsTo(prontoModel);
        if (prontoModel2.isCustom()) {
            return this.getScreenSize(prontoModel2.getScreenSize());
        }
        return prontoModel2.getScreenSize();
    }

    public void conformTo(ProntoModel prontoModel) {
        this.conforms = prontoModel;
        if (prontoModel != null) {
            this.conformTo(prontoModel.getCapability());
            this.checkPanels();
        }
    }

    private void checkPanels() {
        if (this.header.isMarantz()) {
            if (this.getDeviceByName("SCROLL UP") == null) {
                this.appendHomeDevice(this.createDevice("SCROLL UP"));
            }
            if (this.getDeviceByName("SCROLL DOWN") == null) {
                this.appendHomeDevice(this.createDevice("SCROLL DOWN"));
            }
        } else if (this.header.isCustom()) {
            Dimension dimension;
            CCFPanel cCFPanel = this.header.macroPanel;
            cCFPanel.setName("masterTemplate");
            if (cCFPanel.next == null) {
                cCFPanel.next = new CCFPanel("deviceTemplate", this.header);
            }
            if (cCFPanel.next.next == null) {
                cCFPanel.next.next = new CCFPanel("macroTemplate", this.header);
            }
            if (this.getScreenSize(dimension = new Dimension(240, 320)) == dimension) {
                this.setScreenSize(dimension.width, dimension.height);
            }
        }
    }

    public ProntoModel getConformsTo(ProntoModel prontoModel) {
        if (this.conforms != null) {
            return this.conforms;
        }
        ProntoModel[] prontoModelArray = ProntoModel.getModelByCapability(this.header.capability);
        if (prontoModelArray.length > 0) {
            for (int i = 0; i < prontoModelArray.length; ++i) {
                if (prontoModelArray[i] != prontoModel) continue;
                this.conforms = prontoModelArray[i];
                return this.conforms;
            }
            this.conforms = prontoModelArray[0];
            return this.conforms;
        }
        return prontoModel;
    }

    public ProntoModel getModel() {
        return this.getConformsMatch()[0];
    }

    public ProntoModel[] getConformsMatch() {
        ProntoModel[] prontoModelArray = ProntoModel.getModelByCapability(this.header.capability);
        if (prontoModelArray.length > 0) {
            return prontoModelArray;
        }
        return new ProntoModel[]{ProntoModel.getModel(1)};
    }

    void conformTo(int n) {
        this.header.setCapability(n);
        this.resolveVersion();
    }

    public void load(String string) throws IOException {
        this.state = new CCFNodeState(this.header, this.status);
        this.state.decodeFromFile(string);
        this.checkPanels();
    }

    public void decode(byte[] byArray) {
        this.decode(byArray, this.status);
    }

    private void decode(byte[] byArray, ITaskStatus iTaskStatus) {
        this.state = new CCFNodeState(this.header, iTaskStatus);
        this.state.decodeFromBytes(byArray);
        this.checkPanels();
    }

    public void loadFromPronto() throws Exception {
        this.decode(this.loadBytesFromPronto());
    }

    public byte[] loadBytesFromPronto() throws Exception {
        return this.getComm().getCCF(this.status);
    }

    public void save(String string) throws IOException {
        this.state = new CCFNodeState(this.header, this.status);
        this.state.encodeToFile(string);
    }

    public byte[] encode() throws IOException {
        this.state = new CCFNodeState(this.header, this.status);
        return this.state.encodeToBytes();
    }

    public void saveToPronto() throws Exception {
        Comm comm = Comm.scanForPronto(this.status);
        if (comm != null) {
            throw new IOException("Unable to locate Pronto");
        }
        this.saveToPronto(comm);
    }

    public void saveToPronto(Comm comm) throws Exception {
        this.status(0, "Check Pronto Capability");
        if (this.usesRemoteCapability()) {
            debug.log(2, "using remote's capability");
            int n = comm.getPossible();
            if (n != this.header.capability && !Util.confirmDialog("Remote type mismatch", "This CCF and the remote's capabilities do not match.\nProceed with download anyway?")) {
                return;
            }
            this.header.setCapability(n);
        }
        this.status(5, "Update CCF For Pronto");
        this.resolveVersion();
        this.status(10, "Saving to Pronto");
        ITaskStatus iTaskStatus = this.status;
        this.status = new ScopeTask(this.status, 10, 15);
        byte[] byArray = this.encode();
        if (byArray.length > this.conforms.getMemory()) {
            throw new CCFException("Download aborted. CCF Size exceeds Remote's memory");
        }
        this.status = iTaskStatus;
        comm.setCCF(byArray, new ScopeTask(this.status, 15, 100));
    }

    private void status(int n, String string) {
        if (this.status != null) {
            this.status.taskStatus(n, string);
        }
    }

    public CCFDevice getFirstHomeDevice() {
        return this.header.firstHome;
    }

    public void setFirstHomeDevice(CCFDevice cCFDevice) {
        this.header.firstHome = cCFDevice;
        if (cCFDevice != null) {
            cCFDevice.buildTree(this.header);
        }
    }

    public CCFDevice getFirstDevice() {
        return this.header.firstDevice;
    }

    public CCFDevice getDeviceByName(String string) {
        CCFDevice cCFDevice = null;
        cCFDevice = this.searchListForName(this.header.firstHome, string);
        if (cCFDevice != null) {
            return cCFDevice;
        }
        cCFDevice = this.searchListForName(this.header.firstDevice, string);
        if (cCFDevice != null) {
            return cCFDevice;
        }
        cCFDevice = this.searchListForName(this.header.firstMacro, string);
        if (cCFDevice != null) {
            return cCFDevice;
        }
        return cCFDevice;
    }

    private CCFDevice searchListForName(CCFDevice cCFDevice, String string) {
        while (cCFDevice != null) {
            if (cCFDevice.name != null && cCFDevice.name.equals(string)) {
                return cCFDevice;
            }
            cCFDevice = cCFDevice.getNextDevice();
        }
        return null;
    }

    public CCFDevice createDevice() {
        return this.header.createDevice();
    }

    public CCFDevice createDevice(String string) {
        CCFDevice cCFDevice = this.header.createDevice();
        cCFDevice.setName(string);
        return cCFDevice;
    }

    public void setFirstDevice(CCFDevice cCFDevice) {
        this.header.firstDevice = cCFDevice;
        if (cCFDevice != null) {
            cCFDevice.buildTree(this.header);
        }
    }

    public CCFDevice getFirstMacroDevice() {
        return this.header.firstMacro;
    }

    public void setFirstMacroDevice(CCFDevice cCFDevice) {
        this.header.firstMacro = cCFDevice;
        if (cCFDevice != null) {
            cCFDevice.buildTree(this.header);
        }
    }

    public CCFPanel getMacroPanel() {
        return this.header.macroPanel;
    }

    public CCFPanel getMasterTemplate() {
        return this.header.masterTemplate();
    }

    public CCFPanel getDeviceTemplate() {
        return this.header.deviceTemplate();
    }

    public CCFPanel getMacroTemplate() {
        return this.header.macroTemplate();
    }

    public void appendHomeDevice(CCFDevice cCFDevice) {
        if (cCFDevice == null) {
            return;
        }
        CCFDevice cCFDevice2 = this.findByName(this.header.firstHome, cCFDevice.getName());
        if (cCFDevice2 != null) {
            for (CCFPanel cCFPanel = cCFDevice.getFirstPanel(); cCFPanel != null; cCFPanel = cCFPanel.getNextPanel()) {
                cCFDevice2.addPanel((CCFPanel)cCFPanel.getClone());
            }
        } else if (!this.append(this.header.firstHome, cCFDevice)) {
            this.header.firstHome = cCFDevice;
        }
    }

    public void appendDevice(CCFDevice cCFDevice) {
        if (!this.append(this.header.firstDevice, cCFDevice)) {
            this.header.firstDevice = cCFDevice;
        }
    }

    public void appendMacroDevice(CCFDevice cCFDevice) {
        if (!this.append(this.header.firstMacro, cCFDevice)) {
            this.header.firstMacro = cCFDevice;
        }
    }

    public void setNotify(ITaskStatus iTaskStatus) {
        this.status = iTaskStatus;
    }

    public void merge(CCF cCF) {
        CCFDevice cCFDevice;
        CCFPanel cCFPanel = this.header.getEggDVD();
        if (cCFPanel != null && cCF.header.getEggDVD() != null) {
            this.mergeEggStreams(cCF, cCFPanel);
        }
        this.appendHomeDevice(cCFDevice);
        for (cCFDevice = cCF.getFirstHomeDevice(); cCFDevice != null; cCFDevice = cCFDevice.getNextDevice()) {
            cCFDevice.setParent(this.header);
        }
        this.appendDevice(cCFDevice);
        for (cCFDevice = cCF.getFirstDevice(); cCFDevice != null; cCFDevice = cCFDevice.getNextDevice()) {
            cCFDevice.setParent(this.header);
        }
        this.appendMacroDevice(cCFDevice);
        for (cCFDevice = cCF.getFirstMacroDevice(); cCFDevice != null; cCFDevice = cCFDevice.getNextDevice()) {
            cCFDevice.setParent(this.header);
        }
        this.resolveVersion();
    }

    private void mergeEggStreams(CCF cCF, CCFPanel cCFPanel) {
        CCF cCF2 = cCF;
        CCFPanel cCFPanel2 = cCFPanel;
        final CCFPanel cCFPanel3 = cCF.header.getEggDVD();
        final CCFButton[] cCFButtonArray = cCFPanel.getButtons();
        new CCFWalker(cCF2).walk(new IWalker(){

            @Override
            public void onNode(CCFNode cCFNode) {
                if (cCFNode instanceof CCFActionList) {
                    boolean bl = false;
                    CCFAction[] cCFActionArray = ((CCFActionList)cCFNode).getActions();
                    block0: for (int i = 0; cCFActionArray != null && i < cCFActionArray.length; ++i) {
                        ActionAliasButton actionAliasButton;
                        CCFButton cCFButton;
                        CCFPanel cCFPanel;
                        if (!(cCFActionArray[i] instanceof ActionAliasButton) || (cCFPanel = (cCFButton = (actionAliasButton = (ActionAliasButton)cCFActionArray[i]).getButton()).getParentPanel()) != cCFPanel3) continue;
                        for (int j = 0; j < cCFButtonArray.length; ++j) {
                            if (!CCF.this.stringEquals(cCFButtonArray[j].name, cCFButton.name)) continue;
                            actionAliasButton.setButton(cCFButtonArray[j]);
                            bl = true;
                            continue block0;
                        }
                    }
                    if (bl) {
                        ((CCFActionList)cCFNode).setActions(cCFActionArray);
                    }
                }
            }
        });
        cCFPanel3.delete();
    }

    private void resolveVersion() {
        final boolean bl = this.header().hasUDB();
        final boolean bl2 = this.header().hasColor();
        boolean bl3 = this.header().isNewMarantz();
        CCFColor[] cCFColorArray = this.header().getColorMap();
        int[] nArray = new int[]{cCFColorArray[0].getColorIndex(), cCFColorArray[1].getColorIndex(), cCFColorArray[2].getColorIndex(), cCFColorArray[3].getColorIndex()};
        new CCFWalker(this).walk(new IWalker(){

            @Override
            public void onNode(CCFNode cCFNode) {
                if (cCFNode != null) {
                    cCFNode.setHeader(CCF.this.header);
                }
                if (cCFNode instanceof CCFIcon) {
                    if (bl2) {
                        ((CCFIcon)cCFNode).convertToColor();
                    } else {
                        ((CCFIcon)cCFNode).convertToGray();
                    }
                } else if (cCFNode instanceof CCFButton) {
                    CCFButton cCFButton = (CCFButton)cCFNode;
                    if (bl2) {
                        cCFButton.convertToColor();
                    } else {
                        cCFButton.convertToGray();
                    }
                } else if (cCFNode instanceof CCFFrame) {
                    CCFFrame cCFFrame = (CCFFrame)cCFNode;
                    if (bl2) {
                        cCFFrame.convertToColor();
                    } else {
                        cCFFrame.convertToGray();
                    }
                } else if (cCFNode instanceof CCFIRCode) {
                    ((CCFIRCode)cCFNode).setUDB(bl);
                }
            }
        });
    }

    public String getVersionString() {
        return this.header.version;
    }

    public void setVersionString(String string) {
        this.header.version = string;
    }

    public Date getModifiedDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.header.year);
        calendar.set(2, this.header.month - 1);
        calendar.set(5, this.header.day);
        calendar.set(10, this.header.hour);
        calendar.set(12, this.header.minute);
        calendar.set(13, this.header.seconds);
        return calendar.getTime();
    }

    public void setModifiedDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.header.year = calendar.get(1);
        this.header.month = calendar.get(2) + 1;
        this.header.day = calendar.get(5);
        this.header.hour = calendar.get(10);
        this.header.minute = calendar.get(12);
        this.header.seconds = calendar.get(13);
    }

    public void setModified() {
        this.setModifiedDate(new Date());
    }

    public boolean isFactoryCCF() {
        return this.header.isFactoryCCF();
    }

    public boolean isConfigReadOnly() {
        return this.header.isConfigReadOnly();
    }

    public boolean isHomeReadOnly() {
        return this.header.isHomeReadOnly();
    }

    public void setFactoryCCF(boolean bl) {
        this.header.setFactoryCCF(bl);
    }

    public void setConfigReadOnly(boolean bl) {
        this.header.setConfigReadOnly(bl);
    }

    public void setHomeReadOnly(boolean bl) {
        this.header.setHomeReadOnly(bl);
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return "CCF(" + this.header.version + ", mod=" + simpleDateFormat.format(this.getModifiedDate()) + ", hro=" + this.isHomeReadOnly() + ", cro=" + this.isConfigReadOnly() + ", cap=" + this.header.capability + ", ap=" + this.header.attrPos + ")";
    }

    void loadFromPronto(Comm comm) throws Exception {
        byte[] byArray = comm.getCCF(new ScopeTask(this.status, 0, 90));
        this.decode(byArray, new ScopeTask(this.status, 90, 100));
    }

    private Comm getComm() throws Exception {
        Comm comm = Comm.scanForPronto(null);
        if (comm == null) {
            throw new IOException("Unable to locate Pronto");
        }
        return comm;
    }

    private boolean append(CCFDevice cCFDevice, CCFDevice cCFDevice2) {
        if (cCFDevice == null) {
            return false;
        }
        if (cCFDevice2 == null) {
            return true;
        }
        while (cCFDevice.next != null) {
            cCFDevice = cCFDevice.getNextDevice();
        }
        cCFDevice.setNextDevice(cCFDevice2);
        cCFDevice2.setParent(this.header);
        return true;
    }

    private CCFDevice findByName(CCFDevice cCFDevice, String string) {
        while (cCFDevice != null) {
            String string2 = cCFDevice.getName();
            if (string2 == string || string != null && string2 != null && string2.equals(string)) {
                return cCFDevice;
            }
            cCFDevice = cCFDevice.getNextDevice();
        }
        return null;
    }

    private boolean stringEquals(String string, String string2) {
        return string != null && string2 != null && (string == string2 || string.equals(string2));
    }
}

