/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.ActionAliasButton;
import com.neuron.app.tonto.ActionAliasDevice;
import com.neuron.app.tonto.ActionAliasKey;
import com.neuron.app.tonto.ActionBeep;
import com.neuron.app.tonto.ActionDelay;
import com.neuron.app.tonto.ActionIRCode;
import com.neuron.app.tonto.ActionJumpPanel;
import com.neuron.app.tonto.ActionSpecial;
import com.neuron.app.tonto.ActionTimer;
import com.neuron.app.tonto.CCFButton;
import com.neuron.app.tonto.CCFDevice;
import com.neuron.app.tonto.CCFHeader;
import com.neuron.app.tonto.CCFIRCode;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFNodeState;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.CCFTimer;
import java.util.Hashtable;

public class CCFAction
extends CCFNode {
    private static final String[][] codec = new String[][]{{"N1", "type"}, {"N4", "p1"}, {"N4", "p2"}};
    public static final int ACT_DUMMY = 0;
    public static final int ACT_IRCODE = 1;
    public static final int ACT_ALIAS_BUTTON = 2;
    public static final int ACT_JUMP_PANEL = 3;
    public static final int ACT_DELAY = 4;
    public static final int ACT_ALIAS_KEY = 5;
    public static final int ACT_ALIAS_DEV = 6;
    public static final int ACT_TIMER = 7;
    public static final int ACT_BEEP = 8;
    public static final int ACT_MARANTZ_JUMP = 9;
    public static final int JUMP_FORWARD = -1145324613;
    public static final int JUMP_BACK = -858993460;
    public static final int JUMP_SCROLL_DOWN = -572662307;
    public static final int JUMP_SCROLL_UP = -286331154;
    public static final int JUMP_MOUSE_MODE = -1;
    public static final String[] jumpSpecial = new String[]{"Forward", "Back", "Scroll Down", "Scroll Up", "Mouse Mode"};
    public static final int[] jumpSpecialID = new int[]{-1145324613, -858993460, -572662307, -286331154, -1};
    public static final int KEY_LEFT = 0;
    public static final int KEY_RIGHT = 1;
    public static final int KEY_VOLDOWN = 2;
    public static final int KEY_VOLUP = 3;
    public static final int KEY_CHANDOWN = 4;
    public static final int KEY_CHANUP = 5;
    public static final int KEY_MUTE = 6;
    public static final String[] ProntoKeys = new String[]{"Left", "Right", "Vol-", "Vol+", "CH-", "CH+", "Mute"};
    public static final String[] ProntoProKeys = new String[]{"Left", "Right", "Vol-", "Vol+", "CH-", "CH+", "Mute", "Far Left", "Far Right"};
    public static final String[] MarantzKeys = new String[]{"Left", "Right", "Mute", "CH-", "CH+", "Vol-", "Vol+", "Menu", "End", "Exit", "Up Arrow", "Left Arrow", "Right Arrow", "Down Arrow", "Home", "Light", "Back", "Ahead"};
    public static final String[] CustomKeys = new String[]{"Left", "Right", "Vol-", "Vol+", "CH-", "CH+", "Mute", "Far Left", "Far Right", "Enter", "ArrowUp", "ArrowLeft", "ArrowRight", "ArrowDown"};
    int type = 0;
    int p1 = 0;
    int p2 = 5;
    CCFNode action1;
    CCFNode action2;
    private boolean valid;

    CCFAction() {
        this.setValid(true);
    }

    CCFAction(int n, int n2, int n3) {
        this();
        this.type = n;
        this.p1 = n2;
        this.p2 = n3;
        this.setFixedPosition(true);
    }

    CCFAction(int n, CCFNode cCFNode, CCFNode cCFNode2) {
        this();
        this.type = n;
        this.action1 = cCFNode;
        this.action2 = cCFNode2;
        this.setFixedPosition(true);
    }

    public int getActionType() {
        return this.type;
    }

    boolean match(CCFNode cCFNode) {
        return this.action1 == cCFNode || this.action2 == cCFNode;
    }

    boolean willEncode(CCFNodeState cCFNodeState) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                if (this.action1 != null && this.action1.getParent() == null) {
                    debug.log(0, "a1(" + this.action1.getClass() + ") has no parent");
                    return false;
                }
                if (this.action2 == null || this.action2.getParent() != null) break;
                debug.log(0, "a2(" + this.action2.getClass() + ") has no parent");
                return false;
            }
        }
        return this.valid && cCFNodeState.willEncode(this.action1) && cCFNodeState.willEncode(this.action2);
    }

    @Override
    CCFNode getClone() {
        CCFAction cCFAction = (CCFAction)super.getClone();
        if ((this.type == 1 || this.type == 7) && this.action2 != null) {
            cCFAction.action2 = this.action2.getClone();
        }
        cCFAction.buildTree(this.getParent());
        return cCFAction;
    }

    void copy(CCFAction cCFAction) {
        this.setParent(cCFAction.getParent());
        this.type = cCFAction.type;
        this.p1 = cCFAction.p1;
        this.p2 = cCFAction.p2;
        this.action1 = cCFAction.action1;
        this.action2 = cCFAction.action2;
        this.valid = cCFAction.valid;
    }

    CCFAction decodeReplace() {
        switch (this.type) {
            case 1: {
                return new ActionIRCode(this);
            }
            case 2: {
                return new ActionAliasButton(this);
            }
            case 4: {
                return new ActionDelay(this);
            }
            case 5: {
                return new ActionAliasKey(this);
            }
            case 6: {
                return new ActionAliasDevice(this);
            }
            case 7: {
                return new ActionTimer(this);
            }
            case 8: {
                return new ActionBeep(this);
            }
            case 3: 
            case 9: {
                if (this.isSpecialJump()) {
                    return new ActionSpecial(this);
                }
                return new ActionJumpPanel(this);
            }
        }
        debug.log(0, "unknown action (" + this.type + "," + CCFAction.hex(this.p1) + "," + CCFAction.hex(this.p2) + ")");
        return this;
    }

    @Override
    void encodePrep(CCFNodeState cCFNodeState, Hashtable hashtable) {
        if (this.action2 != null && !(this.action2 instanceof CCFPanel) && !(this.action2 instanceof CCFButton)) {
            cCFNodeState.addField(this.action2, hashtable);
        }
    }

    @Override
    void checkVersion() {
    }

    @Override
    void preEncode(CCFNodeState cCFNodeState) {
        if (this.action1 != null) {
            this.p1 = this.action1.getFilePosition();
        }
        if (this.action2 != null) {
            this.p2 = this.action2.getFilePosition();
        }
        this.fixDevicePointer();
    }

    @Override
    void preDecode(CCFNodeState cCFNodeState) {
        this.action1 = null;
        this.action2 = null;
        this.setValid(true);
    }

    @Override
    void postDecode(CCFNodeState cCFNodeState) {
        switch (this.type) {
            case 0: {
                break;
            }
            case 4: 
            case 8: {
                this.p1 = 0;
                break;
            }
            case 1: {
                this.p1 = 0;
                this.action2 = this.getItemByPos(cCFNodeState, this.p2, CCFIRCode.class);
                this.setValid(this.action2 != null);
                break;
            }
            case 2: {
                this.action1 = this.getItemByPos(cCFNodeState, this.p1, CCFDevice.class);
                this.action2 = this.getItemByPos(cCFNodeState, this.p2, CCFButton.class);
                this.setValid(this.action1 != null && this.action2 != null);
                break;
            }
            case 3: 
            case 9: {
                if (this.isSpecialJump()) break;
                this.action1 = this.getItemByPos(cCFNodeState, this.p1, CCFDevice.class);
                this.action2 = this.getItemByPos(cCFNodeState, this.p2, CCFPanel.class);
                this.setValid(this.action1 != null && this.action2 != null);
                break;
            }
            case 5: {
                this.action1 = this.getItemByPos(cCFNodeState, this.p1, CCFDevice.class);
                this.setValid(this.action1 != null);
                break;
            }
            case 6: {
                this.action1 = this.getItemByPos(cCFNodeState, this.p1, CCFDevice.class);
                this.setValid(this.action1 != null);
                break;
            }
            case 7: {
                this.p1 = 0;
                this.action2 = this.getItemByPos(cCFNodeState, this.p2, CCFTimer.class);
                this.setValid(this.action2 != null);
            }
        }
    }

    private void setValid(boolean bl) {
        this.valid = bl;
    }

    @Override
    String[][] getDecodeTable() {
        return codec;
    }

    @Override
    String[][] getEncodeTable() {
        return codec;
    }

    @Override
    void buildTree(CCFNode cCFNode) {
        this.setParent(cCFNode);
        if (this.action2 instanceof CCFIRCode) {
            this.action2.buildTree(this);
        }
    }

    static String[] getKeyNames(CCFDevice cCFDevice) {
        CCFHeader cCFHeader = cCFDevice.getHeader();
        if (cCFHeader.isCustom()) {
            return CustomKeys;
        }
        if (cCFHeader.isNewMarantz()) {
            return MarantzKeys;
        }
        if (cCFHeader.hasColor()) {
            return ProntoProKeys;
        }
        return ProntoKeys;
    }

    static String getKeyName(CCFDevice cCFDevice, int n) {
        String[] stringArray = CCFAction.getKeyNames(cCFDevice);
        if (n >= stringArray.length) {
            return "<INVALID>";
        }
        return stringArray[n];
    }

    public static String getJumpSpecialString(int n) {
        return jumpSpecial[(n >> 24 & 0xF) - 11];
    }

    public static int getJumpSpecialIDFromString(String string) {
        for (int i = 0; i < jumpSpecial.length; ++i) {
            if (!jumpSpecial[i].equals(string)) continue;
            return jumpSpecialID[i];
        }
        return 0;
    }

    public boolean isJump() {
        return this.type == 3 || this.type == 9;
    }

    public boolean isSpecialJump() {
        return (this.p2 >> 24 & 0xF) - 11 >= 0;
    }

    @Override
    public String toString() {
        this.fixDevicePointer();
        CCFDevice cCFDevice = (CCFDevice)this.action1;
        switch (this.type) {
            case 1: {
                return "[IR] " + ((CCFIRCode)this.action2).getName();
            }
            case 2: {
                CCFButton cCFButton = (CCFButton)this.action2;
                return "[Button] " + cCFDevice + " : " + cCFButton.getParentPanel() + " : " + (cCFButton.name != null ? cCFButton.name : "");
            }
            case 3: 
            case 9: {
                int n = (this.p2 >> 24 & 0xF) - 11;
                CCFPanel cCFPanel = (CCFPanel)this.action2;
                return (this.type == 9 ? "[Jump] " : "[Jump] ") + (n >= 0 ? jumpSpecial[n] : (cCFDevice != null ? cCFDevice.name : "()") + " : " + (cCFPanel != null ? cCFPanel.name : "()"));
            }
            case 4: {
                return "[Delay] " + this.p2 + "ms";
            }
            case 5: {
                String string = CCFAction.getKeyName(cCFDevice, this.p2);
                return "[Key] " + cCFDevice.name + (string != null ? " : " + CCFAction.getKeyName(cCFDevice, this.p2) : "");
            }
            case 6: {
                if (cCFDevice == null) {
                    return "<undefined>";
                }
                return "[Device] " + cCFDevice.name;
            }
            case 7: {
                return "[Timer] " + ((CCFTimer)this.action2).describe();
            }
            case 8: {
                return "[Beep] " + ActionBeep.getDutyCycle(this.p2) + "% " + ActionBeep.getDuration(this.p2) + "ms " + ActionBeep.getFrequency(this.p2) + "hz";
            }
        }
        return "<undefined>";
    }

    void fixDevicePointer() {
        if (this.type == 3 && this.isSpecialJump()) {
            return;
        }
        switch (this.type) {
            case 2: 
            case 3: {
                CCFDevice cCFDevice = (CCFDevice)this.action1;
                CCFNode cCFNode = this.action2;
                if (cCFNode == null) {
                    debug.log(0, "action node is null (" + this.type + ":" + this.action1 + ":" + this.p1 + ")");
                    this.traceParents();
                    return;
                }
                CCFDevice cCFDevice2 = cCFNode.getParentDevice();
                if (cCFDevice2 == cCFDevice) break;
                if (cCFDevice2 == null) {
                    debug.log(0, "parent device is null (" + this.type + ":" + this.action1 + ":" + this.action2 + ")");
                    this.traceParents();
                    return;
                }
                debug.log(1, "relinking device pointer (" + this.action1 + ":" + this.action2 + ")");
                this.action1 = cCFDevice2;
                this.p1 = cCFDevice2.getFilePosition();
            }
        }
    }
}

