/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CCFAction;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFNodeState;
import java.util.Vector;

public class CCFActionList
extends CCFNode {
    int count1;
    int count2;
    CCFAction[] action;
    private static final String[][] codec = new String[][]{{"N1", "count1"}, {"N1", "count2"}, {"Z+", "action", "count1"}};

    public CCFActionList() {
    }

    CCFActionList(CCFNode cCFNode) {
        this.setParent(cCFNode);
    }

    @Override
    public String toString() {
        return "CCFActionList[" + this.count1 + "]";
    }

    public int size() {
        return this.count1;
    }

    @Override
    public CCFNode getClone() {
        CCFActionList cCFActionList = (CCFActionList)super.getClone();
        cCFActionList.action = this.getClone(cCFActionList.action);
        cCFActionList.buildTree(this.getParent());
        return cCFActionList;
    }

    private CCFAction[] getClone(CCFAction[] cCFActionArray) {
        if (cCFActionArray == null) {
            return null;
        }
        CCFAction[] cCFActionArray2 = new CCFAction[cCFActionArray.length];
        for (int i = 0; i < cCFActionArray.length; ++i) {
            cCFActionArray2[i] = (CCFAction)cCFActionArray[i].getClone();
        }
        return cCFActionArray2;
    }

    boolean deleteMatching(CCFNode cCFNode) {
        boolean bl = false;
        for (int i = 0; i < this.count1; ++i) {
            if (!this.action[i].match(cCFNode)) continue;
            this.action[i] = null;
            bl = true;
        }
        if (bl) {
            this.cullEmpty();
        }
        return bl;
    }

    void cullEmpty() {
        this.log(2, "culling empty for " + this);
        Vector<CCFAction> vector = new Vector<CCFAction>();
        for (int i = 0; i < this.count1; ++i) {
            if (this.action[i] == null) continue;
            vector.add(this.action[i]);
        }
        CCFAction[] cCFActionArray = new CCFAction[vector.size()];
        this.setActions(vector.toArray(cCFActionArray));
    }

    void checkCullEmpty(CCFNodeState cCFNodeState) {
        if (this.action == null) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < this.count1; ++i) {
            if (this.action[i].willEncode(cCFNodeState)) continue;
            debug.log(2, "culling " + this.action[i] + " from " + this);
            this.action[i] = null;
            bl = true;
        }
        if (bl) {
            this.cullEmpty();
        }
    }

    public CCFAction[] getActions() {
        CCFAction[] cCFActionArray = new CCFAction[this.count1];
        for (int i = 0; i < this.count1; ++i) {
            cCFActionArray[i] = this.action[i].decodeReplace();
        }
        return cCFActionArray;
    }

    public void setActions(CCFAction[] cCFActionArray) {
        this.action = cCFActionArray;
        this.count1 = cCFActionArray.length;
        this.count2 = cCFActionArray.length;
    }

    public void appendAction(CCFAction cCFAction) {
        if (this.action == null) {
            this.action = new CCFAction[0];
        }
        CCFAction[] cCFActionArray = new CCFAction[this.action.length + 1];
        System.arraycopy(this.action, 0, cCFActionArray, 0, this.action.length);
        cCFActionArray[cCFActionArray.length - 1] = cCFAction;
        this.setActions(cCFActionArray);
    }

    @Override
    void checkVersion() {
    }

    @Override
    void preEncode(CCFNodeState cCFNodeState) {
        this.checkCullEmpty(cCFNodeState);
        if (cCFNodeState.getHeader().isNewMarantz() && this.count1 > 0) {
            int n = 3;
            for (int i = this.action.length - 1; i >= 0; --i) {
                if (this.action[i].isJump()) {
                    this.action[i].type = n;
                }
                n = 9;
            }
        }
    }

    @Override
    void preDecode(CCFNodeState cCFNodeState) {
    }

    @Override
    void postDecode(CCFNodeState cCFNodeState) {
        if (this.action == null) {
            throw new NullPointerException("Action list is null");
        }
        if (this.count1 != this.count2) {
            int n = Math.min(Math.min(this.count1, this.count2), 10);
            this.log(0, "count mismatch " + this.count1 + " != " + this.count2 + ". using " + n, cCFNodeState);
            this.count1 = n;
            this.count2 = n;
        }
    }

    @Override
    String[][] getEncodeTable() {
        return codec;
    }

    @Override
    String[][] getDecodeTable() {
        return codec;
    }

    @Override
    void buildTree(CCFNode cCFNode) {
        this.setParent(cCFNode);
        for (int i = 0; i < this.count1; ++i) {
            this.action[i].buildTree(this);
        }
    }

    @Override
    String describe() {
        return "ACTNList," + this.count1;
    }
}

