/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CCFAction;
import com.neuron.app.tonto.CCFActionList;
import com.neuron.app.tonto.CCFChild;
import com.neuron.app.tonto.CCFColor;
import com.neuron.app.tonto.CCFFont;
import com.neuron.app.tonto.CCFIcon;
import com.neuron.app.tonto.CCFIconSet;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFNodeState;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.INamed;
import java.awt.Dimension;
import java.awt.Point;

public class CCFButton
extends CCFNode
implements INamed {
    private static final String[][] nocolor = new String[][]{{"N2", "width"}, {"N2", "height"}, {"Z*", "actions"}, {"S*", "name"}, {"S*", "idtag"}, {"N1", "fontSize"}, {"N1", "_reserve_1"}, {"Z*", "iconIU"}, {"Z*", "iconIS"}, {"Z*", "iconAU"}, {"Z*", "iconAS"}, {"N1", "colorIU"}, {"N1", "colorIS"}, {"N1", "colorAU"}, {"N1", "colorAS"}};
    private static final String[][] color = new String[][]{{"N2", "width"}, {"N2", "height"}, {"Z*", "actions"}, {"S*", "name"}, {"S*", "idtag"}, {"N1", "fontSize"}, {"N1", "textOpt"}, {"Z*", "iconIU"}, {"Z*", "iconIS"}, {"Z*", "iconAU"}, {"Z*", "iconAS"}, {"N4", "colorIU"}, {"N4", "colorIS"}, {"N4", "colorAU"}, {"N4", "colorAS"}};
    private String[][] codec = nocolor;
    private boolean inColor;
    public static final int STATE_ACTIVE_UNSELECTED = 1;
    public static final int STATE_ACTIVE_SELECTED = 2;
    public static final int STATE_INACTIVE_UNSELECTED = 3;
    public static final int STATE_INACTIVE_SELECTED = 4;
    private static final int defBWColors = CCFColor.getComposite(CCFColor.getNamedColor(3, false), CCFColor.getNamedColor(1, false), false);
    private static final int defCOColors = CCFColor.getComposite(CCFColor.getNamedColor(3, true), CCFColor.getNamedColor(1, true), true);
    int width;
    int height;
    CCFActionList actions;
    String name;
    String idtag;
    int textOpt;
    int fontSize;
    int _reserve_1;
    CCFIcon iconIU;
    CCFIcon iconIS;
    CCFIcon iconAU;
    CCFIcon iconAS;
    int colorIU;
    int colorIS;
    int colorAU;
    int colorAS;

    CCFButton() {
    }

    CCFButton(CCFNode cCFNode, String string) {
        int n;
        this.setParent(new CCFChild(cCFNode, this));
        this.setName(string);
        this.width = 50;
        this.height = 25;
        this.setFont(CCFFont.SIZE_14);
        this.inColor = this.usingColor();
        this.colorIU = n = this.inColor ? defCOColors : defBWColors;
        this.colorIS = n;
        this.colorAU = n;
        this.colorAS = n;
        this.checkVersion();
    }

    @Override
    CCFNode getClone() {
        CCFButton cCFButton = (CCFButton)super.getClone();
        cCFButton.actions = this.getClone(cCFButton.actions);
        cCFButton.buildTree(this.getParent());
        return cCFButton;
    }

    @Override
    public void setParent(CCFNode cCFNode) {
        super.setParent(cCFNode);
        if (cCFNode != null && !(cCFNode instanceof CCFChild)) {
            throw new RuntimeException("parent ! CCFChild : " + cCFNode);
        }
    }

    public void copyColors(CCFButton cCFButton) {
        this.colorIU = cCFButton.colorIU;
        this.colorIS = cCFButton.colorIS;
        this.colorAU = cCFButton.colorAU;
        this.colorAS = cCFButton.colorAS;
        boolean bl = this.usingColor();
        boolean bl2 = cCFButton.usingColor();
        if (bl && !bl2) {
            this.inColor = false;
            this.convertToColor();
        } else if (!bl && bl2) {
            this.inColor = true;
            this.convertToGray();
        }
    }

    public void copyIcons(CCFButton cCFButton) {
        this.iconIU = cCFButton.iconIU;
        this.iconIS = cCFButton.iconIS;
        this.iconAU = cCFButton.iconAU;
        this.iconAS = cCFButton.iconAS;
        if (this.usingColor()) {
            this.iconIU.convertToColor();
            this.iconIS.convertToColor();
            this.iconAU.convertToColor();
            this.iconAS.convertToColor();
        } else {
            this.iconIU.convertToGray();
            this.iconIS.convertToGray();
            this.iconAU.convertToGray();
            this.iconAS.convertToGray();
        }
    }

    @Override
    public String toString() {
        return this.getFQN();
    }

    public int getTextAlignment() {
        return this.textOpt & 3;
    }

    public void setTextAlignment(int n) {
        this.textOpt = this.textOpt & 0xFC | n & 3;
    }

    public boolean getTextWrap() {
        return (this.textOpt & 0x80) == 128;
    }

    public void setTextWrap(boolean bl) {
        this.textOpt = this.textOpt & 0x7F | (bl ? 128 : 0);
    }

    public void convertToColor() {
        if (this.inColor) {
            return;
        }
        debug.log(3, "converting " + this.describe() + " to color");
        CCFColor[] cCFColorArray = this.getHeader().getColorMap();
        int[] nArray = new int[]{cCFColorArray[0].getColorIndex(), cCFColorArray[1].getColorIndex(), cCFColorArray[2].getColorIndex(), cCFColorArray[3].getColorIndex()};
        this.colorIU = CCFColor.ccfGrayToRGB(this.colorIU, nArray);
        this.colorIS = CCFColor.ccfGrayToRGB(this.colorIS, nArray);
        this.colorAU = CCFColor.ccfGrayToRGB(this.colorAU, nArray);
        this.colorAS = CCFColor.ccfGrayToRGB(this.colorAS, nArray);
        this.inColor = this.getHeader().hasColor();
    }

    public void convertToGray() {
        if (!this.inColor) {
            return;
        }
        debug.log(3, "converting " + this.describe() + " to gray");
        this.colorIU = CCFColor.ccfRGBToGray(this.colorIU);
        this.colorIS = CCFColor.ccfRGBToGray(this.colorIS);
        this.colorAU = CCFColor.ccfRGBToGray(this.colorAU);
        this.colorAS = CCFColor.ccfRGBToGray(this.colorAS);
        this.inColor = this.getHeader().hasColor();
    }

    public CCFFont getFont() {
        return CCFFont.getFont(this.fontSize);
    }

    public void setFont(CCFFont cCFFont) {
        this.fontSize = cCFFont.getFontSize();
    }

    public CCFIconSet getIconSet() {
        return new CCFIconSet(new CCFIcon[]{this.iconIU, this.iconIS, this.iconAU, this.iconAS}, new int[]{this.colorIU, this.colorIS, this.colorAU, this.colorAS}, this.codec == color);
    }

    public void setIconSet(CCFIconSet cCFIconSet) {
        this.iconIU = cCFIconSet.icons[0];
        this.iconIS = cCFIconSet.icons[1];
        this.iconAU = cCFIconSet.icons[2];
        this.iconAS = cCFIconSet.icons[3];
        this.colorIU = cCFIconSet.colors[0];
        this.colorIS = cCFIconSet.colors[1];
        this.colorAU = cCFIconSet.colors[2];
        this.colorAS = cCFIconSet.colors[3];
    }

    public Dimension getSize() {
        return new Dimension(this.width(), this.height());
    }

    public void setSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public CCFChild getChildWrapper() {
        if (this.getParent() == null) {
            System.out.println(">>>>>> parent null for " + this);
        }
        return (CCFChild)this.getParent();
    }

    public Point getLocation() {
        return this.getChildWrapper().getLocation();
    }

    public void setLocation(Point point) {
        this.getChildWrapper().setLocation(point);
    }

    public CCFAction[] getActions() {
        if (this.actions != null) {
            return this.actions.getActions();
        }
        return null;
    }

    public CCFActionList getActionList() {
        return this.actions;
    }

    public void appendAction(CCFAction cCFAction) {
        if (this.actions == null) {
            this.setActionList(new CCFActionList());
        }
        this.actions.appendAction(cCFAction);
    }

    public void setActionList(CCFActionList cCFActionList) {
        this.actions = cCFActionList;
        this.actions.setParent(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getIDTag() {
        return this.idtag;
    }

    public void setIDTag(String string) {
        this.idtag = string;
    }

    public CCFColor getBackground() {
        return CCFColor.getBackground(this.isActive() ? this.colorAU : this.colorIU, this.inColor);
    }

    public CCFColor getForeground() {
        return CCFColor.getForeground(this.isActive() ? this.colorAU : this.colorIU, this.inColor);
    }

    public boolean isActive() {
        return this.actions != null && this.actions.size() > 0;
    }

    public boolean isResizable() {
        return this.isActive() ? this.iconAU == null : this.iconIU == null;
    }

    public void delete() {
        this.getParentPanel().delete(this);
        this.setParent(null);
    }

    String getFQN() {
        CCFPanel cCFPanel = this.getParentPanel();
        return (cCFPanel != null ? cCFPanel.getFQN() : "<deleted>") + " (" + (this.name != null ? this.name : "") + ")";
    }

    int width() {
        return this.isActive() ? (this.iconAU != null ? this.iconAU.width : this.width) : (this.iconIU != null ? this.iconIU.width : this.width);
    }

    int height() {
        return this.isActive() ? (this.iconAU != null ? this.iconAU.height : this.height) : (this.iconIU != null ? this.iconIU.height : this.height);
    }

    @Override
    String describe() {
        return "Button," + this.name;
    }

    @Override
    void checkVersion() {
        this.codec = this.getHeader().hasColor() ? color : nocolor;
        this.inColor = this.codec == color;
    }

    @Override
    void preEncode(CCFNodeState cCFNodeState) {
        this.width = this.width();
        this.height = this.height();
    }

    @Override
    void preDecode(CCFNodeState cCFNodeState) {
    }

    @Override
    void postDecode(CCFNodeState cCFNodeState) {
    }

    @Override
    String[][] getEncodeTable() {
        return this.codec;
    }

    @Override
    String[][] getDecodeTable() {
        return this.codec;
    }

    @Override
    void buildTree(CCFNode cCFNode) {
        this.setParent(cCFNode);
        if (this.actions != null) {
            this.actions.buildTree(this);
        }
    }
}

