/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CCFButton;
import com.neuron.app.tonto.CCFFrame;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFNodeState;
import com.neuron.app.tonto.IChildContainer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class CCFChild
extends CCFNode {
    private static final String[][] encode = new String[][]{{"N2", "intX"}, {"N2", "intY"}, {"Z*", "child"}, {"N1", "type"}};
    private static final String[][] decode = new String[][]{{"N2", "intX"}, {"N2", "intY"}, {"N4", "childPos"}, {"N1", "type"}};
    public static final int FRAME = 0;
    public static final int BUTTON = 1;
    int intX;
    int intY;
    int childPos;
    int type;
    CCFNode child;

    CCFChild() {
    }

    CCFChild(CCFNode cCFNode, CCFFrame cCFFrame) {
        this.setParent(cCFNode);
        this.setFrame(cCFFrame);
        this.intX = 10;
        this.intY = 10;
    }

    CCFChild(CCFNode cCFNode, CCFButton cCFButton) {
        this.setParent(cCFNode);
        this.setButton(cCFButton);
        this.intX = 10;
        this.intY = 10;
    }

    void setFrame(CCFFrame cCFFrame) {
        this.type = 0;
        this.child = cCFFrame;
        this.child.setParent(this);
    }

    void setButton(CCFButton cCFButton) {
        this.type = 1;
        this.child = cCFButton;
        this.child.setParent(this);
    }

    @Override
    public CCFNode getClone() {
        CCFChild cCFChild = (CCFChild)super.getClone();
        cCFChild.child = cCFChild.child.getClone();
        cCFChild.buildTree(this.getParent());
        return cCFChild;
    }

    @Override
    void dump() {
        super.dump();
        if (this.child != null) {
            this.child.dump();
        }
    }

    public boolean raise() {
        CCFChild[] cCFChildArray = ((IChildContainer)((Object)this.getParent())).getChildren();
        for (int i = 0; i < cCFChildArray.length - 1; ++i) {
            if (cCFChildArray[i] != this) continue;
            CCFChild cCFChild = cCFChildArray[i + 1];
            cCFChildArray[i + 1] = this;
            cCFChildArray[i] = cCFChild;
            ((IChildContainer)((Object)this.getParent())).setChildren(cCFChildArray);
            return true;
        }
        return false;
    }

    public boolean lower() {
        CCFChild[] cCFChildArray = ((IChildContainer)((Object)this.getParent())).getChildren();
        for (int i = 1; i < cCFChildArray.length; ++i) {
            if (cCFChildArray[i] != this) continue;
            CCFChild cCFChild = cCFChildArray[i - 1];
            cCFChildArray[i - 1] = this;
            cCFChildArray[i] = cCFChild;
            ((IChildContainer)((Object)this.getParent())).setChildren(cCFChildArray);
            return true;
        }
        return false;
    }

    public void top() {
        while (this.raise()) {
        }
    }

    public void bottom() {
        while (this.lower()) {
        }
    }

    public Rectangle getBounds() {
        Point point = this.getLocation();
        Dimension dimension = this.getSize();
        return new Rectangle(point.x, point.y, dimension.width, dimension.height);
    }

    public void setBounds(Rectangle rectangle) {
        this.setLocation(new Point(rectangle.x, rectangle.y));
        this.setSize(new Dimension(rectangle.width, rectangle.height));
    }

    public Point getLocation() {
        return new Point(this.intX, this.intY);
    }

    public void setLocation(Point point) {
        this.intX = point.x;
        this.intY = point.y;
    }

    public boolean isResizable() {
        if (this.child == null) {
            return true;
        }
        return this.type == 1 ? ((CCFButton)this.child).isResizable() : ((CCFFrame)this.child).isResizable();
    }

    public Dimension getSize() {
        if (this.child == null) {
            return new Dimension(0, 0);
        }
        return this.type == 1 ? ((CCFButton)this.child).getSize() : ((CCFFrame)this.child).getSize();
    }

    public void setSize(Dimension dimension) {
        if (this.child == null) {
            return;
        }
        if (this.type == 1) {
            ((CCFButton)this.child).setSize(dimension);
        } else {
            ((CCFFrame)this.child).setSize(dimension);
        }
    }

    public boolean isButton() {
        return this.type == 1;
    }

    public boolean isFrame() {
        return this.type == 0;
    }

    public int getType() {
        return this.type;
    }

    public CCFButton getButton() {
        return this.isButton() ? (CCFButton)this.child : null;
    }

    public CCFFrame getFrame() {
        return this.isFrame() ? (CCFFrame)this.child : null;
    }

    public void delete() {
        this.getParentPanel().delete(this.child);
    }

    @Override
    String describe() {
        return "Child," + this.intX + "x" + this.intY + "," + this.type;
    }

    void collectButtons(Vector vector) {
        if (this.child == null) {
            return;
        }
        if (this.type == 0) {
            ((CCFFrame)this.child).collectButtons(vector);
        } else if (this.type == 1) {
            vector.addElement(this.child);
        }
    }

    @Override
    void checkVersion() {
    }

    @Override
    void preEncode(CCFNodeState cCFNodeState) {
    }

    @Override
    void preDecode(CCFNodeState cCFNodeState) {
    }

    @Override
    void postDecode(CCFNodeState cCFNodeState) {
        if (this.childPos > 0) {
            switch (this.type) {
                case 0: {
                    this.child = this.getItemByPos(cCFNodeState, this.childPos, CCFFrame.class);
                    break;
                }
                case 1: {
                    this.child = this.getItemByPos(cCFNodeState, this.childPos, CCFButton.class);
                    break;
                }
                default: {
                    debug.log(0, "Invalid child type: " + this.type);
                }
            }
        }
        if (this.child == null) {
            debug.log(0, "Null child " + this.describe());
            switch (this.type) {
                case 0: {
                    this.child = new CCFFrame(this, null);
                    break;
                }
                case 1: {
                    this.child = new CCFButton(this, null);
                }
            }
        }
    }

    @Override
    String[][] getEncodeTable() {
        return encode;
    }

    @Override
    String[][] getDecodeTable() {
        return decode;
    }

    @Override
    void buildTree(CCFNode cCFNode) {
        this.setParent(cCFNode);
        if (this.child != null) {
            this.child.buildTree(this);
        }
    }
}

