/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import java.awt.Color;
import java.awt.image.ColorModel;

public class CCFColor {
    public static final int BLACK = 0;
    public static final int DARK_GRAY = 1;
    public static final int LIGHT_GRAY = 2;
    public static final int WHITE = 3;
    private static ColorModel cm = ColorModel.getRGBdefault();
    private static int grayTint;
    public static CCFColor[] defaultMap;
    private static final int[][] rgb;
    private static final Color[] model;
    private static final Color[] oldModel;
    private static Color[] tintModel;
    private int color;

    CCFColor(int n) {
        this.color = n & 0xFF;
    }

    public String toString() {
        return "Color[" + this.color + "]";
    }

    public static int getGrayTint() {
        return grayTint;
    }

    public static void setGrayTint(int n) {
        grayTint = n;
        Color color = new Color(255 - n, 255, 255 - n);
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        tintModel = new Color[4];
        for (int i = 0; i < oldModel.length; ++i) {
            Color color2 = oldModel[i];
            int n5 = color2.getRed() * n2 / 255;
            int n6 = color2.getGreen() * n3 / 255;
            int n7 = color2.getBlue() * n4 / 255;
            CCFColor.tintModel[i] = new Color(n5, n6, n7);
        }
    }

    public static int rgbIndexToGrayIndex(int n) {
        return CCFColor.rgbToGrayIndex(model[n].getRGB());
    }

    public static int rgbToGrayIndex(int n) {
        return (cm.getRed(n) * 30 + cm.getGreen(n) * 59 + cm.getBlue(n) * 11) / 6400;
    }

    public static int grayToRGB(int n, int[] nArray) {
        return CCFColor.grayIndexToRGB(CCFColor.rgbToGrayIndex(n), nArray);
    }

    public static int grayIndexToRGB(int n, int[] nArray) {
        return nArray[n & 3];
    }

    public Color getAWTColor(boolean bl) {
        return bl ? model[this.color] : tintModel[this.color & 3];
    }

    public CCFColor makeGray() {
        return new CCFColor(CCFColor.rgbIndexToGrayIndex(this.color));
    }

    public CCFColor makeColor(int[] nArray) {
        return new CCFColor(nArray[this.color & 3]);
    }

    public int getColorIndex() {
        return this.color;
    }

    int getCCFBackground(boolean bl) {
        if (bl) {
            return this.color << 0 | this.color << 8 | this.color << 16;
        }
        return this.color << 2 | this.color << 4 | this.color << 6;
    }

    int getCCFForeground(boolean bl) {
        return bl ? (this.color & 0xFF) << 24 : this.color & 3;
    }

    static Color getAWTColor(int n, boolean bl) {
        return bl ? model[n & 0xFF] : tintModel[n & 3];
    }

    public static Color[] getColorModel(boolean bl) {
        return bl ? model : oldModel;
    }

    static int getComposite(CCFColor cCFColor, CCFColor cCFColor2, boolean bl) {
        return cCFColor2.getCCFBackground(bl) | cCFColor.getCCFForeground(bl);
    }

    public static CCFColor getColor(int n) {
        return new CCFColor(n);
    }

    static CCFColor getNamedColor(int n, boolean bl) {
        if (bl) {
            switch (n) {
                case 0: {
                    return new CCFColor(0);
                }
                case 1: {
                    return new CCFColor(252);
                }
                case 2: {
                    return new CCFColor(244);
                }
            }
            return new CCFColor(215);
        }
        switch (n) {
            case 0: {
                return new CCFColor(0);
            }
            case 1: {
                return new CCFColor(1);
            }
            case 2: {
                return new CCFColor(2);
            }
        }
        return new CCFColor(3);
    }

    static int getBackgroundIndex(int n, boolean bl) {
        return bl ? n & 0xFF : n >> 2 & 3;
    }

    static CCFColor getBackground(int n, boolean bl) {
        return CCFColor.getColor(CCFColor.getBackgroundIndex(n, bl));
    }

    static int getForegroundIndex(int n, boolean bl) {
        return bl ? n >> 24 & 0xFF : n & 3;
    }

    static CCFColor getForeground(int n, boolean bl) {
        return CCFColor.getColor(CCFColor.getForegroundIndex(n, bl));
    }

    static int ccfGrayToRGB(int n, int[] nArray) {
        return CCFColor.getComposite(CCFColor.getForeground(n, false).makeColor(nArray), CCFColor.getBackground(n, false).makeColor(nArray), true);
    }

    static int ccfRGBToGray(int n) {
        return CCFColor.getComposite(CCFColor.getForeground(n, true).makeGray(), CCFColor.getBackground(n, true).makeGray(), false);
    }

    public static int getColorFromRGB(int n, int n2, int n3) {
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < rgb.length; ++i) {
            int n6 = Math.abs(n - rgb[i][0]);
            int n7 = Math.abs(n2 - rgb[i][1]);
            int n8 = Math.abs(n3 - rgb[i][2]);
            if (n6 > 16 || n7 > 16 || n8 > 16) continue;
            int n9 = n6 * n7 * n8;
            if (n5 >= 0 && n9 > n5) continue;
            n5 = n9;
            n4 = i;
        }
        if (n4 >= 0) {
            return n4;
        }
        return n / 51 + n2 / 51 * 6 + n3 / 51 * 36;
    }

    static {
        defaultMap = new CCFColor[]{new CCFColor(0), new CCFColor(251), new CCFColor(245), new CCFColor(215)};
        rgb = new int[][]{{0, 0, 0}, {51, 0, 0}, {102, 0, 0}, {153, 0, 0}, {204, 0, 0}, {255, 0, 0}, {0, 51, 0}, {51, 51, 0}, {102, 51, 0}, {153, 51, 0}, {204, 51, 0}, {255, 51, 0}, {0, 102, 0}, {51, 102, 0}, {102, 102, 0}, {153, 102, 0}, {204, 102, 0}, {255, 102, 0}, {0, 153, 0}, {51, 153, 0}, {102, 153, 0}, {153, 153, 0}, {204, 153, 0}, {255, 153, 0}, {0, 204, 0}, {51, 204, 0}, {102, 204, 0}, {153, 204, 0}, {204, 204, 0}, {255, 204, 0}, {0, 255, 0}, {51, 255, 0}, {102, 255, 0}, {153, 255, 0}, {204, 255, 0}, {255, 255, 0}, {0, 0, 51}, {51, 0, 51}, {102, 0, 51}, {153, 0, 51}, {204, 0, 51}, {255, 0, 51}, {0, 51, 51}, {51, 51, 51}, {102, 51, 51}, {153, 51, 51}, {204, 51, 51}, {255, 51, 51}, {0, 102, 51}, {51, 102, 51}, {102, 102, 51}, {153, 102, 51}, {204, 102, 51}, {255, 102, 51}, {0, 153, 51}, {51, 153, 51}, {102, 153, 51}, {153, 153, 51}, {204, 153, 51}, {255, 153, 51}, {0, 204, 51}, {51, 204, 51}, {102, 204, 51}, {153, 204, 51}, {204, 204, 51}, {255, 204, 51}, {0, 255, 51}, {51, 255, 51}, {102, 255, 51}, {153, 255, 51}, {204, 255, 51}, {255, 255, 51}, {0, 0, 102}, {51, 0, 102}, {102, 0, 102}, {153, 0, 102}, {204, 0, 102}, {255, 0, 102}, {0, 51, 102}, {51, 51, 102}, {102, 51, 102}, {153, 51, 102}, {204, 51, 102}, {255, 51, 102}, {0, 102, 102}, {51, 102, 102}, {102, 102, 102}, {153, 102, 102}, {204, 102, 102}, {255, 102, 102}, {0, 153, 102}, {51, 153, 102}, {102, 153, 102}, {153, 153, 102}, {204, 153, 102}, {255, 153, 102}, {0, 204, 102}, {51, 204, 102}, {102, 204, 102}, {153, 204, 102}, {204, 204, 102}, {255, 204, 102}, {0, 255, 102}, {51, 255, 102}, {102, 255, 102}, {153, 255, 102}, {204, 255, 102}, {255, 255, 102}, {0, 0, 153}, {51, 0, 153}, {102, 0, 153}, {153, 0, 153}, {204, 0, 153}, {255, 0, 153}, {0, 51, 153}, {51, 51, 153}, {102, 51, 153}, {153, 51, 153}, {204, 51, 153}, {255, 51, 153}, {0, 102, 153}, {51, 102, 153}, {102, 102, 153}, {153, 102, 153}, {204, 102, 153}, {255, 102, 153}, {0, 153, 153}, {51, 153, 153}, {102, 153, 153}, {153, 153, 153}, {204, 153, 153}, {255, 153, 153}, {0, 204, 153}, {51, 204, 153}, {102, 204, 153}, {153, 204, 153}, {204, 204, 153}, {255, 204, 153}, {0, 255, 153}, {51, 255, 153}, {102, 255, 153}, {153, 255, 153}, {204, 255, 153}, {255, 255, 153}, {0, 0, 204}, {51, 0, 204}, {102, 0, 204}, {153, 0, 204}, {204, 0, 204}, {255, 0, 204}, {0, 51, 204}, {51, 51, 204}, {102, 51, 204}, {153, 51, 204}, {204, 51, 204}, {255, 51, 204}, {0, 102, 204}, {51, 102, 204}, {102, 102, 204}, {153, 102, 204}, {204, 102, 204}, {255, 102, 204}, {0, 153, 204}, {51, 153, 204}, {102, 153, 204}, {153, 153, 204}, {204, 153, 204}, {255, 153, 204}, {0, 204, 204}, {51, 204, 204}, {102, 204, 204}, {153, 204, 204}, {204, 204, 204}, {255, 204, 204}, {0, 255, 204}, {51, 255, 204}, {102, 255, 204}, {153, 255, 204}, {204, 255, 204}, {255, 255, 204}, {0, 0, 255}, {51, 0, 255}, {102, 0, 255}, {153, 0, 255}, {204, 0, 255}, {255, 0, 255}, {0, 51, 255}, {51, 51, 255}, {102, 51, 255}, {153, 51, 255}, {204, 51, 255}, {255, 51, 255}, {0, 102, 255}, {51, 102, 255}, {102, 102, 255}, {153, 102, 255}, {204, 102, 255}, {255, 102, 255}, {0, 153, 255}, {51, 153, 255}, {102, 153, 255}, {153, 153, 255}, {204, 153, 255}, {255, 153, 255}, {0, 204, 255}, {51, 204, 255}, {102, 204, 255}, {153, 204, 255}, {204, 204, 255}, {255, 204, 255}, {0, 255, 255}, {51, 255, 255}, {102, 255, 255}, {153, 255, 255}, {204, 255, 255}, {255, 255, 255}, {192, 208, 240}, {144, 176, 240}, {112, 144, 208}, {80, 112, 208}, {48, 96, 224}, {64, 80, 224}, {32, 64, 192}, {32, 48, 176}, {160, 160, 208}, {112, 112, 160}, {80, 80, 144}, {48, 64, 144}, {48, 48, 128}, {32, 32, 112}, {16, 16, 112}, {16, 16, 80}, {208, 176, 208}, {176, 144, 176}, {144, 128, 144}, {160, 128, 160}, {144, 128, 144}, {144, 112, 144}, {128, 112, 128}, {128, 96, 128}, {255, 255, 255}, {240, 240, 240}, {224, 224, 224}, {208, 208, 208}, {192, 192, 192}, {176, 176, 176}, {160, 160, 160}, {144, 144, 144}, {128, 128, 128}, {112, 112, 112}, {96, 96, 96}, {80, 80, 80}, {64, 64, 64}, {48, 48, 48}, {32, 32, 32}, {16, 16, 16}};
        model = new Color[rgb.length];
        oldModel = new Color[4];
        tintModel = oldModel;
        for (int i = 0; i < model.length; ++i) {
            CCFColor.model[i] = new Color(rgb[i][0], rgb[i][1], rgb[i][2]);
        }
        CCFColor.oldModel[0] = model[0];
        CCFColor.oldModel[1] = model[251];
        CCFColor.oldModel[2] = model[245];
        CCFColor.oldModel[3] = model[215];
    }
}

