/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CCFAction;
import com.neuron.app.tonto.CCFActionList;
import com.neuron.app.tonto.CCFHardKey;
import com.neuron.app.tonto.CCFHeader;
import com.neuron.app.tonto.CCFIcon;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFNodeState;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.IListElement;
import com.neuron.app.tonto.INamed;
import java.util.Vector;

public class CCFDevice
extends CCFNode
implements INamed,
IListElement {
    public static final int READ_ONLY = 1;
    public static final int IS_TIMER_GROUP = 2;
    public static final int NEEDS_PROGRAMMING = 16;
    public static final int HAS_SEPARATOR = 32;
    public static final int IS_TEMPLATE = 64;
    private static final String[][] nocolor = new String[][]{{"Z*", "next"}, {"S*", "name"}, {"Z*", "iconUnselected"}, {"Z*", "iconSelected"}, {"Z*", "action"}, {"Z*", "keyLt"}, {"Z*", "keyRt"}, {"Z*", "keyVolDn"}, {"Z*", "keyVolUp"}, {"Z*", "keyChanDn"}, {"Z*", "keyChanUp"}, {"Z*", "keyMute"}, {"N4", "_reserve_1"}, {"S*", "keyNameLt"}, {"S*", "keyNameRt"}, {"Z*", "firstPanel"}, {"N1", "attr"}};
    private static final String[][] color = new String[][]{{"Z*", "next"}, {"S*", "name"}, {"Z*", "iconUnselected"}, {"Z*", "iconSelected"}, {"Z*", "action"}, {"Z*", "keyLt"}, {"Z*", "keyRt"}, {"Z*", "keyVolDn"}, {"Z*", "keyVolUp"}, {"Z*", "keyChanDn"}, {"Z*", "keyChanUp"}, {"Z*", "keyMute"}, {"Z*", "keyFarLt"}, {"Z*", "keyFarRt"}, {"N4", "_reserve_1"}, {"S*", "keyNameLt"}, {"S*", "keyNameRt"}, {"S*", "keyNameFarLt"}, {"S*", "keyNameFarRt"}, {"Z*", "firstPanel"}, {"N1", "attr"}, {"N1", "rfExtender"}, {"N4", "_reserve_2"}};
    private static final String[][] marantz = new String[][]{{"Z*", "next"}, {"S*", "name"}, {"Z*", "iconUnselected"}, {"Z*", "iconSelected"}, {"Z*", "action"}, {"Z*", "keyLt"}, {"Z*", "keyRt"}, {"Z*", "keyMute"}, {"Z*", "keyChanDn"}, {"Z*", "keyChanUp"}, {"Z*", "keyVolDn"}, {"Z*", "keyVolUp"}, {"Z*", "keyM"}, {"Z*", "keyReturn"}, {"Z*", "keyEX"}, {"Z*", "arrowUp"}, {"Z*", "arrowLt"}, {"Z*", "arrowRt"}, {"Z*", "arrowDn"}, {"N4", "_reserve_1"}, {"N4", "_reserve_2"}, {"S*", "keyNameLt"}, {"S*", "keyNameRt"}, {"Z*", "firstPanel"}, {"N1", "attr"}, {"N1", "rfExtender"}, {"N2", "_reserve_3"}};
    private static final String[][] custom = new String[][]{{"Z*", "next"}, {"S*", "name"}, {"Z*", "iconUnselected"}, {"Z*", "iconSelected"}, {"Z*", "action"}, {"Z*", "keyLt"}, {"Z*", "keyRt"}, {"Z*", "keyVolDn"}, {"Z*", "keyVolUp"}, {"Z*", "keyChanDn"}, {"Z*", "keyChanUp"}, {"Z*", "keyMute"}, {"Z*", "keyFarLt"}, {"Z*", "keyFarRt"}, {"Z*", "keyReturn"}, {"S*", "keyNameLt"}, {"S*", "keyNameRt"}, {"S*", "keyNameFarLt"}, {"S*", "keyNameFarRt"}, {"Z*", "firstPanel"}, {"N1", "attr"}, {"N1", "rfExtender"}, {"Z*", "arrowUp"}, {"Z*", "arrowLt"}, {"Z*", "arrowRt"}, {"Z*", "arrowDn"}};
    private static final String[][] nocolorKeys = new String[][]{{"Left", "keyNameLt", "keyLt", ""}, {"Right", "keyNameRt", "keyRt", ""}, {"Vol-", null, "keyVolDn"}, {"Vol+", null, "keyVolUp"}, {"Chan-", null, "keyChanDn"}, {"Chan+", null, "keyChanUp"}, {"Mute", null, "keyMute"}};
    private static final String[][] colorKeys = new String[][]{{"Left", "keyNameLt", "keyLt", ""}, {"Right", "keyNameRt", "keyRt", ""}, {"Vol-", null, "keyVolDn"}, {"Vol+", null, "keyVolUp"}, {"Chan-", null, "keyChanDn"}, {"Chan+", null, "keyChanUp"}, {"Mute", null, "keyMute"}, {"Far Left", "keyNameFarLt", "keyFarLt"}, {"Far Right", "keyNameFarRt", "keyFarRt"}};
    private static final String[][] marantzKeys = new String[][]{{"Left", "keyNameLt", "keyLt", ""}, {"Right", "keyNameRt", "keyRt", ""}, {"Vol-", null, "keyVolDn"}, {"Vol+", null, "keyVolUp"}, {"Chan-", null, "keyChanDn"}, {"Chan+", null, "keyChanUp"}, {"Mute", null, "keyMute"}, {"M", null, "keyM"}, {"Return", null, "keyReturn"}, {"Ex", null, "keyEX"}, {"UpArrow", null, "arrowUp"}, {"LeftArrow", null, "arrowLt"}, {"RightArrow", null, "arrowRt"}, {"DownArrow", null, "arrowDn"}};
    private static final String[][] customKeys = new String[][]{{"Far Left", "keyNameFarLt", "keyFarLt", ""}, {"Left", "keyNameLt", "keyLt", ""}, {"Right", "keyNameRt", "keyRt", ""}, {"Far Right", "keyNameFarRt", "keyFarRt", ""}, {"Vol-", null, "keyVolDn"}, {"Vol+", null, "keyVolUp"}, {"Chan-", null, "keyChanDn"}, {"Chan+", null, "keyChanUp"}, {"Mute", null, "keyMute"}, {"UpArrow", null, "arrowUp"}, {"LeftArrow", null, "arrowLt"}, {"RightArrow", null, "arrowRt"}, {"DownArrow", null, "arrowDn"}, {"Click", null, "keyReturn"}};
    private String[][] codec = nocolor;
    CCFDevice next;
    String name;
    CCFIcon iconUnselected;
    CCFIcon iconSelected;
    CCFActionList action;
    CCFActionList keyLt;
    CCFActionList keyRt;
    CCFActionList keyFarLt;
    CCFActionList keyFarRt;
    CCFActionList keyVolDn;
    CCFActionList keyVolUp;
    CCFActionList keyChanDn;
    CCFActionList keyChanUp;
    CCFActionList keyMute;
    CCFActionList keyM;
    CCFActionList keyReturn;
    CCFActionList keyEX;
    CCFActionList arrowUp;
    CCFActionList arrowLt;
    CCFActionList arrowRt;
    CCFActionList arrowDn;
    String keyNameLt;
    String keyNameRt;
    String keyNameFarLt;
    String keyNameFarRt;
    CCFPanel firstPanel;
    int attr;
    int rfExtender;
    int _reserve_1;
    int _reserve_2;
    int _reserve_3;

    CCFDevice() {
    }

    CCFDevice(CCFHeader cCFHeader) {
        this.setParent(cCFHeader);
    }

    @Override
    public String toString() {
        return this.name != null ? this.name : "<unnamed>";
    }

    @Override
    public CCFNode getClone() {
        CCFDevice cCFDevice = (CCFDevice)super.getClone();
        cCFDevice.setNextDevice(null);
        cCFDevice.action = this.getClone(cCFDevice.action);
        cCFDevice.keyLt = this.getClone(cCFDevice.keyLt);
        cCFDevice.keyRt = this.getClone(cCFDevice.keyRt);
        cCFDevice.keyFarLt = this.getClone(cCFDevice.keyFarLt);
        cCFDevice.keyFarRt = this.getClone(cCFDevice.keyFarRt);
        cCFDevice.keyVolDn = this.getClone(cCFDevice.keyVolDn);
        cCFDevice.keyVolUp = this.getClone(cCFDevice.keyVolUp);
        cCFDevice.keyChanDn = this.getClone(cCFDevice.keyChanDn);
        cCFDevice.keyChanUp = this.getClone(cCFDevice.keyChanUp);
        cCFDevice.keyMute = this.getClone(cCFDevice.keyMute);
        cCFDevice.keyM = this.getClone(cCFDevice.keyM);
        cCFDevice.keyReturn = this.getClone(cCFDevice.keyReturn);
        cCFDevice.keyEX = this.getClone(cCFDevice.keyEX);
        cCFDevice.arrowUp = this.getClone(cCFDevice.arrowUp);
        cCFDevice.arrowDn = this.getClone(cCFDevice.arrowDn);
        cCFDevice.arrowLt = this.getClone(cCFDevice.arrowLt);
        cCFDevice.arrowRt = this.getClone(cCFDevice.arrowRt);
        if (cCFDevice.firstPanel != null) {
            cCFDevice.firstPanel = (CCFPanel)cCFDevice.firstPanel.getClone(true);
        }
        cCFDevice.buildTree(this.getParent());
        return cCFDevice;
    }

    CCFPanel[] getPanels() {
        Vector<CCFPanel> vector = new Vector<CCFPanel>();
        CCFPanel cCFPanel = this.firstPanel;
        while (cCFPanel != null) {
            vector.addElement(cCFPanel);
            cCFPanel = cCFPanel.next;
        }
        return vector.toArray(new CCFPanel[vector.size()]);
    }

    public CCFAction[] getActions() {
        if (this.action != null) {
            return this.action.getActions();
        }
        return null;
    }

    void insertBefore(CCFPanel cCFPanel, CCFPanel cCFPanel2) {
        if (this.firstPanel == null || this.firstPanel == cCFPanel) {
            cCFPanel2.setParent(this);
            cCFPanel2.next = this.firstPanel;
            this.firstPanel = cCFPanel2;
            return;
        }
        CCFPanel cCFPanel3 = this.firstPanel;
        while (cCFPanel3.next != cCFPanel && cCFPanel3.next != null) {
            cCFPanel3 = cCFPanel3.next;
        }
        cCFPanel2.buildTree(this);
        cCFPanel2.next = cCFPanel;
        cCFPanel3.next = cCFPanel2;
    }

    void delete(CCFPanel cCFPanel) {
        if (this.firstPanel == null) {
            return;
        }
        if (cCFPanel == this.firstPanel) {
            this.firstPanel = cCFPanel.next;
            cCFPanel.next = null;
        } else {
            CCFPanel cCFPanel2 = this.firstPanel;
            while (cCFPanel2 != null && cCFPanel != cCFPanel2.next) {
                cCFPanel2 = cCFPanel2.next;
            }
            if (cCFPanel2 != null && cCFPanel == cCFPanel2.next) {
                cCFPanel2.next = cCFPanel.next;
                cCFPanel.next = null;
            }
        }
    }

    private CCFHardKey[] getHardKeys(String[][] stringArray) {
        CCFHardKey[] cCFHardKeyArray = new CCFHardKey[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            cCFHardKeyArray[i] = new CCFHardKey(this, stringArray[i][0], stringArray[i][1], stringArray[i][2]);
        }
        return cCFHardKeyArray;
    }

    public CCFPanel getPanelByName(String string) {
        for (CCFPanel cCFPanel = this.firstPanel; cCFPanel != null; cCFPanel = cCFPanel.getNextPanel()) {
            if (cCFPanel.name == null || !cCFPanel.name.equals(string)) continue;
            return cCFPanel;
        }
        return null;
    }

    public CCFHardKey[] getHardKeys() {
        this.checkVersion();
        if (this.codec == nocolor) {
            return this.getHardKeys(nocolorKeys);
        }
        if (this.codec == color) {
            return this.getHardKeys(colorKeys);
        }
        if (this.codec == marantz) {
            return this.getHardKeys(marantzKeys);
        }
        if (this.codec == custom) {
            return this.getHardKeys(customKeys);
        }
        return new CCFHardKey[0];
    }

    public void setKeyActions(CCFHardKey[] cCFHardKeyArray) {
        for (int i = 0; i < cCFHardKeyArray.length; ++i) {
            cCFHardKeyArray[i].copyToDevice(this);
        }
    }

    public int getRFExtender() {
        return this.rfExtender;
    }

    public void setRFExtender(int n) {
        this.rfExtender = n;
    }

    @Override
    public IListElement getNextElement() {
        return this.next;
    }

    public CCFDevice getNextDevice() {
        return this.next;
    }

    public void setNextDevice(CCFDevice cCFDevice) {
        if (cCFDevice != null) {
            cCFDevice.setParent(this.getParent());
        }
        this.next = cCFDevice;
    }

    public void appendDevice(CCFDevice cCFDevice) {
        CCFDevice cCFDevice2 = this;
        while (cCFDevice2.next != null) {
            cCFDevice2 = cCFDevice2.next;
        }
        cCFDevice2.next = cCFDevice;
        cCFDevice.buildTree(this.getParent());
    }

    public void insertAfter(CCFDevice cCFDevice) {
        if (this.next == null) {
            this.next = cCFDevice;
        } else {
            cCFDevice.next = this.next;
            this.next = cCFDevice;
        }
        cCFDevice.buildTree(this.getParent());
    }

    public void insertBefore(CCFDevice cCFDevice) {
        this.getHeader().insertBefore(this, cCFDevice);
    }

    public boolean getFlag(int n) {
        return (this.attr & n) == n;
    }

    public void setFlag(int n, boolean bl) {
        this.attr = bl ? (this.attr |= n) : (this.attr &= n ^ 0xFF);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public CCFPanel getFirstPanel() {
        return this.firstPanel;
    }

    public void setFirstPanel(CCFPanel cCFPanel) {
        this.firstPanel = cCFPanel;
    }

    public CCFPanel createPanel(String string) {
        return new CCFPanel(string, this);
    }

    public void addPanel(CCFPanel cCFPanel) {
        if (cCFPanel == null) {
            return;
        }
        cCFPanel.buildTree(this);
        CCFPanel cCFPanel2 = this.firstPanel;
        if (cCFPanel2 == null) {
            this.firstPanel = cCFPanel;
            return;
        }
        while (cCFPanel2.next != null) {
            cCFPanel2 = cCFPanel2.next;
        }
        cCFPanel2.next = cCFPanel;
    }

    public CCFDevice delete() {
        CCFDevice cCFDevice = this.getHeader().delete(this);
        this.setParent(null);
        return cCFDevice;
    }

    boolean isHomeDevice() {
        return this.getHeader().isHomeDevice(this);
    }

    boolean isNormalDevice() {
        return this.getHeader().isNormalDevice(this);
    }

    boolean isMacroDevice() {
        return this.getHeader().isMacroDevice(this);
    }

    @Override
    String describe() {
        return "Device," + this.name + "," + this.attr;
    }

    @Override
    void checkVersion() {
        CCFHeader cCFHeader = this.getHeader();
        this.codec = cCFHeader.isCustom() ? custom : (cCFHeader.isNewMarantz() ? marantz : (cCFHeader.hasColor() ? color : nocolor));
    }

    @Override
    void preEncode(CCFNodeState cCFNodeState) {
        this._reserve_1 = 0;
        this._reserve_2 = 0;
        this._reserve_3 = 0;
    }

    @Override
    void preDecode(CCFNodeState cCFNodeState) {
    }

    @Override
    void postDecode(CCFNodeState cCFNodeState) {
    }

    @Override
    String[][] getEncodeTable() {
        return this.codec;
    }

    @Override
    String[][] getDecodeTable() {
        return this.codec;
    }

    @Override
    void buildTree(CCFNode cCFNode) {
        this.setParent(cCFNode);
        for (CCFPanel cCFPanel = this.firstPanel; cCFPanel != null; cCFPanel = cCFPanel.getNextPanel()) {
            cCFPanel.buildTree(this);
        }
        if (this.action != null) {
            this.action.buildTree(this);
        }
    }
}

