/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CCFButton;
import com.neuron.app.tonto.CCFChild;
import com.neuron.app.tonto.CCFColor;
import com.neuron.app.tonto.CCFFont;
import com.neuron.app.tonto.CCFIcon;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFNodeState;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.IChildContainer;
import com.neuron.app.tonto.INamed;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Vector;

public class CCFFrame
extends CCFNode
implements IChildContainer,
INamed {
    private static final String[][] nocolor = new String[][]{{"N2", "width"}, {"N2", "height"}, {"S*", "name"}, {"Z*", "icon"}, {"N4", "_reserve_1"}, {"N1", "fontSize"}, {"N1", "colors"}, {"N1", "count1"}, {"N1", "count2"}, {"Z+", "child", "count1"}};
    private static final String[][] color = new String[][]{{"N2", "width"}, {"N2", "height"}, {"S*", "name"}, {"Z*", "icon"}, {"N3", "_reserve_1"}, {"N1", "textOpt"}, {"N1", "fontSize"}, {"N4", "colors"}, {"N1", "count1"}, {"N1", "count2"}, {"Z+", "child", "count1"}};
    private String[][] codec = nocolor;
    private boolean inColor;
    int width;
    int height;
    String name;
    CCFIcon icon;
    int _reserve_1;
    int textOpt;
    int fontSize;
    int colors;
    int count1;
    int count2;
    CCFChild[] child;

    CCFFrame() {
    }

    CCFFrame(CCFNode cCFNode, String string) {
        this.setName(string);
        this.setParent(new CCFChild(cCFNode, this));
        this.width = 90;
        this.height = 60;
        this.inColor = this.usingColor();
        this.setForeground(CCFColor.getNamedColor(0, this.inColor));
        this.setBackground(CCFColor.getNamedColor(2, this.inColor));
        this.checkVersion();
    }

    @Override
    CCFNode getClone() {
        CCFFrame cCFFrame = (CCFFrame)super.getClone();
        cCFFrame.child = this.getClone(cCFFrame.child);
        cCFFrame.buildTree(this.getParent());
        return cCFFrame;
    }

    @Override
    public void setParent(CCFNode cCFNode) {
        super.setParent(cCFNode);
        if (cCFNode != null && !(cCFNode instanceof CCFChild)) {
            throw new RuntimeException("parent ! CCFChild : " + cCFNode);
        }
    }

    public int getTextAlignment() {
        return this.textOpt & 3;
    }

    public void setTextAlignment(int n) {
        this.textOpt = this.textOpt & 0xFC | n & 3;
    }

    public boolean getTextWrap() {
        return (this.textOpt & 0x80) == 128;
    }

    public void setTextWrap(boolean bl) {
        this.textOpt = this.textOpt & 0x7F | (bl ? 128 : 0);
    }

    public void convertToColor() {
        if (this.inColor) {
            return;
        }
        debug.log(3, "converting " + this.describe() + " to color");
        CCFColor[] cCFColorArray = this.getHeader().getColorMap();
        int n = CCFColor.getForegroundIndex(this.colors, false);
        int n2 = CCFColor.getBackgroundIndex(this.colors, false);
        this.colors = CCFColor.getComposite(cCFColorArray[n], cCFColorArray[n2], true);
        this.inColor = this.getHeader().hasColor();
    }

    public void convertToGray() {
        if (!this.inColor) {
            return;
        }
        debug.log(3, "converting " + this.describe() + " to gray");
        int n = CCFColor.rgbIndexToGrayIndex(CCFColor.getForegroundIndex(this.colors, true));
        int n2 = CCFColor.rgbIndexToGrayIndex(CCFColor.getBackgroundIndex(this.colors, true));
        this.colors = CCFColor.getComposite(new CCFColor(n), new CCFColor(n2), false);
        this.inColor = this.getHeader().hasColor();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public CCFButton createButton(String string) {
        return new CCFButton(this.getParentPanel(), string);
    }

    public CCFFrame createFrame(String string) {
        return new CCFFrame(this.getParentPanel(), string);
    }

    public CCFFont getFont() {
        return CCFFont.getFont(this.fontSize);
    }

    public void setFont(CCFFont cCFFont) {
        this.fontSize = cCFFont.getFontSize();
    }

    public CCFColor getBackground() {
        return CCFColor.getBackground(this.colors, this.inColor);
    }

    public void setBackground(CCFColor cCFColor) {
        this.colors = CCFColor.getComposite(this.getForeground(), cCFColor, this.inColor);
    }

    public CCFColor getForeground() {
        return CCFColor.getForeground(this.colors, this.inColor);
    }

    public void setForeground(CCFColor cCFColor) {
        this.colors = CCFColor.getComposite(cCFColor, this.getBackground(), this.inColor);
    }

    public CCFIcon getIcon() {
        return this.icon;
    }

    public void setIcon(CCFIcon cCFIcon) {
        this.icon = cCFIcon;
    }

    @Override
    public CCFChild[] getChildren() {
        return this.child;
    }

    @Override
    public void setChildren(CCFChild[] cCFChildArray) {
        this.child = cCFChildArray;
        this.count2 = this.count1 = cCFChildArray != null ? cCFChildArray.length : 0;
        this.buildTree(this.getParent());
    }

    public void addChild(CCFChild cCFChild) {
        this.setChildren(CCFPanel.add(this.child, cCFChild));
    }

    @Override
    public void addButton(CCFButton cCFButton) {
        this.setChildren(CCFPanel.add(this.child, cCFButton.getChildWrapper()));
    }

    @Override
    public void addFrame(CCFFrame cCFFrame) {
        this.setChildren(CCFPanel.add(this.child, cCFFrame.getChildWrapper()));
    }

    public Dimension getSize() {
        return new Dimension(this.width(), this.height());
    }

    public void setSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public CCFChild getChildWrapper() {
        return (CCFChild)this.getParent();
    }

    public Point getLocation() {
        return this.getChildWrapper().getLocation();
    }

    public void setLocation(Point point) {
        this.getChildWrapper().setLocation(point);
    }

    public boolean isResizable() {
        return this.icon == null;
    }

    public void delete() {
        this.getParentPanel().delete(this);
        this.setParent(null);
    }

    void delete(CCFNode cCFNode) {
        this.setChildren(CCFPanel.delete(this.child, cCFNode));
    }

    int width() {
        return this.icon != null ? this.icon.width : this.width;
    }

    int height() {
        return this.icon != null ? this.icon.height : this.height;
    }

    @Override
    String describe() {
        return "Frame," + this.name + "," + this.width + "x" + this.height + "," + this.fontSize + "," + this.colors;
    }

    void collectButtons(Vector vector) {
        if (this.child == null) {
            return;
        }
        for (int i = 0; i < this.child.length; ++i) {
            this.child[i].collectButtons(vector);
        }
    }

    @Override
    void checkVersion() {
        this.codec = this.getHeader().hasColor() ? color : nocolor;
        this.inColor = this.codec == color;
    }

    @Override
    void preEncode(CCFNodeState cCFNodeState) {
        this.width = this.width();
        this.height = this.height();
    }

    @Override
    void preDecode(CCFNodeState cCFNodeState) {
    }

    @Override
    void postDecode(CCFNodeState cCFNodeState) {
        if (this.count1 != this.count2) {
            int n;
            this.log(0, "frame: child count mismatch " + this.count1 + " != " + this.count2, cCFNodeState);
            this.count1 = n = Math.min(Math.min(this.count1, this.count2), 10);
            this.count2 = n;
        }
    }

    @Override
    String[][] getEncodeTable() {
        return this.codec;
    }

    @Override
    String[][] getDecodeTable() {
        return this.codec;
    }

    @Override
    void buildTree(CCFNode cCFNode) {
        this.setParent(cCFNode);
        if (this.child == null) {
            return;
        }
        for (int i = 0; i < this.child.length; ++i) {
            this.child[i].buildTree(this);
        }
    }

    @Override
    public String toString() {
        return "'" + this.name + "'-" + super.toString();
    }
}

