/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CCFAction;
import com.neuron.app.tonto.CCFActionList;
import com.neuron.app.tonto.CCFDevice;
import com.neuron.app.tonto.Debug;

public class CCFHardKey {
    static Debug debug = Debug.getInstance("ccf");
    private CCFDevice dev;
    private String label;
    private String name;
    private String actions;

    CCFHardKey(CCFDevice cCFDevice, String string, String string2, String string3) {
        this.dev = cCFDevice;
        this.label = string;
        this.name = string2;
        this.actions = string3;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isNamable() {
        return this.name != null;
    }

    public String getName() {
        try {
            return this.isNamable() ? (String)this.dev.getField(this.name).get(this.dev) : null;
        }
        catch (Exception exception) {
            debug.log(0, "unable to get hard key name (" + this.label + ")");
            return null;
        }
    }

    public void setName(String string) {
        try {
            if (this.isNamable()) {
                this.dev.getField(this.name).set(this.dev, string);
            }
        }
        catch (Exception exception) {
            debug.log(0, "unable to set hard key name (" + this.label + ")");
        }
    }

    public CCFActionList getActionList() {
        try {
            return (CCFActionList)this.dev.getField(this.actions).get(this.dev);
        }
        catch (Exception exception) {
            debug.log(0, "unable to get hard key actions (" + this.label + ")");
            return null;
        }
    }

    public void appendAction(CCFAction cCFAction) {
        CCFActionList cCFActionList = this.getActionList();
        if (cCFActionList == null) {
            cCFActionList = new CCFActionList();
            this.setActionList(cCFActionList);
        }
        cCFActionList.appendAction(cCFAction);
    }

    public void setActionList(CCFActionList cCFActionList) {
        try {
            this.dev.getField(this.actions).set(this.dev, cCFActionList);
        }
        catch (Exception exception) {
            debug.log(0, "unable to set hard key actions (" + this.label + ")");
        }
    }

    public void copyToDevice(CCFDevice cCFDevice) {
        try {
            if (this.name != null) {
                cCFDevice.getField(this.name).set(cCFDevice, this.dev.getField(this.name).get(this.dev));
            }
            if (this.actions != null) {
                CCFActionList cCFActionList = (CCFActionList)this.dev.getField(this.actions).get(this.dev);
                cCFDevice.getField(this.actions).set(cCFDevice, cCFActionList != null ? cCFActionList.getClone() : null);
            }
        }
        catch (Exception exception) {
            debug.log(0, "unable to copy hard key (" + this.name + "," + this.actions + ") action to " + cCFDevice);
        }
    }
}

