/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.BufferedFile;
import com.neuron.app.tonto.CCFColor;
import com.neuron.app.tonto.CCFDevice;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFNodeState;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.CCFTimer;
import com.neuron.app.tonto.ProntoModel;
import com.neuron.app.tonto.Tonto;
import com.neuron.app.tonto.Util;
import java.awt.Dimension;

class CCFHeader
extends CCFNode {
    static final int AT_FACTORY_CCF = 1;
    static final int AT_CONFIG_READONLY = 2;
    static final int AT_HOME_READONLY = 4;
    static final int AT_MASK = 7;
    static final int CA_DEFAULT = 1;
    static final int CA_HAS_COLOR = 256;
    static final int CA_HAS_UNKNOWN1 = 512;
    static final int CA_IS_NEW_MARANTZ = 2048;
    static final int CA_HAS_TIMERS = 131072;
    static final int CA_HAS_UDB = 262144;
    static final int CA_CUSTOM = 16909057;
    static final String[][] gray_notimers = new String[][]{{"S*", "version"}, {"N4", "_reserve_1"}, {"S8", "id1"}, {"N4", "crc1Pos"}, {"N2", "year"}, {"N1", "month"}, {"N1", "day"}, {"N1", "_reserve_2"}, {"N1", "hour"}, {"N1", "minute"}, {"N1", "seconds"}, {"N4", "_reserve_3"}, {"S4", "id2"}, {"N4", "capability"}, {"N4", "crc2Pos"}, {"N4", "attrPos"}, {"Z*", "firstHome"}, {"Z*", "firstDevice"}, {"Z*", "firstMacro"}, {"N4", "attr"}, {"Z*", "macroPanel"}, {"N4", "_reserve_4"}};
    static final String[][] gray_timers = new String[][]{{"S*", "version"}, {"N4", "_reserve_1"}, {"S8", "id1"}, {"N4", "crc1Pos"}, {"N2", "year"}, {"N1", "month"}, {"N1", "day"}, {"N1", "_reserve_2"}, {"N1", "hour"}, {"N1", "minute"}, {"N1", "seconds"}, {"N4", "_reserve_3"}, {"S4", "id2"}, {"N4", "capability"}, {"N4", "crc2Pos"}, {"N4", "attrPos"}, {"Z*", "firstHome"}, {"Z*", "firstDevice"}, {"Z*", "firstMacro"}, {"Z*", "firstTimer"}, {"N4", "attr"}, {"Z*", "macroPanel"}, {"N4", "_reserve_4"}};
    static final String[][] color_notimers = new String[][]{{"S*", "version"}, {"N4", "_reserve_1"}, {"S8", "id1"}, {"N4", "crc1Pos"}, {"N2", "year"}, {"N1", "month"}, {"N1", "day"}, {"N1", "_reserve_2"}, {"N1", "hour"}, {"N1", "minute"}, {"N1", "seconds"}, {"N4", "_reserve_3"}, {"S4", "id2"}, {"N4", "capability"}, {"N4", "crc2Pos"}, {"N4", "attrPos"}, {"Z*", "firstHome"}, {"Z*", "firstDevice"}, {"Z*", "firstMacro"}, {"N4", "attr"}, {"Z*", "macroPanel"}, {"N1", "channelID"}};
    static final String[][] color_timers = new String[][]{{"S*", "version"}, {"N4", "_reserve_1"}, {"S8", "id1"}, {"N4", "crc1Pos"}, {"N2", "year"}, {"N1", "month"}, {"N1", "day"}, {"N1", "_reserve_2"}, {"N1", "hour"}, {"N1", "minute"}, {"N1", "seconds"}, {"N4", "_reserve_3"}, {"S4", "id2"}, {"N4", "capability"}, {"N4", "crc2Pos"}, {"N4", "attrPos"}, {"Z*", "firstHome"}, {"Z*", "firstDevice"}, {"Z*", "firstMacro"}, {"Z*", "firstTimer"}, {"N4", "attr"}, {"Z*", "macroPanel"}, {"N4", "_reserve_4"}, {"N3", "_reserve_5"}, {"N1", "channelID"}};
    String version;
    String id1 = "@\u00a5Z@_CCF";
    String id2 = "CCF\u0000";
    int crc1Pos;
    int crc2Pos;
    int year;
    int month;
    int day;
    int hour;
    int minute;
    int seconds;
    int capability;
    int attrPos;
    int attr;
    CCFDevice firstHome;
    CCFDevice firstDevice;
    CCFDevice firstMacro;
    CCFTimer firstTimer;
    CCFPanel macroPanel;
    int channelID;
    int _reserve_1;
    int _reserve_2;
    int _reserve_3;
    int _reserve_4;
    int _reserve_5;
    int _reserve_6;
    private CCFPanel eggDVD;
    private String[][] detected;
    private CCFColor[] colorMap = CCFColor.defaultMap;

    CCFHeader() {
        this.clear();
    }

    CCFColor getTransparentColor() {
        return CCFColor.getColor(this._reserve_2);
    }

    void setTransparentColor(CCFColor cCFColor) {
        this._reserve_2 = cCFColor.getColorIndex();
    }

    boolean isTransparentColor(CCFColor cCFColor) {
        return cCFColor.getColorIndex() == this._reserve_2;
    }

    void setScreenSize(int n, int n2) {
        this._reserve_3 = (n & 0xFFFF) << 16 | n2 & 0xFFFF;
    }

    Dimension getScreenSize(Dimension dimension) {
        int n = this._reserve_3 >>> 16 & 0xFFFF;
        int n2 = this._reserve_3 & 0xFFFF;
        if (n > 0 && n2 > 0) {
            return new Dimension(n, n2);
        }
        return dimension;
    }

    CCFColor[] getColorMap() {
        return this.colorMap;
    }

    void setColorMap(CCFColor[] cCFColorArray) {
        this.colorMap = cCFColorArray;
    }

    void clear() {
        this.version = "Tonto v" + Tonto.version();
        this.capability = 0;
        this.attrPos = 64;
        this.firstHome = new CCFDevice(this);
        this.firstHome.name = "HOME";
        this.firstHome.firstPanel = new CCFPanel("Home", this.firstHome);
        this.firstDevice = null;
        this.firstMacro = null;
        this.firstTimer = null;
        this.macroPanel = new CCFPanel("macro", this);
        this.attr = 4;
        this.detected = gray_timers;
    }

    void setFactoryCCF(boolean bl) {
        this.attr = bl ? (this.attr |= 1) : (this.attr &= 0xFFFFFFFE);
    }

    void setConfigReadOnly(boolean bl) {
        this.attr = bl ? (this.attr |= 2) : (this.attr &= 0xFFFFFFFD);
    }

    void setHomeReadOnly(boolean bl) {
        this.attr = bl ? (this.attr |= 4) : (this.attr &= 0xFFFFFFFB);
    }

    boolean isFactoryCCF() {
        return (this.attr & 1) == 1;
    }

    boolean isConfigReadOnly() {
        return (this.attr & 2) == 2;
    }

    boolean isHomeReadOnly() {
        return (this.attr & 4) == 4;
    }

    void setEggDVD(CCFPanel cCFPanel) {
        this.eggDVD = cCFPanel;
    }

    CCFPanel getEggDVD() {
        return this.eggDVD;
    }

    @Override
    String describe() {
        return this.version + "," + this.year + "-" + this.month + "-" + this.day + "," + this.hour + ":" + this.minute + ":" + this.seconds;
    }

    boolean hasUDB() {
        return CCFHeader.hasUDB(this.capability);
    }

    boolean hasTimers() {
        return CCFHeader.hasTimers(this.capability);
    }

    boolean hasColor() {
        return CCFHeader.hasColor(this.capability);
    }

    boolean isCustom() {
        return this.capability == 16909057;
    }

    boolean isMarantz() {
        return this.isNewMarantz() || this.isOldMarantz();
    }

    boolean isNewMarantz() {
        return CCFHeader.isNewMarantz(this.capability);
    }

    boolean isOldMarantz() {
        return CCFHeader.isOldMarantz(this.capability);
    }

    static boolean hasTimers(int n) {
        return (n & 0x20000) == 131072;
    }

    static boolean hasUDB(int n) {
        return (n & 0x40000) == 262144 || CCFHeader.hasCustom(n);
    }

    static boolean hasColor(int n) {
        return (n & 0x100) == 256;
    }

    static boolean hasCustom(int n) {
        return (n & 0x1020301) == 16909057;
    }

    static boolean isOldMarantz(int n) {
        return n == 1;
    }

    static boolean isNewMarantz(int n) {
        return (n & 0x800) == 2048;
    }

    void setCapability(int n) {
        this.capability = n;
        this.attr &= 7;
        if (CCFHeader.isNewMarantz(n)) {
            this.capability &= 0xFFFF;
        }
        if (this.hasColor()) {
            this.detected = color_timers;
            this.attrPos = 64;
            this._reserve_4 = 0;
        } else {
            this.detected = gray_timers;
            this.attrPos = 64;
            this._reserve_4 = 0;
        }
        this.log(2, "set capability cap=" + this.capability + " ap=" + this.attrPos + " v4=" + this._reserve_4);
    }

    @Override
    void checkVersion() {
    }

    @Override
    void preEncode(CCFNodeState cCFNodeState) {
        if (!this.isCustom()) {
            this.macroPanel.next = null;
        }
    }

    @Override
    void preDecode(CCFNodeState cCFNodeState) {
        BufferedFile bufferedFile = cCFNodeState.buffer();
        long l = bufferedFile.getFilePointer();
        bufferedFile.seek(36L);
        this.capability = bufferedFile.getInt();
        int n = bufferedFile.getInt();
        this.attrPos = bufferedFile.getInt();
        if (this.hasColor()) {
            if (this.attrPos == 64) {
                this.detected = color_timers;
            } else {
                debug.log(2, "header claims timers but attr pos mismatch @ " + this.attrPos);
                this.detected = color_notimers;
            }
        } else if (this.attrPos == 64) {
            this.detected = gray_timers;
        } else {
            debug.log(2, "header claims timers but attr pos mismatch @ " + this.attrPos);
            this.detected = gray_notimers;
        }
        bufferedFile.seek(l);
    }

    @Override
    void postDecode(CCFNodeState cCFNodeState) {
        this.printSummary();
        if (this.crc1Pos != this.crc2Pos) {
            this.log(1, "ccf: crc position mismatch " + CCFHeader.hex(this.crc1Pos) + " != " + CCFHeader.hex(this.crc2Pos), cCFNodeState);
        }
        if (this.macroPanel == null) {
            this.macroPanel = new CCFPanel("macro", this);
        }
        this.setCapability(this.capability);
    }

    void printSummary() {
        ProntoModel[] prontoModelArray = ProntoModel.getModelByCapability(this.capability);
        if (prontoModelArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer("header type = ");
            for (int i = 0; i < prontoModelArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(prontoModelArray[i].getName());
            }
            this.log(1, stringBuffer.toString());
        } else {
            this.log(1, "header capa = " + CCFHeader.get32Bits(this.capability) + " (" + Util.toHex(this.capability) + ")");
            this.log(1, "header timer=" + CCFHeader.hasTimers(this.capability) + " color=" + CCFHeader.hasColor(this.capability) + " attrpos=" + this.attrPos + " end=" + this._reserve_4);
        }
        this.log(2, "header attr = " + CCFHeader.get32Bits(this.attr) + " (" + Util.toHex(this.attr) + ")");
    }

    String summary() {
        return CCFHeader.get32Bits(this.capability) + " " + CCFHeader.get32Bits(this.attr) + " " + CCFHeader.get16Bits(this._reserve_4);
    }

    @Override
    String[][] getEncodeTable() {
        return this.detected;
    }

    @Override
    String[][] getDecodeTable() {
        return this.detected;
    }

    @Override
    void buildTree(CCFNode cCFNode) {
        this.buildDeviceTree(this.firstHome);
        this.buildDeviceTree(this.firstDevice);
        this.buildDeviceTree(this.firstMacro);
        CCFPanel cCFPanel = this.macroPanel;
        while (cCFPanel != null) {
            cCFPanel.buildTree(this);
            cCFPanel = cCFPanel.next;
        }
    }

    private void buildDeviceTree(CCFDevice cCFDevice) {
        while (cCFDevice != null) {
            cCFDevice.buildTree(this);
            cCFDevice = cCFDevice.getNextDevice();
        }
    }

    void insertBefore(CCFDevice cCFDevice, CCFDevice cCFDevice2) {
        if (this.firstHome == cCFDevice) {
            cCFDevice2.buildTree(this);
            cCFDevice2.next = cCFDevice;
            this.firstHome = cCFDevice2;
            return;
        }
        if (this.firstDevice == cCFDevice) {
            cCFDevice2.buildTree(this);
            cCFDevice2.next = cCFDevice;
            this.firstDevice = cCFDevice2;
            return;
        }
        if (this.firstMacro == cCFDevice) {
            cCFDevice2.buildTree(this);
            cCFDevice2.next = cCFDevice;
            this.firstMacro = cCFDevice2;
            return;
        }
        if (this.checkInsertBefore(this.firstHome, cCFDevice, cCFDevice2)) {
            return;
        }
        if (this.checkInsertBefore(this.firstDevice, cCFDevice, cCFDevice2)) {
            return;
        }
        if (this.checkInsertBefore(this.firstMacro, cCFDevice, cCFDevice2)) {
            return;
        }
    }

    boolean checkInsertBefore(CCFDevice cCFDevice, CCFDevice cCFDevice2, CCFDevice cCFDevice3) {
        if (cCFDevice == null) {
            return false;
        }
        while (cCFDevice.next != cCFDevice2) {
            if (cCFDevice.next == null) {
                return false;
            }
            cCFDevice = cCFDevice.next;
        }
        cCFDevice3.buildTree(this);
        cCFDevice3.next = cCFDevice2;
        cCFDevice.next = cCFDevice3;
        return true;
    }

    CCFDevice delete(CCFDevice cCFDevice) {
        if (this.firstHome == cCFDevice) {
            this.firstHome = cCFDevice.next;
            cCFDevice.next = null;
            return this.firstHome;
        }
        if (this.firstDevice == cCFDevice) {
            this.firstDevice = cCFDevice.next;
            cCFDevice.next = null;
            return this.firstDevice;
        }
        if (this.firstMacro == cCFDevice) {
            this.firstMacro = cCFDevice.next;
            cCFDevice.next = null;
            return this.firstMacro;
        }
        if (this.checkDelete(this.firstHome, cCFDevice)) {
            return this.firstHome;
        }
        if (this.checkDelete(this.firstDevice, cCFDevice)) {
            return this.firstDevice;
        }
        if (this.checkDelete(this.firstMacro, cCFDevice)) {
            return this.firstMacro;
        }
        return null;
    }

    CCFDevice createDevice() {
        return new CCFDevice(this);
    }

    private boolean checkDelete(CCFDevice cCFDevice, CCFDevice cCFDevice2) {
        if (cCFDevice == null || cCFDevice2 == null) {
            return false;
        }
        while (cCFDevice != null && cCFDevice.next != cCFDevice2) {
            cCFDevice = cCFDevice.next;
        }
        if (cCFDevice != null && cCFDevice.next == cCFDevice2) {
            cCFDevice.next = cCFDevice2.next;
            cCFDevice2.next = null;
            return true;
        }
        return false;
    }

    boolean isHomeDevice(CCFDevice cCFDevice) {
        return this.inDeviceList(this.firstHome, cCFDevice);
    }

    boolean isNormalDevice(CCFDevice cCFDevice) {
        return this.inDeviceList(this.firstDevice, cCFDevice);
    }

    boolean isMacroDevice(CCFDevice cCFDevice) {
        return this.inDeviceList(this.firstMacro, cCFDevice);
    }

    CCFPanel masterTemplate() {
        return this.macroPanel;
    }

    CCFPanel deviceTemplate() {
        return this.macroPanel.next;
    }

    CCFPanel macroTemplate() {
        return this.macroPanel.next == null ? null : this.macroPanel.next.next;
    }

    private boolean inDeviceList(CCFDevice cCFDevice, CCFDevice cCFDevice2) {
        if (cCFDevice == null || cCFDevice2 == null) {
            return false;
        }
        while (cCFDevice != null && cCFDevice != cCFDevice2) {
            cCFDevice = cCFDevice.next;
        }
        return cCFDevice == cCFDevice2;
    }
}

