/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CCFHeader;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFNodeState;
import com.neuron.irdb.impl.ProntoConstants;

public class CCFIRCode
extends CCFNode
implements ProntoConstants {
    private static final String[][] codec = new String[][]{{"N2", "size"}, {"S*", "name"}, {"B+", "data", "size", "-6"}};
    int size;
    String name;
    byte[] data;
    private boolean hasUDB;

    CCFIRCode() {
    }

    public CCFIRCode(CCFHeader cCFHeader) {
        this.setHeader(cCFHeader);
        this.hasUDB = cCFHeader.hasUDB();
    }

    public CCFIRCode(CCFHeader cCFHeader, String string) {
        this(cCFHeader, "Learned", string);
    }

    public CCFIRCode(CCFHeader cCFHeader, String string, String string2) {
        this(cCFHeader);
        this.setName(string);
        this.setCode(string2);
    }

    @Override
    int getLength() {
        CCFHeader cCFHeader = this.getHeader();
        if (cCFHeader == null) {
            return super.getLength();
        }
        return super.getLength() + (cCFHeader.hasUDB() && !this.hasUDB ? 6 : 0);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setUDB(boolean bl) {
        if (bl == this.hasUDB || this.data == null) {
            return;
        }
        if (bl) {
            debug.log(3, "ir convert v1 to v2 " + this);
            byte[] byArray = new byte[this.data.length + 6];
            System.arraycopy(this.data, 0, byArray, 6, this.data.length);
            this.setData(byArray);
        } else {
            debug.log(3, "ir convert v2 to v1 " + this);
            byte[] byArray = new byte[this.data.length - 6];
            System.arraycopy(this.data, 6, byArray, 0, byArray.length);
            this.setData(byArray);
        }
        this.hasUDB = bl;
    }

    public String getCode() {
        if (this.data == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.data.length; ++i) {
            int n = this.data[i] & 0xFF;
            if (n <= 15) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n));
            if (i % 2 != 1 || i <= 0 || i >= this.data.length - 1) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public void setCode(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < string.length(); ++n) {
            if (Character.isWhitespace(string.charAt(n))) continue;
            stringBuffer.append(string.charAt(n));
        }
        this.setData(new byte[stringBuffer.length() / 2]);
        for (n = 0; n < this.data.length; ++n) {
            this.data[n] = (byte)Integer.parseInt(stringBuffer.substring(n * 2, n * 2 + 2), 16);
        }
    }

    boolean hasUDB() {
        return this.hasUDB;
    }

    byte[] getData() {
        return this.data;
    }

    void setData(byte[] byArray) {
        this.data = byArray;
        this.size = byArray.length + 6;
    }

    @Override
    String describe() {
        return "IR," + this.name + "," + this.size + "," + (this.hasUDB ? "udb" : "noudb");
    }

    @Override
    public void checkVersion() {
    }

    @Override
    public void preEncode(CCFNodeState cCFNodeState) {
        this.setUDB(this.getHeader().hasUDB());
    }

    @Override
    public void preDecode(CCFNodeState cCFNodeState) {
    }

    @Override
    public void postDecode(CCFNodeState cCFNodeState) {
        this.hasUDB = cCFNodeState.getHeader().hasUDB();
        if (this.data == null) {
            throw new NullPointerException("IR data is null");
        }
        if (this.name == null) {
            this.name = "IR Code";
        }
    }

    @Override
    String[][] getEncodeTable() {
        return codec;
    }

    @Override
    String[][] getDecodeTable() {
        return codec;
    }

    @Override
    void buildTree(CCFNode cCFNode) {
        this.setParent(cCFNode);
    }
}

