/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import Acme.JPM.Encoders.GifEncoder;
import com.neuron.app.tonto.CCFColor;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFNodeState;
import com.neuron.app.tonto.Util;
import com.neuron.app.tonto.ui.PNGImageProducer;
import com.neuron.io.ByteOutputBuffer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import osbaldeston.image.BMP;

public class CCFIcon
extends CCFNode {
    public static final int MODE_2BIT = 1;
    public static final int MODE_8BIT = 2;
    public static final int MODE_32BIT = 3;
    private static Hashtable cache = new Hashtable();
    private static final int FG_MASK = 1536;
    private static final int BG_MASK = 6144;
    private static final int COLOR_4 = 256;
    private static final int COLOR_256 = 1793;
    private static final int COLOR_FULL = 1921;
    private static final int COMPRESS = 32768;
    private static final String[][] codec_normal = new String[][]{{"N2", "size", "+"}, {"N2", "width"}, {"N2", "height"}, {"N2", "type", "+"}, {"B+", "data", "size", "-8"}};
    private static final String[][] codec_custom = new String[][]{{"N4", "size"}, {"N2", "width"}, {"N2", "height"}, {"N2", "type", "+"}, {"B+", "data", "size", "-10"}};
    private static String[][] codec = codec_normal;
    int size;
    int width;
    int height;
    int type;
    byte[] data;
    private Icon icon;
    private ImageProducer image;

    CCFIcon() {
    }

    CCFIcon(CCFNode cCFNode) {
        this.setParent(cCFNode);
    }

    @Override
    int getLength() {
        int n = super.getLength();
        return n;
    }

    @Override
    public String toString() {
        return "Icon" + CCFIcon.get16Bits(this.type) + "(" + this.width + "x" + this.height + ")=" + this.size;
    }

    static int getGray(int n) {
        return CCFColor.getAWTColor(n, false).getRGB();
    }

    static int getRGB(int n) {
        return CCFColor.getAWTColor(n, true).getRGB();
    }

    public static CCFIcon create(String string, int n) throws IOException {
        return CCFIcon.create(Util.readFile(string), n);
    }

    public static CCFIcon create(InputStream inputStream, int n) throws IOException {
        return CCFIcon.create(Util.readFully(inputStream), n);
    }

    public static CCFIcon create(byte[] byArray, int n) throws IOException {
        if (byArray[0] == 66 && byArray[1] == 77) {
            return CCFIcon.create(new BMP(new ByteArrayInputStream(byArray)).getImage(), n);
        }
        if (byArray[0] == 137 && byArray[1] == 80 && byArray[2] == 78 && byArray[3] == 71) {
            return CCFIcon.create(Toolkit.getDefaultToolkit().createImage(new PNGImageProducer(new ByteArrayInputStream(byArray))), n);
        }
        return CCFIcon.create(Toolkit.getDefaultToolkit().createImage(byArray), n);
    }

    public static CCFIcon create(Image image, int n) {
        CCFIcon cCFIcon = (CCFIcon)cache.get(image);
        if (cCFIcon != null) {
            return cCFIcon;
        }
        cCFIcon = new CCFIcon();
        cCFIcon.setFromImage(image, n, false);
        cache.put(image, cCFIcon);
        return cCFIcon;
    }

    public void saveGIF(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.saveGIF(fileOutputStream);
        fileOutputStream.close();
    }

    public void saveGIF(OutputStream outputStream) throws IOException {
        new GifEncoder(this.getImageProducer(), outputStream).encode();
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    void checkVersion() {
        if (this.getHeader().isCustom()) {
            codec = codec_custom;
            this.size = this.data != null ? this.data.length + 10 : 10;
        } else {
            codec = codec_normal;
            this.size = this.data != null ? this.data.length + 8 : 8;
        }
    }

    @Override
    void preEncode(CCFNodeState cCFNodeState) {
        this.checkVersion();
    }

    @Override
    void preDecode(CCFNodeState cCFNodeState) {
        this.checkVersion();
    }

    @Override
    void postDecode(CCFNodeState cCFNodeState) {
        if (this.data == null) {
            throw new NullPointerException("icon data is null");
        }
        this.width &= 0xFFFF;
        this.height &= 0xFFFF;
        if (this.width > 2000 || this.height > 2000) {
            this.log(1, "trimming oversized icon: " + this.describe());
            this.width = Math.min(this.width, 2000);
            this.height = Math.min(this.height, 2000);
        }
    }

    @Override
    String[][] getEncodeTable() {
        return codec;
    }

    @Override
    String[][] getDecodeTable() {
        return codec;
    }

    @Override
    void buildTree(CCFNode cCFNode) {
    }

    @Override
    String describe() {
        return "Icon," + this.width + "x" + this.height + "," + CCFIcon.get16Bits(this.type) + "," + (this.data != null ? this.data.length : -1) + ",(" + (this.isCompressed() ? "compressed " : "") + (this.isFullColor() ? "fullColor" : (this.isColor() ? "color" : (this.isGray() ? "gray" : "b&w"))) + ")";
    }

    private void setImage(int n, int n2, byte[] byArray, boolean bl, boolean bl2) {
        this.setImage(n, n2, byArray, (bl ? 32768 : 0) | (bl2 ? 1793 : 256));
    }

    private void setImage(int n, int n2, byte[] byArray, int n3) {
        this.width = n;
        this.height = n2;
        this.type = n3;
        this.setData(byArray);
    }

    private void setFullImage(int n, int n2, byte[] byArray, boolean bl) {
        this.width = n;
        this.height = n2;
        this.type = 1921;
        this.setData(byArray);
    }

    private void setData(byte[] byArray) {
        this.data = byArray;
        this.size = byArray.length + (this.isFullColor() ? 10 : 8);
    }

    public void setCompressed(boolean bl) {
        if (!this.isCompressible() || this.isCompressed() == bl) {
            return;
        }
        this.setFromImage(Toolkit.getDefaultToolkit().createImage(this.getImageProducer()), this.isFullColor() ? 3 : (this.isColor() ? 2 : 1), bl);
    }

    public boolean isCompressible() {
        return this.isFullColor() || this.isGray() && !this.isColor();
    }

    public boolean isCompressed() {
        return (this.type & 0x8000) == 32768;
    }

    public boolean isFullColor() {
        return (this.type & 0x781) == 1921;
    }

    public boolean isColor() {
        return (this.type & 0x701) == 1793;
    }

    public boolean isGray() {
        return (this.type & 0x100) == 256;
    }

    public boolean isBW() {
        return !this.isGray() && !this.isColor() && !this.isFullColor();
    }

    public void clearCache() {
        this.icon = null;
        this.image = null;
    }

    public void convertToGray() {
        if (!this.isColor()) {
            return;
        }
        debug.log(3, "converting " + this + " to gray");
        this.create4Color(this.width, this.height, this.getRGBImage(), false);
        this.clearCache();
    }

    public void convertToColor() {
        if (this.isColor()) {
            return;
        }
        CCFColor[] cCFColorArray = this.getHeader().getColorMap();
        debug.log(3, "converting " + this + " to color");
        int[] nArray = this.getRGBImage();
        int[] nArray2 = new int[]{cCFColorArray[0].getAWTColor(true).getRGB(), cCFColorArray[1].getAWTColor(true).getRGB(), cCFColorArray[2].getAWTColor(true).getRGB(), cCFColorArray[3].getAWTColor(true).getRGB()};
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            nArray[i] = CCFColor.grayToRGB(nArray[i], nArray2);
        }
        this.create256Color(this.width, this.height, nArray, false);
        this.clearCache();
    }

    public Icon getIcon(Component component) {
        if (this.icon == null) {
            this.icon = new ImageIcon(component.createImage(this.getImageProducer()));
        }
        return this.icon;
    }

    Image getImage(Component component) {
        return component.createImage(this.getImageProducer());
    }

    ImageProducer getImageProducer() {
        if (this.image == null) {
            this.image = new MemoryImageSource(this.width, this.height, this.getRGBImage(), 0, this.width);
        }
        return this.image;
    }

    public static CCFIcon composite(CCFIcon cCFIcon, CCFIcon cCFIcon2) {
        if (cCFIcon == null) {
            return cCFIcon2;
        }
        int n = cCFIcon.width;
        int n2 = cCFIcon.height;
        int[] nArray = cCFIcon.getRGBImage();
        int[] nArray2 = cCFIcon2.getRGBImage();
        int n3 = Math.min(nArray.length, nArray2.length);
        int n4 = nArray[0];
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] != n4) continue;
            nArray[i] = nArray2[i];
        }
        CCFIcon cCFIcon3 = new CCFIcon();
        switch (cCFIcon.type & 0x781) {
            case 1921: {
                cCFIcon3.createFullColor(n, n2, nArray);
                break;
            }
            case 1793: {
                cCFIcon3.create256Color(n, n2, nArray, false);
                break;
            }
            case 256: {
                cCFIcon3.create4Color(n, n2, nArray, false);
                break;
            }
        }
        return cCFIcon3;
    }

    int[] getRGBImage() {
        switch (this.type & 0x781) {
            case 1921: {
                return this.loadFullColor(this.isCompressed());
            }
            case 1793: {
                return this.load256Color(this.isCompressed());
            }
            case 256: {
                return this.load4Color(this.isCompressed());
            }
        }
        return this.load2Color(this.type >> 9 & 3, this.type >> 11 & 3);
    }

    private int rgbToGrayIndex(int n) {
        return CCFColor.rgbToGrayIndex(n);
    }

    void setFromImage(Image image, int n, boolean bl) {
        if (image == null) {
            debug.log(0, "unable to load!");
        } else {
            MediaTracker mediaTracker = new MediaTracker(new Frame());
            mediaTracker.addImage(image, 1);
            try {
                mediaTracker.waitForAll();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            int n2 = image.getWidth(null);
            int n3 = image.getHeight(null);
            int[] nArray = new int[n2 * n3];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n2, n3, nArray, 0, n2);
            try {
                pixelGrabber.grabPixels();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                throw new RuntimeException("image load aborted");
            }
            switch (n) {
                case 1: {
                    this.create4Color(n2, n3, nArray, bl);
                    break;
                }
                case 2: {
                    this.create256Color(n2, n3, nArray, bl);
                    break;
                }
                case 3: {
                    this.createFullColor(n2, n3, nArray);
                    break;
                }
            }
        }
        this.clearCache();
    }

    private void create4Color(int n, int n2, int[] nArray, boolean bl) {
        if (bl) {
            this.create4ColorCompressed(n, n2, nArray);
            return;
        }
        ColorModel colorModel = ColorModel.getRGBdefault();
        int n3 = n / 4 + (n % 4 > 0 ? 1 : 0);
        int n4 = n3 % 2;
        int n5 = (n3 += n4) * 4;
        byte[] byArray = new byte[n3 * n2];
        for (int i = 0; i < nArray.length; ++i) {
            int n6 = i % n;
            int n7 = (i / n * n5 + n6) / 4;
            int n8 = this.rgbToGrayIndex(nArray[i]);
            int n9 = n7;
            byArray[n9] = (byte)(byArray[n9] | (n8 & 3) << (3 - n6 % 4) * 2);
        }
        this.setImage(n, n2, byArray, false, false);
    }

    private void create4ColorCompressed(int n, int n2, int[] nArray) {
        int n3 = 0;
        byte[] byArray = new byte[n * n2 / 2];
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5;
            int n6 = nArray[n4];
            if (n4 + 3 < nArray.length && n6 == nArray[n4 + 1] && n6 == nArray[n4 + 2] && n6 == nArray[n4 + 3]) {
                for (n5 = n4 + 3; n5 < nArray.length && n5 - n4 < 32 && nArray[n5] == n6; ++n5) {
                }
                byArray[n3] = (byte)(0x80 | this.rgbToGrayIndex(n6) | n5 - n4 - 4 << 2);
                n4 = n5;
            } else {
                for (n5 = 0; n5 < 3 && n5 + n4 < nArray.length; ++n5) {
                    int n7 = n3;
                    byArray[n7] = (byte)(byArray[n7] | this.rgbToGrayIndex(nArray[n4 + n5]) << (2 - n5) * 2);
                }
                n4 += n5;
            }
            ++n3;
        }
        n3 += n3 % 2;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        this.setImage(n, n2, byArray2, true, false);
    }

    private void create256Color(int n, int n2, int[] nArray, boolean bl) {
        if (bl) {
            this.create256ColorCompressed(n, n2, nArray);
            return;
        }
        ColorModel colorModel = ColorModel.getRGBdefault();
        int n3 = nArray.length % 16;
        byte[] byArray = new byte[nArray.length + (n3 > 0 ? 16 - n3 : 0)];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)CCFColor.getColorFromRGB(colorModel.getRed(nArray[i]), colorModel.getGreen(nArray[i]), colorModel.getBlue(nArray[i]));
        }
        this.setImage(n, n2, byArray, false, true);
    }

    private void create256ColorCompressed(int n, int n2, int[] nArray) {
        ColorModel colorModel = ColorModel.getRGBdefault();
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)CCFColor.getColorFromRGB(colorModel.getRed(nArray[i]), colorModel.getGreen(nArray[i]), colorModel.getBlue(nArray[i]));
        }
        ByteOutputBuffer byteOutputBuffer = new ByteOutputBuffer();
        boolean bl = nArray.length % 2 == 1;
        int n3 = 0;
        int n4 = nArray.length - (bl ? 9 : 8);
        try {
            int n5;
            Object object;
            Object object2;
            int n6 = 0;
            while (n3 < nArray.length) {
                object2 = new Segment(byArray, n3, n4);
                object = new Segment(byArray, n3 + ((Segment)object2).len, n4);
                if ((((Segment)object2).rle || ((Segment)object).rle) && ((Segment)object2).len > 0 && ((Segment)object).len > 0) {
                    byteOutputBuffer.write((byte)((((Segment)object2).rle ? 0 : 128) + ((Segment)object2).len / 2));
                    byteOutputBuffer.write((byte)((((Segment)object).rle ? 0 : 128) + ((Segment)object).len / 2));
                    ((Segment)object2).write(byteOutputBuffer);
                    ((Segment)object).write(byteOutputBuffer);
                    n3 += ((Segment)object2).len + ((Segment)object).len;
                } else {
                    int n7;
                    n5 = ((Segment)object2).len + ((Segment)object).len;
                    if (n5 > 4) {
                        byteOutputBuffer.write(255);
                        byteOutputBuffer.write(n5 / 2 + 1);
                        for (n7 = n3; n7 < n5; ++n7) {
                            byteOutputBuffer.write(byArray[n7]);
                        }
                        if ((n3 += n5) < n4) continue;
                    }
                    if (bl) {
                        byteOutputBuffer.write(128 + (nArray.length - n3) / 2);
                        byteOutputBuffer.write(129);
                    } else {
                        byteOutputBuffer.write(255);
                        byteOutputBuffer.write((nArray.length - n3) / 2 + 1);
                    }
                    for (n7 = n3; n7 < nArray.length; ++n7) {
                        byteOutputBuffer.write(byArray[n7]);
                    }
                    byteOutputBuffer.write(0);
                    byteOutputBuffer.write(0);
                    break;
                }
                ++n6;
            }
            object2 = File.createTempFile("tonto-color", ".comp");
            object = new FileOutputStream((File)object2);
            ((FileOutputStream)object).write(byteOutputBuffer.toByteArray());
            n5 = byteOutputBuffer.size() % 16;
            if (n5 > 0) {
                byteOutputBuffer.write(new byte[16 - n5]);
            }
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        this.setImage(n, n2, byteOutputBuffer.toByteArray(), true, true);
    }

    private void createFullColor(int n, int n2, int[] nArray) {
        byte[] byArray = new byte[nArray.length * 4];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i * 4 + 0] = (byte)(nArray[i] >>> 24 & 0xFF);
            byArray[i * 4 + 1] = (byte)(nArray[i] >>> 16 & 0xFF);
            byArray[i * 4 + 2] = (byte)(nArray[i] >>> 8 & 0xFF);
            byArray[i * 4 + 3] = (byte)(nArray[i] >>> 0 & 0xFF);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setImage(n, n2, byteArrayOutputStream.toByteArray(), 34689);
    }

    int[] load2Color(int n, int n2) {
        int[] nArray = new int[this.width * this.height];
        int n3 = this.data.length / this.height * 8;
        int n4 = n3 - this.width;
        if (this.data == null || this.data.length == 0) {
            return nArray;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n5 = i % this.width;
            int n6 = (i / this.width * n3 + n5) / 8;
            int n7 = (this.data[n6] >> 7 - n5 % 8 & 1) == 1 ? n2 : n;
            nArray[i] = CCFIcon.getGray(n7);
        }
        return nArray;
    }

    int[] load4Color(boolean bl) {
        int[] nArray = new int[this.width * this.height];
        if (this.data == null || this.data.length == 0) {
            return nArray;
        }
        if (bl) {
            int n = 0;
            for (int i = 0; i < this.data.length; ++i) {
                byte by = this.data[i];
                if ((by & 0x80) > 0) {
                    int n2 = by & 3;
                    int n3 = (by >> 2 & 0x1F) + 4;
                    for (int j = 0; j < n3 && n < nArray.length; ++j) {
                        nArray[n++] = CCFIcon.getGray(n2);
                    }
                    continue;
                }
                if (n >= nArray.length - 3) continue;
                nArray[n++] = CCFIcon.getGray(by >> 4 & 3);
                nArray[n++] = CCFIcon.getGray(by >> 2 & 3);
                nArray[n++] = CCFIcon.getGray(by >> 0 & 3);
            }
        } else {
            int n;
            int n4;
            int n5 = this.data.length * 4 / this.height;
            int n6 = n5 - this.width;
            for (int i = 0; i < nArray.length && (n4 = (i / this.width * n5 + (n = i % this.width)) / 4) < this.data.length; ++i) {
                int n7 = this.data[n4] >> (3 - n % 4) * 2 & 3;
                nArray[i] = CCFIcon.getGray(n7);
            }
        }
        return nArray;
    }

    int[] load256Color(boolean bl) {
        if (bl) {
            return this.load256ColorCompressed();
        }
        int[] nArray = new int[this.width * this.height];
        if (this.data == null || this.data.length == 0) {
            return nArray;
        }
        if (nArray.length != this.data.length && this.data.length < nArray.length) {
            new Exception("array too small " + nArray.length + " > " + this.data.length).printStackTrace();
            return nArray;
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = CCFIcon.getRGB(this.data[i] & 0xFF);
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int[] load256ColorCompressed() {
        int n = this.width * this.height;
        int n2 = n % 16;
        int[] nArray = new int[n + 16 - n2];
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        if (this.data == null) return nArray;
        if (this.data.length == 0) {
            return nArray;
        }
        try {
            block2: while (n4 < nArray.length) {
                int n5;
                int n6;
                int n7;
                int n8 = this.data[n3++] & 0xFF;
                int n9 = this.data[n3++] & 0xFF;
                if (n8 == 0 && n9 == 0) {
                    return nArray;
                }
                if (n8 == 255 && n9 > 0) {
                    n9 = (n9 - 1) * 2;
                    n7 = 0;
                    while (true) {
                        if (n7 >= n9) continue block2;
                        nArray[n4++] = CCFIcon.getRGB(this.data[n3++]);
                        ++n7;
                    }
                }
                if (n8 > 127 && n9 == 129) {
                    n8 = (n8 - 128) * 2;
                    for (n7 = 0; n7 < n8; ++n7) {
                        nArray[n4++] = CCFIcon.getRGB(this.data[n3++]);
                    }
                    nArray[n4++] = CCFIcon.getRGB(this.data[n3++]);
                    continue;
                }
                if (n8 > 128 && n9 < 128) {
                    n8 = (n8 - 128) * 2;
                    for (n7 = 0; n7 < n8; ++n7) {
                        nArray[n4++] = CCFIcon.getRGB(this.data[n3++]);
                    }
                    if (n9 <= 0) continue;
                    n7 = CCFIcon.getRGB(this.data[n3++]);
                    n6 = CCFIcon.getRGB(this.data[n3++]);
                    n5 = 0;
                    while (true) {
                        if (n5 >= n9) continue block2;
                        nArray[n4++] = n7;
                        nArray[n4++] = n6;
                        ++n5;
                    }
                }
                if (n8 < 128 && n9 > 128) {
                    if (n8 > 0) {
                        n7 = CCFIcon.getRGB(this.data[n3++]);
                        n6 = CCFIcon.getRGB(this.data[n3++]);
                        for (n5 = 0; n5 < n8; ++n5) {
                            nArray[n4++] = n7;
                            nArray[n4++] = n6;
                        }
                    }
                    n9 = (n9 - 128) * 2;
                    n7 = 0;
                    while (true) {
                        if (n7 >= n9) continue block2;
                        nArray[n4++] = CCFIcon.getRGB(this.data[n3++]);
                        ++n7;
                    }
                }
                if (n8 < 128 && n9 < 128) {
                    if (n8 > 0) {
                        n7 = CCFIcon.getRGB(this.data[n3++]);
                        n6 = CCFIcon.getRGB(this.data[n3++]);
                        for (n5 = 0; n5 < n8; ++n5) {
                            nArray[n4++] = n7;
                            nArray[n4++] = n6;
                        }
                    }
                    if (n9 <= 0) continue;
                    n7 = CCFIcon.getRGB(this.data[n3++]);
                    n6 = CCFIcon.getRGB(this.data[n3++]);
                    n5 = 0;
                    while (true) {
                        if (n5 >= n9) continue block2;
                        nArray[n4++] = n7;
                        nArray[n4++] = n6;
                        ++n5;
                    }
                }
                new IllegalArgumentException("Unrecognized control: " + Integer.toHexString(n8) + " " + Integer.toHexString(n9)).printStackTrace();
                System.exit(0);
            }
            return nArray;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    int[] loadFullColor(boolean bl) {
        Object object;
        byte[] byArray = this.data;
        if (bl) {
            try {
                object = new GZIPInputStream(new ByteArrayInputStream(this.data));
                byArray = Util.readFully((InputStream)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = new int[byArray.length / 4];
        for (int i = 0; i < ((int[])object).length; ++i) {
            object[i] = (byArray[i * 4 + 0] & 0xFF) << 24 | (byArray[i * 4 + 1] & 0xFF) << 16 | (byArray[i * 4 + 2] & 0xFF) << 8 | (byArray[i * 4 + 3] & 0xFF) << 0;
        }
        return object;
    }

    private class Segment {
        private boolean rle;
        private int len;
        private int spos;
        private byte[] data;

        Segment(byte[] byArray, int n, int n2) {
            int n3;
            int n4;
            if (n >= n2) {
                return;
            }
            this.data = byArray;
            this.spos = n;
            if ((n4 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) == (n3 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF)) {
                while (n < n2 && n4 == n3 && n - this.spos < 256) {
                    n3 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                }
                this.rle = true;
                this.len = n - this.spos - 2;
            } else {
                int n5 = 0xFFFFFF;
                while (n < n2 && n4 != n3 && n - this.spos < 256) {
                    n4 = n3;
                    n3 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                }
                this.rle = false;
                this.len = n - this.spos - 4;
            }
        }

        void write(OutputStream outputStream) throws IOException {
            if (this.rle) {
                outputStream.write(this.data[this.spos]);
                outputStream.write(this.data[this.spos + 1]);
            } else {
                for (int i = this.spos; i < this.spos + this.len; ++i) {
                    outputStream.write(this.data[i]);
                }
            }
        }
    }
}

