/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.BufferedFile;
import com.neuron.app.tonto.CCFActionList;
import com.neuron.app.tonto.CCFChild;
import com.neuron.app.tonto.CCFDevice;
import com.neuron.app.tonto.CCFHeader;
import com.neuron.app.tonto.CCFNodeState;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.Debug;
import com.neuron.app.tonto.Util;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Hashtable;

public abstract class CCFNode
implements Cloneable {
    static Debug debug = Debug.getInstance("ccf");
    private static int nextZip = 0;
    private static Hashtable classCache = new Hashtable();
    private static final char BYTE_FIELD = 'B';
    private static final char NODE_FIELD = 'Z';
    private static final char INTEGER_FIELD = 'N';
    private static final char STRING_FIELD = 'S';
    private static final char IGNORE_FIELD = 'X';
    private static final char FIELD_PTR = '*';
    private static final char FIELD_COUNT = '+';
    public static final char TEXT_CENTER = '\u0000';
    public static final char TEXT_LEFT = '\u0001';
    public static final char TEXT_RIGHT = '\u0002';
    private int zipNum = nextZip++;
    private int filepos;
    private boolean fixedPos;
    private Hashtable cache;
    private CCFNode parent;
    private CCFHeader header;
    private static final String pad = "                                         ";

    CCFNode() {
        Hashtable hashtable = (Hashtable)classCache.get(this.getClass());
        if (hashtable == null) {
            hashtable = new Hashtable();
            classCache.put(this.getClass(), hashtable);
        }
        this.cache = hashtable;
    }

    final void setHeader(CCFHeader cCFHeader) {
        if (cCFHeader == null) {
            new Exception("set header to null").printStackTrace();
        }
        this.header = cCFHeader;
    }

    void setParent(CCFNode cCFNode) {
        this.parent = cCFNode;
        if (cCFNode instanceof CCFHeader) {
            this.setHeader((CCFHeader)cCFNode);
        } else if (cCFNode != null) {
            this.setHeader(cCFNode.getHeader());
        }
    }

    public CCFNode getParent() {
        return this.parent;
    }

    public CCFHeader getHeader() {
        if (this.header != null) {
            return this.header;
        }
        if (this instanceof CCFHeader) {
            return (CCFHeader)this;
        }
        CCFNode cCFNode = this.getParent();
        if (cCFNode == null) {
            return null;
        }
        return cCFNode.getHeader();
    }

    public CCFDevice getParentDevice() {
        if (this instanceof CCFDevice) {
            return (CCFDevice)this;
        }
        CCFNode cCFNode = this.getParent();
        if (cCFNode == null) {
            return null;
        }
        return cCFNode.getParentDevice();
    }

    public CCFPanel getParentPanel() {
        if (this instanceof CCFPanel) {
            return (CCFPanel)this;
        }
        CCFNode cCFNode = this.getParent();
        return cCFNode != null ? cCFNode.getParentPanel() : null;
    }

    boolean usingColor() {
        return this.getHeader().hasColor();
    }

    void setFixedPosition(boolean bl) {
        this.fixedPos = bl;
    }

    int getFilePosition() {
        return this.filepos;
    }

    void setFilePosition(int n) {
        this.filepos = n;
    }

    String getFieldName(int n) {
        return this.getDecodeTable()[n][1];
    }

    Field getField(String string) {
        if (string == null) {
            return null;
        }
        try {
            Field field = (Field)this.cache.get(string);
            if (field != null) {
                return field;
            }
            field = this.useParentFields() ? this.getClass().getSuperclass().getDeclaredField(string) : this.getClass().getDeclaredField(string);
            this.cache.put(string, field);
            return field;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw this.error(exception);
        }
    }

    Object get(String string) {
        try {
            return this.getField(string).get(this);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw this.error(exception);
        }
    }

    void set(String string, Object object) {
        try {
            this.getField(string).set(this, object);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw this.error(exception);
        }
    }

    String getEncodeField(int n) {
        return this.getEncodeTable()[n][1];
    }

    Object getEncodeValue(int n) {
        return this.get(this.getEncodeTable()[n][1]);
    }

    String getDecodeField(int n) {
        return this.getDecodeTable()[n][1];
    }

    Object getDecodeValue(int n) {
        return this.get(this.getDecodeTable()[n][1]);
    }

    int getDecodeValueLength(int n) {
        return ((Number)this.get(this.getDecodeTable()[n][2])).intValue() & 0xFFFFFFFF;
    }

    int getDecodeValueVariance(int n) {
        return Integer.parseInt(this.getDecodeTable()[n][3]);
    }

    CCFNode getClone() {
        try {
            CCFNode cCFNode = (CCFNode)this.clone();
            return cCFNode;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    CCFActionList getClone(CCFActionList cCFActionList) {
        if (cCFActionList != null) {
            return (CCFActionList)cCFActionList.getClone();
        }
        return null;
    }

    CCFChild[] getClone(CCFChild[] cCFChildArray) {
        if (cCFChildArray == null) {
            return null;
        }
        CCFChild[] cCFChildArray2 = new CCFChild[cCFChildArray.length];
        for (int i = 0; i < cCFChildArray.length; ++i) {
            cCFChildArray2[i] = (CCFChild)cCFChildArray[i].getClone();
        }
        return cCFChildArray2;
    }

    private boolean jumpDecode(int n, CCFNodeState cCFNodeState) {
        long l = cCFNodeState.buffer().getFilePointer();
        this.log(3, "jumpDecode(" + n + ") <- (" + l + ")");
        if (cCFNodeState.seek(n)) {
            this.decode(cCFNodeState);
            cCFNodeState.buffer().seek(l);
            return true;
        }
        this.error("attempt to read outside file bounds (" + CCFNode.hex(n) + ")");
        this.traceParents();
        return false;
    }

    private CCFNode readItem(CCFNodeState cCFNodeState, Class clazz) {
        return this.getItemByPos(cCFNodeState, (int)cCFNodeState.buffer().getFilePointer(), clazz, false);
    }

    CCFNode getItemByPos(CCFNodeState cCFNodeState, int n, Class clazz) {
        return this.getItemByPos(cCFNodeState, n, clazz, true);
    }

    private CCFNode getItemByPos(CCFNodeState cCFNodeState, int n, Class clazz, boolean bl) {
        if (!cCFNodeState.isValidPtr(n)) {
            this.error("invalid pointer (" + CCFNode.hex(n) + ") to " + Util.shortName(clazz) + " in " + this.describe());
            return null;
        }
        CCFNode cCFNode = cCFNodeState.getObjectAt(n);
        if (cCFNode != null) {
            if (!bl) {
                this.log(3, "**** skipping already read (" + cCFNode + ")", cCFNodeState);
                cCFNodeState.buffer().skipBytes(cCFNode.getLength());
            }
            return cCFNode;
        }
        try {
            cCFNode = (CCFNode)clazz.newInstance();
            cCFNode.setHeader(cCFNodeState.getHeader());
            cCFNode.checkVersion();
            cCFNodeState.putObjectAt(n, cCFNode);
        }
        catch (Exception exception) {
            this.error(exception);
            return null;
        }
        if (bl) {
            if (!cCFNode.jumpDecode(n, cCFNodeState)) {
                this.log(3, "**** removing invalid (" + cCFNode + "@" + n + ")", cCFNodeState);
                cCFNodeState.removeObjectAt(n);
                return null;
            }
        } else {
            cCFNode.decode(cCFNodeState);
        }
        return cCFNode;
    }

    int getLength(int n) {
        this.filepos = n;
        return this.getLength();
    }

    int getFieldLen(String[][] stringArray, int n) {
        char c = stringArray[n][0].charAt(0);
        char c2 = stringArray[n][0].charAt(1);
        if (c == 'X') {
            return 0;
        }
        if (c2 == '*') {
            return 4;
        }
        if (c2 == '+') {
            return 0;
        }
        if (c == 'S' || c == 'N') {
            return c2 - 48;
        }
        if (c == 'Z') {
            return 0;
        }
        throw this.error("unhandled encode option '" + c + "'");
    }

    int getLength() {
        int n = 0;
        String[][] stringArray = this.getEncodeTable();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            char c = stringArray[i][0].charAt(0);
            char c2 = stringArray[i][0].charAt(1);
            if (c == 'X') continue;
            if (c2 == '*') {
                n += 4;
                continue;
            }
            if (c2 == '+') {
                if (c == 'B') {
                    object = (byte[])this.getEncodeValue(i);
                    if (object == null) continue;
                    n += ((byte[])object).length;
                    continue;
                }
                if (c == 'Z') {
                    object = (CCFNode[])this.getEncodeValue(i);
                    for (int j = 0; object != null && j < ((byte[])object).length; ++j) {
                        n += ((CCFNode)object[j]).getLength(this.filepos + n);
                    }
                    continue;
                }
                throw this.error("unhandled encode option '" + c + "'");
            }
            if (c == 'S' || c == 'N') {
                n += c2 - 48;
                continue;
            }
            if (c == 'Z') {
                object = (CCFNode)this.getEncodeValue(i);
                if (object != null) {
                    n += object.getLength(this.filepos + n);
                    continue;
                }
                this.error("field is missing required node");
                continue;
            }
            throw this.error("unhandled encode option '" + c + "'");
        }
        return n;
    }

    void trace(int n, String[][] stringArray, int n2, Exception exception) {
        exception.printStackTrace();
        debug.log(0, "errstack @ " + CCFNode.hex(n) + " (" + this.myName() + "," + stringArray[n2][0] + "," + stringArray[n2][1] + ") (" + exception + ")");
        for (CCFNode cCFNode = this; cCFNode != null; cCFNode = cCFNode.getParent()) {
            debug.log(0, "  " + cCFNode.describe());
        }
    }

    void traceParents() {
        debug.log(0, "trace -->");
        for (CCFNode cCFNode = this; cCFNode != null; cCFNode = cCFNode.getParent()) {
            debug.log(0, "  " + CCFNode.rpad(cCFNode.myName(), 20) + " " + CCFNode.lpad(CCFNode.hex(cCFNode.hashCode()), 10) + " " + cCFNode.describe());
        }
    }

    long encode(CCFNodeState cCFNodeState) {
        return this.encode(cCFNodeState, true);
    }

    long encode(CCFNodeState cCFNodeState, boolean bl) {
        BufferedFile bufferedFile = cCFNodeState.buffer();
        long l = bufferedFile.getFilePointer();
        int n = 0;
        this.setHeader(cCFNodeState.getHeader());
        try {
            this.log(2, "encoding", cCFNodeState);
            bufferedFile.seek(this.filepos);
            this.preEncode(cCFNodeState);
            String[][] stringArray = this.getEncodeTable();
            block16: for (n = 0; n < stringArray.length; ++n) {
                char c = stringArray[n][0].charAt(0);
                char c2 = stringArray[n][0].charAt(1);
                Object object = null;
                try {
                    object = this.getEncodeValue(n);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
                this.log(3, "   >>  @ " + CCFNode.hex(this.filepos) + " (" + this.myName() + "," + stringArray[n][0] + "," + stringArray[n][1] + ") (" + object + ")");
                switch (c) {
                    case 'X': {
                        continue block16;
                    }
                    case 'B': {
                        bufferedFile.write((byte[])object);
                        continue block16;
                    }
                    case 'Z': {
                        int n2;
                        if (c2 == '*') {
                            CCFNode cCFNode = (CCFNode)object;
                            if (cCFNode != null) {
                                bufferedFile.putInt(cCFNode.filepos);
                                continue block16;
                            }
                            bufferedFile.putInt(0);
                            continue block16;
                        }
                        if (c2 == '+') {
                            CCFNode[] cCFNodeArray = (CCFNode[])object;
                            for (n2 = 0; cCFNodeArray != null && n2 < cCFNodeArray.length; ++n2) {
                                cCFNodeArray[n2].encode(cCFNodeState, false);
                            }
                            continue block16;
                        }
                        CCFNode cCFNode = (CCFNode)object;
                        cCFNode.encode(cCFNodeState, false);
                        continue block16;
                    }
                    case 'N': {
                        switch (c2) {
                            case '1': {
                                bufferedFile.putByte(((Number)object).intValue());
                                continue block16;
                            }
                            case '2': {
                                bufferedFile.putShort(((Number)object).intValue());
                                continue block16;
                            }
                            case '4': {
                                bufferedFile.putInt(((Number)object).intValue());
                                continue block16;
                            }
                        }
                        int n3 = c2 - 48;
                        int n2 = ((Number)object).intValue();
                        for (int i = 0; i < n3; ++i) {
                            bufferedFile.putByte(n2 >> (n3 - i) * 8 & 0xFF);
                        }
                        continue block16;
                    }
                    case 'S': {
                        String string = (String)object;
                        if (c2 == '*') {
                            bufferedFile.putInt(this.getStringEncodePos(cCFNodeState, string));
                            continue block16;
                        }
                        CCFNode.stringEncode(bufferedFile, string);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.error(exception);
            this.trace((int)l, this.getEncodeTable(), n, exception);
        }
        if (bl) {
            bufferedFile.seek(l);
        }
        return bufferedFile.getFilePointer();
    }

    int getStringEncodePos(CCFNodeState cCFNodeState, String string) {
        if (string == null) {
            return 0;
        }
        return (int)cCFNodeState.getStringLocation(string);
    }

    void decode(CCFNodeState cCFNodeState) {
        this.log(2, "begin decode", cCFNodeState);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            this.preDecode(cCFNodeState);
            BufferedFile bufferedFile = cCFNodeState.buffer();
            this.filepos = n2 = (int)bufferedFile.getFilePointer();
            String[][] stringArray = this.getDecodeTable();
            for (n = 0; n < stringArray.length; ++n) {
                Object object = null;
                char c = stringArray[n][0].charAt(0);
                char c2 = stringArray[n][0].charAt(1);
                String string = this.getDecodeField(n);
                Field field = this.getField(string);
                long l = bufferedFile.getFilePointer();
                int n4 = -1;
                switch (c) {
                    case 'B': {
                        int n5 = this.getDecodeValueLength(n);
                        if (stringArray[n].length > 3) {
                            n5 += this.getDecodeValueVariance(n);
                        }
                        byte[] byArray = new byte[n5];
                        bufferedFile.readFully(byArray);
                        object = byArray;
                        n3 += byArray.length;
                        break;
                    }
                    case 'Z': {
                        int n6;
                        Class<?> clazz = field.getType();
                        if (c2 == '*') {
                            int n7 = bufferedFile.getInt();
                            if (n7 > 0) {
                                cCFNodeState.deferResolve(this, string, n7, clazz);
                                n4 = n7;
                            }
                            n3 += 4;
                            break;
                        }
                        if (c2 == '+') {
                            CCFNode[] cCFNodeArray = (CCFNode[])Array.newInstance(clazz.getComponentType(), this.getDecodeValueLength(n));
                            for (n6 = 0; n6 < cCFNodeArray.length; ++n6) {
                                cCFNodeArray[n6] = this.readItem(cCFNodeState, clazz.getComponentType());
                                cCFNodeArray[n6].fixedPos = true;
                            }
                            object = cCFNodeArray;
                            n3 = (int)((long)n3 + (bufferedFile.getFilePointer() - l));
                            break;
                        }
                        if (c2 != '1') break;
                        CCFNode cCFNode = this.readItem(cCFNodeState, clazz);
                        cCFNode.fixedPos = true;
                        object = cCFNode;
                        n3 = (int)((long)n3 + (bufferedFile.getFilePointer() - l));
                        break;
                    }
                    case 'N': {
                        int n8;
                        int n6;
                        switch (c2) {
                            case '1': {
                                if (stringArray[n].length > 2) {
                                    object = new Integer(bufferedFile.getByte() & 0xFF);
                                    break;
                                }
                                object = new Integer(bufferedFile.getByte());
                                break;
                            }
                            case '2': {
                                if (stringArray[n].length > 2) {
                                    object = new Integer(bufferedFile.getShort() & 0xFFFF);
                                    break;
                                }
                                object = new Integer(bufferedFile.getShort());
                                break;
                            }
                            case '4': {
                                object = new Integer(bufferedFile.getInt());
                                break;
                            }
                            default: {
                                int n9 = c2 - 48;
                                n6 = 0;
                                for (n8 = 0; n8 < n9; ++n8) {
                                    n6 += (bufferedFile.getByte() & 0xFF) << (n9 - n8) * 8;
                                }
                                object = new Integer(n6);
                            }
                        }
                        n3 += c2 - 48;
                        break;
                    }
                    case 'S': {
                        int n8;
                        long l2 = -1L;
                        if (c2 == '*') {
                            n8 = bufferedFile.getInt();
                            object = cCFNodeState.getLocationString(n8);
                            if (object != null || n8 == 0) break;
                            l2 = bufferedFile.getFilePointer();
                            if ((long)n8 > bufferedFile.length()) {
                                object = null;
                                this.log(0, "attempt to read string outside of file bounds", cCFNodeState);
                            } else {
                                bufferedFile.seek(n8);
                                object = this.stringLengthDecode(bufferedFile);
                                cCFNodeState.putLocationString((String)object, n8);
                                bufferedFile.seek(l2);
                            }
                            n3 += 4;
                            break;
                        }
                        object = this.stringDecode(bufferedFile, (char)(c2 - 48));
                        n3 += c2 - 48;
                    }
                }
                if (debug.debug(3)) {
                    this.log(3, " >>  @ " + CCFNode.hex(bufferedFile.getFilePointer()) + " (" + this.myName() + "," + stringArray[n][0] + "," + stringArray[n][1] + ") " + "(" + (object == null ? Integer.toString(n4) : object) + ")");
                }
                field.set(this, object);
            }
        }
        catch (RuntimeException runtimeException) {
            this.trace(n2, this.getDecodeTable(), n, runtimeException);
        }
        catch (Exception exception) {
            this.error(exception);
            this.trace(n2, this.getDecodeTable(), n, exception);
        }
        this.postDecode(cCFNodeState);
        cCFNodeState.updateMeter(this, n3);
        this.log(3, "end decode", cCFNodeState);
    }

    String stringJumpDecode(int n, CCFNodeState cCFNodeState) {
        cCFNodeState.buffer().seek(n);
        return this.stringLengthDecode(cCFNodeState.buffer());
    }

    String stringLengthDecode(BufferedFile bufferedFile) {
        return this.stringDecode(bufferedFile, bufferedFile.read());
    }

    String stringDecode(BufferedFile bufferedFile, int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)bufferedFile.read();
        }
        return new String(cArray);
    }

    static void stringLengthEncode(BufferedFile bufferedFile, String string) {
        bufferedFile.write(string.length());
        CCFNode.stringEncode(bufferedFile, string);
    }

    static void stringEncode(BufferedFile bufferedFile, String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        for (int i = 0; i < cArray.length; ++i) {
            bufferedFile.write(cArray[i]);
        }
    }

    public String toString() {
        return this.myName();
    }

    String myName() {
        return this.cname() + "-" + CCFNode.hex(this.zipNum);
    }

    static final String lpad(String string, int n) {
        int n2 = string.length();
        if (n2 < n) {
            return pad.substring(0, n - n2) + string;
        }
        if (n2 > n) {
            return string.substring(0, n);
        }
        return string;
    }

    static final String rpad(String string, int n) {
        int n2 = string.length();
        if (n2 < n) {
            return string + pad.substring(0, n - n2);
        }
        if (n2 > n) {
            return string.substring(0, n);
        }
        return string;
    }

    static final String hex(int n) {
        return "0x" + Integer.toHexString(n);
    }

    static final String hex(long l) {
        return "0x" + Long.toHexString(l);
    }

    static final boolean hasBits(int n, int n2) {
        return (n & n2) == n2;
    }

    void dump() {
        debug.log(0, "--( dump : " + this + " )--");
        String[][] stringArray = this.getEncodeTable();
        int n = this.filepos;
        for (int i = 0; i < stringArray.length; ++i) {
            Field field = this.getField(this.getEncodeField(i));
            try {
                Object object = field.get(this);
                if (object instanceof Integer) {
                    object = CCFNode.hex((Integer)object);
                } else if (object == null) {
                    object = "<null>";
                } else if (object instanceof String) {
                    object = "'" + object + "'";
                }
                debug.log(0, CCFNode.lpad(CCFNode.hex(n), 7) + "  " + CCFNode.rpad(field.getName(), 15) + " " + object);
                n += this.getFieldLen(stringArray, i);
                continue;
            }
            catch (Exception exception) {
                debug.log(0, field.getName() + " = <inaccessible>");
            }
        }
    }

    void log(int n, String string) {
        debug.log(n, string);
    }

    void log(int n, String string, CCFNodeState cCFNodeState) {
        if (debug.debug(n)) {
            try {
                debug.log(n, string + " (" + this.myName() + ") @ " + CCFNode.hex(cCFNodeState.buffer().getFilePointer()));
            }
            catch (Exception exception) {
                debug.log(0, "** error tracing error **");
                debug.log(0, string + " (" + this.myName() + ") @ unknown");
                this.error(exception);
            }
        }
    }

    RuntimeException error(Exception exception) {
        this.log(0, "error -> " + exception.toString());
        return new RuntimeException(exception.getMessage());
    }

    RuntimeException error(String string) {
        this.log(0, "error -> " + string);
        return new RuntimeException(string);
    }

    void errorOn(boolean bl, String string) {
        if (bl) {
            this.error(string);
        }
    }

    String cname() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1);
    }

    static String get8BitSet(int n) {
        return "[" + CCFNode.get8Bits(n) + "]";
    }

    static String get32Bits(int n) {
        return "[" + CCFNode.get8Bits(n >> 24) + "," + CCFNode.get8Bits(n >> 16) + "," + CCFNode.get8Bits(n >> 8) + "," + CCFNode.get8Bits(n) + "]";
    }

    static String get16Bits(int n) {
        return "[" + CCFNode.get8Bits(n >> 8) + "," + CCFNode.get8Bits(n & 0xFF) + "]";
    }

    static String get8Bits(int n) {
        return CCFNode.getBit(n, 7) + CCFNode.getBit(n, 6) + CCFNode.getBit(n, 5) + CCFNode.getBit(n, 4) + CCFNode.getBit(n, 3) + CCFNode.getBit(n, 2) + CCFNode.getBit(n, 1) + CCFNode.getBit(n, 0);
    }

    static String getBit(int n, int n2) {
        return (n & 1 << n2) > 0 ? "O" : "-";
    }

    String describe() {
        return this.cname() + "@" + CCFNode.hex(this.filepos);
    }

    boolean useParentFields() {
        return false;
    }

    void encodePrep(CCFNodeState cCFNodeState, Hashtable hashtable) {
        String[][] stringArray = this.getEncodeTable();
        for (int i = 0; i < stringArray.length; ++i) {
            cCFNodeState.addField(this.getEncodeValue(i), hashtable, stringArray[i][0].charAt(1) == '*');
        }
    }

    abstract void checkVersion();

    abstract void preEncode(CCFNodeState var1);

    abstract void preDecode(CCFNodeState var1);

    abstract void postDecode(CCFNodeState var1);

    abstract String[][] getEncodeTable();

    abstract String[][] getDecodeTable();

    abstract void buildTree(CCFNode var1);
}

