/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.BufferedFile;
import com.neuron.app.tonto.CCFAction;
import com.neuron.app.tonto.CCFActionList;
import com.neuron.app.tonto.CCFButton;
import com.neuron.app.tonto.CCFChild;
import com.neuron.app.tonto.CCFDevice;
import com.neuron.app.tonto.CCFFrame;
import com.neuron.app.tonto.CCFHeader;
import com.neuron.app.tonto.CCFIRCode;
import com.neuron.app.tonto.CCFIcon;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.CCFTimer;
import com.neuron.app.tonto.CRC16;
import com.neuron.app.tonto.Debug;
import com.neuron.app.tonto.ITaskStatus;
import com.neuron.app.tonto.Util;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

final class CCFNodeState {
    private static Debug debug = Debug.getInstance("ccf");
    public static final int MAGIC = 1296849487;
    public static final int magicOffset = 8;
    CCFHeader head;
    private BufferedFile ra;
    private Hashtable cache;
    private Hashtable strings;
    private Stack resolveStack;
    private ITaskStatus status;
    private long ccflen;
    private long readbytes;
    private int lastPCT = -1;
    private Hashtable all;

    CCFNodeState(CCFHeader cCFHeader, ITaskStatus iTaskStatus) {
        this.head = cCFHeader;
        this.status = iTaskStatus;
        this.cache = new Hashtable();
        this.strings = new Hashtable();
        this.resolveStack = new Stack();
    }

    BufferedFile buffer() {
        return this.ra;
    }

    void updateMeter(Object object, int n) {
        this.readbytes += (long)n;
        if (this.ccflen > 0L) {
            this.setMeter((int)(this.readbytes * 100L / this.ccflen));
        }
    }

    void setMeter(ITaskStatus iTaskStatus) {
        this.status = iTaskStatus;
    }

    void setMeter(int n) {
        if (this.status != null && n != this.lastPCT) {
            this.status.taskStatus(Math.min(100, n), null);
            this.lastPCT = n;
        }
    }

    void notify(String string) {
        if (this.status != null) {
            this.status.taskNotify(string);
        }
    }

    private void addByClass(Hashtable hashtable, Vector vector, Class clazz) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (v.getClass() != clazz) continue;
            vector.addElement(v);
        }
    }

    boolean willEncode(CCFNode cCFNode) {
        if (cCFNode == null || this.all == null) {
            return true;
        }
        return this.all.get(cCFNode) != null;
    }

    byte[] encodeToBytes() throws IOException {
        this.ra = new BufferedFile();
        this.encode();
        return this.ra.toByteArray();
    }

    void encodeToFile(String string) throws IOException {
        File file = new File(string);
        File file2 = new File(string + ".tmp-" + (Util.time() & 0xFFFFL));
        debug.log(3, "encode: F=" + file + " T=" + file2);
        this.ra = new BufferedFile(file2.toString(), "rw");
        this.ra.setLength(0);
        this.encode();
        boolean bl = true;
        if (file.exists()) {
            File file3 = new File(string + ".old");
            debug.log(3, "encode: F=" + file + " T=" + file2 + " old=" + file3 + " :: old exists=" + file3.exists());
            if (file3.exists()) {
                file3.delete();
            }
            bl = file.renameTo(new File(string + ".old"));
            debug.log(3, "encode: rename = " + bl);
        }
        if (file2.length() < 75L) {
            throw new IOException("Unknown error writing new file");
        }
        if (!file2.renameTo(file)) {
            debug.log(3, "encode: unable to rename T to F");
            throw new IOException("Unable to rename temp to current");
        }
        if (!bl) {
            throw new IOException("Unable to rename previous file to .old");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encode() throws IOException {
        try {
            Object e;
            this.notify("Encoding CCF");
            this.cache.clear();
            this.strings.clear();
            this.all = new Hashtable();
            this.head.setFilePosition(0);
            this.addField(this.head, this.all);
            this.setMeter(0);
            this.setMeter(1);
            Vector<CCFHeader> vector = new Vector<CCFHeader>();
            vector.addElement(this.head);
            this.addByClass(this.all, vector, CCFIcon.class);
            this.setMeter(2);
            this.addByClass(this.all, vector, String.class);
            this.setMeter(3);
            this.addByClass(this.all, vector, CCFIRCode.class);
            this.setMeter(4);
            this.addByClass(this.all, vector, CCFActionList.class);
            this.setMeter(5);
            this.addByClass(this.all, vector, CCFButton.class);
            this.setMeter(6);
            this.addByClass(this.all, vector, CCFFrame.class);
            this.setMeter(7);
            this.addByClass(this.all, vector, CCFPanel.class);
            this.setMeter(8);
            this.addByClass(this.all, vector, CCFDevice.class);
            this.setMeter(9);
            this.addByClass(this.all, vector, CCFTimer.class);
            this.setMeter(10);
            int n = 0;
            int n2 = 0;
            int n3 = vector.size();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object object;
                e = enumeration.nextElement();
                if (e instanceof CCFNode) {
                    object = (CCFNode)e;
                    ((CCFNode)object).setFilePosition(n);
                    n += ((CCFNode)object).getLength();
                } else if (e instanceof String) {
                    object = (String)e;
                    this.putStringLocation(n, (String)object);
                    n += ((String)object).length() + 1;
                }
                this.setMeter(10 + n2 / n3);
                n2 += 30;
            }
            n += n % 2;
            this.head.crc1Pos = n;
            this.head.crc2Pos = n;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                if (e instanceof CCFNode) {
                    ((CCFNode)e).encode(this, false);
                } else if (e instanceof String) {
                    CCFNode.stringLengthEncode(this.ra, (String)e);
                }
                this.setMeter(10 + n2 / n3);
                n2 += 60;
            }
            this.setMeter(100);
            this.ra.seek(this.head.crc1Pos);
            this.ra.write(0);
            this.ra.seek(this.head.crc1Pos);
            this.ra.putShort(this.ra.getCRC(this.head.crc1Pos));
        }
        finally {
            this.ra.close();
        }
    }

    void setBuffer(byte[] byArray) {
        this.ra = new BufferedFile(byArray);
    }

    void setBuffer(String string) throws IOException {
        this.ra = new BufferedFile(string, "r");
    }

    void decodeFromBytes(byte[] byArray) {
        this.ra = new BufferedFile(byArray);
        this.decode();
    }

    void decodeFromFile(String string) throws IOException {
        this.ra = new BufferedFile(string, "r");
        this.decode();
    }

    private void checkLZO() {
        try {
            this.ra.seek(8L);
            if (this.ra.getInt() == 1296849487) {
                int n;
                debug.log(0, "detected compressed ccf");
                this.ra.seek(0L);
                int n2 = this.ra.getInt();
                int n3 = this.ra.getInt();
                int n4 = this.ra.getInt();
                int n5 = 0;
                byte[] byArray = new byte[n2];
                byte[] byArray2 = new byte[n2];
                BufferedFile bufferedFile = new BufferedFile(new byte[n3]);
                while ((n = this.ra.getInt()) > 0) {
                    int n6 = this.ra.read(byArray, 0, n);
                    int n7 = Util.decompress(byArray, 0, n, byArray2, 0, n2);
                    int n8 = 100 - (int)((double)n / (double)n7 * 100.0);
                    debug.log(2, "lzo blk=" + n5++ + " in=" + n + " out=" + n7 + " comp=" + n8 + "%");
                    this.ra.skipBytes(n % 4 > 0 ? 4 - n % 4 : 0);
                    bufferedFile.write(byArray2, 0, n7);
                }
                this.ra = bufferedFile;
            }
            this.ra.seek(0L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void decode() {
        this.notify("Decoding CCF");
        long l = Util.time();
        this.checkLZO();
        this.ccflen = this.ra.length();
        this.cache.clear();
        this.strings.clear();
        this.head.decode(this);
        this.processDeferred();
        this.head.buildTree(null);
        this.setMeter(100);
        this.ra.close();
        l = Util.time() - l;
        debug.log(2, "*** ccf decoded in " + l + " ms ***");
    }

    void addField(Object object, Hashtable hashtable) {
        this.addField(object, hashtable, true);
    }

    void addField(Object object, Hashtable hashtable, boolean bl) {
        if (object != null && hashtable.get(object) != null) {
            return;
        }
        if (object instanceof CCFNode) {
            CCFNode cCFNode = (CCFNode)object;
            cCFNode.setHeader(this.head);
            cCFNode.checkVersion();
            if (!(object instanceof CCFAction) && !(object instanceof CCFChild)) {
                hashtable.put(cCFNode, cCFNode);
            }
            cCFNode.encodePrep(this, hashtable);
        } else {
            if (object instanceof CCFNode[]) {
                CCFNode[] cCFNodeArray = (CCFNode[])object;
                for (int i = 0; i < cCFNodeArray.length; ++i) {
                    this.addField(cCFNodeArray[i], hashtable);
                }
                return;
            }
            if (object instanceof String && bl) {
                hashtable.put(object, object);
            }
        }
    }

    void putObjectAt(int n, CCFNode cCFNode) {
        this.cache.put(new Integer(n), cCFNode);
    }

    void removeObjectAt(int n) {
        this.cache.remove(new Integer(n));
    }

    CCFNode[] getOrderedNodes() {
        Vector<CCFNode> vector = new Vector<CCFNode>();
        vector.add(this.head);
        Object[] objectArray = this.cache.keys();
        while (objectArray.hasMoreElements()) {
            Integer n = (Integer)objectArray.nextElement();
            CCFNode cCFNode = (CCFNode)this.cache.get(n);
            vector.add(cCFNode);
        }
        objectArray = new CCFNode[vector.size()];
        vector.copyInto(objectArray);
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                if (object == object2 || object == null || object2 == null) {
                    return 0;
                }
                int n2 = ((CCFNode)object).getFilePosition();
                if (n2 < (n = ((CCFNode)object2).getFilePosition())) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        return objectArray;
    }

    CCFNode getObjectAt(int n) {
        return (CCFNode)this.cache.get(new Integer(n));
    }

    void putLocationString(String string, int n) {
        this.strings.put(new Integer(n), string);
    }

    String getLocationString(int n) {
        return (String)this.strings.get(new Integer(n));
    }

    long getStringLocation(String string) {
        if (string == null) {
            return 0L;
        }
        Long l = (Long)this.strings.get(string);
        return l != null ? l : 0L;
    }

    void putStringLocation(long l, String string) {
        this.strings.put(string, new Long(l));
    }

    private int getCRC(String string, int n) throws IOException {
        BufferedFile bufferedFile = new BufferedFile(string, "r");
        CRC16 cRC16 = new CRC16();
        for (int i = 0; i < n; ++i) {
            cRC16.update((byte)bufferedFile.read());
        }
        return cRC16.getValue();
    }

    CCFHeader getHeader() {
        return this.head;
    }

    void deferResolve(CCFNode cCFNode, String string, int n, Class clazz) {
        this.resolveStack.push(new defer(cCFNode, string, n, clazz));
    }

    void processDeferred() {
        while (!this.resolveStack.empty()) {
            ((defer)this.resolveStack.pop()).process();
        }
    }

    boolean seek(long l) {
        if (l < (long)this.head.attrPos || l > this.ccflen) {
            return false;
        }
        this.ra.seek(l);
        return true;
    }

    boolean isValidPtr(long l) {
        return l > 0L && l < this.ccflen;
    }

    CodecError error(String string, CCFNode cCFNode, String string2, int n, Exception exception) {
        CodecError codecError = new CodecError(string, cCFNode, string2, n, exception);
        cCFNode.error(codecError);
        return codecError;
    }

    class CodecError
    extends RuntimeException {
        private CCFNode node;
        private String fld;
        private int pos;
        private Exception ex;

        CodecError(String string, CCFNode cCFNode, String string2, int n, Exception exception) {
            super(string);
            this.node = cCFNode;
            this.fld = string2;
            this.pos = n;
            this.ex = exception;
        }

        @Override
        public String toString() {
            return "err in " + this.node + "[" + this.fld + "] @ " + this.pos + (this.ex != null ? " (" + super.getMessage() + ":" + this.ex + ")" : super.getMessage());
        }

        @Override
        public String getMessage() {
            return this.toString();
        }

        @Override
        public void printStackTrace() {
            if (this.ex != null) {
                this.ex.printStackTrace();
            } else {
                super.printStackTrace();
            }
        }
    }

    class defer {
        private CCFNode src;
        private String field;
        private int pos;
        private Class clz;

        defer(CCFNode cCFNode, String string, int n, Class clazz) {
            this.src = cCFNode;
            this.field = string;
            this.pos = n;
            this.clz = clazz;
        }

        void process() {
            try {
                CCFNode cCFNode = this.src.getItemByPos(CCFNodeState.this, this.pos, this.clz);
                this.src.set(this.field, cCFNode);
            }
            catch (Exception exception) {
                CCFNodeState.this.error("defer", this.src, this.field, this.pos, exception);
                debug.log(1, "defer process error @ " + this.src);
            }
        }
    }
}

