/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CCFButton;
import com.neuron.app.tonto.CCFChild;
import com.neuron.app.tonto.CCFDevice;
import com.neuron.app.tonto.CCFFrame;
import com.neuron.app.tonto.CCFHeader;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFNodeState;
import com.neuron.app.tonto.IChildContainer;
import com.neuron.app.tonto.IListElement;
import com.neuron.app.tonto.INamed;
import java.util.List;
import java.util.Vector;

public class CCFPanel
extends CCFNode
implements IChildContainer,
INamed,
IListElement {
    private static final String[][] encode = new String[][]{{"Z*", "next"}, {"N4", "namePos"}, {"N1", "count1"}, {"N1", "count2"}, {"Z+", "child", "count1"}, {"X*", "name"}};
    private static final String[][] decode = new String[][]{{"Z*", "next"}, {"N4", "namePos"}, {"N1", "count1"}, {"N1", "count2"}, {"Z+", "child", "count1"}};
    static final int HIDDEN = Integer.MIN_VALUE;
    static final int NAME_MASK = Integer.MAX_VALUE;
    CCFPanel next;
    int namePos;
    int count1;
    int count2;
    CCFChild[] child;
    boolean hidden;
    String name;

    CCFPanel() {
    }

    CCFPanel(String string, CCFHeader cCFHeader) {
        this.setName(string);
        this.setParent(cCFHeader);
    }

    CCFPanel(String string, CCFDevice cCFDevice) {
        this.setName(string);
        this.setParent(cCFDevice);
    }

    @Override
    CCFNode getClone() {
        return this.getClone(false);
    }

    CCFNode getClone(boolean bl) {
        CCFPanel cCFPanel = (CCFPanel)super.getClone();
        if (bl) {
            if (cCFPanel.next != null) {
                cCFPanel.next = (CCFPanel)cCFPanel.next.getClone(bl);
            }
        } else {
            cCFPanel.setNextPanel(null);
        }
        cCFPanel.child = this.getClone(cCFPanel.child);
        cCFPanel.buildTree(this.getParent());
        return cCFPanel;
    }

    void delete(CCFNode cCFNode) {
        this.setChildren(CCFPanel.delete(this.child, cCFNode));
    }

    CCFChild getPrevious(CCFChild cCFChild) {
        List list = this.getAllChildren();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != cCFChild) continue;
            if (i > 0) {
                return (CCFChild)list.get(i - 1);
            }
            return (CCFChild)list.get(list.size() - 1);
        }
        return null;
    }

    CCFChild getNext(CCFChild cCFChild) {
        List list = this.getAllChildren();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != cCFChild) continue;
            if (i < list.size() - 1) {
                return (CCFChild)list.get(i + 1);
            }
            return (CCFChild)list.get(0);
        }
        return null;
    }

    private List getAllChildren() {
        return this.getAllChildren(this, new Vector());
    }

    private List getAllChildren(IChildContainer iChildContainer, List list) {
        CCFChild[] cCFChildArray = iChildContainer.getChildren();
        for (int i = 0; i < cCFChildArray.length; ++i) {
            list.add(cCFChildArray[i]);
            if (!(cCFChildArray[i] instanceof IChildContainer)) continue;
            this.getAllChildren((IChildContainer)((Object)this.child[i]), list);
        }
        return list;
    }

    static CCFChild[] delete(CCFChild[] cCFChildArray, CCFNode cCFNode) {
        if (cCFNode == null || cCFChildArray == null) {
            return cCFChildArray;
        }
        for (int i = 0; i < cCFChildArray.length; ++i) {
            if (cCFChildArray[i].child == cCFNode) {
                CCFChild[] cCFChildArray2 = new CCFChild[cCFChildArray.length - 1];
                System.arraycopy(cCFChildArray, 0, cCFChildArray2, 0, i);
                if (i < cCFChildArray.length) {
                    System.arraycopy(cCFChildArray, i + 1, cCFChildArray2, i, cCFChildArray2.length - i);
                }
                return cCFChildArray2;
            }
            if (!cCFChildArray[i].isFrame()) continue;
            cCFChildArray[i].getFrame().delete(cCFNode);
        }
        return cCFChildArray;
    }

    static CCFChild[] add(CCFChild[] cCFChildArray, CCFChild cCFChild) {
        if (cCFChildArray == null) {
            return new CCFChild[]{cCFChild};
        }
        CCFChild[] cCFChildArray2 = new CCFChild[cCFChildArray.length + 1];
        System.arraycopy(cCFChildArray, 0, cCFChildArray2, 0, cCFChildArray.length);
        cCFChildArray2[cCFChildArray.length] = cCFChild;
        return cCFChildArray2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public IListElement getNextElement() {
        return this.next;
    }

    public CCFPanel getNextPanel() {
        return this.next;
    }

    public void setNextPanel(CCFPanel cCFPanel) {
        if (cCFPanel != null) {
            cCFPanel.setParent(this.getParent());
        }
        this.next = cCFPanel;
    }

    public boolean isTemplate() {
        return this.getParent() == this.getHeader();
    }

    public void insertBefore(CCFPanel cCFPanel) {
        this.getParentDevice().insertBefore(this, cCFPanel);
    }

    public void insertAfter(CCFPanel cCFPanel) {
        if (this.next == null) {
            this.next = cCFPanel;
        } else {
            cCFPanel.next = this.next;
            this.next = cCFPanel;
        }
        cCFPanel.buildTree(this.getParent());
    }

    public CCFButton createButton(String string) {
        return new CCFButton(this, string);
    }

    public CCFFrame createFrame(String string) {
        return new CCFFrame(this, string);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    @Override
    public CCFChild[] getChildren() {
        return this.child;
    }

    public boolean hasChildren() {
        return this.child != null && this.child.length > 0;
    }

    public CCFPanel getTemplate() {
        CCFPanel cCFPanel;
        CCFHeader cCFHeader = this.getHeader();
        CCFDevice cCFDevice = this.getParentDevice();
        if (cCFDevice == null || cCFHeader == null || this.isTemplate()) {
            return null;
        }
        CCFPanel cCFPanel2 = cCFDevice.isNormalDevice() ? cCFHeader.deviceTemplate() : (cCFPanel = cCFDevice.isMacroDevice() ? cCFHeader.macroTemplate() : cCFHeader.masterTemplate());
        if (cCFPanel == null || !cCFPanel.hasChildren()) {
            cCFPanel = cCFHeader.masterTemplate();
        }
        return cCFPanel;
    }

    @Override
    public void setChildren(CCFChild[] cCFChildArray) {
        this.child = cCFChildArray;
        this.count2 = this.count1 = cCFChildArray != null ? cCFChildArray.length : 0;
        this.buildTree(this.getParent());
    }

    public void addChild(CCFChild cCFChild) {
        this.setChildren(CCFPanel.add(this.child, cCFChild));
    }

    @Override
    public void addButton(CCFButton cCFButton) {
        this.setChildren(CCFPanel.add(this.child, cCFButton.getChildWrapper()));
    }

    @Override
    public void addFrame(CCFFrame cCFFrame) {
        this.setChildren(CCFPanel.add(this.child, cCFFrame.getChildWrapper()));
    }

    public void delete() {
        this.getParentDevice().delete(this);
        this.setParent(null);
    }

    @Override
    public String toString() {
        return this.name != null ? (this.hidden ? "(" + this.name + ")" : this.name) : "";
    }

    public boolean equals(Object object) {
        return object == this;
    }

    String getFQN() {
        return this.getParentDevice() + " : " + (this.name != null ? this.name : "");
    }

    CCFButton[] getButtons() {
        Vector vector = new Vector();
        if (this.child != null) {
            for (int i = 0; i < this.child.length; ++i) {
                this.child[i].collectButtons(vector);
            }
        }
        return vector.toArray(new CCFButton[vector.size()]);
    }

    public CCFButton getButtonByName(String string) {
        CCFButton[] cCFButtonArray = this.getButtons();
        for (int i = 0; i < cCFButtonArray.length; ++i) {
            if (cCFButtonArray[i].name == null || !cCFButtonArray[i].name.equals(string)) continue;
            return cCFButtonArray[i];
        }
        return null;
    }

    public CCFButton getButtonByID(String string) {
        CCFButton[] cCFButtonArray = this.getButtons();
        for (int i = 0; i < cCFButtonArray.length; ++i) {
            if (cCFButtonArray[i].idtag == null || !cCFButtonArray[i].idtag.equals(string)) continue;
            return cCFButtonArray[i];
        }
        return null;
    }

    @Override
    String describe() {
        return "Panel," + (this.name != null ? (this.hidden ? "(" + this.name + ")" : this.name) : "") + "," + (this.child != null ? this.child.length : 0);
    }

    @Override
    void checkVersion() {
    }

    @Override
    void preEncode(CCFNodeState cCFNodeState) {
        this.namePos = this.getStringEncodePos(cCFNodeState, this.name);
        if (this.hidden) {
            this.namePos |= Integer.MIN_VALUE;
        }
    }

    @Override
    void preDecode(CCFNodeState cCFNodeState) {
    }

    @Override
    void postDecode(CCFNodeState cCFNodeState) {
        if (this.count1 != this.count2) {
            int n;
            this.log(0, "panel: child count mismatch " + this.count1 + " != " + this.count2, cCFNodeState);
            this.count1 = n = Math.min(Math.min(this.count1, this.count2), 10);
            this.count2 = n;
        }
        this.hidden = (this.namePos & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        this.name = this.stringJumpDecode(this.namePos & Integer.MAX_VALUE, cCFNodeState);
        cCFNodeState.putStringLocation(this.namePos, this.name);
        if (this.name != null && this.name.equals("EggDVD")) {
            cCFNodeState.getHeader().setEggDVD(this);
        }
    }

    @Override
    String[][] getEncodeTable() {
        return encode;
    }

    @Override
    String[][] getDecodeTable() {
        return decode;
    }

    @Override
    void buildTree(CCFNode cCFNode) {
        this.setParent(cCFNode);
        if (this.child == null) {
            return;
        }
        for (int i = 0; i < this.child.length; ++i) {
            this.child[i].buildTree(this);
        }
    }
}

