/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.ActionAliasButton;
import com.neuron.app.tonto.ActionAliasDevice;
import com.neuron.app.tonto.ActionAliasKey;
import com.neuron.app.tonto.ActionBeep;
import com.neuron.app.tonto.ActionDelay;
import com.neuron.app.tonto.ActionIRCode;
import com.neuron.app.tonto.ActionJumpPanel;
import com.neuron.app.tonto.ActionTimer;
import com.neuron.app.tonto.CCF;
import com.neuron.app.tonto.CCFAction;
import com.neuron.app.tonto.CCFActionList;
import com.neuron.app.tonto.CCFButton;
import com.neuron.app.tonto.CCFChild;
import com.neuron.app.tonto.CCFColor;
import com.neuron.app.tonto.CCFDevice;
import com.neuron.app.tonto.CCFFont;
import com.neuron.app.tonto.CCFFrame;
import com.neuron.app.tonto.CCFHeader;
import com.neuron.app.tonto.CCFIRCode;
import com.neuron.app.tonto.CCFIcon;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.CCFTimer;
import com.neuron.app.tonto.IChildContainer;
import com.neuron.app.tonto.INamed;
import com.neuron.app.tonto.ITaskStatus;
import com.neuron.app.tonto.ProntoModel;
import com.neuron.app.tonto.TaskStatus;
import com.neuron.app.tonto.Tonto;
import com.neuron.app.tonto.Util;
import com.neuron.io.ByteOutputBuffer;
import com.neuron.xml.XMLNode;
import com.neuron.xml.XMLParser;
import java.awt.Dimension;
import java.awt.Point;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CCFPorter {
    private Hashtable npos = new Hashtable();
    private Stack nposList = new Stack();
    private Hashtable icon = new Hashtable();
    private Stack iconList = new Stack();
    private Hashtable acts = new Hashtable();
    private Stack actList = new Stack();
    private Hashtable irs = new Hashtable();
    private Stack irList = new Stack();
    private boolean iscolor = false;
    private int cpos = 0;
    private CCF ccf;
    private ByteOutputBuffer emitTo = new ByteOutputBuffer();
    private static final String[] actName = new String[]{"ir", "button", "panel", "delay", "key", "device", "timer", "beep", "panel"};

    private CCFPorter() {
    }

    private CCFPorter(CCF cCF) {
        this.ccf = cCF;
        this.iscolor = cCF.header().hasColor();
    }

    private void emit(int n, String string) {
        try {
            for (int i = 0; i < n; ++i) {
                this.emitTo.write("  ".getBytes());
            }
            this.emitTo.write(string.getBytes());
            this.emitTo.write(10);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }

    public static void exportZip(CCF cCF, String string) throws IOException {
        CCFPorter.exportZip(cCF, string, new TaskStatus());
    }

    public static void exportZip(CCF cCF, String string, ITaskStatus iTaskStatus) throws IOException {
        new CCFPorter(cCF).Export(string, iTaskStatus);
    }

    private void Export(String string, ITaskStatus iTaskStatus) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        iTaskStatus.taskStatus(0, "Generating XML");
        this.emit(0, "<?xml version=\"1.0\" ?>");
        this.emit(0, "");
        this.emit(0, "<!-- Generated By: Tonto " + Tonto.version() + " -->");
        this.emit(0, "");
        this.emit(0, "<!-- colors='fg/bg' -->");
        this.emit(0, "<!-- button colors='inactive unselected, inactive selected, active unselected, active selected' -->");
        this.emit(0, "<!-- button icons='inactive unselected, inactive selected, active unselected, active selected' -->");
        this.emit(0, "<!-- device icons='unselected, selected' -->");
        this.emit(0, "");
        this.emit(this.ccf.header());
        iTaskStatus.taskStatus(5, "Generating XML");
        ZipEntry zipEntry = new ZipEntry("ccf.xml");
        zipEntry.setSize(this.emitTo.size());
        zipOutputStream.putNextEntry(zipEntry);
        this.emitTo.writeToStream(zipOutputStream);
        zipOutputStream.closeEntry();
        iTaskStatus.taskStatus(50, "Generating Icons");
        int n = this.iconList.size();
        for (int i = 0; i < n; ++i) {
            CCFIcon cCFIcon = (CCFIcon)this.iconList.get(i);
            zipEntry = new ZipEntry("icon-" + i + ".gif");
            zipOutputStream.putNextEntry(zipEntry);
            cCFIcon.saveGIF(zipOutputStream);
            zipOutputStream.closeEntry();
            iTaskStatus.taskStatus(50 + i * 50 / n, "Generating Icons");
        }
        iTaskStatus.taskStatus(100, "Completing");
        zipOutputStream.close();
    }

    private String safe(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= '~') {
                if (c == '\\') {
                    stringBuffer.append("\\\\");
                    continue;
                }
                if (c == '/') {
                    stringBuffer.append("\\/");
                    continue;
                }
                if (c == '\"') {
                    stringBuffer.append("&quot;");
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("\\" + Integer.toString(c, 8));
        }
        return stringBuffer.toString();
    }

    private String unsafe(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) == '\\') {
                if (n2 == n) {
                    stringBuffer.append('\\');
                    ++n2;
                    continue;
                }
                if (string.charAt(n2) == '/') {
                    stringBuffer.append(string.charAt(n2));
                    ++n2;
                    continue;
                }
                if (n2 >= n - 2) continue;
                stringBuffer.append((char)Integer.parseInt(string.substring(n2, n2 + 3), 8));
                n2 += 3;
                continue;
            }
            if (c == '&' && n2 < n - 5 && string.substring(n2, n2 + 5).equals("quot;")) {
                stringBuffer.append('\"');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private String atstr(String string, int n) {
        return this.atstr(string, Integer.toString(n));
    }

    private String atstr(String string, String string2) {
        if (string2 == null) {
            return string + "=\"\"";
        }
        return string + "=\"" + string2 + "\"";
    }

    private String atcolor(String string, int n) {
        return this.atstr(string, CCFColor.getForegroundIndex(n, this.iscolor) + "/" + CCFColor.getBackgroundIndex(n, this.iscolor));
    }

    private String atcolors(String string, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(CCFColor.getForegroundIndex(nArray[i], this.iscolor) + "/" + CCFColor.getBackgroundIndex(nArray[i], this.iscolor) + (i < nArray.length - 1 ? "," : ""));
        }
        return this.atstr(string, stringBuffer.toString());
    }

    private String aticon(String string, CCFIcon cCFIcon) {
        if (cCFIcon == null) {
            return this.atstr(string, null);
        }
        return this.atstr(string, this.iconPtr(cCFIcon));
    }

    private String aticons(String string, CCFIcon[] cCFIconArray) {
        if (cCFIconArray == null) {
            return this.atstr(string, null);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cCFIconArray.length; ++i) {
            stringBuffer.append(this.iconPtr(cCFIconArray[i]) + (i < cCFIconArray.length - 1 ? "," : ""));
        }
        return this.atstr(string, stringBuffer.toString());
    }

    private String atdim(CCFNode cCFNode) {
        if (cCFNode instanceof CCFButton) {
            CCFButton cCFButton = (CCFButton)cCFNode;
            CCFChild cCFChild = (CCFChild)cCFNode.getParent();
            return this.atstr("pos", cCFChild.intX + "x" + cCFChild.intY) + " " + this.atstr("dim", cCFButton.width + "x" + cCFButton.height);
        }
        if (cCFNode instanceof CCFFrame) {
            CCFFrame cCFFrame = (CCFFrame)cCFNode;
            CCFChild cCFChild = (CCFChild)cCFNode.getParent();
            return this.atstr("pos", cCFChild.intX + "x" + cCFChild.intY) + " " + this.atstr("dim", cCFFrame.width + "x" + cCFFrame.height);
        }
        return "";
    }

    private String actionPtr(CCFActionList cCFActionList) {
        if (cCFActionList == null) {
            return this.atstr("actions", null);
        }
        Integer n = (Integer)this.acts.get(cCFActionList);
        if (n == null) {
            n = new Integer(this.acts.size());
            this.actList.push(cCFActionList);
            this.acts.put(cCFActionList, n);
        }
        return this.atstr("actions", n);
    }

    private String irPtr(CCFIRCode cCFIRCode) {
        if (cCFIRCode == null) {
            return this.atstr("ir", null);
        }
        Integer n = (Integer)this.irs.get(cCFIRCode);
        if (this.irs.get(cCFIRCode) == null) {
            n = new Integer(this.irs.size());
            this.irList.push(cCFIRCode);
            this.irs.put(cCFIRCode, n);
        }
        return this.atstr("ir", n);
    }

    private String iconPtr(CCFIcon cCFIcon) {
        if (cCFIcon == null) {
            return "";
        }
        Integer n = (Integer)this.icon.get(cCFIcon);
        if (this.icon.get(cCFIcon) == null) {
            n = new Integer(this.icon.size());
            this.iconList.push(cCFIcon);
            this.icon.put(cCFIcon, n);
        }
        return n.toString();
    }

    private void emit(CCFHeader cCFHeader) {
        this.emit(0, "<ccf " + this.atstr("modified", cCFHeader.year + "/" + cCFHeader.month + "/" + cCFHeader.day + "," + cCFHeader.hour + ":" + cCFHeader.minute + ":" + cCFHeader.seconds) + " " + this.atstr("model", ProntoModel.getModelByCapability(cCFHeader.capability)[0].getName()) + " " + this.atstr("version", cCFHeader.version) + ">");
        this.emit(1, "<homes>");
        this.emit(2, cCFHeader.firstHome);
        this.emit(1, "</homes>");
        this.emit(1, "<devices>");
        this.emit(2, cCFHeader.firstDevice);
        this.emit(1, "</devices>");
        this.emit(1, "<macros>");
        this.emit(2, cCFHeader.firstMacro);
        this.emit(1, "</macros>");
        this.emit(1, cCFHeader.macroPanel);
        this.emitActions();
        this.emitIRCodes();
        this.emitIcons();
        this.emit(0, "</ccf>");
    }

    private void emit(int n, CCFDevice cCFDevice) {
        if (cCFDevice == null) {
            return;
        }
        this.incrPos(cCFDevice);
        this.emit(n, "<device " + this.atstr("name", this.safe(cCFDevice.name)) + (cCFDevice.getFlag(1) ? " readonly" : "") + (cCFDevice.getFlag(32) ? " separator" : "") + (cCFDevice.getFlag(64) ? " template" : "") + " " + this.actionPtr(cCFDevice.action) + " " + this.aticons("icons", new CCFIcon[]{cCFDevice.iconUnselected, cCFDevice.iconSelected}) + ">");
        this.pushPos();
        this.emit(n + 1, cCFDevice.firstPanel);
        this.popPos();
        this.emit(n, "</device>");
        this.emit(n, cCFDevice.next);
    }

    private void emit(int n, CCFPanel cCFPanel) {
        if (cCFPanel == null) {
            return;
        }
        this.incrPos(cCFPanel);
        this.emit(n, "<panel " + this.atstr("name", this.safe(cCFPanel.name)) + (cCFPanel.isHidden() ? " hidden" : "") + ">");
        this.pushPos();
        this.emit(n + 1, cCFPanel.child);
        this.popPos();
        this.emit(n, "</panel>");
        this.emit(n, cCFPanel.next);
    }

    private void emit(int n, CCFFrame cCFFrame) {
        if (cCFFrame == null) {
            return;
        }
        this.incrPos(cCFFrame);
        this.emit(n, "<frame " + this.atstr("font", CCFFont.getAWTSize(cCFFrame.fontSize)) + " " + this.atstr("name", this.safe(cCFFrame.name)) + " " + this.atcolor("colors", cCFFrame.colors) + " " + this.aticon("icon", cCFFrame.icon) + " " + this.atdim(cCFFrame) + ">");
        this.pushPos();
        this.emit(n + 1, cCFFrame.child);
        this.popPos();
        this.emit(n, "</frame>");
    }

    private void emit(int n, CCFButton cCFButton) {
        this.incrPos(cCFButton);
        this.emit(n, "<button " + this.atstr("font", CCFFont.getAWTSize(cCFButton.fontSize)) + " " + this.atstr("name", this.safe(cCFButton.name)) + " " + this.atstr("id", this.safe(cCFButton.idtag)) + " " + this.actionPtr(cCFButton.actions) + " " + this.atcolors("colors", new int[]{cCFButton.colorIU, cCFButton.colorIS, cCFButton.colorAU, cCFButton.colorAS}) + " " + this.aticons("icons", new CCFIcon[]{cCFButton.iconIU, cCFButton.iconIS, cCFButton.iconAU, cCFButton.iconAS}) + " " + this.atdim(cCFButton) + " />");
    }

    private void emit(int n, CCFChild[] cCFChildArray) {
        if (cCFChildArray == null || cCFChildArray.length == 0) {
            return;
        }
        block4: for (int i = 0; i < cCFChildArray.length; ++i) {
            switch (cCFChildArray[i].type) {
                case 0: {
                    this.emit(n, cCFChildArray[i].getFrame());
                    continue block4;
                }
                case 1: {
                    this.emit(n, cCFChildArray[i].getButton());
                }
            }
        }
    }

    private String getPath(CCFNode cCFNode) {
        String string = null;
        while (cCFNode != null && !(cCFNode instanceof CCFHeader)) {
            try {
                String string2 = (String)cCFNode.getClass().getDeclaredField("name").get(cCFNode);
                if (string2 == null) {
                    throw new Exception();
                }
                CCFNode cCFNode2 = cCFNode.getParent();
                if (cCFNode2 instanceof IChildContainer) {
                    CCFChild[] cCFChildArray = ((IChildContainer)((Object)cCFNode2)).getChildren();
                    for (int i = 0; i < cCFChildArray.length; ++i) {
                        String string3;
                        if (cCFChildArray[i] == cCFNode || (string3 = ((INamed)((Object)cCFChildArray[i])).getName()) == null || !string3.equals(string2)) continue;
                        throw new Exception();
                    }
                }
                string = this.safe(string2) + (string != null ? "/" + string : "");
            }
            catch (Exception exception) {
                string = "[" + this.npos.get(cCFNode) + "]" + (string != null ? "/" + string : "");
            }
            if (cCFNode instanceof CCFDevice) {
                string = this.getDevTreeName((CCFDevice)cCFNode) + "/" + string;
            }
            if (!((cCFNode = cCFNode.getParent()) instanceof CCFChild)) continue;
            cCFNode = cCFNode.getParent();
        }
        return string;
    }

    private String getDevTreeName(CCFDevice cCFDevice) {
        if (this.devListHas(this.ccf.header().firstHome, cCFDevice)) {
            return "HOME";
        }
        if (this.devListHas(this.ccf.header().firstDevice, cCFDevice)) {
            return "DEVICE";
        }
        if (this.devListHas(this.ccf.header().firstMacro, cCFDevice)) {
            return "MACRO";
        }
        throw new RuntimeException("unable to find tree for '" + cCFDevice + "'");
    }

    private boolean devListHas(CCFDevice cCFDevice, CCFDevice cCFDevice2) {
        while (cCFDevice != null) {
            if (cCFDevice == cCFDevice2) {
                return true;
            }
            cCFDevice = cCFDevice.next;
        }
        return false;
    }

    private void incrPos(CCFNode cCFNode) {
        this.npos.put(cCFNode, new Integer(++this.cpos));
    }

    private void pushPos() {
        this.nposList.push(new Integer(this.cpos));
        this.cpos = 0;
    }

    private void popPos() {
        this.cpos = (Integer)this.nposList.pop();
    }

    private void emitIcons() {
        this.emit(1, "<icons>");
        for (int i = 0; i < this.iconList.size(); ++i) {
            CCFIcon cCFIcon = (CCFIcon)this.iconList.get(i);
            this.emit(2, "<icon " + this.atstr("id", i) + " " + this.atstr("bits", cCFIcon.isColor() ? "8" : (cCFIcon.isGray() ? "2" : "1")) + " " + this.atstr("file", "icon-" + i + ".gif") + (cCFIcon.isCompressed() ? " compressed" : "") + " />");
        }
        this.emit(1, "</icons>");
    }

    private void emitIRCodes() {
        this.emit(1, "<codes>");
        for (int i = 0; i < this.irList.size(); ++i) {
            CCFIRCode cCFIRCode = (CCFIRCode)this.irList.get(i);
            this.emit(2, "<ir " + this.atstr("id", i) + " " + this.atstr("name", cCFIRCode.getName()) + " " + this.atstr("code", cCFIRCode.getCode()) + " />");
        }
        this.emit(1, "</codes>");
    }

    private void emitAction(int n, CCFAction cCFAction) {
        if (cCFAction == null) {
            this.emit(n, "<action />");
            return;
        }
        String string = "";
        switch (cCFAction.type) {
            case 1: {
                string = this.irPtr((CCFIRCode)cCFAction.action2);
                break;
            }
            case 2: {
                string = this.atstr("press", this.getPath(cCFAction.action2));
                break;
            }
            case 3: 
            case 9: {
                if (cCFAction.isSpecialJump()) {
                    string = this.atstr("special", CCFAction.getJumpSpecialString(cCFAction.p2));
                    break;
                }
                string = this.atstr("jump", this.getPath(cCFAction.action2));
                break;
            }
            case 4: {
                string = this.atstr("time", cCFAction.p2);
                break;
            }
            case 5: {
                CCFDevice cCFDevice = (CCFDevice)cCFAction.action1;
                string = this.atstr("device", this.getPath(cCFDevice)) + " " + this.atstr("key", CCFAction.getKeyName(cCFDevice, cCFAction.p2));
                break;
            }
            case 6: {
                string = this.atstr("jump", this.getPath(cCFAction.action1));
                break;
            }
            case 7: {
                CCFTimer cCFTimer = (CCFTimer)cCFAction.action2;
                this.emit(n, "<action " + this.atstr("type", "timer") + " " + this.atstr("startDays", Integer.toString(cCFTimer.startDays)) + " " + this.atstr("startTime", Integer.toString(cCFTimer.startTime)) + " " + this.atstr("endDays", Integer.toString(cCFTimer.endDays)) + " " + this.atstr("endTime", Integer.toString(cCFTimer.endTime)) + ">");
                this.emitAction(n + 1, cCFTimer.startAction);
                this.emitAction(n + 1, cCFTimer.endAction);
                this.emit(n, "</action>");
                return;
            }
            case 8: {
                ActionBeep actionBeep = (ActionBeep)cCFAction;
                string = this.atstr("duration", actionBeep.getDuration()) + " " + this.atstr("freq", actionBeep.getFrequency()) + " " + this.atstr("duty", actionBeep.getDutyCycle());
            }
        }
        this.emit(n, "<action " + this.atstr("type", actName[cCFAction.type - 1]) + " " + string + " />");
    }

    private void emitActions() {
        this.emit(1, "<actions>");
        for (int i = 0; i < this.actList.size(); ++i) {
            CCFActionList cCFActionList = (CCFActionList)this.actList.get(i);
            this.emit(2, "<sequence " + this.atstr("id", i) + ">");
            CCFAction[] cCFActionArray = cCFActionList.getActions();
            for (int j = 0; j < cCFActionArray.length; ++j) {
                this.emitAction(3, cCFActionArray[j]);
            }
            this.emit(2, "</sequence>");
        }
        this.emit(1, "</actions>");
    }

    public static CCF importZip(String string) throws IOException {
        return CCFPorter.importZip(string, new TaskStatus());
    }

    public static CCF importZip(String string, ITaskStatus iTaskStatus) throws IOException {
        return new CCFPorter().Import(string, iTaskStatus);
    }

    private CCF Import(String string, ITaskStatus iTaskStatus) throws IOException {
        Object object;
        Object object2;
        Object object3;
        String string2;
        Object object4;
        Object object5;
        Object object6;
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string));
        Hashtable<String, byte[]> hashtable = new Hashtable<String, byte[]>();
        XMLNode xMLNode = null;
        boolean bl = true;
        iTaskStatus.taskStatus(0, "Scanning Zip");
        while ((object6 = zipInputStream.getNextEntry()) != null) {
            String string3;
            String string4 = ((ZipEntry)object6).getName();
            if (string4.lastIndexOf(47) > 0) {
                string4 = string4.substring(string4.lastIndexOf(47) + 1);
            }
            if ((string3 = string4.toLowerCase()).equals("ccf.xml")) {
                iTaskStatus.taskStatus(5, "Loading XML Manifest");
                object5 = new XMLParser();
                ((XMLParser)object5).load(zipInputStream);
                xMLNode = ((XMLParser)object5).getRootNode();
                continue;
            }
            hashtable.put(string4, Util.readFully(zipInputStream));
        }
        iTaskStatus.taskStatus(10, "Loading Icons");
        object6 = xMLNode.getNode("icons");
        int n = hashtable.size();
        int n2 = 0;
        object5 = ((XMLNode)object6).getNodeEnumeration("icon");
        while (object5.hasMoreElements()) {
            object4 = (XMLNode)object5.nextElement();
            string2 = ((XMLNode)object4).getAttribute("file");
            if (string2.lastIndexOf(47) > 0) {
                string2 = string2.substring(string2.lastIndexOf(47) + 1);
            }
            if ((object3 = (byte[])hashtable.get(string2)) == null) {
                throw new IllegalArgumentException("unable to find icon file '" + string2 + "'");
            }
            int n3 = Integer.parseInt(((XMLNode)object4).getAttribute("bits"));
            object2 = CCFIcon.create(object3, n3 == 8 ? 2 : 1);
            ((CCFIcon)object2).setCompressed(((XMLNode)object4).hasAttribute("compressed"));
            this.icon.put(((XMLNode)object4).getAttribute("id"), object2);
            iTaskStatus.taskStatus(10 + ++n2 * 50 / n, "Loading Icons");
        }
        this.ccf = new CCF();
        object5 = this.ccf.header();
        object4 = xMLNode.getAttribute("modified");
        string2 = xMLNode.getAttribute("model");
        object3 = xMLNode.getAttribute("version");
        if (string2 != null) {
            ProntoModel prontoModel = ProntoModel.getModelByName(string2);
            ((CCFHeader)object5).capability = prontoModel != null ? prontoModel.getCapability() : 1;
        }
        this.iscolor = this.ccf.header().hasColor();
        this.ccf.setVersionString((String)object3);
        iTaskStatus.taskStatus(60, "Loading IR Codes");
        object6 = xMLNode.getNode("codes");
        if (object6 != null) {
            Enumeration enumeration = ((XMLNode)object6).getNodeEnumeration("ir");
            while (enumeration != null && enumeration.hasMoreElements()) {
                object2 = (XMLNode)enumeration.nextElement();
                object = ((XMLNode)object2).getAttribute("code");
                this.irs.put(((XMLNode)object2).getAttribute("id"), new CCFIRCode((CCFHeader)object5, ((XMLNode)object2).getAttribute("name"), ((XMLNode)object2).getAttribute("code")));
            }
        }
        iTaskStatus.taskStatus(65, "Loading Action Lists");
        object6 = xMLNode.getNode("actions");
        if (object6 != null) {
            Enumeration enumeration = ((XMLNode)object6).getNodeEnumeration("sequence");
            while (enumeration != null && enumeration.hasMoreElements()) {
                object2 = (XMLNode)enumeration.nextElement();
                object = new CCFActionList();
                this.acts.put(((XMLNode)object2).getAttribute("id"), object);
                this.acts.put(object, object2);
                this.actList.add(object);
            }
        }
        iTaskStatus.taskStatus(70, "Building CCF");
        if (object4 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object4, "/,:");
            if (stringTokenizer.countTokens() >= 6) {
                ((CCFHeader)object5).year = this.nextInt(stringTokenizer);
                ((CCFHeader)object5).month = this.nextInt(stringTokenizer);
                ((CCFHeader)object5).day = this.nextInt(stringTokenizer);
                ((CCFHeader)object5).hour = this.nextInt(stringTokenizer);
                ((CCFHeader)object5).minute = this.nextInt(stringTokenizer);
                ((CCFHeader)object5).seconds = this.nextInt(stringTokenizer);
            } else {
                throw new IllegalArgumentException("malformed date '" + (String)object4 + "'");
            }
        }
        iTaskStatus.taskStatus(75, "Building CCF");
        this.ccf.setFirstHomeDevice(this.getDevices((CCFHeader)object5, xMLNode.getNode("homes")));
        this.ccf.setFirstDevice(this.getDevices((CCFHeader)object5, xMLNode.getNode("devices")));
        this.ccf.setFirstMacroDevice(this.getDevices((CCFHeader)object5, xMLNode.getNode("macros")));
        ((CCFHeader)object5).macroPanel = this.getPanels((CCFNode)object5, xMLNode);
        ((CCFHeader)object5).buildTree(null);
        iTaskStatus.taskStatus(85, "Completing Actions");
        for (int i = 0; i < this.actList.size(); ++i) {
            object2 = (CCFActionList)this.actList.get(i);
            object = (XMLNode)this.acts.get(object2);
            Vector vector = new Vector();
            Object[] objectArray = ((XMLNode)object).getNodeEnumeration("action");
            while (objectArray != null && objectArray.hasMoreElements()) {
                XMLNode xMLNode2 = (XMLNode)objectArray.nextElement();
                this.parseAction(this.ccf, xMLNode, xMLNode2, vector);
            }
            if (vector.size() <= 0) continue;
            objectArray = new CCFAction[vector.size()];
            vector.copyInto(objectArray);
            ((CCFActionList)object2).setActions((CCFAction[])objectArray);
        }
        return this.ccf;
    }

    private void parseAction(CCF cCF, XMLNode xMLNode, XMLNode xMLNode2, Vector vector) {
        String string = xMLNode2.getAttribute("type");
        if (string.equals("device")) {
            CCFDevice cCFDevice = (CCFDevice)this.resolvePath(xMLNode, xMLNode2.getAttribute("jump"));
            if (cCFDevice != null) {
                vector.add(new ActionAliasDevice(cCFDevice));
            }
        } else if (string.equals("panel")) {
            CCFPanel cCFPanel = (CCFPanel)this.resolvePath(xMLNode, xMLNode2.getAttribute("jump"));
            if (cCFPanel != null) {
                vector.add(new ActionJumpPanel(cCFPanel, cCF.header().isNewMarantz()));
            } else {
                String string2 = xMLNode2.getAttribute("special");
                if (string2 != null) {
                    vector.add(new CCFAction(3, 0, CCFAction.getJumpSpecialIDFromString(string2)).decodeReplace());
                }
            }
        } else if (string.equals("button")) {
            CCFButton cCFButton = (CCFButton)this.resolvePath(xMLNode, xMLNode2.getAttribute("press"));
            if (cCFButton != null) {
                vector.add(new ActionAliasButton(cCFButton));
            }
        } else if (string.equals("key")) {
            CCFDevice cCFDevice = (CCFDevice)this.resolvePath(xMLNode, xMLNode2.getAttribute("device"));
            if (cCFDevice == null) {
                return;
            }
            String string3 = xMLNode2.getAttribute("key");
            String[] stringArray = CCFAction.getKeyNames(cCFDevice);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string3)) continue;
                vector.add(new ActionAliasKey(cCFDevice, i));
                return;
            }
        } else if (string.equals("ir")) {
            vector.add(new ActionIRCode((CCFIRCode)this.irs.get(xMLNode2.getAttribute("ir"))));
        } else if (string.equals("delay")) {
            vector.add(new ActionDelay(Integer.parseInt(xMLNode2.getAttribute("time"))));
        } else if (string.equals("beep")) {
            vector.add(new ActionBeep(Integer.parseInt(xMLNode2.getAttribute("duration")), Integer.parseInt(xMLNode2.getAttribute("freq")), Integer.parseInt(xMLNode2.getAttribute("duty"))));
        } else if (string.equals("timer")) {
            CCFTimer cCFTimer = new CCFTimer();
            cCFTimer.startDays = Integer.parseInt(xMLNode2.getAttribute("startDays"));
            cCFTimer.startTime = Integer.parseInt(xMLNode2.getAttribute("startTime"));
            cCFTimer.endDays = Integer.parseInt(xMLNode2.getAttribute("endDays"));
            cCFTimer.endTime = Integer.parseInt(xMLNode2.getAttribute("endTime"));
            XMLNode[] xMLNodeArray = xMLNode2.getAllNodes();
            Vector vector2 = new Vector();
            this.parseAction(cCF, xMLNode, xMLNodeArray[0], vector2);
            this.parseAction(cCF, xMLNode, xMLNodeArray[1], vector2);
            cCFTimer.startAction = (CCFAction)vector2.get(0);
            cCFTimer.endAction = (CCFAction)vector2.get(1);
            vector.add(new ActionTimer(cCFTimer));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CCFNode resolvePath(XMLNode xMLNode, String string) {
        try {
            if (xMLNode == null || string == null || string.length() == 0) {
                return null;
            }
            Object object = this.ccf.header();
            StringBuffer stringBuffer = new StringBuffer();
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c;
                if ((c = string.charAt(n2++)) == '\\' && n2 < n && string.charAt(n2) == '/') {
                    stringBuffer.append("\\/");
                    if (++n2 != n) continue;
                }
                if (c == '/' || n2 == n) {
                    Object object2;
                    if (n2 == n) {
                        stringBuffer.append(c);
                    }
                    String string2 = this.unsafe(stringBuffer.toString());
                    if (object instanceof CCFHeader) {
                        if (string2.equals("HOME")) {
                            object = ((CCFHeader)object).firstHome;
                        } else if (string2.equals("DEVICE")) {
                            object = ((CCFHeader)object).firstDevice;
                        } else if (string2.equals("MACRO")) {
                            object = ((CCFHeader)object).firstMacro;
                        } else {
                            if (!string2.equals("PANEL")) throw new RuntimeException("no header key match for '" + string2 + "'");
                            object = ((CCFHeader)object).macroPanel;
                        }
                    } else if (object instanceof CCFDevice) {
                        object2 = (CCFDevice)object;
                        if (string2.startsWith("[")) {
                            int n3 = Integer.parseInt(string2.substring(1, string2.length() - 1)) - 1;
                            for (int i = 0; i < n3; ++i) {
                                object2 = ((CCFDevice)object2).next;
                            }
                        } else {
                            while (!((CCFDevice)object2).name.equals(string2)) {
                                object2 = ((CCFDevice)object2).next;
                            }
                        }
                        object = n2 < n ? ((CCFDevice)object2).firstPanel : object2;
                    } else if (object instanceof CCFPanel) {
                        object2 = (CCFPanel)object;
                        if (string2.startsWith("[")) {
                            int n4 = Integer.parseInt(string2.substring(1, string2.length() - 1)) - 1;
                            for (int i = 0; i < n4; ++i) {
                                object2 = ((CCFPanel)object2).next;
                            }
                        } else {
                            while (!((CCFPanel)object2).name.equals(string2)) {
                                object2 = ((CCFPanel)object2).next;
                            }
                        }
                        object = n2 < n ? ((CCFPanel)object2).getChildren() : object2;
                    } else {
                        if (!(object instanceof CCFChild[])) throw new IllegalArgumentException("unhandled node '" + object + "' (" + object.getClass() + ") in '" + string + "'");
                        object2 = (CCFChild[])object;
                        Object object3 = null;
                        if (string2.startsWith("[")) {
                            String string3 = string2.substring(1, string2.length() - 1);
                            object3 = object2[Integer.parseInt(string2.substring(1, string2.length() - 1)) - 1];
                        } else {
                            for (int i = 0; i < ((Object)object2).length; ++i) {
                                String string4;
                                Object object4 = object2[i];
                                String string5 = string4 = ((CCFChild)object4).type == 0 ? ((CCFChild)object4).getFrame().name : ((CCFChild)object4).getButton().name;
                                if (string4 == null || !string4.equals(string2)) continue;
                                object3 = object4;
                                break;
                            }
                        }
                        if (object3 != null && (object = n2 < n && object3 instanceof IChildContainer ? ((IChildContainer)((Object)((CCFChild)object3).child)).getChildren() : ((CCFChild)object3).child) instanceof CCFFrame && n2 < n) {
                            object = ((CCFFrame)object).getChildren();
                        }
                    }
                    stringBuffer.setLength(0);
                    continue;
                }
                stringBuffer.append(c);
            }
            return (CCFNode)object;
        }
        catch (Exception exception) {
            System.out.println("error on root=" + xMLNode + " path=" + string);
            exception.printStackTrace();
            return null;
        }
    }

    private CCFDevice getDevices(CCFHeader cCFHeader, XMLNode xMLNode) {
        if (xMLNode == null) {
            return null;
        }
        CCFDevice cCFDevice = null;
        CCFDevice cCFDevice2 = null;
        Enumeration enumeration = xMLNode.getNodeEnumeration("device");
        while (enumeration != null && enumeration.hasMoreElements()) {
            XMLNode xMLNode2 = (XMLNode)enumeration.nextElement();
            CCFDevice cCFDevice3 = new CCFDevice(cCFHeader);
            cCFDevice3.name = this.unsafe(xMLNode2.getAttribute("name"));
            cCFDevice3.setFlag(1, xMLNode2.hasAttribute("readonly"));
            cCFDevice3.setFlag(32, xMLNode2.hasAttribute("separator"));
            cCFDevice3.setFlag(64, xMLNode2.hasAttribute("template"));
            cCFDevice3.firstPanel = this.getPanels(cCFDevice3, xMLNode2);
            if (cCFDevice == null) {
                cCFDevice = cCFDevice3;
                cCFDevice2 = cCFDevice3;
                continue;
            }
            cCFDevice2.next = cCFDevice3;
            cCFDevice2 = cCFDevice3;
        }
        return cCFDevice;
    }

    private CCFPanel getPanels(CCFNode cCFNode, XMLNode xMLNode) {
        if (xMLNode == null) {
            return null;
        }
        CCFPanel cCFPanel = null;
        CCFPanel cCFPanel2 = null;
        Enumeration enumeration = xMLNode.getNodeEnumeration("panel");
        while (enumeration != null && enumeration.hasMoreElements()) {
            XMLNode xMLNode2 = (XMLNode)enumeration.nextElement();
            String string = this.unsafe(xMLNode2.getAttribute("name"));
            CCFPanel cCFPanel3 = cCFNode instanceof CCFDevice ? ((CCFDevice)cCFNode).createPanel(string) : new CCFPanel(string, (CCFHeader)cCFNode);
            cCFPanel3.setChildren(this.getChildren(cCFPanel3, xMLNode2));
            cCFPanel3.setHidden(xMLNode2.hasAttribute("hidden"));
            if (cCFPanel == null) {
                cCFPanel = cCFPanel3;
                cCFPanel2 = cCFPanel3;
                continue;
            }
            cCFPanel2.next = cCFPanel3;
            cCFPanel2 = cCFPanel3;
        }
        return cCFPanel;
    }

    private CCFChild[] getChildren(CCFNode cCFNode, XMLNode xMLNode) {
        if (cCFNode == null || xMLNode == null || !(cCFNode instanceof CCFFrame) && !(cCFNode instanceof CCFPanel)) {
            return null;
        }
        Vector<CCFChild> vector = new Vector<CCFChild>();
        XMLNode[] xMLNodeArray = xMLNode.getAllNodes();
        for (int i = 0; xMLNodeArray != null && i < xMLNodeArray.length; ++i) {
            XMLNode xMLNode2 = xMLNodeArray[i];
            String string = xMLNode2.getName();
            if (string.equals("button")) {
                vector.add(this.getButton(cCFNode, xMLNode2));
                continue;
            }
            if (!string.equals("frame")) continue;
            vector.add(this.getFrame(cCFNode, xMLNode2));
        }
        Object[] objectArray = new CCFChild[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private CCFChild getFrame(CCFNode cCFNode, XMLNode xMLNode) {
        CCFFrame cCFFrame = new CCFFrame(cCFNode, this.unsafe(xMLNode.getAttribute("name")));
        CCFChild cCFChild = new CCFChild(cCFNode, cCFFrame);
        cCFFrame.fontSize = Math.max(0, (Integer.parseInt(xMLNode.getAttribute("font")) - 6) / 2);
        cCFFrame.setSize(this.parseDim(xMLNode.getAttribute("dim")));
        cCFFrame.setLocation(this.parsePos(xMLNode.getAttribute("pos")));
        StringTokenizer stringTokenizer = new StringTokenizer(xMLNode.getAttribute("colors"), ",/");
        if (stringTokenizer.countTokens() < 2) {
            throw new IllegalArgumentException("malformed colors '" + xMLNode.getAttribute("colors") + "'");
        }
        cCFFrame.colors = CCFColor.getComposite(new CCFColor(this.nextInt(stringTokenizer)), new CCFColor(this.nextInt(stringTokenizer)), this.iscolor);
        cCFFrame.icon = this.getIcon(xMLNode.getAttribute("icon"));
        cCFFrame.setChildren(this.getChildren(cCFFrame, xMLNode));
        return cCFChild;
    }

    private CCFChild getButton(CCFNode cCFNode, XMLNode xMLNode) {
        CCFButton cCFButton = new CCFButton(cCFNode, this.unsafe(xMLNode.getAttribute("name")));
        CCFChild cCFChild = new CCFChild(cCFNode, cCFButton);
        cCFChild.setButton(cCFButton);
        cCFButton.fontSize = Math.max(0, (Integer.parseInt(xMLNode.getAttribute("font")) - 6) / 2);
        cCFButton.idtag = this.unsafe(xMLNode.getAttribute("id"));
        cCFButton.setSize(this.parseDim(xMLNode.getAttribute("dim")));
        cCFButton.setLocation(this.parsePos(xMLNode.getAttribute("pos")));
        cCFButton.actions = this.getActionList(xMLNode.getAttribute("actions"));
        StringTokenizer stringTokenizer = new StringTokenizer(xMLNode.getAttribute("colors"), ",/");
        if (stringTokenizer.countTokens() < 8) {
            throw new IllegalArgumentException("malformed colors '" + xMLNode.getAttribute("colors") + "'");
        }
        cCFButton.colorIU = CCFColor.getComposite(new CCFColor(this.nextInt(stringTokenizer)), new CCFColor(this.nextInt(stringTokenizer)), this.iscolor);
        cCFButton.colorIS = CCFColor.getComposite(new CCFColor(this.nextInt(stringTokenizer)), new CCFColor(this.nextInt(stringTokenizer)), this.iscolor);
        cCFButton.colorAU = CCFColor.getComposite(new CCFColor(this.nextInt(stringTokenizer)), new CCFColor(this.nextInt(stringTokenizer)), this.iscolor);
        cCFButton.colorAS = CCFColor.getComposite(new CCFColor(this.nextInt(stringTokenizer)), new CCFColor(this.nextInt(stringTokenizer)), this.iscolor);
        stringTokenizer = new StringTokenizer(xMLNode.getAttribute("icons"), ",", true);
        CCFIcon[] cCFIconArray = new CCFIcon[4];
        int n = 0;
        while (stringTokenizer.hasMoreTokens() && n < cCFIconArray.length) {
            String string = stringTokenizer.nextToken();
            if (!string.equals(",")) {
                cCFIconArray[n] = this.getIcon(string);
                continue;
            }
            ++n;
        }
        cCFButton.iconIU = cCFIconArray[0];
        cCFButton.iconIS = cCFIconArray[1];
        cCFButton.iconAU = cCFIconArray[2];
        cCFButton.iconAS = cCFIconArray[3];
        return cCFChild;
    }

    private int nextInt(StringTokenizer stringTokenizer) {
        return Integer.parseInt(stringTokenizer.nextToken());
    }

    private Point parsePos(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "x");
        if (stringTokenizer.countTokens() < 2) {
            throw new IllegalArgumentException("malformed position '" + string + "'");
        }
        return new Point(this.nextInt(stringTokenizer), this.nextInt(stringTokenizer));
    }

    private Dimension parseDim(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "x");
        if (stringTokenizer.countTokens() < 2) {
            throw new IllegalArgumentException("malformed dimension '" + string + "'");
        }
        return new Dimension(this.nextInt(stringTokenizer), this.nextInt(stringTokenizer));
    }

    private CCFActionList getActionList(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return (CCFActionList)this.acts.get(string);
    }

    private CCFIcon getIcon(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return (CCFIcon)this.icon.get(string);
    }
}

