/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.ActionIRCode;
import com.neuron.app.tonto.CCF;
import com.neuron.app.tonto.CCFAction;
import com.neuron.app.tonto.CCFActionList;
import com.neuron.app.tonto.CCFButton;
import com.neuron.app.tonto.CCFChild;
import com.neuron.app.tonto.CCFDevice;
import com.neuron.app.tonto.CCFFrame;
import com.neuron.app.tonto.CCFHardKey;
import com.neuron.app.tonto.CCFHeader;
import com.neuron.app.tonto.CCFIRCode;
import com.neuron.app.tonto.CCFIcon;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFNodeState;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.CCFPorter;
import com.neuron.app.tonto.Debug;
import com.neuron.app.tonto.ITaskStatus;
import com.neuron.app.tonto.IWalker;
import com.neuron.app.tonto.IWalker2;
import com.neuron.app.tonto.ProntoModel;
import com.neuron.irdb.IRDatabase;
import com.neuron.irdb.IRRemote;
import com.neuron.irdb.impl.Pronto;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public class CCFWalker {
    private static final Hashtable cmd = new Hashtable();
    private static final int HEAD = 0;
    private static final int VIEW = 1;
    private static final int IREX1 = 2;
    private static final int LOAD = 3;
    private static final int SORT = 4;
    private static final int SUMM = 5;
    private static final int IREX2 = 6;
    private static final int DBUG = 7;
    private static final int XPRT = 8;
    private static final int MPRT = 9;
    private CCF ccf;
    private IWalker walker;
    private IWalker2 walker2;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            CCFWalker.usage();
            return;
        }
        Integer n = (Integer)cmd.get(stringArray[0]);
        if (n == null) {
            CCFWalker.usage();
            return;
        }
        block12: for (int i = 1; i < stringArray.length; ++i) {
            switch (n) {
                case 0: {
                    CCFWalker.head(stringArray[i]);
                    continue block12;
                }
                case 1: {
                    CCFWalker.view(stringArray[i]);
                    continue block12;
                }
                case 2: {
                    CCFWalker.irex(stringArray[i], true);
                    continue block12;
                }
                case 3: {
                    CCFWalker.load(stringArray[i]);
                    continue block12;
                }
                case 4: {
                    CCFWalker.sort(stringArray[i]);
                    continue block12;
                }
                case 5: {
                    CCFWalker.summ(stringArray[i], i);
                    continue block12;
                }
                case 6: {
                    CCFWalker.irex(stringArray[i], false);
                    continue block12;
                }
                case 7: {
                    CCFWalker.dbug(stringArray[i]);
                    continue block12;
                }
                case 8: {
                    CCFWalker.xprt(stringArray[1], stringArray[2]);
                    i = stringArray.length;
                    continue block12;
                }
                case 9: {
                    CCFWalker.mprt(stringArray[1], stringArray[2]);
                    i = stringArray.length;
                    continue block12;
                }
                default: {
                    CCFWalker.usage();
                }
            }
        }
        System.exit(0);
    }

    private static String[] subarr(String[] stringArray, int n, int n2) {
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, n, stringArray2, 0, n2);
        return stringArray2;
    }

    private static void usage() {
        CCFWalker.debug("CCFWalker <command> <ccf.file>");
        CCFWalker.debug("   -head      = dump ccf header");
        CCFWalker.debug("   -view      = walk the ccf tree");
        CCFWalker.debug("   -irex[1|2] = extract ir codes 1) save 2) view");
        CCFWalker.debug("   -load      = raw upload from pronto to file");
        CCFWalker.debug("   -summ      = summarize headers of several ccfs");
        CCFWalker.debug("   -dbug      = full debug load/parse of ccf");
        CCFWalker.debug("   -xprt      = export ccf as zip/xml file");
        CCFWalker.debug("   -mprt      = import ccf from zip/xml file");
    }

    private static void head(String string) throws IOException {
        CCF cCF = new CCF();
        Debug.getInstance("ccf").setLevel(1);
        cCF.load(string);
        cCF.header().dump();
    }

    private static void dbug(String string) throws IOException {
        CCF cCF = new CCF();
        Debug.getInstance("ccf").setLevel(3);
        cCF.load(string);
    }

    private static void xprt(String string, String string2) throws IOException {
        CCF cCF = new CCF();
        cCF.load(string);
        CCFPorter.exportZip(cCF, string2);
    }

    private static void mprt(String string, String string2) throws IOException {
        CCF cCF = CCFPorter.importZip(string);
        cCF.save(string2);
    }

    private static void view(String string) throws IOException {
        CCF cCF = new CCF();
        cCF.load(string);
        new CCFWalker(cCF).walk(new IWalker(){

            @Override
            public void onNode(CCFNode cCFNode) {
                if (cCFNode instanceof CCFDevice) {
                    CCFWalker.debug(cCFNode.describe());
                } else if (cCFNode instanceof CCFPanel) {
                    CCFWalker.debug("  " + cCFNode.describe());
                } else if (cCFNode instanceof CCFIcon) {
                    CCFWalker.debug("    " + cCFNode.describe());
                }
            }
        });
    }

    private static void load(String string) throws Exception {
        Debug.getInstance("comm").setLevel(2);
        Debug.getInstance("xmodem").setLevel(2);
        CCF cCF = new CCF();
        cCF.setNotify(new ITaskStatus(){

            @Override
            public void taskStatus(int n, String string) {
                CCFWalker.debug("** " + n + ", " + string);
            }

            @Override
            public void taskError(Throwable throwable) {
                CCFWalker.debug("** " + throwable);
            }

            @Override
            public void taskNotify(Object object) {
                CCFWalker.debug("** " + object);
            }
        });
        byte[] byArray = cCF.loadBytesFromPronto();
        new FileOutputStream(string).write(byArray);
    }

    private static void sort(String string) throws Exception {
        CCF cCF = new CCF();
        cCF.load(string);
        CCFNodeState cCFNodeState = cCF.getLastNodeState();
        CCFNode[] cCFNodeArray = cCFNodeState.getOrderedNodes();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cCFNodeArray.length; ++i) {
            CCFNode cCFNode = cCFNodeArray[i];
            int n3 = cCFNode.getFilePosition();
            int n4 = cCFNode.getLength();
            if (!(cCFNode instanceof CCFAction) && !(cCFNode instanceof CCFChild) && n3 != n) {
                CCFWalker.debug("** file gap int(" + n + " - " + n3 + ") " + "hex(" + Integer.toHexString(n) + " - " + Integer.toHexString(n3) + ") " + "(len=" + (n3 - n) + ")");
                n2 += n3 - n;
            }
            n = n3 + n4;
            CCFWalker.debug("[" + i + "] pos=" + n3 + " len=" + n4 + " >> " + cCFNode.describe());
        }
        CCFWalker.debug("** wasted space: " + n2);
        System.exit(0);
    }

    private static void summ(String string, int n) throws Exception {
        if (n == 1) {
            CCFWalker.debug("capability                            attributes                            version4");
        }
        CCF cCF = new CCF();
        cCF.load(string);
        CCFHeader cCFHeader = cCF.header();
        String string2 = new File(string).getName();
        if (string2.toLowerCase().endsWith(".ccf")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        ProntoModel[] prontoModelArray = cCF.getConformsMatch();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < prontoModelArray.length; ++i) {
            stringBuffer.append(prontoModelArray[i].getName() + (i < prontoModelArray.length - 1 ? ", " : ""));
        }
        CCFWalker.debug(cCFHeader.summary() + " " + CCFNode.rpad(string2, 20) + " " + stringBuffer.toString());
    }

    private static void irex(String string, boolean bl) throws IOException {
        CCF cCF = new CCF();
        cCF.load(string);
        if (bl) {
            CCFWalker.irex(cCF, IRDatabase.create("new.db"));
        } else {
            CCFWalker.debug("---( " + string + " )---");
            IWalker iWalker = new IWalker(){
                int ov = 0;

                @Override
                public void onNode(CCFNode cCFNode) {
                    if (cCFNode instanceof CCFIRCode) {
                        CCFIRCode cCFIRCode = (CCFIRCode)cCFNode;
                        CCFWalker.debug((cCFIRCode.hasUDB() ? "2" : "1") + ": " + cCFIRCode.getCode());
                    }
                }
            };
            new CCFWalker(cCF).walk(iWalker);
        }
    }

    public static void irex(CCF cCF, IRDatabase iRDatabase) throws IOException {
        final IRDatabase iRDatabase2 = iRDatabase;
        final CCF cCF2 = cCF;
        new CCFWalker(cCF).walk(new IWalker(){
            private CCFDevice dev;
            private CCFPanel pan;
            private CCFButton btn;
            private IRRemote remote;

            @Override
            public void onNode(CCFNode cCFNode) {
                if (cCFNode instanceof CCFButton) {
                    this.btn = (CCFButton)cCFNode;
                } else if (cCFNode instanceof CCFPanel) {
                    this.pan = (CCFPanel)cCFNode;
                } else if (cCFNode instanceof CCFDevice) {
                    this.dev = (CCFDevice)cCFNode;
                    CCFDevice cCFDevice = (CCFDevice)cCFNode;
                    this.remote = new IRRemote("unknown", "unknown", cCFDevice.getName());
                    iRDatabase2.add(this.remote);
                } else if (cCFNode instanceof CCFActionList) {
                    this.processActions((CCFActionList)cCFNode);
                }
            }

            private void processActions(CCFActionList cCFActionList) {
                if (cCFActionList == null) {
                    return;
                }
                CCFAction[] cCFActionArray = cCFActionList.getActions();
                for (int i = 0; cCFActionArray != null && i < cCFActionArray.length; ++i) {
                    if (!(cCFActionArray[i] instanceof ActionIRCode)) continue;
                    CCFIRCode cCFIRCode = ((ActionIRCode)cCFActionArray[i]).getIRCode();
                    try {
                        Pronto pronto = new Pronto(cCFIRCode.getCode(), cCF2.usesUDB() ? 2 : 1);
                        String string = this.pan.getName() + "-" + this.btn.getName();
                        pronto.setName(string);
                        this.remote.add(pronto);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        iRDatabase2.write();
    }

    private static void debug(String string) {
        System.out.println(string);
    }

    private boolean process(CCFNode cCFNode) {
        return cCFNode != null && (this.walker2 == null || this.walker2.processNode(cCFNode));
    }

    private void walk(CCF cCF) {
        if (cCF == null) {
            return;
        }
        this.walk(cCF.getFirstHomeDevice());
        this.walk(cCF.getFirstDevice());
        this.walk(cCF.getFirstMacroDevice());
        this.walk(cCF.getMacroPanel());
    }

    private void walk(CCFDevice cCFDevice) {
        if (!this.process(cCFDevice)) {
            return;
        }
        this.walker.onNode(cCFDevice);
        CCFHardKey[] cCFHardKeyArray = cCFDevice.getHardKeys();
        for (int i = 0; i < cCFHardKeyArray.length; ++i) {
            this.walk(cCFHardKeyArray[i].getActionList());
        }
        this.walk(cCFDevice.getFirstPanel());
        this.walk(cCFDevice.getNextDevice());
    }

    private void walk(CCFPanel cCFPanel) {
        if (!this.process(cCFPanel)) {
            return;
        }
        this.walker.onNode(cCFPanel);
        this.walk(cCFPanel.getChildren());
        this.walk(cCFPanel.getNextPanel());
    }

    private void walk(CCFChild[] cCFChildArray) {
        if (cCFChildArray == null || cCFChildArray.length == 0) {
            return;
        }
        for (int i = 0; i < cCFChildArray.length; ++i) {
            this.walk(cCFChildArray[i]);
        }
    }

    private void walk(CCFChild cCFChild) {
        if (!this.process(cCFChild)) {
            return;
        }
        this.walker.onNode(cCFChild);
        this.walk(cCFChild.getButton());
        this.walk(cCFChild.getFrame());
    }

    private void walk(CCFButton cCFButton) {
        if (!this.process(cCFButton)) {
            return;
        }
        this.walker.onNode(cCFButton);
        this.walker.onNode(cCFButton.iconIU);
        this.walker.onNode(cCFButton.iconIS);
        this.walker.onNode(cCFButton.iconAU);
        this.walker.onNode(cCFButton.iconAS);
        this.walk(cCFButton.getActionList());
    }

    private void walk(CCFFrame cCFFrame) {
        if (!this.process(cCFFrame)) {
            return;
        }
        this.walker.onNode(cCFFrame);
        this.walker.onNode(cCFFrame.icon);
        this.walk(cCFFrame.getChildren());
    }

    private void walk(CCFActionList cCFActionList) {
        if (!this.process(cCFActionList)) {
            return;
        }
        this.walker.onNode(cCFActionList);
        CCFAction[] cCFActionArray = cCFActionList.getActions();
        for (int i = 0; cCFActionArray != null && i < cCFActionArray.length; ++i) {
            this.walk(cCFActionArray[i]);
        }
    }

    private void walk(CCFAction cCFAction) {
        if (!this.process(cCFAction)) {
            return;
        }
        this.walker.onNode(cCFAction);
        if (cCFAction.getActionType() == 1) {
            this.walk((CCFIRCode)cCFAction.action2);
        }
    }

    private void walk(CCFIRCode cCFIRCode) {
        if (!this.process(cCFIRCode)) {
            return;
        }
        this.walker.onNode(cCFIRCode);
    }

    public CCFWalker(CCF cCF) {
        this.ccf = cCF;
    }

    public void walk(IWalker iWalker) {
        this.walker = iWalker;
        if (iWalker instanceof IWalker2) {
            this.walker2 = (IWalker2)iWalker;
        }
        this.walk(this.ccf);
    }

    public void walk(IWalker iWalker, CCFNode cCFNode) {
        Class<?> clazz;
        this.walker = iWalker;
        if (iWalker instanceof IWalker2) {
            this.walker2 = (IWalker2)iWalker;
        }
        if ((clazz = cCFNode.getClass()) == CCFDevice.class) {
            this.walk((CCFDevice)cCFNode);
        } else if (clazz == CCFPanel.class) {
            this.walk((CCFPanel)cCFNode);
        } else if (clazz == CCFFrame.class) {
            this.walk((CCFFrame)cCFNode);
        } else if (clazz == CCFButton.class) {
            this.walk((CCFButton)cCFNode);
        } else if (clazz == CCFChild.class) {
            this.walk((CCFChild)cCFNode);
        } else if (clazz == CCFActionList.class) {
            this.walk((CCFActionList)cCFNode);
        } else if (clazz == CCFAction.class) {
            this.walk((CCFAction)cCFNode);
        }
    }

    static {
        cmd.put("-head", new Integer(0));
        cmd.put("-view", new Integer(1));
        cmd.put("-irex1", new Integer(2));
        cmd.put("-irex2", new Integer(6));
        cmd.put("-load", new Integer(3));
        cmd.put("-sort", new Integer(4));
        cmd.put("-summ", new Integer(5));
        cmd.put("-dbug", new Integer(7));
        cmd.put("-xprt", new Integer(8));
        cmd.put("-mprt", new Integer(9));
        if (System.getProperty("ccf") != null) {
            Debug.getInstance("ccf").setLevel(3);
        }
    }
}

