/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CCF;
import com.neuron.app.tonto.CommJavax;
import com.neuron.app.tonto.Debug;
import com.neuron.app.tonto.Firmware;
import com.neuron.app.tonto.IComm;
import com.neuron.app.tonto.ICommSerialPort;
import com.neuron.app.tonto.ICommSerialPortID;
import com.neuron.app.tonto.ICommSource;
import com.neuron.app.tonto.ITaskStatus;
import com.neuron.app.tonto.PortProbe;
import com.neuron.app.tonto.RetryError;
import com.neuron.app.tonto.ScopeTask;
import com.neuron.app.tonto.Tonto;
import com.neuron.app.tonto.Util;
import com.neuron.app.tonto.Xmodem;
import com.neuron.io.ByteOutputBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.StringTokenizer;

class Comm
implements IComm {
    static Debug debug = Debug.getInstance("comm");
    private static final byte[] ATN = new byte[]{0};
    private static final byte[] ATN2 = new byte[]{24, 24, 24, 24, 24};
    private static final int NUL = 0;
    private static final int ACK = 6;
    private static final int CR = 13;
    private static final int LF = 10;
    private static final int MODE_STANDBY = 1;
    private static final int MODE_WAITING = 2;
    private static final int MODE_NOPRONTO = 3;
    private static int loadDelay = 250;
    private static int commandDelay = 50;
    private static int attentionDelay = 50;
    private static ICommSource source = new CommJavax();
    private static boolean onWindows98 = Util.onWindows98();
    private ICommSerialPortID comm;
    private ICommSerialPort port;
    private InputStream input;
    private OutputStream output;
    private int mode;
    private int[] CCFCapable;
    private int CCFPossible = -1;
    private int CCFSize;
    private boolean isCCFDirty;
    private long lastCMDTime = 0L;
    private String CCFDate;
    private String CCFTime;
    private OutputStream log;
    private boolean learning = false;
    private boolean sending = false;
    private StringBuffer logBuf;
    private Thread logThread;
    private Object learnLock = new Object();
    private long lastUpdate;

    public Comm(String string) throws Exception {
        this(source.getSerialPort(string));
    }

    public Comm(ICommSerialPortID iCommSerialPortID) throws Exception {
        this.comm = iCommSerialPortID;
        this.open();
    }

    public void open() throws Exception {
        this.port = this.comm.open();
        this.input = this.port.getInputStream();
        this.output = this.port.getOutputStream();
    }

    public void reopen() throws Exception {
        this.close();
        try {
            this.open();
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void close() {
        if (onWindows98) {
            if (this.output != null) {
                try {
                    this.output.flush();
                    this.output.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.input != null) {
                try {
                    this.input.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.port != null) {
            try {
                this.port.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isProntoOK() throws Exception {
        this.drainInput();
        for (int i = 0; i < 2; ++i) {
            this.send(ATN2);
            this.flush();
            switch (this.recv()) {
                case 33: 
                case 42: 
                case 126: {
                    return true;
                }
            }
            this.port.sendBreak(250);
            Comm.safeSleep(250);
            this.reopen();
        }
        return false;
    }

    public String getPortName() {
        return this.comm.getName();
    }

    private boolean sendReboot() {
        try {
            for (int i = 0; i < 3; ++i) {
                this.send(ATN2);
                this.flush();
                if (this.recv() != 33) continue;
                this.send("reboot".getBytes());
                this.send(13);
                this.flush();
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void undeadPronto(String string, ITaskStatus iTaskStatus) throws IOException {
        File file = new File(string);
        byte[] byArray = Comm.readFile(file);
        if (this.sendReboot()) {
            iTaskStatus.taskStatus(2, "Looking for Boot Message");
            this.findBytes("Boot".getBytes());
        } else {
            iTaskStatus.taskStatus(2, "Press RESET on Remote");
            this.findBytes("12\r\n14\r\n16\r\n".getBytes());
        }
        iTaskStatus.taskStatus(10, "Issuing Escape");
        this.send(27);
        this.flush();
        iTaskStatus.taskStatus(15, "Looking for CABERNET");
        this.findBytes("CABERNET> ".getBytes());
        iTaskStatus.taskStatus(20, "Issuing Download Command");
        this.send("dl ccf\r".getBytes());
        this.flush();
        for (int i = 0; i < 7; ++i) {
            this.recv();
        }
        iTaskStatus.taskStatus(30, "Downloading new CCF");
        new Xmodem(this, new ScopeTask(iTaskStatus, 30, 100)).sendFile(byArray);
        iTaskStatus.taskStatus(90, "Booting Remote");
        this.send("go\r".getBytes());
        this.flush();
        iTaskStatus.taskStatus(100, "Download Complete");
    }

    public void updateFirmware(Firmware firmware, ITaskStatus iTaskStatus) throws IOException {
        this.updateFirmware(firmware, null, iTaskStatus);
    }

    public void updateFirmware(Firmware firmware, CCF cCF, ITaskStatus iTaskStatus) throws IOException {
        this.updateFirmware(firmware, cCF, false, iTaskStatus);
    }

    public void updateFirmware(Firmware firmware, CCF cCF, boolean bl, ITaskStatus iTaskStatus) throws IOException {
        int n;
        byte[] byArray;
        boolean bl2;
        Object object;
        Object object2;
        Object object3;
        double d = 0.0;
        double d2 = 0.0;
        String string = firmware.getDescription().replace(',', ';').replace('-', ';');
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            object3 = stringTokenizer.nextToken().trim().toLowerCase();
            if (((String)object3).startsWith("sys")) {
                d = Comm.getVersion((String)object3);
                continue;
            }
            if (!((String)object3).startsWith("app")) continue;
            d2 = Comm.getVersion((String)object3);
        }
        debug.log(0, "Firmware _SYS=" + d + " _APP=" + d2);
        object3 = new byte[]{27, 0, 0, 13, 10};
        Comm.safeSleep(500);
        iTaskStatus.taskStatus(0, "Rebooting Pronto");
        if (this.sendReboot()) {
            iTaskStatus.taskStatus(2, "Looking for Boot Message");
            this.findBytes("Boot".getBytes());
        } else {
            iTaskStatus.taskStatus(2, "Press RESET on Remote");
            this.findBytes("12\r\n14\r\n16\r\n".getBytes());
        }
        iTaskStatus.taskStatus(3, "Issuing Interrupt");
        this.send((byte[])object3);
        this.flush();
        iTaskStatus.taskStatus(4, "Looking for CABERNET");
        this.findBytes("CABERNET> ".getBytes());
        this.drainInput();
        double d3 = 0.0;
        double d4 = 0.0;
        if (!bl) {
            iTaskStatus.taskStatus(5, "Issuing Query");
            this.send("\u0000q\r\n".getBytes());
            this.flush();
            iTaskStatus.taskStatus(6, "Looking for Query echo");
            this.findBytes("q\n\r".getBytes());
            iTaskStatus.taskStatus(7, "Collecting Statistics");
            byte[] byArray2 = this.collectUntil("CABERNET> ".getBytes());
            if (byArray2 == null) {
                debug.log(0, "Error reading statistics (null)");
                byArray2 = new byte[]{};
            }
            String string2 = new String(byArray2);
            System.out.println("Pronto Statistics (((\n" + string2 + "\n)))");
            stringTokenizer = new StringTokenizer(string2, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                object2 = stringTokenizer.nextToken().trim();
                if (!((String)object2).startsWith("_SYS") && !((String)object2).startsWith("_APP") || ((StringTokenizer)(object = (Object)new StringTokenizer((String)object2, ","))).countTokens() <= 3) continue;
                ((StringTokenizer)object).nextToken();
                ((StringTokenizer)object).nextToken();
                double d5 = Comm.getVersion(((StringTokenizer)object).nextToken().trim());
                if (((String)object2).startsWith("_SYS")) {
                    d3 = d5;
                    continue;
                }
                d4 = d5;
            }
            debug.log(0, "Pronto _SYS=" + d3 + " _APP=" + d4);
            if (!bl && (d3 <= 0.0 || d4 <= 0.0)) {
                debug.log(0, "Error reading statistics");
                this.send("\u0000go\r\n".getBytes());
                this.flush();
                throw new IOException("Unable to read remote's status");
            }
        }
        boolean bl3 = bl || d > d3;
        boolean bl4 = bl2 = bl || bl3 || d2 > d4;
        if (bl3 || bl2) {
            iTaskStatus.taskStatus(9, "Upgrading: " + (bl3 ? "_SYS" : "") + " " + (bl2 ? "_APP" : ""));
        } else {
            iTaskStatus.taskStatus(9, "Firmware up to date");
        }
        object2 = firmware.get_SYS();
        object = firmware.get_APP();
        byte[] byArray3 = byArray = cCF != null ? cCF.encode() : firmware.get_CCF();
        if (!bl) {
            iTaskStatus.taskStatus(10, "Looking for CABERNET");
            this.findBytes("CABERNET> ".getBytes());
            this.drainInput();
        }
        int n2 = 10;
        int n3 = byArray.length + (bl2 ? ((byte[])object).length : 0) + (bl3 ? ((byte[])object2).length : 0);
        debug.log(2, "total send: " + n3);
        if (bl3) {
            n = n2 + this.percent(((byte[])object2).length, n3, 90);
            debug.log(2, "sys: pct=" + n2 + " hi=" + n + " len=" + ((Object)object2).length);
            n2 = this.updateSegment(iTaskStatus, "_SYS", (byte[])object2, n2, n);
        }
        if (bl2) {
            n = n2 + this.percent(((byte[])object).length, n3, 90);
            debug.log(2, "app: pct=" + n2 + " hi=" + n + " len=" + ((Object)object).length);
            n2 = this.updateSegment(iTaskStatus, "_APP", (byte[])object, n2, n);
        }
        n = n2 + this.percent(byArray.length, n3, 90);
        debug.log(2, "ccf: pct=" + n2 + " hi=" + n + " len=" + byArray.length);
        n2 = this.updateSegment(iTaskStatus, "_CCF", byArray, n2, n);
        iTaskStatus.taskStatus(100, "Booting Pronto");
        this.send("\u0000go\r\n".getBytes());
        this.flush();
        iTaskStatus.taskStatus(100, "Download Complete");
    }

    private int percent(int n, int n2, int n3) {
        return n * 100 / n2 * n3 / 100;
    }

    private int updateSegment(ITaskStatus iTaskStatus, String string, byte[] byArray, int n, int n2) throws IOException {
        this.drainInput();
        debug.log(0, "Sending " + string + " Segment");
        iTaskStatus.taskStatus(n, "Issuing Download Command");
        this.send("\u0000d\r\n".getBytes());
        this.flush();
        this.findBytes("d\n\r".getBytes());
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5;
            if ((n5 = this.recv()) == -1) {
                n4 += 5;
            } else {
                if (n5 == 67) {
                    if (++n3 == 2) {
                        break;
                    }
                } else {
                    n3 = 0;
                }
                if (n4 > 25) {
                    throw new IOException("Segment update for '" + string + "' failed");
                }
            }
            ++n4;
        }
        iTaskStatus.taskStatus(n, "Downloading " + string);
        new Xmodem(this, new ScopeTask(iTaskStatus, n, n2)).sendFile(byArray);
        return n2;
    }

    private static double getVersion(String string) {
        string = string.trim().toLowerCase();
        double d = 0.0;
        int n = string.indexOf("v");
        if (n >= 0) {
            string = string.substring(n + 1, string.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            double d2 = 1.0;
            while (stringTokenizer.hasMoreTokens()) {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                d += (double)n2 * d2;
                d2 /= 100.0;
            }
        }
        return d;
    }

    final void findBytes(byte[] byArray) throws IOException {
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = this.recv()) != byArray[n++]) {
                n = 0;
                continue;
            }
            if (n == byArray.length) break;
        }
    }

    final byte[] collectUntil(byte[] byArray) throws IOException {
        ByteOutputBuffer byteOutputBuffer = new ByteOutputBuffer(4096);
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3 = this.recv();
            byteOutputBuffer.write(n3);
            if (n3 == -1) {
                if (n2++ <= 20) continue;
                return null;
            }
            if (n3 != byArray[n++]) {
                n = 0;
                n2 = 0;
                continue;
            }
            if (n == byArray.length) break;
        }
        byte[] byArray2 = byteOutputBuffer.toByteArray();
        byte[] byArray3 = new byte[byArray2.length - byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        return byArray3;
    }

    public String queryPronto() throws IOException {
        for (int i = 0; i < 2; ++i) {
            this.sendCMD("q ccf");
            String string = this.readString();
            if (string != null && string.length() > 10) {
                debug.log(1, this.comm.getName() + " Reply '" + string + "'");
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                if (stringTokenizer.countTokens() < 4) {
                    throw new IOException("Pronto inquiry failed");
                }
                this.isCCFDirty = Integer.parseInt(stringTokenizer.nextToken()) != 0;
                this.CCFSize = Integer.parseInt(stringTokenizer.nextToken());
                this.CCFDate = stringTokenizer.nextToken();
                this.CCFTime = stringTokenizer.nextToken();
                this.drainInput();
                return string;
            }
            debug.log(1, "query[" + i + "] failed");
            Comm.safeSleep(500);
        }
        throw new IOException("Pronto not responding to query on " + this.comm.getName());
    }

    private int dehex(String string) {
        return Integer.parseInt(string.substring(2), 16);
    }

    public void rebootPronto() throws IOException {
        this.sendCMD("reboot");
        this.drainInput();
    }

    public int[] getCCFCapable() throws IOException {
        for (int i = 0; i < 2; ++i) {
            this.sendCMD("cap ccf");
            String string = this.readString();
            if (string != null && string.length() >= 6) {
                debug.log(1, this.comm.getName() + " Reply '" + string + "'");
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(4));
                int[] nArray = new int[stringTokenizer.countTokens()];
                for (int j = 0; j < nArray.length; ++j) {
                    nArray[j] = this.dehex(stringTokenizer.nextToken());
                }
                this.CCFCapable = nArray;
                this.drainInput();
                return this.CCFCapable;
            }
            debug.log(1, "cap[" + i + "] failed");
        }
        throw new IOException("Pronto not responding to capability");
    }

    public int getCCFPossible() throws IOException {
        for (int i = 0; i < 2; ++i) {
            this.sendCMD("possible ccf");
            String string = this.readString();
            if (string != null && string.length() >= 10) {
                debug.log(1, this.comm.getName() + " Reply '" + string + "' (" + string.length() + ")");
                this.CCFPossible = this.dehex(string.substring(8));
                this.drainInput();
                return this.CCFPossible;
            }
            debug.log(1, "pos[" + i + "] failed");
        }
        throw new IOException("Pronto not responding to possible");
    }

    private String readString() throws IOException {
        String string = null;
        char[] cArray = new char[128];
        int n = 0;
        while (n < cArray.length) {
            int n2 = this.recv();
            if (n2 == 13) continue;
            if (n2 == -1 || n2 == 10) {
                string = new String(cArray, 0, n);
                break;
            }
            cArray[n++] = (char)n2;
        }
        return string;
    }

    boolean isCCFDirty() {
        return this.isCCFDirty;
    }

    int getCCFSize() {
        return this.CCFSize;
    }

    String getCCFDate() {
        return this.CCFDate;
    }

    String getCCFTime() {
        return this.CCFTime;
    }

    int[] getCapable() {
        return this.CCFCapable;
    }

    int getPossible() throws IOException {
        if (this.CCFPossible < 0) {
            this.getCCFPossible();
        }
        return this.CCFPossible;
    }

    public String toString() {
        return "{" + (this.isCCFDirty ? "dirty" : "clean") + "," + this.CCFSize + "," + this.CCFDate + "," + this.CCFTime + "," + this.port.getName() + "}";
    }

    byte[] getCCF() throws Exception {
        return this.getCCF(null);
    }

    byte[] getCCF(ITaskStatus iTaskStatus) throws Exception {
        iTaskStatus.taskStatus(0, "Checking Pronto Status");
        this.queryPronto();
        for (int i = 0; i < 3; ++i) {
            iTaskStatus.taskStatus(4, "Initiating Upload");
            this.sendCMD("ul ccf");
            Comm.safeSleep(loadDelay);
            iTaskStatus.taskStatus(6, "Upload in Progress");
            byte[] byArray = null;
            try {
                byArray = new Xmodem(this, new ScopeTask(iTaskStatus, 8, 100)).recvFile(this.CCFSize);
            }
            catch (RetryError retryError) {
                iTaskStatus.taskNotify("Command Failure. Retrying.");
                this.reopen();
                this.drainInput();
                Comm.safeSleep(1000);
                this.queryPronto();
                continue;
            }
            if (byArray != null) {
                if (byArray.length < this.CCFSize) {
                    debug.log(0, "truncated ccf (" + byArray.length + " < " + this.CCFSize + ")");
                } else if (byArray.length > this.CCFSize + 128) {
                    debug.log(0, "inflated ccf (" + byArray.length + " > " + this.CCFSize + ")");
                }
                return byArray;
            }
            throw new IOException("No CCF Returned");
        }
        throw new IOException("Too Many Retries");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitLearning() {
        Object object = this.learnLock;
        synchronized (object) {
            if (!this.learning) {
                try {
                    this.learnLock.wait();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.learning = false;
        }
    }

    void testIR(byte[] byArray) throws Exception {
        this.sendCMD("irstart");
        new Xmodem(this, null).sendFile(byArray);
        this.send("irstop".getBytes());
        this.send(13);
        this.flush();
        this.drainInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] learnIR(ITaskStatus iTaskStatus) throws Exception {
        for (int i = 0; i < 1; ++i) {
            Object object;
            try {
                object = this.learnLock;
                synchronized (object) {
                    this.sendCMD("irlearn 5000");
                    this.learning = true;
                    this.learnLock.notify();
                }
                object = new Xmodem(this, iTaskStatus).recvFile(this.CCFSize);
                return object;
            }
            catch (RetryError retryError) {
                debug.log(0, "retry learnIR on err[" + i + "]: " + retryError);
                this.reopen();
                this.drainInput();
                Comm.safeSleep(1000);
                this.queryPronto();
                continue;
            }
            finally {
                object = this.learnLock;
                synchronized (object) {
                    this.learning = false;
                }
            }
        }
        return null;
    }

    void setCCF(byte[] byArray) throws IOException {
        this.setCCF(byArray, null);
    }

    void setCCF(byte[] byArray, ITaskStatus iTaskStatus) throws IOException {
        iTaskStatus.taskStatus(5, "Initiating Download");
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            this.sendCMD("dl ccf");
            Comm.safeSleep(loadDelay);
            iTaskStatus.taskStatus(10, "Download in Progress");
            try {
                new Xmodem(this, new ScopeTask(iTaskStatus, 10, 100)).sendFile(byArray);
                iTaskStatus.taskNotify("Download Complete");
                return;
            }
            catch (Exception exception) {
                Tonto.debug(exception);
                iTaskStatus.taskNotify("Download Error... Retrying");
                Comm.safeSleep(500);
                continue;
            }
        }
        throw new IOException("Unexpected response (" + n + ")");
    }

    private void drainInput() throws IOException {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while ((n = this.recv()) != -1) {
            stringBuffer.append(Xmodem.hex(n) + " ");
            stringBuffer2.append((char)n);
            ++n2;
        }
        if (n2 > 0) {
            debug.log(2, "(---- drained ----)");
            debug.log(2, "num: " + stringBuffer);
            debug.log(2, "raw: " + stringBuffer2);
            debug.log(2, "(-----------------)");
        }
    }

    private void sendCMD(String string) throws IOException {
        this.sendCMD(string, null);
    }

    @Override
    public void sendAttention() throws IOException {
        this.send(ATN2);
        this.flush();
        Comm.safeSleep(100);
    }

    private void sendCMD(String string, String string2) throws IOException {
        int n;
        this.drainInput();
        Comm.safeSleep(commandDelay);
        block5: for (n = 0; n < 2; ++n) {
            this.send(ATN2);
            this.flush();
            Comm.safeSleep(100);
            int n2 = this.recv();
            Comm.safeSleep(attentionDelay + 10);
            debug.log(2, this.comm.getName() + " said (" + Xmodem.hex(n2) + ") on try #" + n);
            switch (n2) {
                case -1: {
                    Comm.safeSleep(500);
                    this.mode = 3;
                    continue block5;
                }
                case 33: 
                case 42: {
                    this.mode = 1;
                    break block5;
                }
                case 126: {
                    this.mode = 2;
                    break block5;
                }
                default: {
                    if (n == 0) continue block5;
                    this.mode = 3;
                    debug.log(2, "ERR: " + n2 + " on " + this.comm.getName());
                    throw new IOException("Invalid probe response (" + n2 + ")");
                }
            }
        }
        if (n == 2) {
            throw new IOException("Unable to raise Pronto");
        }
        debug.log(1, this.comm.getName() + " Request (" + string + ") (" + string2 + ")");
        this.send(string.getBytes());
        this.send(13);
        if (string2 != null) {
            this.send(string2.getBytes());
        }
        this.flush();
        this.lastCMDTime = Util.time();
        Comm.safeSleep(commandDelay);
    }

    public static boolean isDriverOK() {
        try {
            return source.getSerialPorts() != null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static int getLoadDelay() {
        return loadDelay;
    }

    public static void setLoadDelay(int n) {
        loadDelay = n;
    }

    public static int getCommandDelay() {
        return commandDelay;
    }

    public static void setCommandDelay(int n) {
        commandDelay = n;
    }

    public static int getAttentionDelay() {
        return attentionDelay;
    }

    public static void setAttentionDelay(int n) {
        attentionDelay = n;
    }

    static byte[] readFile(File file) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        for (int i = 0; i < byArray.length; i += n) {
            n = fileInputStream.read(byArray, i, byArray.length - i);
            if (n >= 0) continue;
            throw new IOException("Unexpected read error");
        }
        return byArray;
    }

    static void safeSleep(int n) throws IOException {
        try {
            debug.log(3, "sleep " + n);
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (Exception exception) {
            throw new InterruptedIOException(exception.getMessage());
        }
    }

    static ICommSerialPortID[] getSerialPorts() {
        return source.getSerialPorts();
    }

    static Comm detectPronto(String string) throws Exception {
        return Comm.detectPronto(source.getSerialPort(string));
    }

    static Comm detectPronto(ICommSerialPortID iCommSerialPortID) throws Exception {
        debug.log(1, "probing '" + iCommSerialPortID + "'");
        for (int i = 0; i < 1; ++i) {
            Comm comm = null;
            try {
                comm = new Comm(iCommSerialPortID);
                if (comm.isProntoOK()) {
                    return comm;
                }
                comm.close();
                return null;
            }
            catch (Exception exception) {
                if (exception.getMessage() == null) {
                    debug.log(2, "<" + exception.getClass().getName() + "> on " + iCommSerialPortID.getName());
                } else {
                    debug.log(2, "'" + exception.getMessage() + "' on " + iCommSerialPortID.getName());
                }
                if (comm == null) continue;
                comm.close();
                continue;
            }
        }
        return null;
    }

    static Comm scanForPronto(ITaskStatus iTaskStatus) throws Exception {
        return Comm.scanForPronto(iTaskStatus, null);
    }

    static Comm scanForPronto(ITaskStatus iTaskStatus, String string) throws Exception {
        long l = Util.time();
        ICommSerialPortID iCommSerialPortID = null;
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        if (string != null) {
            debug.log(1, "Default port " + string);
            try {
                iCommSerialPortID = source.getSerialPort(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Comm comm = new PortProbe(iCommSerialPortID).getComm();
        l = Util.time() - l;
        debug.log(1, "Comm Scan took " + l + " ms");
        return comm;
    }

    public static void main(String[] stringArray) throws Exception {
        debug.log(0, "driver ok: " + Comm.isDriverOK());
        Comm comm = Comm.scanForPronto(null);
        if (comm != null) {
            debug.log(0, "Pronto found : " + comm);
            byte[] byArray = comm.getCCF(new ITaskStatus(){

                @Override
                public void taskStatus(int n, String string) {
                    debug.log(0, "getccfmsg: " + n + ", " + string);
                }

                @Override
                public void taskError(Throwable throwable) {
                    debug.log(0, "getccferr: " + throwable);
                }

                @Override
                public void taskNotify(Object object) {
                    debug.log(0, "getccfobj: " + object);
                }
            });
            FileOutputStream fileOutputStream = new FileOutputStream("foo.ccf");
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        } else {
            debug.log(0, "Pronto not found on any ports");
        }
    }

    private synchronized boolean checkLogging(boolean bl) {
        if (debug.debug(3)) {
            if (this.logBuf == null || this.sending != bl) {
                if (this.logThread == null) {
                    this.logThread = new Thread(){

                        @Override
                        public void run() {
                            Comm.this.lastUpdate = Util.time();
                            try {
                                while (true) {
                                    2.sleep(1000L);
                                    if (Util.time() - Comm.this.lastUpdate <= 1000L) continue;
                                    Comm.this.checkLogging(!Comm.this.sending);
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                return;
                            }
                        }
                    };
                    this.logThread.start();
                }
                if (this.logBuf != null && this.logBuf.length() > 0) {
                    debug.log(3, (this.sending ? "SEND " : "RECV ") + this.logBuf);
                }
                this.logBuf = new StringBuffer();
                this.lastUpdate = Util.time();
            }
            this.sending = bl;
            return true;
        }
        return false;
    }

    @Override
    public int recv() throws IOException {
        int n = this.input.read();
        if (n == -1 && onWindows98) {
            debug.log(1, "Windows98 read do over on -1");
            n = this.input.read();
        }
        if (this.checkLogging(false)) {
            this.fprint(n);
        }
        return n;
    }

    @Override
    public int recv(byte[] byArray) throws IOException {
        return this.recv(byArray, 0, byArray.length);
    }

    @Override
    public int recv(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.input.read(byArray, n, n2);
        if (this.checkLogging(false)) {
            if (n3 > 0) {
                for (int i = 0; i < n3; ++i) {
                    this.fprint(byArray[n + i]);
                }
            } else {
                this.fprint(-1);
            }
        }
        return n3;
    }

    @Override
    public void send(int n) throws IOException {
        if (this.checkLogging(true)) {
            this.fprint(n);
        }
        this.output.write(n);
    }

    @Override
    public void send(byte[] byArray) throws IOException {
        this.send(byArray, 0, byArray.length);
    }

    @Override
    public void send(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            if (!this.checkLogging(true)) continue;
            this.fprint(byArray[n + i]);
        }
        this.output.write(byArray, n, n2);
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    private void fprint(byte by) throws IOException {
        if (by >= 32 && by <= 126) {
            this.fprint((char)by + "  ");
        } else {
            this.fprint(Xmodem.hex(by) + " ");
        }
    }

    private void fprint(int n) throws IOException {
        if (n < 0) {
            this.fprint("xxx ");
        } else if (n >= 32 && n <= 126) {
            this.fprint((char)n + "  ");
        } else {
            this.fprint(Xmodem.hex(n) + " ");
        }
    }

    private void fprint(String string) throws IOException {
        this.logBuf.append(string);
    }
}

